/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.versioncontrol.engines.internal;

import com.microsoft.tfs.core.Messages;
import com.microsoft.tfs.core.clients.versioncontrol.ChangePendedFlags;
import com.microsoft.tfs.core.clients.versioncontrol.OperationStatus;
import com.microsoft.tfs.core.clients.versioncontrol.VersionControlClient;
import com.microsoft.tfs.core.clients.versioncontrol.engines.internal.AsyncCheckinOperation;
import com.microsoft.tfs.core.clients.versioncontrol.engines.internal.GetEngine;
import com.microsoft.tfs.core.clients.versioncontrol.engines.internal.workers.CheckinWorker;
import com.microsoft.tfs.core.clients.versioncontrol.engines.internal.workers.WorkerStatus;
import com.microsoft.tfs.core.clients.versioncontrol.events.EventSource;
import com.microsoft.tfs.core.clients.versioncontrol.events.PendingChangeEvent;
import com.microsoft.tfs.core.clients.versioncontrol.exceptions.CheckinException;
import com.microsoft.tfs.core.clients.versioncontrol.exceptions.VersionControlException;
import com.microsoft.tfs.core.clients.versioncontrol.internal.concurrent.AccountingCompletionService;
import com.microsoft.tfs.core.clients.versioncontrol.internal.fileattributes.FileAttributeValues;
import com.microsoft.tfs.core.clients.versioncontrol.internal.fileattributes.FileAttributesCollection;
import com.microsoft.tfs.core.clients.versioncontrol.internal.fileattributes.StringPairFileAttribute;
import com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace.WorkspaceLock;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.ChangeType;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.PendingChange;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.Workspace;
import com.microsoft.tfs.core.exceptions.internal.CoreCancelException;
import com.microsoft.tfs.core.util.CodePageMapping;
import com.microsoft.tfs.core.util.FileEncoding;
import com.microsoft.tfs.core.util.internal.AppleSingleUtil;
import com.microsoft.tfs.jni.FileSystemAttributes;
import com.microsoft.tfs.jni.FileSystemUtils;
import com.microsoft.tfs.jni.helpers.FileCopyHelper;
import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.HashUtils;
import com.microsoft.tfs.util.NewlineUtils;
import com.microsoft.tfs.util.Platform;
import com.microsoft.tfs.util.tasks.CanceledException;
import com.microsoft.tfs.util.tasks.TaskMonitor;
import com.microsoft.tfs.util.tasks.TaskMonitorService;
import com.microsoft.tfs.util.temp.TempStorageService;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CheckinEngine {
    private static final int UPLOAD_YIELD_COUNT = 8;
    private static final Log log = LogFactory.getLog(CheckinEngine.class);
    private final VersionControlClient client;
    private final Workspace workspace;

    public CheckinEngine(VersionControlClient client, Workspace workspace) {
        Check.notNull(client, "client");
        Check.notNull(workspace, "workspace");
        this.client = client;
        this.workspace = workspace;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void uploadChanges(PendingChange[] changes, boolean forShelve, boolean saveUploadedContentAsBaselines) throws CheckinException, CoreCancelException {
        Check.notNull(changes, "changes");
        WorkspaceLock workspaceLock = saveUploadedContentAsBaselines ? this.workspace.lock() : null;
        try {
            TaskMonitor monitor = TaskMonitorService.getTaskMonitor();
            monitor.begin("", changes.length);
            AtomicBoolean pendingChangesUpdatedByServer = new AtomicBoolean();
            this.workspace.reconcile(false, pendingChangesUpdatedByServer);
            if (pendingChangesUpdatedByServer.get()) {
                throw new VersionControlException(Messages.getString("CheckinEngine.PendingChangesModified"));
            }
            AccountingCompletionService<WorkerStatus> completions = new AccountingCompletionService<WorkerStatus>(this.client.getUploadDownloadWorkerExecutor());
            AsyncCheckinOperation asyncOp = new AsyncCheckinOperation(workspaceLock);
            try {
                int uploadedCount = 0;
                for (PendingChange change : changes) {
                    this.throwIfCanceled(monitor);
                    this.throwIfFatalError(asyncOp);
                    ChangeType changeType = change.getChangeType();
                    PendingChangeEvent event = new PendingChangeEvent(EventSource.newFromHere(), this.workspace, change, OperationStatus.GETTING, ChangePendedFlags.UNKNOWN);
                    if (forShelve) {
                        this.client.getEventEngine().fireBeforeShelvePendingChange(event);
                    } else {
                        this.client.getEventEngine().fireBeforeCheckinPendingChange(event);
                    }
                    if (changeType.contains(ChangeType.EDIT) && !(changeType.contains(ChangeType.MERGE) && changeType.contains(ChangeType.DELETE))) {
                        monitor.setCurrentWorkDescription(MessageFormat.format(Messages.getString("CheckinEngine.UploadingFormat"), change.getServerItem()));
                        if (change.getLocalItem() == null) {
                            throw new VersionControlException(MessageFormat.format(Messages.getString("CheckinEngine.NoLocalFileForPendingChangeFormat"), change.getServerItem()));
                        }
                        if (null != asyncOp.getBaselineFolders() && 0 == uploadedCount++ % 8) {
                            asyncOp.getWorkspaceLock().yield();
                        }
                        this.uploadFile(change, completions, asyncOp);
                    } else if (changeType.contains(ChangeType.DELETE) || changeType.contains(ChangeType.LOCK) || changeType.contains(ChangeType.RENAME) || changeType.contains(ChangeType.UNDELETE) || changeType.contains(ChangeType.BRANCH) || changeType.contains(ChangeType.ENCODING) || !changeType.contains(ChangeType.MERGE)) {
                        // empty if block
                    }
                    monitor.worked(1);
                }
            }
            finally {
                this.waitForCompletions(completions);
                monitor.done();
            }
            this.throwIfCanceled(monitor);
            this.throwIfFatalError(asyncOp);
        }
        finally {
            if (workspaceLock != null) {
                workspaceLock.close();
            }
        }
    }

    private void throwIfCanceled(TaskMonitor taskMonitor) throws CoreCancelException {
        if (taskMonitor.isCanceled()) {
            throw new CoreCancelException();
        }
    }

    private void throwIfFatalError(AsyncCheckinOperation asyncOp) throws CheckinException {
        Check.notNull(asyncOp, "asyncOp");
        Throwable fatalError = asyncOp.getFatalError();
        if (fatalError != null) {
            throw new CheckinException(null, false, false, fatalError);
        }
    }

    private void waitForCompletions(AccountingCompletionService<WorkerStatus> completionService) {
        Check.notNull(completionService, "completionService");
        completionService.waitForCompletions(new AccountingCompletionService.ResultProcessor<WorkerStatus>(){

            @Override
            public void processResult(WorkerStatus result) {
                WorkerStatus status = result;
                if (status.getFinalState() == WorkerStatus.FinalState.ERROR) {
                    log.debug((Object)"Checkin worker thread finished with EXCEPTION");
                } else if (status.getFinalState() == WorkerStatus.FinalState.CANCELED) {
                    log.debug((Object)"Checkin worker thread finished with CANCELED");
                }
            }
        }, new AccountingCompletionService.ExecutionExceptionHandler(){

            @Override
            public void handleException(ExecutionException e) {
                log.warn((Object)"Checkin worker exception", (Throwable)e);
            }
        });
    }

    private void uploadFile(PendingChange change, CompletionService<WorkerStatus> completionService, AsyncCheckinOperation state) throws CheckinException, CoreCancelException {
        Check.notNull(change, "change");
        Check.notNull(change.getLocalItem(), "change.getLocalItem()");
        String localItem = change.getLocalItem();
        FileSystemAttributes attrs = FileSystemUtils.getInstance().getAttributes(localItem);
        if (!new File(change.getLocalItem()).exists() && !attrs.isSymbolicLink()) {
            throw new CheckinException(null, false, false, MessageFormat.format(Messages.getString("CheckinEngine.LocalItemNoLongerExistsFormat"), change.getLocalItem()));
        }
        String filterTempFile = null;
        GetEngine getEngine = new GetEngine(this.client);
        FileAttributesCollection attributes = getEngine.getAttributesForFile(localItem, change.getServerItem(), FileEncoding.BINARY.getCodePage() != change.getEncoding());
        if (attributes != null) {
            StringPairFileAttribute transformAttribute;
            StringPairFileAttribute eolAttribute = attributes.getStringPairFileAttribute("server-eol");
            if (eolAttribute != null && eolAttribute.getValue() != null) {
                String desiredNewlineSequence = FileAttributeValues.getEndOfLineStringForAttributeValue(eolAttribute);
                if (desiredNewlineSequence == null) {
                    throw new CheckinException(null, false, false, MessageFormat.format(Messages.getString("CheckinEngine.UnsupportedServerEOLStyleFormat"), eolAttribute.getValue(), change.getLocalItem(), ".tpattributes"));
                }
                if (desiredNewlineSequence.equals("")) {
                    log.debug((Object)MessageFormat.format("Not converting line endings in {0}", change.getLocalItem()));
                } else {
                    log.debug((Object)MessageFormat.format("Converting line endings for {0} to {1}", change.getLocalItem(), eolAttribute.getValue()));
                    try {
                        Charset charset;
                        if (filterTempFile == null) {
                            filterTempFile = this.createTempFile(change);
                        }
                        if ((charset = CodePageMapping.getCharset(change.getEncoding(), false)) == null) {
                            charset = Charset.defaultCharset();
                        }
                        NewlineUtils.convertFile(new File(filterTempFile), charset, desiredNewlineSequence);
                        log.info((Object)MessageFormat.format("Converted line endings in {0} to {1}", filterTempFile, eolAttribute.getValue(), charset.name()));
                    }
                    catch (UnsupportedEncodingException e) {
                        String message = MessageFormat.format(Messages.getString("CheckinEngine.CouldNotChangeEOLStyleUnknownJavaEncodingFormat"), change.getLocalItem(), e.getLocalizedMessage());
                        log.error((Object)message, (Throwable)e);
                        throw new CheckinException(null, false, false, message);
                    }
                    catch (IOException e) {
                        String message = MessageFormat.format(Messages.getString("CheckinEngine.CouldNotChangeEOLStyleIOExceptionFormat"), change.getLocalItem(), e.getLocalizedMessage());
                        log.error((Object)message, (Throwable)e);
                        throw new CheckinException(null, false, false, message);
                    }
                }
            }
            if ((transformAttribute = attributes.getStringPairFileAttribute("transform")) != null && "apple".equals(transformAttribute.getValue())) {
                if (Platform.isCurrentPlatform(Platform.MAC_OS_X)) {
                    try {
                        if (filterTempFile == null) {
                            filterTempFile = this.createTempFile(change);
                        }
                        AppleSingleUtil.encodeFile(new File(filterTempFile), change.getLocalItem());
                    }
                    catch (IOException e) {
                        String message = MessageFormat.format(Messages.getString("CheckinEngine.CouldNotDecodeAppleSingleFileFormat"), change.getLocalItem(), e.getLocalizedMessage());
                        log.error((Object)message, (Throwable)e);
                        throw new CheckinException(null, false, false, message);
                    }
                } else {
                    log.warn((Object)MessageFormat.format("Not preserving Apple metadata for {0} on platform {1}", change.getLocalItem(), Platform.getCurrentPlatformString()));
                }
            }
        }
        if (attrs.isSymbolicLink()) {
            try {
                String link = FileSystemUtils.getInstance().getSymbolicLink(localItem);
                filterTempFile = this.createTempFileForSymbolicLink(localItem, link);
            }
            catch (IOException e) {
                String message = MessageFormat.format(Messages.getString("CheckinEngine.CouldNotCreateTempFileForSymlinkFormat"), localItem, e.getLocalizedMessage());
                log.error((Object)message, (Throwable)e);
                throw new CheckinException(null, false, false, message);
            }
        }
        if (filterTempFile != null) {
            change = new PendingChange(change);
            change.setLocalItem(filterTempFile);
        }
        byte[] localMD5Hash = CheckinEngine.computeMD5Hash(change.getLocalItem(), TaskMonitorService.getTaskMonitor());
        byte[] serverHash = change.getUploadContentHashValue();
        if (serverHash == null) {
            serverHash = change.getHashValue();
        }
        if (serverHash != null && serverHash.length > 0 && Arrays.equals(serverHash, localMD5Hash)) {
            log.trace((Object)MessageFormat.format("skipped upload of {0} because hash codes match", change.getLocalItem()));
            if (filterTempFile != null) {
                TempStorageService.getInstance().cleanUpItem(new File(filterTempFile));
            }
            return;
        }
        completionService.submit(new CheckinWorker(TaskMonitorService.getTaskMonitor(), this.client, this.workspace, change, localMD5Hash, state));
    }

    private String createTempFile(PendingChange change) throws IOException {
        String tempFile = TempStorageService.getInstance().createTempFile().getAbsolutePath();
        log.trace((Object)MessageFormat.format("Using temporary file {0} for EOL conversion output", tempFile));
        FileCopyHelper.copy(change.getLocalItem(), tempFile);
        log.trace((Object)MessageFormat.format("Content copied from {0} to {1}", change.getLocalItem(), tempFile));
        return tempFile;
    }

    private String createTempFileForSymbolicLink(String localItem, String targetLink) throws IOException {
        String tempFile = TempStorageService.getInstance().createTempFile().getAbsolutePath();
        log.trace((Object)MessageFormat.format("Using temporary file {0} for symbolic link {1}", tempFile, localItem));
        BufferedWriter out = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(tempFile)));
        out.write(targetLink);
        ((Writer)out).close();
        log.trace((Object)MessageFormat.format("Symbolic link target {0} written to temporary file {1} as contents", targetLink, tempFile));
        return tempFile;
    }

    public static byte[] computeMD5Hash(String fileName, TaskMonitor taskMonitor) throws CoreCancelException {
        Check.notNullOrEmpty(fileName, "fileName");
        FileSystemUtils util = FileSystemUtils.getInstance();
        FileSystemAttributes attrs = util.getAttributes(fileName);
        if (attrs.isSymbolicLink()) {
            String linkTarget = util.getSymbolicLink(fileName);
            return HashUtils.hashString(linkTarget, null, "MD5");
        }
        File file = new File(fileName);
        try {
            return HashUtils.hashFile(file, "MD5", taskMonitor);
        }
        catch (CanceledException e) {
            throw new CoreCancelException();
        }
        catch (FileNotFoundException e) {
            throw new VersionControlException(e);
        }
        catch (IOException e) {
            throw new VersionControlException(e);
        }
    }
}

