/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.versioncontrol.engines.internal;

import com.microsoft.tfs.core.Messages;
import com.microsoft.tfs.core.clients.versioncontrol.ChangePendedFlags;
import com.microsoft.tfs.core.clients.versioncontrol.ClientLocalVersionUpdate;
import com.microsoft.tfs.core.clients.versioncontrol.GetOptions;
import com.microsoft.tfs.core.clients.versioncontrol.GetStatus;
import com.microsoft.tfs.core.clients.versioncontrol.OperationStatus;
import com.microsoft.tfs.core.clients.versioncontrol.ProcessType;
import com.microsoft.tfs.core.clients.versioncontrol.PropertyConstants;
import com.microsoft.tfs.core.clients.versioncontrol.PropertyUtils;
import com.microsoft.tfs.core.clients.versioncontrol.UpdateLocalVersionQueue;
import com.microsoft.tfs.core.clients.versioncontrol.UpdateLocalVersionQueueOptions;
import com.microsoft.tfs.core.clients.versioncontrol.VersionControlClient;
import com.microsoft.tfs.core.clients.versioncontrol.WebServiceLevel;
import com.microsoft.tfs.core.clients.versioncontrol.WorkspaceLocation;
import com.microsoft.tfs.core.clients.versioncontrol.WorkspaceOptions;
import com.microsoft.tfs.core.clients.versioncontrol.engines.internal.AsyncGetOperation;
import com.microsoft.tfs.core.clients.versioncontrol.engines.internal.RetryEntry;
import com.microsoft.tfs.core.clients.versioncontrol.engines.internal.workers.GetDownloadWorker;
import com.microsoft.tfs.core.clients.versioncontrol.engines.internal.workers.WorkerStatus;
import com.microsoft.tfs.core.clients.versioncontrol.events.EventSource;
import com.microsoft.tfs.core.clients.versioncontrol.events.GetEvent;
import com.microsoft.tfs.core.clients.versioncontrol.events.MergingEvent;
import com.microsoft.tfs.core.clients.versioncontrol.events.NonFatalErrorEvent;
import com.microsoft.tfs.core.clients.versioncontrol.events.PendingChangeEvent;
import com.microsoft.tfs.core.clients.versioncontrol.exceptions.DestroyedContentUnavailableException;
import com.microsoft.tfs.core.clients.versioncontrol.exceptions.PathTooLongException;
import com.microsoft.tfs.core.clients.versioncontrol.exceptions.ServerPathFormatException;
import com.microsoft.tfs.core.clients.versioncontrol.exceptions.VersionControlException;
import com.microsoft.tfs.core.clients.versioncontrol.internal.concurrent.AccountingCompletionService;
import com.microsoft.tfs.core.clients.versioncontrol.internal.fileattributes.FileAttribute;
import com.microsoft.tfs.core.clients.versioncontrol.internal.fileattributes.FileAttributeValues;
import com.microsoft.tfs.core.clients.versioncontrol.internal.fileattributes.FileAttributesCollection;
import com.microsoft.tfs.core.clients.versioncontrol.internal.fileattributes.FileAttributesEntry;
import com.microsoft.tfs.core.clients.versioncontrol.internal.fileattributes.FileAttributesFile;
import com.microsoft.tfs.core.clients.versioncontrol.internal.fileattributes.StringPairFileAttribute;
import com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace.BaselineFolderCollection;
import com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace.LocalVersionTransaction;
import com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace.LocalWorkspaceProperties;
import com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace.LocalWorkspaceTransaction;
import com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace.WorkspaceLocalItem;
import com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace.WorkspaceLock;
import com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace.WorkspacePropertiesTransaction;
import com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace.WorkspaceVersionTable;
import com.microsoft.tfs.core.clients.versioncontrol.localworkspace.BaselineFolder;
import com.microsoft.tfs.core.clients.versioncontrol.path.LocalPath;
import com.microsoft.tfs.core.clients.versioncontrol.path.ServerPath;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.ChangeType;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.Conflict;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.ConflictType;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.GetOperation;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.Item;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.ItemType;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.PendingChange;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.PropertyValue;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.RequestType;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.Workspace;
import com.microsoft.tfs.core.exceptions.TECoreException;
import com.microsoft.tfs.core.exceptions.internal.CoreCancelException;
import com.microsoft.tfs.core.util.CodePageMapping;
import com.microsoft.tfs.core.util.FileEncoding;
import com.microsoft.tfs.core.util.internal.AppleSingleUtil;
import com.microsoft.tfs.core.ws.runtime.exceptions.ProxyException;
import com.microsoft.tfs.jni.FileSystemAttributes;
import com.microsoft.tfs.jni.FileSystemUtils;
import com.microsoft.tfs.jni.PlatformMiscUtils;
import com.microsoft.tfs.jni.helpers.FileCopyHelper;
import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.FileHelpers;
import com.microsoft.tfs.util.GUID;
import com.microsoft.tfs.util.HashUtils;
import com.microsoft.tfs.util.NewlineUtils;
import com.microsoft.tfs.util.Platform;
import com.microsoft.tfs.util.datetime.DotNETDate;
import com.microsoft.tfs.util.shutdown.ShutdownEventListener;
import com.microsoft.tfs.util.shutdown.ShutdownManager;
import com.microsoft.tfs.util.tasks.CanceledException;
import com.microsoft.tfs.util.tasks.TaskMonitor;
import com.microsoft.tfs.util.tasks.TaskMonitorService;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.text.Collator;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class GetEngine {
    private static final int PROCESS_GET_OPERATIONS_UNIT_OF_WORK = 24;
    private static final ShutdownManager.Priority SHUTDOWN_HANDLER_PRIORITY = ShutdownManager.Priority.EARLY;
    private static final Log log = LogFactory.getLog(GetEngine.class);
    private final VersionControlClient client;
    private static FileAttributesCollection defaultFileAttributes;
    private List<FileAttributesEntry> globalAttributeEntries = null;
    private static final String EOL_CLIENT_ENVIRONMENT_VARIABLE = "TF_EOL_CLIENT";
    private static final String EOL_SERVER_ENVIRONMENT_VARIABLE = "TF_EOL_SERVER";
    private final Map<String, List<FileAttributesEntry>> localDirectoryToEntryListMap = new HashMap<String, List<FileAttributesEntry>>();

    public GetEngine(VersionControlClient client) {
        Check.notNull(client, "client");
        this.client = client;
    }

    public String getSymbolicLinkDestination(File tempFile, GetOperation operation, Workspace workspace) {
        boolean isSymlink;
        Check.notNull(workspace, "workspace");
        String targetLocalItem = operation.getTargetLocalItem();
        String targetServerItem = operation.getTargetServerItem();
        if (targetLocalItem == null) {
            return null;
        }
        if (PlatformMiscUtils.getInstance().getEnvironmentVariable("TF_DISABLE_SYMBOLIC_LINK_PROP") == null && (isSymlink = PropertyConstants.IS_SYMLINK.equals(PropertyUtils.selectMatching(operation.getPropertyValues(), "Microsoft.TeamFoundation.VersionControl.SymbolicLink")))) {
            String localDestinationPath = null;
            try {
                BufferedReader br = new BufferedReader(new FileReader(tempFile));
                localDestinationPath = br.readLine();
                br.close();
            }
            catch (IOException e) {
                this.onNonFatalError(e);
                return "";
            }
            if (localDestinationPath == null || localDestinationPath.length() == 0) {
                this.onNonFatalError(new IOException(MessageFormat.format(Messages.getString("GetEngine.CannotCreateTargetItemAsSymbolicLinkBecauseNoLocalDestinationPathSuppliedFormat"), targetLocalItem)));
                return "";
            }
            return localDestinationPath;
        }
        FileAttributesCollection attributes = this.getAttributesForFile(targetLocalItem, targetServerItem, this.isTextEncoding(operation.getEncoding()));
        if (attributes == null) {
            return null;
        }
        StringPairFileAttribute localLinkAttribute = attributes.getStringPairFileAttribute("local-link");
        if (localLinkAttribute != null) {
            String localDestinationPath = localLinkAttribute.getValue();
            if (localDestinationPath == null || localDestinationPath.length() == 0) {
                this.onNonFatalError(new IOException(MessageFormat.format(Messages.getString("GetEngine.CannotCreateTargetItemAsSymbolicLinkBecauseNoLocalDestinationPathSuppliedFormat"), targetLocalItem)));
                return "";
            }
            return localDestinationPath;
        }
        StringPairFileAttribute serverLinkAttribute = attributes.getStringPairFileAttribute("link");
        if (serverLinkAttribute != null) {
            String destinationServerPath = serverLinkAttribute.getValue();
            if (destinationServerPath == null || destinationServerPath.length() == 0) {
                this.onNonFatalError(new IOException(MessageFormat.format(Messages.getString("GetEngine.CannotCreateTargetItemAsSymbolicLinkBecauseNoDestinationPathSuppliedFormat"), targetLocalItem)));
                return "";
            }
            if (!destinationServerPath.startsWith("$/")) {
                String serverPathForLocalItem = workspace.getMappedServerPath(targetLocalItem);
                Check.notNull(serverPathForLocalItem, "serverPathForLocalItem");
                try {
                    destinationServerPath = ServerPath.canonicalize(ServerPath.getParent(serverPathForLocalItem) + "/" + destinationServerPath);
                }
                catch (ServerPathFormatException e) {
                    this.onNonFatalError(new ServerPathFormatException(MessageFormat.format(Messages.getString("GetEngine.CannotCreateTargetItemAsSymbolicLinkBecauseRelativeDestinationPathCouldNotBeParsedFormat"), targetLocalItem, destinationServerPath, e.getLocalizedMessage())));
                    return "";
                }
            }
            String localDestination = null;
            try {
                localDestination = workspace.getMappedLocalPath(destinationServerPath);
                if (localDestination == null) {
                    this.onNonFatalError(new IOException(MessageFormat.format(Messages.getString("GetEngine.CannotCreateTargetItemAsSymbolicLinkBecauseDestinationServerPathCannotBeMappedFormat"), targetLocalItem, destinationServerPath)));
                    return "";
                }
                if (!workspace.isLocalPathMapped(localDestination)) {
                    this.onNonFatalError(new IOException(MessageFormat.format(Messages.getString("GetEngine.CannotCreateTargetItemAsSymbolicLinkBecauseDestinationPathIsNotInsideMappedFolderFormat"), targetLocalItem, localDestination)));
                    return "";
                }
            }
            catch (ServerPathFormatException e) {
                this.onNonFatalError(new ServerPathFormatException(MessageFormat.format(Messages.getString("GetEngine.CannotCreateTargetItemAsSymbolicLinkBecauseAbsoluteDestinationPathCouldNotBeParsedFormat"), targetLocalItem, destinationServerPath, e.getLocalizedMessage())));
                return "";
            }
            return localDestination;
        }
        return null;
    }

    public void onNonFatalError(Throwable t) {
        this.onNonFatalError(t, null);
    }

    public void onNonFatalError(Throwable t, Workspace workspace) {
        if (workspace != null) {
            this.client.getEventEngine().fireNonFatalError(new NonFatalErrorEvent(EventSource.newFromHere(), workspace, t));
        } else {
            this.client.getEventEngine().fireNonFatalError(new NonFatalErrorEvent(EventSource.newFromHere(), this.client, t));
        }
    }

    private void fireGettingEvent(AsyncGetOperation asyncOp, OperationStatus status, GetOperation getOp, ChangeType targetChangeType, PropertyValue[] targetPropertyValues) {
        if (status == OperationStatus.TARGET_LOCAL_PENDING) {
            Check.isTrue(targetChangeType != ChangeType.NONE, "There should have been a target pending change: " + getOp);
        } else {
            targetChangeType = ChangeType.NONE;
        }
        this.client.getEventEngine().fireGet(new GetEvent(EventSource.newFromHere(), asyncOp, status, getOp, getOp.getTargetLocalItem(), targetChangeType, targetPropertyValues));
    }

    private void recordEvent(AsyncGetOperation asyncOp, OperationStatus status, GetOperation getOp) {
        this.recordEvent(asyncOp, status, getOp, null);
    }

    private void recordEvent(AsyncGetOperation asyncOp, OperationStatus status, GetOperation getOp, GetOperation targetOp) {
        PropertyValue[] targetPropertyValues;
        Check.isTrue(status != OperationStatus.DELETING || null == getOp.getTargetLocalItem(), "targetLocalItem must be null for deletion events");
        ChangeType targetChangeType = targetOp != null ? targetOp.getEffectiveChangeType() : ChangeType.NONE;
        PropertyValue[] propertyValueArray = targetPropertyValues = targetOp != null ? targetOp.getPropertyValues() : null;
        if (log.isTraceEnabled()) {
            log.trace((Object)MessageFormat.format("Recording OperationStatus.{0} for {1}", status, getOp.getTargetServerItem()));
        }
        try {
            if (asyncOp.getType() == ProcessType.PEND && getOp.getChangeType().contains(ChangeType.EDIT) && getOp.getVersionLocal() != getOp.getVersionServer()) {
                this.fireGettingEvent(asyncOp, status, getOp, targetChangeType, targetPropertyValues);
            }
            if (asyncOp.getType() == ProcessType.GET || (asyncOp.getType() == ProcessType.MERGE || asyncOp.getType() == ProcessType.ROLLBACK) && getOp.getMergeDetails() == null) {
                this.fireGettingEvent(asyncOp, status, getOp, targetChangeType, targetPropertyValues);
            } else if (asyncOp.getType() == ProcessType.PEND || asyncOp.getType() == ProcessType.UNDO || asyncOp.getType() == ProcessType.UNSHELVE) {
                if (getOp.getChangeType().contains(ChangeType.RENAME) && status == OperationStatus.SOURCE_DIRECTORY_NOT_EMPTY) {
                    this.onNonFatalError(new VersionControlException(MessageFormat.format(Messages.getString("GetEngine.CantDeleteNonEmptyDirPathFormat"), getOp.getSourceLocalItem())), asyncOp.getWorkspace());
                } else if (getOp.getChangeType().equals(ChangeType.NONE) && asyncOp.getType() == ProcessType.UNSHELVE) {
                    this.fireGettingEvent(asyncOp, status, getOp, targetChangeType, targetPropertyValues);
                } else {
                    PendingChange pc = new PendingChange(asyncOp.getWorkspace(), getOp, asyncOp.getType());
                    PendingChangeEvent event = new PendingChangeEvent(EventSource.newFromHere(), asyncOp.getWorkspace(), pc, status, asyncOp.getFlags());
                    if (asyncOp.getType() == ProcessType.UNDO) {
                        this.client.getEventEngine().fireUndonePendingChange(event);
                    } else {
                        this.client.getEventEngine().fireNewPendingChange(event);
                    }
                }
            } else if (asyncOp.getType() == ProcessType.MERGE || asyncOp.getType() == ProcessType.ROLLBACK) {
                Conflict mergeDetails = getOp.getMergeDetails();
                if (mergeDetails.getBaseChangeType().contains(ChangeType.RENAME) && status == OperationStatus.SOURCE_DIRECTORY_NOT_EMPTY) {
                    this.onNonFatalError(new VersionControlException(MessageFormat.format(Messages.getString("GetEngine.CantDeleteNonEmptyDirPathFormat"), mergeDetails.getTargetLocalItem())), asyncOp.getWorkspace());
                } else {
                    PendingChange pc = null;
                    if (getOp.hasPendingChange()) {
                        pc = new PendingChange(asyncOp.getWorkspace(), getOp, asyncOp.getType());
                    }
                    this.client.getEventEngine().fireMerging(new MergingEvent(EventSource.newFromHere(), mergeDetails, asyncOp.getWorkspace(), getOp.isLatest(), pc, status, targetChangeType, !asyncOp.isPreview(), getOp.getPropertyValues()));
                }
            }
        }
        catch (Exception e) {
            log.warn((Object)"Exception recording get event", (Throwable)e);
        }
    }

    public GetStatus processGetOperations(Workspace workspace, ProcessType type, GetOperation[] operations, GetOptions options, ChangePendedFlags flags) {
        GetOperation[][] operationSet = new GetOperation[][]{operations};
        return this.processGetOperations(workspace, type, RequestType.NONE, operationSet, options, false, true, flags);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GetStatus processGetOperations(final Workspace workspace, ProcessType type, RequestType requestType, final GetOperation[][] results, GetOptions options, boolean deleteUndoneAdds, boolean onlineOperation, ChangePendedFlags flags) throws CanceledException {
        Check.notNull(workspace, "workspace");
        Check.notNull(type, "type");
        Check.notNull(requestType, "requestType");
        Check.notNull(results, "results");
        Check.notNull(options, "options");
        Check.notNull(flags, "flags");
        log.debug((Object)("Set all get operations type to: " + type.toString()));
        int getOpsCount = 0;
        GetOperation[][] arr$ = results;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            GetOperation[] getOperations;
            for (GetOperation getOp : getOperations = arr$[i$]) {
                getOp.setProcessType(type);
                ++getOpsCount;
            }
        }
        log.debug((Object)("Get operations count: " + String.valueOf(getOpsCount)));
        UpdateLocalVersionQueueOptions localUpdateOptions = this.calculateUpdateLocalVersionOptions(workspace, type, requestType, onlineOperation);
        log.debug((Object)("localUpdateOptions: " + localUpdateOptions.toString()));
        log.debug((Object)("options: " + options.toString()));
        final ArrayList remapUpdates = new ArrayList();
        if (WorkspaceLocation.LOCAL == workspace.getLocation() && options.contains(GetOptions.REMAP)) {
            LocalWorkspaceTransaction transaction = new LocalWorkspaceTransaction(workspace);
            try {
                log.debug((Object)"Trying to remap versions in the local workspace");
                transaction.execute(new LocalVersionTransaction(){

                    @Override
                    public void invoke(WorkspaceVersionTable lv) {
                        boolean setLastFileTimeToCheckin = workspace.getOptions().contains(WorkspaceOptions.SET_FILE_TO_CHECKIN);
                        GetOperation[][] arr$ = results;
                        int len$ = arr$.length;
                        for (int i$ = 0; i$ < len$; ++i$) {
                            GetOperation[] getOperations;
                            for (GetOperation getOp : getOperations = arr$[i$]) {
                                if (null == getOp.getTargetLocalItem() || !LocalPath.equals(getOp.getSourceLocalItem(), getOp.getTargetLocalItem()) || getOp.getVersionLocal() != getOp.getVersionServer()) continue;
                                getOp.setIgnore(true);
                                WorkspaceLocalItem lvExisting = lv.getByLocalItem(getOp.getTargetLocalItem());
                                if (null == lvExisting) continue;
                                if (setLastFileTimeToCheckin && !DotNETDate.MIN_CALENDAR.equals(getOp.getVersionServerDate()) && -3 != getOp.getEncoding() && new File(getOp.getTargetLocalItem()).exists()) {
                                    try {
                                        File targetLocalFile = new File(getOp.getTargetLocalItem());
                                        FileSystemAttributes attrs = FileSystemUtils.getInstance().getAttributes(targetLocalFile);
                                        boolean restoreReadOnly = false;
                                        if (attrs.isReadOnly()) {
                                            attrs.setReadOnly(false);
                                            FileSystemUtils.getInstance().setAttributes(targetLocalFile, attrs);
                                            restoreReadOnly = true;
                                        }
                                        targetLocalFile.setLastModified(getOp.getVersionServerDate().getTimeInMillis());
                                        if (restoreReadOnly) {
                                            attrs.setReadOnly(true);
                                            FileSystemUtils.getInstance().setAttributes(targetLocalFile, attrs);
                                        }
                                    }
                                    catch (Exception ex) {
                                        log.warn((Object)"Error setting file time for get with remap", (Throwable)ex);
                                    }
                                }
                                remapUpdates.add(new ClientLocalVersionUpdate(getOp.getSourceServerItem(), getOp.getItemID(), getOp.getTargetLocalItem(), getOp.getVersionServer(), getOp.getVersionServerDate(), getOp.getEncoding(), lvExisting.getHashValue(), lvExisting.getLength(), lvExisting.getBaselineFileGUID(), null, getOp.getPropertyValues()));
                            }
                        }
                    }
                });
            }
            finally {
                try {
                    transaction.close();
                }
                catch (IOException e) {
                    throw new VersionControlException(e);
                }
            }
            log.debug((Object)"The remapUpdates list has been prepared");
        }
        WorkspaceLock wLock = workspace.lock();
        try {
            final AtomicReference baselineFolders = new AtomicReference();
            if (workspace.getLocation() == WorkspaceLocation.LOCAL) {
                LocalWorkspaceTransaction transaction = new LocalWorkspaceTransaction(workspace);
                try {
                    transaction.execute(new WorkspacePropertiesTransaction(){

                        @Override
                        public void invoke(LocalWorkspaceProperties wp) {
                            baselineFolders.set(new BaselineFolderCollection(workspace, wp.getBaselineFolders()));
                        }
                    });
                }
                finally {
                    try {
                        transaction.close();
                    }
                    catch (IOException e) {
                        throw new VersionControlException(e);
                    }
                }
                wLock.setBaselineFolders((BaselineFolderCollection)baselineFolders.get());
            }
            log.debug((Object)("remapUpdates.size(): " + remapUpdates.size()));
            if (remapUpdates.size() > 0) {
                Check.isTrue(localUpdateOptions.contains(UpdateLocalVersionQueueOptions.UPDATE_SERVER), "localUpdateOptions.contains(UpdateLocalVersionQueueOptions.UPDATE_SERVER)");
                UpdateLocalVersionQueue ulvq = new UpdateLocalVersionQueue(workspace, localUpdateOptions, wLock, 5000, 10000, Integer.MAX_VALUE);
                try {
                    for (ClientLocalVersionUpdate remapUpdate : remapUpdates) {
                        ulvq.queueUpdate(remapUpdate);
                    }
                }
                finally {
                    ulvq.close();
                }
                log.debug((Object)"Local version updates have been successfully queued.");
            }
            AsyncGetOperation asyncOp = new AsyncGetOperation(workspace, type, requestType, options, deleteUndoneAdds, wLock, localUpdateOptions, flags, new AccountingCompletionService<WorkerStatus>(this.client.getUploadDownloadWorkerExecutor()));
            log.debug((Object)"Preparing Get Operation actions");
            GetOperation[] actions = this.prepareGetOperations(asyncOp, results);
            log.debug((Object)("Number of Get Operation actions prepared: " + actions.length));
            this.processOperations(asyncOp, actions);
            log.debug((Object)"All Get Operation actions have been processed.");
            GetStatus getStatus = asyncOp.getStatus();
            return getStatus;
        }
        catch (CoreCancelException e) {
            throw new CanceledException();
        }
        finally {
            if (wLock != null) {
                wLock.close();
            }
        }
    }

    private UpdateLocalVersionQueueOptions calculateUpdateLocalVersionOptions(Workspace workspace, ProcessType type, RequestType requestType, boolean onlineOperation) {
        UpdateLocalVersionQueueOptions localUpdateOptions = UpdateLocalVersionQueueOptions.UPDATE_BOTH;
        if (WorkspaceLocation.LOCAL == workspace.getLocation()) {
            if (ProcessType.PEND == type) {
                if (requestType == RequestType.ADD || requestType == RequestType.EDIT || requestType == RequestType.DELETE || requestType == RequestType.RENAME) {
                    localUpdateOptions = UpdateLocalVersionQueueOptions.UPDATE_LOCAL;
                }
                UpdateLocalVersionQueueOptions updateLocalVersionQueueOptions = localUpdateOptions = onlineOperation ? localUpdateOptions.combine(UpdateLocalVersionQueueOptions.UPDATE_SERVER) : localUpdateOptions;
            }
            if (ProcessType.UNDO == type) {
                localUpdateOptions = UpdateLocalVersionQueueOptions.UPDATE_LOCAL;
                if (onlineOperation) {
                    localUpdateOptions = localUpdateOptions.combine(UpdateLocalVersionQueueOptions.UPDATE_SERVER);
                }
            }
        }
        return localUpdateOptions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processOperations(AsyncGetOperation asyncOp, GetOperation[] actions) throws CoreCancelException {
        Check.notNull(asyncOp, "asyncOp");
        Check.notNull(actions, "actions");
        if (actions.length == 0) {
            return;
        }
        TaskMonitor taskMonitor = TaskMonitorService.getTaskMonitor();
        taskMonitor.begin(null, 100);
        try {
            if (WorkspaceLocation.LOCAL == asyncOp.getWorkspace().getLocation() && asyncOp.getLocalUpdateOptions().contains(UpdateLocalVersionQueueOptions.UPDATE_SERVER)) {
                log.debug((Object)"Preparing local version updates: begins");
                taskMonitor.setCurrentWorkDescription(Messages.getString("GetEngine.PreparingLocalVersionUpdates"));
                final GetOperation[] transactionActions = actions;
                LocalWorkspaceTransaction transaction = new LocalWorkspaceTransaction(asyncOp.getWorkspace());
                try {
                    transaction.execute(new LocalVersionTransaction(){

                        @Override
                        public void invoke(WorkspaceVersionTable lv) {
                            for (GetOperation operation : transactionActions) {
                                if (null == operation.getTargetLocalItem()) continue;
                                operation.setLocalVersionEntry(lv.getByLocalItem(operation.getTargetLocalItem()));
                            }
                        }
                    });
                }
                finally {
                    try {
                        transaction.close();
                    }
                    catch (IOException e) {
                        throw new VersionControlException(e);
                    }
                }
                log.debug((Object)"Preparing local version updates: ended");
            }
            taskMonitor.worked(1);
            ShutdownMonitor shutdownMonitor = new ShutdownMonitor();
            GetShutdownEventListener getInterruptedShutdownListener = new GetShutdownEventListener(taskMonitor, shutdownMonitor);
            try {
                ShutdownManager.getInstance().addShutdownEventListener(getInterruptedShutdownListener, SHUTDOWN_HANDLER_PRIORITY);
                asyncOp.getStatus().setNumOperations(actions.length);
                for (GetOperation action : actions) {
                    if (!action.isIgnore()) continue;
                    asyncOp.getStatus().decrementNumOperations();
                }
                log.debug((Object)"Getting files: started");
                TaskMonitor gettingTaskMonitor = taskMonitor.newSubTaskMonitor(98);
                gettingTaskMonitor.begin(Messages.getString("GetEngine.Getting"), actions.length);
                try {
                    while (true) {
                        this.processOperationsInternal(asyncOp, actions, gettingTaskMonitor);
                        int retryCount = actions.length;
                        Check.isTrue(asyncOp.getRetryList().size() <= retryCount, "The retry list size exceeded the previous one!");
                        if (asyncOp.isPreview() || asyncOp.getRetryList().size() == 0) break;
                        if (asyncOp.getRetryList().size() >= retryCount) {
                            break;
                        }
                        actions = new GetOperation[asyncOp.getRetryList().size()];
                        for (int i = 0; i < actions.length; ++i) {
                            actions[i] = asyncOp.getRetryList().get(i).getRetryOp();
                        }
                        asyncOp.resetForRetry();
                    }
                }
                finally {
                    gettingTaskMonitor.done();
                }
                log.debug((Object)"Getting files: ended");
                for (RetryEntry entry : asyncOp.getRetryList()) {
                    if (entry.getStatus() == OperationStatus.SOURCE_DIRECTORY_NOT_EMPTY && entry.getRetryOp().getTargetLocalItem() != null && asyncOp.getDontDeleteFolderHash().containsKey(entry.getRetryOp().getTargetLocalItem())) {
                        this.onNonFatalError(new Exception(MessageFormat.format(Messages.getString("GetEngine.CantDeleteNonEmptyDirPathFormat"), entry.getRetryOp().getCurrentLocalItem())), asyncOp.getWorkspace());
                        continue;
                    }
                    if (!asyncOp.isPreview() && entry.getStatus() == OperationStatus.SOURCE_DIRECTORY_NOT_EMPTY && entry.getRetryOp().getTargetLocalItem() == null) {
                        asyncOp.queueLocalVersionUpdate(entry.getRetryOp(), null, entry.getRetryOp().getVersionLocal());
                    }
                    asyncOp.getStatus().incrementNumWarnings();
                    if (!(asyncOp.isPreview() || entry.getStatus() != OperationStatus.SOURCE_WRITABLE && entry.getStatus() != OperationStatus.TARGET_WRITABLE && entry.getStatus() != OperationStatus.TARGET_LOCAL_PENDING)) {
                        asyncOp.getLocalUpdateQueue().flush();
                        asyncOp.getWorkspace().addConflict(ConflictType.LOCAL, entry.getRetryOp().getItemID(), entry.getRetryOp().getVersionServer(), entry.getRetryOp().getPendingChangeID(), entry.getRetryOp().getCurrentLocalItem(), entry.getRetryOp().getTargetLocalItem(), entry.getStatus());
                        asyncOp.getStatus().setHaveResolvableWarnings(true);
                    }
                    this.recordEvent(asyncOp, entry.getStatus(), entry.getRetryOp(), entry.getTargetAction());
                }
            }
            finally {
                taskMonitor.setCurrentWorkDescription(Messages.getString("GetEngine.WaitingForVersionUpdatesToFinish"));
                try {
                    asyncOp.getLocalUpdateQueue().close();
                }
                finally {
                    taskMonitor.worked(1);
                    ShutdownManager.getInstance().removeShutdownEventListener(getInterruptedShutdownListener, SHUTDOWN_HANDLER_PRIORITY);
                    log.trace((Object)"acquiring shutdown monitor lock from get loop");
                    ShutdownMonitor shutdownMonitor2 = shutdownMonitor;
                    synchronized (shutdownMonitor2) {
                        log.trace((Object)"setting isShutdown");
                        shutdownMonitor.setShutdown();
                        log.trace((Object)"notifying all listeners");
                        shutdownMonitor.notifyAll();
                    }
                }
            }
        }
        finally {
            taskMonitor.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processOperationsInternal(AsyncGetOperation asyncOp, GetOperation[] actions, TaskMonitor gettingTaskMonitor) throws CoreCancelException {
        Check.notNull(asyncOp, "asyncOp");
        Check.notNull(actions, "actions");
        Check.notNull(gettingTaskMonitor, "taskMonitor");
        log.debug((Object)"Try processOperationsInternal: started");
        try {
            int actionCount = 0;
            for (GetOperation action : actions) {
                if (0 == actionCount++ % 24 && WorkspaceLocation.LOCAL == asyncOp.getWorkspace().getLocation() && asyncOp.getWorkspaceLock().isYieldRequested()) {
                    GetEngine.waitForCompletions(asyncOp.getCompletionService());
                    asyncOp.getLocalUpdateQueue().flush();
                    asyncOp.getWorkspaceLock().yield();
                }
                if (action.isIgnore()) continue;
                this.throwIfCanceled(gettingTaskMonitor);
                this.throwIfFatalError(asyncOp);
                gettingTaskMonitor.setCurrentWorkDescription(action.getTargetServerItem());
                this.processOperation(action, asyncOp);
                gettingTaskMonitor.worked(1);
            }
        }
        finally {
            log.debug((Object)"Try processOperationsInternal: waiting for downloads completion");
            GetEngine.waitForCompletions(asyncOp.getCompletionService());
        }
        log.debug((Object)"Try processOperationsInternal: finished successfully");
        this.throwIfCanceled(gettingTaskMonitor);
        this.throwIfFatalError(asyncOp);
        this.finishDirectoryDeletionsAndMoves(asyncOp, gettingTaskMonitor);
    }

    public void deleteSource(GetOperation operation, FileSystemAttributes existingLocalAttrs) {
        Check.notNull(operation, "op");
        if (!existingLocalAttrs.exists()) {
            return;
        }
        if (operation.getItemType() == ItemType.FOLDER) {
            if (existingLocalAttrs.isDirectory()) {
                new File(operation.getCurrentLocalItem()).delete();
                log.debug((Object)MessageFormat.format("Deleted directory: {0}", operation.getCurrentLocalItem()));
                return;
            }
        } else if (operation.getItemType() == ItemType.FILE) {
            if (existingLocalAttrs.isDirectory() && !existingLocalAttrs.isSymbolicLink()) {
                throw new VersionControlException(MessageFormat.format(Messages.getString("GetEngine.FileIsADirectoryFormat"), operation.getCurrentLocalItem()));
            }
            new File(operation.getCurrentLocalItem()).delete();
            log.debug((Object)MessageFormat.format("Deleted file: {0}", operation.getCurrentLocalItem()));
        } else {
            Check.isTrue(operation.getTargetServerItem() == null && operation.getVersionServer() == 0, "Cannot pass ItemType of any when there is server information");
            if (existingLocalAttrs.isDirectory()) {
                new File(operation.getCurrentLocalItem()).delete();
                log.debug((Object)MessageFormat.format("Deleted directory: {0}", operation.getCurrentLocalItem()));
            } else {
                new File(operation.getCurrentLocalItem()).delete();
                log.debug((Object)MessageFormat.format("Deleted file: {0}", operation.getCurrentLocalItem()));
            }
            return;
        }
    }

    private GetOperation[] prepareGetOperations(AsyncGetOperation asyncOp, GetOperation[][] results) {
        Check.notNull(asyncOp, "asyncOp");
        Check.notNull(results, "results");
        TreeMap<String, GetOperation> newLocalItemHash = null;
        if (results.length > 1) {
            newLocalItemHash = new TreeMap<String, GetOperation>(LocalPath.TOP_DOWN_COMPARATOR);
        }
        System.currentTimeMillis();
        for (int i = 0; i < results.length; ++i) {
            GetOperation[] tempGetOps;
            for (GetOperation getOp : tempGetOps = results[i]) {
                String newLocalItem;
                String sourceLocalItem = getOp.getSourceLocalItem();
                if (sourceLocalItem != null) {
                    if (results.length == 1) {
                        if (!asyncOp.getExistingLocalHash().containsKey(sourceLocalItem)) {
                            asyncOp.getExistingLocalHash().put(sourceLocalItem, getOp);
                            continue;
                        }
                        this.onNonFatalError(new Exception(MessageFormat.format(Messages.getString("GetEngine.ServerGateUsTwoGetOperationsForSameLocalPathMayRequireMultipleGetsFormat"), sourceLocalItem)));
                        continue;
                    }
                    if (sourceLocalItem == null) continue;
                    if (!asyncOp.getExistingLocalHash().containsKey(sourceLocalItem)) {
                        asyncOp.getExistingLocalHash().put(sourceLocalItem, getOp);
                        continue;
                    }
                    GetOperation existingOp = asyncOp.getExistingLocalHash().get(sourceLocalItem);
                    if (existingOp.getTargetLocalItem() != null || getOp.getTargetLocalItem() == null) continue;
                    asyncOp.getExistingLocalHash().put(sourceLocalItem, getOp);
                    continue;
                }
                if (results.length == 1 || (newLocalItem = getOp.getTargetLocalItem()) == null || newLocalItemHash.containsKey(newLocalItem)) continue;
                newLocalItemHash.put(newLocalItem, getOp);
            }
        }
        TreeSet<GetOperation> getOps = new TreeSet<GetOperation>(GetOperation.GET_OPERATION_COMPARATOR);
        if (results.length == 1) {
            getOps.addAll(Arrays.asList(results[0]));
        } else {
            getOps.addAll(asyncOp.getExistingLocalHash().values());
            getOps.addAll(newLocalItemHash.values());
        }
        asyncOp.totalNumOperations = getOps.size();
        return getOps.toArray(new GetOperation[getOps.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishDirectoryDeletionsAndMoves(AsyncGetOperation asyncOp, TaskMonitor taskMonitor) throws CoreCancelException {
        Check.notNull(asyncOp, "asyncOp");
        Check.notNull(taskMonitor, "taskMonitor");
        for (GetOperation delete : asyncOp.getDeletes().values()) {
            this.throwIfCanceled(taskMonitor);
            if (delete.getCurrentLocalItem() == null || asyncOp.getDontDeleteFolderHash().containsKey(delete.getCurrentLocalItem())) continue;
            try {
                FileSystemAttributes attrs = FileSystemUtils.getInstance().getAttributes(delete.getCurrentLocalItem());
                boolean dirExists = attrs.exists();
                if (null != asyncOp.getBaselineFolders() && asyncOp.getBaselineFolders().isImmediateParentOfBaselineFolder(delete.getSourceLocalItem())) {
                    this.clearBaselineFoldersBeneathPath(asyncOp.getWorkspace(), delete.getSourceLocalItem());
                }
                if (asyncOp.isPreview() || asyncOp.isNoDiskUpdate() || !dirExists || LocalPath.isDirectoryEmpty(delete.getSourceLocalItem())) {
                    boolean deleteAsUndoAdd = GetEngine.shouldDeleteAsUndoAdd(asyncOp, delete);
                    String newLocalItem = delete.getTargetLocalItem();
                    if (!(deleteAsUndoAdd || newLocalItem != null && asyncOp.getDontDeleteFolderHash().get(newLocalItem) == delete)) {
                        this.recordEvent(asyncOp, OperationStatus.DELETING, delete);
                        if (!asyncOp.isPreview()) {
                            asyncOp.queueLocalVersionUpdate(delete, null, delete.getVersionLocal());
                        }
                    }
                    delete.setDownloadCompleted(true);
                    asyncOp.getExistingLocalHash().remove(delete.getCurrentLocalItem());
                    try {
                        if (asyncOp.isPreview() || asyncOp.isNoDiskUpdate()) continue;
                        this.deleteSource(delete, attrs);
                        continue;
                    }
                    finally {
                        delete.clearLocalItem();
                        continue;
                    }
                }
                asyncOp.addWarning(OperationStatus.SOURCE_DIRECTORY_NOT_EMPTY, delete, null);
            }
            catch (ProxyException e) {
                throw e;
            }
            catch (Exception e) {
                this.onNonFatalError(e, asyncOp.getWorkspace());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearBaselineFoldersBeneathPath(Workspace workspace, final String sourceLocalItem) {
        LocalWorkspaceTransaction transaction = new LocalWorkspaceTransaction(workspace);
        try {
            transaction.execute(new WorkspacePropertiesTransaction(){

                @Override
                public void invoke(LocalWorkspaceProperties wp) {
                    while (true) {
                        BaselineFolder toRemove = null;
                        for (BaselineFolder baselineFolder : wp.getBaselineFolders()) {
                            if (null == baselineFolder.path || !LocalPath.isDirectChild(sourceLocalItem, baselineFolder.path)) continue;
                            toRemove = baselineFolder;
                            break;
                        }
                        if (null == toRemove) break;
                        wp.removeBaselineFolder(toRemove);
                    }
                }
            });
        }
        finally {
            try {
                transaction.close();
            }
            catch (IOException e) {
                throw new VersionControlException(e);
            }
        }
    }

    private static boolean shouldDeleteAsUndoAdd(AsyncGetOperation asyncOp, GetOperation getOp) {
        return asyncOp.getDeleteUndoneAdds() && getOp.getChangeType().contains(ChangeType.ADD) && ProcessType.UNDO == getOp.getType();
    }

    private boolean isWritableFileConflict(AsyncGetOperation asyncOp, GetOperation action, FileSystemAttributes newLocalAttrs) {
        if (action.isOkayToOverwriteExistingLocal() && LocalPath.equals(action.getSourceLocalItem(), action.getTargetLocalItem())) {
            return false;
        }
        if (WorkspaceLocation.SERVER == asyncOp.getWorkspace().getLocation()) {
            if (newLocalAttrs.isReadOnly() || newLocalAttrs.isDirectory()) {
                return false;
            }
        } else {
            if (newLocalAttrs.isDirectory()) {
                return false;
            }
            WorkspaceLocalItem lvEntry = action.getLocalVersionEntry();
            boolean fileIsWritable = false;
            fileIsWritable |= null == lvEntry;
            if (null != lvEntry) {
                fileIsWritable |= lvEntry.getLength() != newLocalAttrs.getSize();
                long onDiskModifiedTime = newLocalAttrs.getModificationTime().getWindowsFilesystemTime();
                fileIsWritable |= lvEntry.getLastModifiedTime() != onDiskModifiedTime;
            }
            if (!fileIsWritable) {
                return false;
            }
        }
        return !GetEngine.localContentIsRedundant(action.getTargetLocalItem(), action.getHashValue());
    }

    private static boolean localContentIsRedundant(String localItemPath, byte[] serverHashValue) {
        byte[] localHashValue;
        try {
            localHashValue = HashUtils.hashFile(new File(localItemPath), "MD5");
        }
        catch (Exception e) {
            return false;
        }
        boolean redundant = false;
        if (serverHashValue != null && localHashValue != null && serverHashValue.length != 0) {
            redundant = Arrays.equals(serverHashValue, localHashValue);
        }
        return redundant;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processOperation(GetOperation action, AsyncGetOperation asyncOp) {
        block120: {
            Check.notNull(action, "action");
            Check.notNull(asyncOp, "asyncOp");
            String newLocalItem = action.getTargetLocalItem();
            if (newLocalItem != null && !asyncOp.isPreview()) {
                try {
                    LocalPath.checkLocalItem(newLocalItem, null, false, false, false, true);
                }
                catch (PathTooLongException e) {
                    log.warn((Object)"Path too long, not getting", (Throwable)e);
                    this.onNonFatalError(new VersionControlException(MessageFormat.format(Messages.getString("GetEngine.LocalPathTooLongFormat"), newLocalItem)), asyncOp.getWorkspace());
                    return;
                }
            }
            if (action.isDownloadCompleted()) {
                return;
            }
            if (action.hasConflict()) {
                asyncOp.addConflict(action);
                this.recordEvent(asyncOp, OperationStatus.CONFLICT, action);
                return;
            }
            boolean isCaseChangingRename = action.isCaseChangingRename();
            boolean downloadCompletedHere = false;
            try {
                boolean existingLocalExists;
                FileSystemAttributes existingLocalAttrs;
                block123: {
                    boolean deleteAsUndoAdd;
                    boolean newLocalExists;
                    FileSystemAttributes newLocalAttrs;
                    block124: {
                        Object util;
                        block121: {
                            block122: {
                                existingLocalAttrs = new FileSystemAttributes();
                                existingLocalExists = false;
                                if (action.getCurrentLocalItem() != null) {
                                    existingLocalAttrs = FileSystemUtils.getInstance().getAttributes(action.getCurrentLocalItem());
                                    existingLocalExists = existingLocalAttrs.exists();
                                    log.debug((Object)MessageFormat.format("existingLocalAttrs = {0}, existingLocalExists = {1}", existingLocalAttrs, existingLocalExists));
                                    if (asyncOp.getType() == ProcessType.UNDO && action.getChangeType().contains(ChangeType.EDIT) && !action.getChangeType().contains(ChangeType.ADD)) {
                                        action.setOkayToOverwriteExistingLocal(true);
                                        if (WorkspaceLocation.SERVER == asyncOp.getWorkspace().getLocation() && !existingLocalAttrs.isReadOnly()) {
                                            existingLocalAttrs.setReadOnly(true);
                                            existingLocalAttrs.setArchive(false);
                                            FileSystemUtils.getInstance().setAttributes(action.getCurrentLocalItem(), existingLocalAttrs);
                                            log.debug((Object)MessageFormat.format("Setting file to read only (archive=true) as part of undoing an edit: {0}", action.getCurrentLocalItem()));
                                        }
                                    }
                                    if (existingLocalExists && (newLocalItem == null || !LocalPath.equals(action.getCurrentLocalItem(), newLocalItem)) && action.getItemType() == ItemType.FILE && !existingLocalAttrs.isSymbolicLink() && existingLocalAttrs.isDirectory()) {
                                        existingLocalExists = false;
                                    }
                                }
                                newLocalAttrs = new FileSystemAttributes();
                                newLocalExists = false;
                                GetOperation targetAction = null;
                                if (newLocalItem != null) {
                                    newLocalAttrs = FileSystemUtils.getInstance().getAttributes(newLocalItem);
                                    newLocalExists = newLocalAttrs.exists();
                                    log.debug((Object)MessageFormat.format("newLocalAttrs = {0}, newLocalExists = {1}", newLocalAttrs.toString(), newLocalExists));
                                    log.debug((Object)MessageFormat.format("NewContentNeeded = {0}", action.isNewContentNeeded()));
                                    if (newLocalExists && action.getItemType() != ItemType.FOLDER && !newLocalAttrs.isSymbolicLink() && newLocalAttrs.isDirectory()) {
                                        asyncOp.addWarning(OperationStatus.TARGET_IS_DIRECTORY, action);
                                        log.debug((Object)MessageFormat.format("TargetIsDirectory, newLocalItem = {0}", newLocalItem));
                                        return;
                                    }
                                    targetAction = asyncOp.getExistingLocalHash().get(newLocalItem);
                                    if (targetAction != null && targetAction != action && !isCaseChangingRename) {
                                        if (newLocalExists && action.getType() != ProcessType.UNSHELVE && action.getType() != ProcessType.MERGE && action.getType() != ProcessType.ROLLBACK && action.getType() != ProcessType.UNDO && !targetAction.getEffectiveChangeType().isEmpty()) {
                                            asyncOp.addWarning(OperationStatus.TARGET_LOCAL_PENDING, action, targetAction);
                                            log.debug((Object)MessageFormat.format("TargetLocalPending, newLocalItem = {0}, targetAction.ChangeType = {1}", newLocalItem, targetAction.getEffectiveChangeType()));
                                            return;
                                        }
                                        if (newLocalExists && !asyncOp.isOverwrite() && this.isWritableFileConflict(asyncOp, action, newLocalAttrs) && !newLocalAttrs.isSymbolicLink()) {
                                            asyncOp.addWarning(OperationStatus.TARGET_WRITABLE, action);
                                            log.debug((Object)MessageFormat.format("TargetWritable, newLocalItem = {0}", newLocalItem));
                                            return;
                                        }
                                        if (targetAction.getItemType() == ItemType.FILE) {
                                            GetOperation getOperation = targetAction;
                                            synchronized (getOperation) {
                                                log.debug((Object)MessageFormat.format("ProcessOperation: clearing source local item {0}", action.getCurrentLocalItem()));
                                                if (!asyncOp.isPreview() && !targetAction.isDownloadCompleted() && targetAction.isDelete()) {
                                                    asyncOp.queueLocalVersionUpdate(targetAction, null, targetAction.getVersionLocal());
                                                }
                                                if (targetAction.isDelete() && !targetAction.isDownloadCompleted()) {
                                                    targetAction.setDownloadCompleted(true);
                                                    downloadCompletedHere = true;
                                                    this.recordEvent(asyncOp, OperationStatus.DELETING, targetAction);
                                                }
                                                targetAction.clearLocalItem();
                                                asyncOp.getExistingLocalHash().remove(newLocalItem);
                                            }
                                        }
                                    }
                                }
                                deleteAsUndoAdd = GetEngine.shouldDeleteAsUndoAdd(asyncOp, action);
                                if (action.isDelete()) break block123;
                                if (action.getItemType() == ItemType.FOLDER) {
                                    if (!asyncOp.isOverwrite() && newLocalExists && this.isWritableFileConflict(asyncOp, action, newLocalAttrs)) {
                                        asyncOp.addWarning(OperationStatus.TARGET_WRITABLE, action);
                                        log.debug((Object)MessageFormat.format("TargetWritable, newLocalItem = {0}", newLocalItem));
                                        return;
                                    }
                                    if (!asyncOp.isPreview() && !asyncOp.isNoDiskUpdate() && newLocalExists && !newLocalAttrs.isDirectory()) {
                                        if (!new File(newLocalItem).delete()) {
                                            throw new IOException(MessageFormat.format(Messages.getString("GetEngine.CouldNotDeleteFileFormat"), newLocalItem));
                                        }
                                        log.debug((Object)MessageFormat.format("Deleting read-only file that''s in the way of a directory: {0}", newLocalItem));
                                        newLocalExists = false;
                                    }
                                    String sourceLocalItem = null;
                                    if (isCaseChangingRename && existingLocalExists) {
                                        sourceLocalItem = action.getCurrentLocalItem();
                                    } else if (newLocalExists && targetAction != null && targetAction.getItemType() == ItemType.FOLDER && targetAction.isDelete() && !LocalPath.lastPartEqualsCaseSensitive(targetAction.getCurrentLocalItem(), newLocalItem)) {
                                        sourceLocalItem = targetAction.getCurrentLocalItem();
                                    }
                                    if (!(asyncOp.isPreview() || newLocalExists && sourceLocalItem == null)) {
                                        if (sourceLocalItem != null) {
                                            try {
                                                FileHelpers.rename(sourceLocalItem, newLocalItem);
                                                log.debug((Object)MessageFormat.format("Renamed directory: {0} -> {1}", action.getCurrentLocalItem(), newLocalItem));
                                            }
                                            catch (IOException e) {
                                                this.onNonFatalError(new IOException(MessageFormat.format(Messages.getString("GetEngine.FailedToRenameDirectoryFormat"), sourceLocalItem, newLocalItem)), asyncOp.getWorkspace());
                                            }
                                        } else if (!asyncOp.isNoDiskUpdate()) {
                                            File newLocalFile = new File(newLocalItem);
                                            if (!newLocalFile.mkdirs()) {
                                                if (!newLocalFile.isDirectory()) {
                                                    this.onNonFatalError(new IOException(MessageFormat.format(Messages.getString("GetEngine.FailedToCreateDirectoryFormat"), newLocalItem)), asyncOp.getWorkspace());
                                                }
                                            } else {
                                                log.debug((Object)MessageFormat.format("Created directory: {0}", newLocalItem));
                                            }
                                        }
                                    }
                                    if (deleteAsUndoAdd) {
                                        if (!asyncOp.getDeletes().containsKey(newLocalItem)) {
                                            asyncOp.getDeletes().put(newLocalItem, action);
                                        }
                                    } else if (!asyncOp.getDontDeleteFolderHash().containsKey(newLocalItem)) {
                                        asyncOp.getDontDeleteFolderHash().put(newLocalItem, action);
                                    }
                                    if (existingLocalExists && !LocalPath.equals(action.getCurrentLocalItem(), newLocalItem)) {
                                        if (!asyncOp.getDeletes().containsKey(action.getCurrentLocalItem())) {
                                            asyncOp.getDeletes().put(action.getCurrentLocalItem(), action);
                                        }
                                        this.recordEvent(asyncOp, action.getCurrentLocalItem() == null ? OperationStatus.GETTING : OperationStatus.REPLACING, action);
                                        if (!asyncOp.isPreview()) {
                                            asyncOp.queueLocalVersionUpdate(action, action.getTargetLocalItem(), action.getVersionServer());
                                            action.setDownloadCompleted(true);
                                            downloadCompletedHere = true;
                                        }
                                    } else {
                                        this.recordEvent(asyncOp, action.getCurrentLocalItem() == null ? OperationStatus.GETTING : OperationStatus.REPLACING, action);
                                        if (!asyncOp.isPreview() && (asyncOp.getType() != ProcessType.PEND && asyncOp.getType() != ProcessType.UNDO || !action.getEffectiveChangeType().contains(ChangeType.ADD))) {
                                            asyncOp.queueLocalVersionUpdate(action, action.getTargetLocalItem(), action.getVersionServer(), asyncOp.getWorkspace().getLocation() == WorkspaceLocation.LOCAL);
                                            action.setDownloadCompleted(true);
                                            downloadCompletedHere = true;
                                        }
                                    }
                                    break block120;
                                }
                                if (!existingLocalExists || (!action.getEffectiveChangeType().contains(ChangeType.EDIT) || action.getVersionLocal() != action.getVersionServer()) && (asyncOp.isGetAll() || action.isNewContentNeeded())) break block124;
                                try {
                                    if (!LocalPath.equals(action.getCurrentLocalItem(), newLocalItem, true)) break block121;
                                    if (action.getEffectiveChangeType().contains(ChangeType.EDIT) && asyncOp.isGetAll()) {
                                        this.recordEvent(asyncOp, OperationStatus.UNABLE_TO_REFRESH, action);
                                        asyncOp.getStatus().incrementNumWarnings();
                                    } else {
                                        if (!asyncOp.isPreview() && isCaseChangingRename && !asyncOp.isNoDiskUpdate()) {
                                            try {
                                                FileHelpers.rename(action.getCurrentLocalItem(), newLocalItem);
                                                log.debug((Object)MessageFormat.format("Renamed file from {0} to {1}", action.getCurrentLocalItem(), newLocalItem));
                                            }
                                            catch (Exception e) {
                                                this.onNonFatalError(new IOException(MessageFormat.format(Messages.getString("GetEngine.FailedToRenameFileFormat"), action.getCurrentLocalItem(), newLocalItem)), asyncOp.getWorkspace());
                                            }
                                        }
                                        if (asyncOp.getType() != ProcessType.GET || isCaseChangingRename) {
                                            this.recordEvent(asyncOp, OperationStatus.GETTING, action);
                                        }
                                    }
                                    if (!asyncOp.isPreview()) {
                                        Check.isTrue(!action.isNewContentNeeded() || action.getEffectiveChangeType().contains(ChangeType.EDIT) && asyncOp.isGetAll(), MessageFormat.format("Local and server versions expected to be equal except for edit: {0}", action));
                                        if (deleteAsUndoAdd) {
                                            if (!new File(newLocalItem).delete()) {
                                                throw new IOException(MessageFormat.format(Messages.getString("GetEngine.CouldNotDeleteFileFormat"), newLocalItem));
                                            }
                                        } else if (ProcessType.UNDO != asyncOp.getType() || !action.getChangeType().contains(ChangeType.ADD)) {
                                            asyncOp.queueLocalVersionUpdate(action, action.getTargetLocalItem(), action.getVersionServer());
                                            action.setDownloadCompleted(true);
                                            downloadCompletedHere = true;
                                        }
                                    }
                                    if (asyncOp.isPreview() || !action.getEffectiveChangeType().contains(ChangeType.EDIT) || !existingLocalAttrs.isReadOnly() || existingLocalAttrs.isSymbolicLink()) break block122;
                                    existingLocalAttrs.setReadOnly(false);
                                    existingLocalAttrs.setArchive(true);
                                    FileSystemUtils.getInstance().setAttributes(action.getCurrentLocalItem(), existingLocalAttrs);
                                }
                                catch (Throwable throwable) {
                                    if (!asyncOp.isPreview() && action.getEffectiveChangeType().contains(ChangeType.EDIT) && existingLocalAttrs.isReadOnly() && !existingLocalAttrs.isSymbolicLink()) {
                                        existingLocalAttrs.setReadOnly(false);
                                        existingLocalAttrs.setArchive(true);
                                        FileSystemUtils.getInstance().setAttributes(action.getCurrentLocalItem(), existingLocalAttrs);
                                        log.debug((Object)MessageFormat.format("Set edited file to read/write (archive=true): {0}", action.getCurrentLocalItem()));
                                    }
                                    throw throwable;
                                }
                                log.debug((Object)MessageFormat.format("Set edited file to read/write (archive=true): {0}", action.getCurrentLocalItem()));
                            }
                            return;
                        }
                        if (!asyncOp.isPreview() && action.getEffectiveChangeType().contains(ChangeType.EDIT) && existingLocalAttrs.isReadOnly() && !existingLocalAttrs.isSymbolicLink()) {
                            existingLocalAttrs.setReadOnly(false);
                            existingLocalAttrs.setArchive(true);
                            FileSystemUtils.getInstance().setAttributes(action.getCurrentLocalItem(), existingLocalAttrs);
                            log.debug((Object)MessageFormat.format("Set edited file to read/write (archive=true): {0}", action.getCurrentLocalItem()));
                        }
                        if (!asyncOp.isOverwrite() && newLocalExists && this.isWritableFileConflict(asyncOp, action, newLocalAttrs) && !asyncOp.isNoDiskUpdate()) {
                            asyncOp.addWarning(OperationStatus.TARGET_WRITABLE, action);
                            return;
                        }
                        if (!(asyncOp.isPreview() || deleteAsUndoAdd || asyncOp.isNoDiskUpdate())) {
                            FileHelpers.createDirectoryIfNecessary(LocalPath.getParent(newLocalItem));
                            if (newLocalAttrs.exists()) {
                                new File(newLocalItem).delete();
                            }
                            if (!existingLocalAttrs.isSymbolicLink()) {
                                FileCopyHelper.copy(action.getCurrentLocalItem(), newLocalItem);
                                log.debug((Object)MessageFormat.format("Copied file from {0} to {1}", action.getCurrentLocalItem(), newLocalItem));
                                if (asyncOp.getWorkspace().getOptions().contains(WorkspaceOptions.SET_FILE_TO_CHECKIN) && !DotNETDate.MIN_CALENDAR.equals(action.getVersionServerDate())) {
                                    File newLocalFile = new File(newLocalItem);
                                    if (existingLocalAttrs.isReadOnly()) {
                                        existingLocalAttrs.setReadOnly(false);
                                        FileSystemUtils.getInstance().setAttributes(newLocalFile, existingLocalAttrs);
                                        existingLocalAttrs.setReadOnly(true);
                                    }
                                    if (action.getEffectiveChangeType().contains(ChangeType.EDIT)) {
                                        newLocalFile.setLastModified(action.getVersionServerDate().getTimeInMillis());
                                    } else {
                                        FileSystemAttributes attrs = FileSystemUtils.getInstance().getAttributes(action.getCurrentLocalItem());
                                        newLocalFile.setLastModified(attrs.getModificationTime().getJavaTime());
                                    }
                                }
                            } else {
                                util = FileSystemUtils.getInstance();
                                String destinationPath = ((FileSystemUtils)util).getSymbolicLink(action.getCurrentLocalItem());
                                ((FileSystemUtils)util).createSymbolicLink(destinationPath, newLocalItem);
                            }
                            FileSystemUtils.getInstance().setAttributes(newLocalItem, existingLocalAttrs);
                        }
                        this.recordEvent(asyncOp, action.getCurrentLocalItem() == null ? OperationStatus.GETTING : OperationStatus.REPLACING, action);
                        if (asyncOp.isPreview()) {
                            return;
                        }
                        asyncOp.queueLocalVersionUpdate(action, action.getTargetLocalItem(), action.getVersionServer());
                        util = action;
                        synchronized (util) {
                            action.setDownloadCompleted(true);
                            downloadCompletedHere = true;
                            if (!asyncOp.isNoDiskUpdate()) {
                                if (!new File(action.getCurrentLocalItem()).delete()) {
                                    throw new IOException(MessageFormat.format(Messages.getString("GetEngine.CouldNotDeleteFileFormat"), action.getCurrentLocalItem()));
                                }
                                log.debug((Object)MessageFormat.format("Deleted file source of move: {0}", action.getCurrentLocalItem()));
                            }
                            break block120;
                        }
                    }
                    if (action.getEffectiveChangeType().contains(ChangeType.ADD) && !action.isNewContentNeeded()) {
                        if (asyncOp.getType() == ProcessType.PEND || asyncOp.getType() == ProcessType.UNDO) {
                            this.recordEvent(asyncOp, OperationStatus.GETTING, action);
                        }
                        if (!(asyncOp.isNoDiskUpdate() || asyncOp.getType() == ProcessType.UNDO || asyncOp.isPreview() && asyncOp.getType() == ProcessType.PEND)) {
                            if (newLocalItem != null) {
                                this.onNonFatalError(new VersionControlException(MessageFormat.format(Messages.getString("GetEngine.AddedItemMissingLocallyFormat"), newLocalItem)), asyncOp.getWorkspace());
                            } else {
                                this.onNonFatalError(new VersionControlException(MessageFormat.format(Messages.getString("GetEngine.AddedItemMissingLocallyFormat"), action.getCurrentLocalItem())), asyncOp.getWorkspace());
                            }
                        }
                        return;
                    }
                    if (!(asyncOp.isOverwrite() || WorkspaceLocation.SERVER != asyncOp.getWorkspace().getLocation() || !existingLocalExists || existingLocalAttrs.isReadOnly() || action.isOkayToOverwriteExistingLocal() || isCaseChangingRename || GetEngine.localContentIsRedundant(action.getCurrentLocalItem(), action.getHashValue()) || existingLocalAttrs.isSymbolicLink())) {
                        asyncOp.addWarning(OperationStatus.SOURCE_WRITABLE, action, null);
                    } else {
                        if (!asyncOp.isOverwrite() && newLocalExists && this.isWritableFileConflict(asyncOp, action, newLocalAttrs) && !isCaseChangingRename && !newLocalAttrs.isSymbolicLink()) {
                            asyncOp.addWarning(OperationStatus.TARGET_WRITABLE, action);
                            return;
                        }
                        this.recordEvent(asyncOp, action.getCurrentLocalItem() == null ? OperationStatus.GETTING : OperationStatus.REPLACING, action);
                        if (action.isContentDestroyed()) {
                            this.onNonFatalError(new DestroyedContentUnavailableException(MessageFormat.format(Messages.getString("GetEngine.DestroyedFileContentUnavailableExceptionFormat"), action.getVersionServer(), action.getTargetLocalItem())), asyncOp.getWorkspace());
                            return;
                        }
                        if (asyncOp.isPreview()) {
                            return;
                        }
                        Check.isTrue(!deleteAsUndoAdd, "We are downloading file which is not needed (undo of pending add)");
                        if (action.isUndo() && null != action.getBaselineFileGUID() && null == action.getDownloadURL()) {
                            if (!asyncOp.isNoDiskUpdate()) {
                                boolean isSymlink = PropertyConstants.IS_SYMLINK.equals(PropertyUtils.selectMatching(action.getPropertyValues(), "Microsoft.TeamFoundation.VersionControl.SymbolicLink"));
                                asyncOp.getBaselineFolders().copyBaselineToTarget(action.getBaselineFileGUID(), action.getTargetLocalItem(), -1L, action.getHashValue(), isSymlink);
                            }
                            if (asyncOp.getWorkspace().getOptions().contains(WorkspaceOptions.SET_FILE_TO_CHECKIN) && !DotNETDate.MIN_CALENDAR.equals(action.getVersionServerDate())) {
                                new File(action.getTargetLocalItem()).setLastModified(action.getVersionServerDate().getTimeInMillis());
                            }
                            asyncOp.queueLocalVersionUpdate(new ClientLocalVersionUpdate(action.getSourceServerItem(), action.getItemID(), action.getTargetLocalItem(), action.getVersionServer(), action.getEncoding(), false, action.getPropertyValues()));
                            if (existingLocalExists && action.getCurrentLocalItem() != null && !LocalPath.equals(action.getCurrentLocalItem(), action.getTargetLocalItem()) && !asyncOp.isNoDiskUpdate()) {
                                Check.isTrue(action.getItemType() != ItemType.FOLDER, MessageFormat.format("Should not try to delete a folder here: {0}", action.toString()));
                                this.deleteSource(action, existingLocalAttrs);
                            }
                            downloadCompletedHere = true;
                        } else if (null != action.getDownloadURL()) {
                            this.asyncGetFile(action, existingLocalExists, existingLocalAttrs, newLocalExists, newLocalAttrs, asyncOp);
                        }
                    }
                    break block120;
                }
                if (action.getItemType() == ItemType.FOLDER || action.getItemType() == ItemType.ANY && !existingLocalAttrs.isSymbolicLink() && existingLocalAttrs.isDirectory()) {
                    if (action.getCurrentLocalItem() == null) {
                        this.recordEvent(asyncOp, OperationStatus.DELETING, action);
                    } else if (!asyncOp.getDeletes().containsKey(action.getCurrentLocalItem())) {
                        asyncOp.getDeletes().put(action.getCurrentLocalItem(), action);
                    }
                } else if (!(asyncOp.isOverwrite() || !existingLocalExists || WorkspaceLocation.SERVER != asyncOp.getWorkspace().getLocation() || existingLocalAttrs.isReadOnly() || existingLocalAttrs.isSymbolicLink() || action.isOkayToOverwriteExistingLocal())) {
                    Check.isTrue(!action.getEffectiveChangeType().contains(ChangeType.EDIT), MessageFormat.format("The edit bit is set, yet we are trying to delete this file: {0}", action));
                    asyncOp.addWarning(OperationStatus.SOURCE_WRITABLE, action, null);
                } else {
                    this.recordEvent(asyncOp, OperationStatus.DELETING, action);
                    if (asyncOp.isPreview()) {
                        return;
                    }
                    this.deleteSource(action, existingLocalAttrs);
                    asyncOp.queueLocalVersionUpdate(action, null, action.getVersionServer() != 0 ? action.getVersionServer() : action.getVersionLocal());
                    action.setDownloadCompleted(true);
                    downloadCompletedHere = true;
                }
            }
            catch (PathTooLongException e) {
                log.warn((Object)"Path too long, not getting", (Throwable)e);
                this.onNonFatalError(new VersionControlException(MessageFormat.format(Messages.getString("GetEngine.LocalPathTooLongFormat"), newLocalItem)), asyncOp.getWorkspace());
            }
            catch (CanceledException e) {
                throw e;
            }
            catch (Exception e) {
                log.warn((Object)"Caught and converted an exception: ", (Throwable)e);
                this.onNonFatalError(e, asyncOp.getWorkspace());
            }
            finally {
                if (downloadCompletedHere && !asyncOp.isPreview() && !asyncOp.isNoDiskUpdate()) {
                    this.applyFileAttributesAfterGet(asyncOp, action);
                }
            }
        }
    }

    private void asyncGetFile(GetOperation action, boolean existingLocalExists, FileSystemAttributes existingLocalAttrs, boolean newLocalExists, FileSystemAttributes newLocalAttrs, AsyncGetOperation asyncOp) {
        if (!asyncOp.isNoDiskUpdate()) {
            if (asyncOp.getBaselineFolders() != null && !action.getEffectiveChangeType().contains(ChangeType.EDIT)) {
                action.setBaselineFileGUID(GUID.newGUID().getGUIDBytes());
            }
            GetDownloadWorker worker = new GetDownloadWorker(EventSource.newFromHere(), TaskMonitorService.getTaskMonitor(), this.client, this, action, asyncOp, existingLocalAttrs, asyncOp.getBaselineFolders(), action.getBaselineFileGUID());
            if (action.getTargetServerItem() != null && ServerPath.getFileName(action.getTargetServerItem()).equals(".tpattributes")) {
                try {
                    worker.call();
                }
                catch (Exception e) {
                    log.warn((Object)"Exception downloading synchronously", (Throwable)e);
                }
            } else {
                asyncOp.getCompletionService().submit(worker);
            }
        } else {
            asyncOp.queueLocalVersionUpdate(action, action.getTargetLocalItem(), action.getVersionServer());
        }
    }

    private synchronized void ensureAttributesReadIntoCache(String localItem) {
        Check.notNullOrEmpty(localItem, "localItem");
        List<FileAttributesEntry> entries = null;
        String localDirectory = LocalPath.getDirectory(localItem);
        if (this.localDirectoryToEntryListMap.containsKey(localDirectory)) {
            List<FileAttributesEntry> value = this.localDirectoryToEntryListMap.get(localDirectory);
            if (value == null) {
                return;
            }
            entries = value;
        } else {
            entries = FileAttributesFile.loadAttributesFile(localDirectory + File.separator + ".tpattributes");
            if (entries == null) {
                if (!Collator.getInstance().equals(LocalPath.getFileName(localItem), ".tpattributes")) {
                    this.localDirectoryToEntryListMap.put(localDirectory, null);
                }
                return;
            }
            this.localDirectoryToEntryListMap.put(localDirectory, entries);
        }
    }

    private synchronized void ensureGlobalAttributesReadIntoCache() {
        if (this.globalAttributeEntries == null) {
            List<Object> entries = null;
            String globalPath = PlatformMiscUtils.getInstance().getEnvironmentVariable("TF_GLOBAL_TPATTRIBUTES");
            if (globalPath != null && globalPath.length() > 0 && (entries = FileAttributesFile.loadGlobalFile(globalPath)) == null) {
                log.warn((Object)MessageFormat.format("Could not read global attributes file {0}", globalPath));
            }
            this.globalAttributeEntries = entries != null ? entries : new ArrayList();
        }
    }

    private boolean isTextEncoding(int encoding) {
        return encoding != FileEncoding.BINARY.getCodePage();
    }

    public synchronized FileAttributesCollection getAttributesForFile(String localItem, String serverItem, boolean includeDefaults) {
        Check.notNullOrEmpty(localItem, "localItem");
        this.ensureAttributesReadIntoCache(localItem);
        if (LocalPath.getFileName(localItem).equalsIgnoreCase(".tpattributes")) {
            return defaultFileAttributes;
        }
        String fileName = LocalPath.getFileName(localItem);
        List<FileAttributesEntry> entries = this.localDirectoryToEntryListMap.get(LocalPath.getDirectory(localItem));
        if (entries != null) {
            for (FileAttributesEntry entry : entries) {
                if (entry == null || !entry.matchesFilename(fileName)) continue;
                return entry.getAttributes().mergeWith(includeDefaults ? defaultFileAttributes : null);
            }
        }
        if (serverItem != null) {
            this.ensureGlobalAttributesReadIntoCache();
            for (FileAttributesEntry entry : this.globalAttributeEntries) {
                if (entry == null || !entry.matchesFilename(serverItem)) continue;
                return entry.getAttributes().mergeWith(includeDefaults ? defaultFileAttributes : null);
            }
        }
        return includeDefaults ? defaultFileAttributes : null;
    }

    public void applyFileAttributesToTempFile(String targetServerItem, String targetLocalItem, int encoding, File tempFile) {
        this.applyFileAttributesToTempFile(targetServerItem, targetLocalItem, encoding, tempFile, null);
    }

    public void applyFileAttributesToTempFile(String targetServerItem, String targetLocalItem, int encoding, File tempFile, GetOperation operation) {
        if (targetServerItem == null || targetLocalItem == null) {
            return;
        }
        Check.notNull(tempFile, "tempFile");
        FileAttributesCollection attributes = this.getAttributesForFile(targetLocalItem, targetServerItem, this.isTextEncoding(encoding));
        if (attributes != null) {
            StringPairFileAttribute eolAttribute;
            StringPairFileAttribute transformAttribute = attributes.getStringPairFileAttribute("transform");
            if (transformAttribute != null && "apple".equals(transformAttribute.getValue()) && AppleSingleUtil.isSupportedPlatform()) {
                log.debug((Object)MessageFormat.format("Decoding AppleSingle file for {0}", targetLocalItem));
                try {
                    AppleSingleUtil.decodeFile(tempFile);
                }
                catch (IOException e) {
                    String message = MessageFormat.format(Messages.getString("GetEngine.CouldNotDecodeAppleSingleFileFormat"), targetLocalItem, e.getLocalizedMessage());
                    log.warn((Object)message, (Throwable)e);
                    this.onNonFatalError(new TECoreException(message));
                }
            }
            if ((eolAttribute = attributes.getStringPairFileAttribute("client-eol")) != null && eolAttribute.getValue() != null) {
                if (encoding == -2 && this.client.getServiceLevel().getValue() < WebServiceLevel.TFS_2012.getValue() && operation != null) {
                    Item item = this.client.getItem(operation.getItemID(), operation.getVersionServer());
                    operation.setEncoding(item.getEncoding().getCodePage());
                }
                if (operation.getEncoding() != FileEncoding.BINARY.getCodePage()) {
                    String desiredNewlineSequence = FileAttributeValues.getEndOfLineStringForAttributeValue(eolAttribute);
                    if (desiredNewlineSequence == null) {
                        this.onNonFatalError(new TECoreException(MessageFormat.format(Messages.getString("GetEngine.UnsupportedClientEOLStyleFormat"), eolAttribute.getValue(), targetLocalItem, ".tpattributes")));
                    } else if (desiredNewlineSequence.equals("")) {
                        log.debug((Object)MessageFormat.format("Not converting line endings for {0}", targetLocalItem));
                    } else {
                        log.debug((Object)MessageFormat.format("Converting line endings for {0} to {1}", targetLocalItem, eolAttribute.getValue()));
                        try {
                            Charset charset = CodePageMapping.getCharset(operation.getEncoding(), false);
                            if (charset == null) {
                                charset = Charset.defaultCharset();
                            }
                            NewlineUtils.convertFile(tempFile, charset, desiredNewlineSequence);
                            log.info((Object)MessageFormat.format("Converted line endings in {0} to {1} (using charset {2})", tempFile, eolAttribute.getValue(), charset.name()));
                        }
                        catch (UnsupportedEncodingException e) {
                            String message = MessageFormat.format(Messages.getString("GetEngine.CouldNotChangeEOLBecauseUnknownFileEncodingFormat"), targetLocalItem, e.getLocalizedMessage());
                            log.error((Object)message, (Throwable)e);
                            this.onNonFatalError(new TECoreException(message));
                        }
                        catch (IOException e) {
                            String message = MessageFormat.format(Messages.getString("GetEngine.CouldNotChangeEOLBecauseIOExceptionFormat"), targetLocalItem, e.getLocalizedMessage());
                            log.error((Object)message, (Throwable)e);
                            this.onNonFatalError(new TECoreException(message));
                        }
                    }
                }
            }
        }
    }

    public void applyFileAttributesAfterGet(AsyncGetOperation asyncOp, GetOperation operation) {
        FileAttributesCollection attributes;
        if (asyncOp.isNoDiskUpdate() || !Platform.isCurrentPlatform(Platform.GENERIC_UNIX) || operation.getTargetLocalItem() == null || asyncOp.getType() == ProcessType.PEND && operation.getChangeType().contains(ChangeType.ADD)) {
            return;
        }
        String localItem = operation.getTargetLocalItem();
        String serverItem = operation.getTargetServerItem();
        FileSystemAttributes attr = FileSystemUtils.getInstance().getAttributes(localItem);
        if (!attr.exists() || attr.isDirectory()) {
            return;
        }
        boolean desiredExecutable = false;
        if (PlatformMiscUtils.getInstance().getEnvironmentVariable("TF_DISABLE_APPLY_EXECUTABLE_PROP") == null) {
            desiredExecutable = PropertyConstants.EXECUTABLE_ENABLED_VALUE.equals(PropertyUtils.selectMatching(operation.getPropertyValues(), "Microsoft.TeamFoundation.VersionControl.Executable"));
        }
        if (!desiredExecutable && (attributes = this.getAttributesForFile(localItem, serverItem, this.isTextEncoding(operation.getEncoding()))) != null) {
            desiredExecutable = attributes.containsBooleanAttribute("x");
        }
        if (!attr.isSymbolicLink() && attr.isExecutable() != desiredExecutable) {
            attr.setExecutable(desiredExecutable);
            FileSystemUtils.getInstance().setAttributes(localItem, attr);
        }
    }

    public static void waitForCompletions(AccountingCompletionService<WorkerStatus> completionService) {
        Check.notNull(completionService, "completionService");
        completionService.waitForCompletions(new AccountingCompletionService.ResultProcessor<WorkerStatus>(){

            @Override
            public void processResult(WorkerStatus result) {
                WorkerStatus status = result;
                if (status.getFinalState() == WorkerStatus.FinalState.ERROR) {
                    log.debug((Object)"Get worker thread finished with EXCEPTION");
                } else if (status.getFinalState() == WorkerStatus.FinalState.CANCELED) {
                    log.debug((Object)"Get worker thread finished with CANCELED");
                }
            }
        }, new AccountingCompletionService.ExecutionExceptionHandler(){

            @Override
            public void handleException(ExecutionException e) {
                log.warn((Object)"Get worker exception", (Throwable)e);
            }
        });
    }

    private void throwIfCanceled(TaskMonitor gettingTaskMonitor) throws CoreCancelException {
        if (gettingTaskMonitor.isCanceled()) {
            CoreCancelException e = new CoreCancelException();
            log.error((Object)e);
            throw e;
        }
    }

    private void throwIfFatalError(AsyncGetOperation asyncOp) {
        Check.notNull(asyncOp, "asyncOp");
        Throwable fatalError = asyncOp.getFatalError();
        if (fatalError != null) {
            log.error((Object)"Fatal download error detected: ", fatalError);
            if (fatalError instanceof VersionControlException) {
                throw (VersionControlException)fatalError;
            }
            throw new VersionControlException(fatalError);
        }
    }

    static {
        try {
            String defaultServerEol;
            ArrayList<StringPairFileAttribute> attributes = new ArrayList<StringPairFileAttribute>();
            String defaultClientEol = PlatformMiscUtils.getInstance().getEnvironmentVariable(EOL_CLIENT_ENVIRONMENT_VARIABLE);
            if (defaultClientEol != null) {
                attributes.add(new StringPairFileAttribute("client-eol", defaultClientEol));
            }
            if ((defaultServerEol = PlatformMiscUtils.getInstance().getEnvironmentVariable(EOL_SERVER_ENVIRONMENT_VARIABLE)) != null) {
                attributes.add(new StringPairFileAttribute("server-eol", defaultServerEol));
            }
            if (attributes.size() > 0) {
                defaultFileAttributes = new FileAttributesCollection(attributes.toArray(new FileAttribute[attributes.size()]));
            }
        }
        catch (Exception e) {
            log.warn((Object)"Could not query default file attributes", (Throwable)e);
        }
    }

    private static class GetShutdownEventListener
    implements ShutdownEventListener {
        private final TaskMonitor taskMonitor;
        private final ShutdownMonitor shutdownMonitor;

        GetShutdownEventListener(TaskMonitor taskMonitor, ShutdownMonitor shutdownMonitor) {
            Check.notNull(taskMonitor, "taskMonitor");
            Check.notNull(shutdownMonitor, "shutdownMonitor");
            this.taskMonitor = taskMonitor;
            this.shutdownMonitor = shutdownMonitor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onShutdown() {
            log.trace((Object)"listener shutting down in-progress get operation");
            ShutdownManager.getInstance().removeShutdownEventListener(this, SHUTDOWN_HANDLER_PRIORITY);
            log.trace((Object)"listener canceling TaskMonitor");
            this.taskMonitor.setCanceled();
            log.trace((Object)"listener acquiring shutdown monitor");
            ShutdownMonitor shutdownMonitor = this.shutdownMonitor;
            synchronized (shutdownMonitor) {
                while (!this.shutdownMonitor.isShutdown()) {
                    log.trace((Object)"listener waiting on monitor because no shutdown yet");
                    try {
                        this.shutdownMonitor.wait();
                        log.trace((Object)"listener monitor woke");
                    }
                    catch (InterruptedException e) {
                        log.error((Object)"listener monitor interrupted, ignoring", (Throwable)e);
                    }
                }
                log.trace((Object)"listener confirmed shutdown");
            }
        }
    }

    private static class ShutdownMonitor {
        private volatile boolean isShutdown;

        protected boolean isShutdown() {
            return this.isShutdown;
        }

        protected void setShutdown() {
            this.isShutdown = true;
        }
    }
}

