/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.versioncontrol.events;

import com.microsoft.tfs.core.Messages;
import com.microsoft.tfs.core.clients.CoreClientEvent;
import com.microsoft.tfs.core.clients.versioncontrol.OperationStatus;
import com.microsoft.tfs.core.clients.versioncontrol.events.EventSource;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.ChangeType;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.Conflict;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.PendingChange;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.PropertyValue;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.Resolution;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.Workspace;
import com.microsoft.tfs.core.clients.versioncontrol.specs.VersionedFileSpec;
import com.microsoft.tfs.core.clients.versioncontrol.specs.version.ChangesetVersionSpec;
import java.text.MessageFormat;
import java.util.concurrent.atomic.AtomicReference;

public class MergingEvent
extends CoreClientEvent {
    private final Conflict conflict;
    private final Workspace workspace;
    private final boolean isLatest;
    private final PendingChange pendingChange;
    private final OperationStatus status;
    private final ChangeType targetLocalChangeType;
    private final boolean diskUpdateAttempted;
    private final PropertyValue[] properties;

    public MergingEvent(EventSource source, Conflict conflict, Workspace workspace, boolean isLatest, PendingChange pendingChange, OperationStatus status, ChangeType targetLocalChangeType, boolean diskUpdateAttempted, PropertyValue[] properties) {
        super(source);
        this.conflict = conflict;
        this.workspace = workspace;
        this.isLatest = isLatest;
        this.pendingChange = pendingChange;
        this.status = status;
        this.targetLocalChangeType = targetLocalChangeType;
        this.diskUpdateAttempted = diskUpdateAttempted;
        this.properties = properties;
    }

    public boolean isDiskUpdateAttempted() {
        return this.diskUpdateAttempted;
    }

    public boolean isLatest() {
        return this.isLatest;
    }

    public PendingChange getPendingChange() {
        return this.pendingChange;
    }

    public OperationStatus getStatus() {
        return this.status;
    }

    public ChangeType getTargetLocalPendingChange() {
        return this.targetLocalChangeType;
    }

    public Workspace getWorkspace() {
        return this.workspace;
    }

    public ChangeType getChangeType() {
        return this.conflict.getBaseChangeType();
    }

    public String getSourceServerItem() {
        return this.conflict.getTheirServerItem();
    }

    public String getSourceLocalItem() {
        return this.conflict.getSourceLocalItem();
    }

    public ChangesetVersionSpec getSourceVersionFrom() {
        return new ChangesetVersionSpec(this.conflict.getBaseVersion());
    }

    public ChangesetVersionSpec getSourceVersionTo() {
        return new ChangesetVersionSpec(this.conflict.getTheirVersion());
    }

    public String getTargetServerItem() {
        return this.conflict.getYourServerItem();
    }

    public String getTargetLocalItem() {
        return this.conflict.getTargetLocalItem();
    }

    public ChangesetVersionSpec getTargetVersionPended() {
        return new ChangesetVersionSpec(this.conflict.getYourVersion());
    }

    public boolean isConflict() {
        return this.conflict.getResolution() == Resolution.NONE;
    }

    public String toString() {
        ChangeType changeType = this.getChangeType();
        OperationStatus status = this.getStatus();
        String source = !changeType.contains(ChangeType.MERGE) ? null : (changeType.contains(ChangeType.BRANCH) ? VersionedFileSpec.formatForPath(this.getSourceServerItem(), this.getSourceVersionTo()) : VersionedFileSpec.formatForPath(this.getSourceServerItem(), this.getSourceVersionFrom(), this.getSourceVersionTo()));
        String target = changeType.contains(ChangeType.BRANCH) ? this.getTargetServerItem() : VersionedFileSpec.formatForPath(this.getTargetServerItem(), this.getTargetVersionPended());
        String message = status == OperationStatus.CONFLICT ? MessageFormat.format(Messages.getString("MergingEvent.MergeConflictOfTypeBetweenSourceAndTargetFormat"), changeType.toUIString(false), source, target) : (source == null ? MessageFormat.format(Messages.getString("MergingEvent.MergeOfAssociatedPendingChangeTypeForTargetFormat"), changeType.toUIString(false), target) : MessageFormat.format(Messages.getString("MergingEvent.MergePendedForChangeTypeForSourceToTargetFormat"), changeType.toUIString(false), source, target));
        return message;
    }

    public String getMessage(AtomicReference<String> error) {
        error.set(null);
        if (this.status != OperationStatus.GETTING && this.status != OperationStatus.REPLACING && this.status != OperationStatus.DELETING && this.status != OperationStatus.CONFLICT) {
            if (this.status == OperationStatus.SOURCE_DIRECTORY_NOT_EMPTY) {
                error.set(MessageFormat.format(Messages.getString("MergingEvent.CantDeleteNonEmptyDirPathFormat"), this.getSourceLocalItem()));
            } else if (this.status == OperationStatus.SOURCE_WRITABLE) {
                error.set(MessageFormat.format(Messages.getString("MergingEvent.FileIsWritablePathFormat"), this.getSourceLocalItem()));
            } else if (this.status == OperationStatus.TARGET_IS_DIRECTORY) {
                error.set(MessageFormat.format(Messages.getString("MergingEvent.FoundDirectoryExpectedFilePathFormat"), this.getTargetLocalItem()));
            } else if (this.status == OperationStatus.TARGET_LOCAL_PENDING) {
                error.set(MessageFormat.format(Messages.getString("MergingEvent.TargetLocalPendingPathFormat"), this.getSourceLocalItem(), this.getTargetLocalItem(), this.getTargetLocalPendingChange().toUIString(false)));
            } else if (this.status == OperationStatus.TARGET_WRITABLE) {
                error.set(MessageFormat.format(Messages.getString("MergingEvent.FileIsWritablePathFormat"), this.getTargetLocalItem()));
            }
        }
        return this.conflict.getDetailedMessage(this.getStatus() == OperationStatus.CONFLICT);
    }

    public PropertyValue[] getPropertyValues() {
        return this.properties;
    }
}

