/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.versioncontrol.events;

import com.microsoft.tfs.core.Messages;
import com.microsoft.tfs.core.clients.CoreClientEvent;
import com.microsoft.tfs.core.clients.versioncontrol.VersionControlClient;
import com.microsoft.tfs.core.clients.versioncontrol.events.EventSource;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.Failure;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.Workspace;
import com.microsoft.tfs.util.Check;

public class NonFatalErrorEvent
extends CoreClientEvent {
    static final long serialVersionUID = 1861259112856825407L;
    private final VersionControlClient vcClient;
    private final Workspace workspace;
    private final Throwable throwable;
    private final Failure failure;

    public NonFatalErrorEvent(EventSource source, VersionControlClient vcClient, Throwable throwable) {
        super(source);
        Check.notNull(vcClient, "vcClient");
        Check.notNull(throwable, "throwable");
        this.vcClient = vcClient;
        this.workspace = null;
        this.throwable = throwable;
        this.failure = null;
    }

    public NonFatalErrorEvent(EventSource source, VersionControlClient vcClient, Failure failure) {
        super(source);
        Check.notNull(vcClient, "vcClient");
        Check.notNull(failure, "failure");
        this.vcClient = vcClient;
        this.workspace = null;
        this.throwable = null;
        this.failure = failure;
    }

    public NonFatalErrorEvent(EventSource source, Workspace workspace, Failure failure) {
        super(source);
        Check.notNull(workspace, "workspace");
        Check.notNull(failure, "failure");
        this.vcClient = workspace.getClient();
        this.workspace = workspace;
        this.throwable = null;
        this.failure = failure;
    }

    public NonFatalErrorEvent(EventSource source, Workspace workspace, Throwable throwable) {
        super(source);
        Check.notNull(workspace, "workspace");
        Check.notNull(throwable, "exception");
        this.vcClient = workspace.getClient();
        this.workspace = workspace;
        this.throwable = throwable;
        this.failure = null;
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public Failure getFailure() {
        return this.failure;
    }

    public VersionControlClient getClient() {
        return this.vcClient;
    }

    public Workspace getWorkspace() {
        return this.workspace;
    }

    public String getMessage() {
        if (this.throwable != null) {
            return this.throwable.getLocalizedMessage();
        }
        if (this.failure == null) {
            return Messages.getString("NonFatalErrorEvent.NonFatalErrorOfUnknownReason");
        }
        return this.failure.getFormattedMessage();
    }
}

