/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.versioncontrol.internal.fileattributes;

import com.microsoft.tfs.core.Messages;
import com.microsoft.tfs.core.clients.versioncontrol.internal.fileattributes.BooleanFileAttribute;
import com.microsoft.tfs.core.clients.versioncontrol.internal.fileattributes.FileAttribute;
import com.microsoft.tfs.core.clients.versioncontrol.internal.fileattributes.FileAttributeImpl;
import com.microsoft.tfs.core.clients.versioncontrol.internal.fileattributes.FileAttributesCollection;
import com.microsoft.tfs.core.clients.versioncontrol.internal.fileattributes.StringPairFileAttribute;
import com.microsoft.tfs.util.Check;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class FileAttributesEntry {
    private static final Log log = LogFactory.getLog(FileAttributesEntry.class);
    private final Pattern filenamePattern;
    private final FileAttributesCollection attributes;
    private static final char FILE_AND_ATTRIBUTES_SEPARATOR = ':';
    private static final char ATTRIBUTE_SEPARATOR = '|';

    public FileAttributesEntry(String filenameExpression) {
        Check.notNullOrEmpty(filenameExpression, "filename");
        this.filenamePattern = this.compilePattern(filenameExpression);
        this.attributes = new FileAttributesCollection(new FileAttribute[0]);
    }

    public FileAttributesEntry(String filenameExpression, FileAttribute[] initialAttributes) {
        Check.notNullOrEmpty(filenameExpression, "filename");
        Check.notNull(initialAttributes, "initialAttributes");
        this.filenamePattern = this.compilePattern(filenameExpression);
        this.attributes = new FileAttributesCollection(initialAttributes);
    }

    private Pattern compilePattern(String filenameExpression) {
        return Pattern.compile(filenameExpression, 66);
    }

    public static FileAttributesEntry parse(String serializedEntry) throws ParseException, PatternSyntaxException {
        Check.notNull(serializedEntry, "serializedEntry");
        if (serializedEntry.length() == 0) {
            throw new ParseException(Messages.getString("FileAttributesEntry.FileAttributesEntryIsEmpty"), 0);
        }
        int sepIndex = serializedEntry.indexOf(58);
        if (sepIndex == -1) {
            throw new ParseException(MessageFormat.format(Messages.getString("FileAttributesEntry.FileAndAttributesSeparatorNotFoundFormat"), Character.valueOf(':')), 0);
        }
        String filenameExpression = serializedEntry.substring(0, sepIndex);
        String rest = serializedEntry.substring(sepIndex + 1);
        String[] attributeStrings = rest.split("\\|");
        ArrayList<StringPairFileAttribute> attributes = new ArrayList<StringPairFileAttribute>();
        for (int i = 0; i < attributeStrings.length; ++i) {
            String attributeString = attributeStrings[i];
            if (attributeString.length() == 0) continue;
            FileAttributeImpl a = null;
            a = StringPairFileAttribute.looksLikeStringPairFileAttribute(attributeString) ? StringPairFileAttribute.parse(attributeString) : BooleanFileAttribute.parse(attributeString);
            if (a != null) {
                attributes.add((StringPairFileAttribute)a);
                continue;
            }
            log.warn((Object)MessageFormat.format("Ignoring malformed file attribute ''{0}''", attributeString));
        }
        return new FileAttributesEntry(filenameExpression, attributes.toArray(new FileAttribute[attributes.size()]));
    }

    public String toString() {
        if (this.attributes.size() == 0) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        sb.append(this.filenamePattern.pattern());
        sb.append(':');
        int i = 0;
        for (FileAttribute attribute2 : this.attributes) {
            if (attribute2 == null) continue;
            if (i++ > 0) {
                sb.append('|');
            }
            sb.append(((Object)attribute2).toString());
        }
        return sb.toString();
    }

    public boolean matchesFilename(String filename) {
        Check.notNullOrEmpty(filename, "filename");
        return this.filenamePattern.matcher(filename).matches();
    }

    public FileAttributesCollection getAttributes() {
        return this.attributes;
    }
}

