/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace;

import com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace.RenameType;
import com.microsoft.tfs.core.clients.versioncontrol.path.ServerPath;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.RecursionType;

public class ApplicableRename
implements Comparable<ApplicableRename> {
    private final String committedServerItem;
    private final RenameType renameType;
    private final RecursionType recursion;

    public ApplicableRename(String committedServerItem, RenameType renameType, RecursionType recursionType) {
        this.committedServerItem = committedServerItem;
        this.renameType = renameType;
        this.recursion = recursionType;
    }

    @Override
    public int compareTo(ApplicableRename other) {
        int compare = ServerPath.compareTopDown(this.committedServerItem, other.committedServerItem);
        if (0 != compare) {
            return compare;
        }
        if (this.renameType == other.renameType) {
            return 0;
        }
        if (this.renameType == RenameType.ADDITIVE) {
            return 1;
        }
        return -1;
    }

    public String getCommittedServerItem() {
        return this.committedServerItem;
    }

    public RenameType getRenameType() {
        return this.renameType;
    }

    public RecursionType getRecursionType() {
        return this.recursion;
    }
}

