/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace;

import com.microsoft.tfs.core.Messages;
import com.microsoft.tfs.core.clients.versioncontrol.ChangePendedFlags;
import com.microsoft.tfs.core.clients.versioncontrol.ClientLocalVersionUpdate;
import com.microsoft.tfs.core.clients.versioncontrol.GetItemsOptions;
import com.microsoft.tfs.core.clients.versioncontrol.ILocalVersionUpdate;
import com.microsoft.tfs.core.clients.versioncontrol.IPopulatableLocalVersionUpdate;
import com.microsoft.tfs.core.clients.versioncontrol.InitiallyDeletedLocalVersionUpdate;
import com.microsoft.tfs.core.clients.versioncontrol.MoveUncommittedLocalVersionUpdate;
import com.microsoft.tfs.core.clients.versioncontrol.OwnershipState;
import com.microsoft.tfs.core.clients.versioncontrol.PendChangesOptions;
import com.microsoft.tfs.core.clients.versioncontrol.ProcessType;
import com.microsoft.tfs.core.clients.versioncontrol.PropertyConstants;
import com.microsoft.tfs.core.clients.versioncontrol.PropertyUtils;
import com.microsoft.tfs.core.clients.versioncontrol.SupportedFeatures;
import com.microsoft.tfs.core.clients.versioncontrol.TeamProject;
import com.microsoft.tfs.core.clients.versioncontrol.UpdateLocalVersionQueue;
import com.microsoft.tfs.core.clients.versioncontrol.UpdateLocalVersionQueueOptions;
import com.microsoft.tfs.core.clients.versioncontrol.UploadedBaselinesCollection;
import com.microsoft.tfs.core.clients.versioncontrol.WorkspaceOptions;
import com.microsoft.tfs.core.clients.versioncontrol.exceptions.CannotRenameDueToChildConflictException;
import com.microsoft.tfs.core.clients.versioncontrol.exceptions.PartialRenameConflictException;
import com.microsoft.tfs.core.clients.versioncontrol.exceptions.ReconcileBlockedByProjectRenameException;
import com.microsoft.tfs.core.clients.versioncontrol.exceptions.ReconcileFailedException;
import com.microsoft.tfs.core.clients.versioncontrol.exceptions.RepositoryPathTooLongException;
import com.microsoft.tfs.core.clients.versioncontrol.exceptions.VersionControlException;
import com.microsoft.tfs.core.clients.versioncontrol.internal.WebServiceLayer;
import com.microsoft.tfs.core.clients.versioncontrol.internal.WebServiceLayerLocalWorkspaces;
import com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace.AllTablesTransaction;
import com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace.BaselineFileGUIDComparer;
import com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace.BaselineFolderCollection;
import com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace.BaselineRequest;
import com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace.LocalPendingChangesTable;
import com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace.LocalPendingChangesTableHeader;
import com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace.LocalVersionHeaderTransaction;
import com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace.LocalVersionTransaction;
import com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace.LocalWorkspaceProperties;
import com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace.LocalWorkspaceTransaction;
import com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace.ParsedItemSpec;
import com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace.ParsedItemSpecOptions;
import com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace.PendingChangesHeaderTransaction;
import com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace.PendingChangesTransaction;
import com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace.RenameCalculationEntry;
import com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace.RenamedPendingChange;
import com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace.ServerItemIsCommittedTuple;
import com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace.ServerItemMapper;
import com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace.UndoneChange;
import com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace.WorkspaceLocalItem;
import com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace.WorkspacePropertiesLocalVersionTransaction;
import com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace.WorkspacePropertiesTransaction;
import com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace.WorkspaceVersionTable;
import com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace.WorkspaceVersionTableHeader;
import com.microsoft.tfs.core.clients.versioncontrol.localworkspace.BaselineFolder;
import com.microsoft.tfs.core.clients.versioncontrol.path.ItemPath;
import com.microsoft.tfs.core.clients.versioncontrol.path.LocalPath;
import com.microsoft.tfs.core.clients.versioncontrol.path.ServerPath;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.ChangeRequest;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.ChangeType;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.DeletedState;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.ExtendedItem;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.Failure;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.GetOperation;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.GetRequest;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.ItemSet;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.ItemType;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.LocalPendingChange;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.LocalVersion;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.LockLevel;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.PathTranslation;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.PendingChange;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.PendingSet;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.PendingSetType;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.PropertyValue;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.ReconcileResult;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.RecursionType;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.RequestType;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.SeverityType;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.WorkingFolder;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.Workspace;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.WorkspaceItem;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.internal.ServerItemLocalVersionUpdate;
import com.microsoft.tfs.core.clients.versioncontrol.sparsetree.KeyValuePair;
import com.microsoft.tfs.core.clients.versioncontrol.sparsetree.SparseTree;
import com.microsoft.tfs.core.clients.versioncontrol.specs.ItemSpec;
import com.microsoft.tfs.core.clients.versioncontrol.specs.version.LatestVersionSpec;
import com.microsoft.tfs.core.clients.versioncontrol.specs.version.VersionSpec;
import com.microsoft.tfs.core.clients.versioncontrol.specs.version.WorkspaceVersionSpec;
import com.microsoft.tfs.core.config.EnvironmentVariables;
import com.microsoft.tfs.core.exceptions.internal.CoreCancelException;
import com.microsoft.tfs.core.internal.wrappers.WebServiceObjectWrapper;
import com.microsoft.tfs.core.internal.wrappers.WrapperUtils;
import com.microsoft.tfs.jni.FileSystemAttributes;
import com.microsoft.tfs.jni.FileSystemUtils;
import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.GUID;
import com.microsoft.tfs.util.Platform;
import com.microsoft.tfs.util.StringUtil;
import com.microsoft.tfs.util.datetime.DotNETDate;
import com.microsoft.tfs.util.tasks.TaskMonitor;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import ms.tfs.versioncontrol.clientservices._03._WorkingFolder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LocalDataAccessLayer {
    private static final Log log = LogFactory.getLog(LocalDataAccessLayer.class);
    private static final ChangeType PEND_DELETE_CONFLICTING_CHANGE_TYPES = ChangeType.ALL.remove(ChangeType.ENCODING).remove(ChangeType.DELETE).remove(ChangeType.BRANCH).remove(ChangeType.MERGE).remove(ChangeType.LOCK);
    private static final String characterCorpus = "abcdefghjklmnopqrstuvwxyz0123456789-";

    public static GetOperation[] pendAdd(Workspace workspace, LocalWorkspaceProperties wp, WorkspaceVersionTable lv, LocalPendingChangesTable pc, ChangeRequest[] changeRequests, boolean silent, AtomicReference<Failure[]> failures, String[] itemPropertyFilters) {
        Check.notNull(workspace, "workspace");
        Check.notNullOrEmpty(changeRequests, "changeRequests");
        ArrayList<Failure> failureList = new ArrayList<Failure>();
        ArrayList<GetOperation> getOps = new ArrayList<GetOperation>();
        TreeSet<String> duplicatesFilter = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        for (ChangeRequest changeRequest : changeRequests) {
            if (null == changeRequest) continue;
            Check.isTrue(changeRequest.getLockLevel() == LockLevel.UNCHANGED || changeRequest.getLockLevel() == LockLevel.NONE, "changeRequest.getLockLevel() == LockLevel.UNCHANGED || changeRequest.getLockLevel() == LockLevel.NONE");
            if (ServerPath.isServerPath(changeRequest.getItemSpec().getItem()) || RecursionType.NONE != changeRequest.getItemSpec().getRecursionType()) {
                throw new IllegalArgumentException(MessageFormat.format(Messages.getString("LocalDataAccessLayer.ChangeRequestMustBeLocalNonRecursiveFormat"), changeRequest.getItemSpec()));
            }
            LocalPath.checkLocalItem(changeRequest.getItemSpec().getItem(), "item", false, false, false, true);
            String targetServerItem = WorkingFolder.getServerItemForLocalItem(changeRequest.getItemSpec().getItem(), wp.getWorkingFolders());
            if (null == targetServerItem) {
                failureList.add(LocalDataAccessLayer.createItemCloakedFailure(changeRequest.getItemSpec().getItem()));
                continue;
            }
            if (targetServerItem.length() > 399) {
                failureList.add(LocalDataAccessLayer.createPathTooLongFailure(targetServerItem));
                continue;
            }
            WorkspaceLocalItem lvEntry = lv.getByLocalItem(changeRequest.getItemSpec().getItem());
            LocalPendingChange pcEntry = pc.getByTargetServerItem(targetServerItem);
            Failure teamProjectValidationFailure = TeamProject.validateChange(targetServerItem, changeRequest.getItemType());
            if (teamProjectValidationFailure != null && (lvEntry == null || lvEntry.getVersion() == 0)) {
                failureList.add(teamProjectValidationFailure);
                continue;
            }
            if (pcEntry == null || !pcEntry.isAdd()) {
                if (pcEntry != null) {
                    failureList.add(new Failure(MessageFormat.format(Messages.getString("LocalDataAccessLayer.ChangeAlreadyPendingExceptionFormat"), targetServerItem), "ChangeAlreadyPendingException", SeverityType.ERROR, changeRequest.getItemSpec().getItem()));
                    continue;
                }
                if (lvEntry != null && lvEntry.getVersion() != 0) {
                    failureList.add(new Failure(MessageFormat.format(Messages.getString("LocalDataAccessLayer.ItemExistsExceptionFormat"), targetServerItem), "ItemExistsException", SeverityType.ERROR, changeRequest.getItemSpec().getItem()));
                    continue;
                }
                if (pc.getRecursiveChangeTypeForTargetServerItem(targetServerItem).contains(ChangeType.DELETE)) {
                    String changedItem = changeRequest.getItemSpec().getItem();
                    failureList.add(LocalDataAccessLayer.createPendingParentDeleteFailure(targetServerItem, changedItem));
                    continue;
                }
            }
            if (null == lvEntry) {
                lvEntry = new WorkspaceLocalItem();
                lvEntry.setServerItem(targetServerItem);
                lvEntry.setVersion(0);
                lvEntry.setLocalItem(changeRequest.getItemSpec().getItem());
                lvEntry.setEncoding(ItemType.FILE == changeRequest.getItemType() ? changeRequest.getEncoding() : -3);
                lvEntry.setPendingReconcile(true);
                lv.add(lvEntry);
            }
            lvEntry.setPropertyValues(changeRequest.getProperties());
            if (null == pcEntry) {
                pcEntry = new LocalPendingChange(lvEntry, targetServerItem, ChangeType.ADD_ENCODING);
                pcEntry.setEncoding(lvEntry.getEncoding());
                pcEntry.setTargetServerItem(targetServerItem);
                pcEntry.setCommittedServerItem(null);
                if (ItemType.FILE == changeRequest.getItemType()) {
                    pcEntry.setChangeType(pcEntry.getChangeType().combine(ChangeType.EDIT));
                }
                if (changeRequest.getProperties() != null && changeRequest.getProperties().length > 0) {
                    pcEntry.setChangeType(pcEntry.getChangeType().combine(ChangeType.PROPERTY));
                    pcEntry.setPropertyValues(changeRequest.getProperties());
                }
                pc.pendChange(pcEntry);
                pc.removeCandidateByTargetServerItem(targetServerItem);
            }
            if (silent || !duplicatesFilter.add(lvEntry.getServerItem())) continue;
            getOps.add(lvEntry.toGetOperation(pcEntry, itemPropertyFilters));
        }
        for (Failure failure : failureList) {
            failure.setRequestType(RequestType.ADD);
        }
        failures.set(failureList.toArray(new Failure[failureList.size()]));
        return getOps.toArray(new GetOperation[getOps.size()]);
    }

    public static GetOperation[] pendDelete(Workspace workspace, LocalWorkspaceProperties wp, WorkspaceVersionTable lv, LocalPendingChangesTable pc, ChangeRequest[] changeRequests, boolean silent, AtomicReference<Failure[]> failures, String[] itemPropertyFilters) {
        Check.notNull(workspace, "workspace");
        Check.notNullOrEmpty(changeRequests, "changeRequests");
        workspace.getWorkspaceWatcher().scan(wp, lv, pc);
        ArrayList<Failure> failureList = new ArrayList<Failure>();
        ArrayList<GetOperation> getOps = new ArrayList<GetOperation>();
        HashSet<WorkspaceLocalItem> duplicatesFilter = new HashSet<WorkspaceLocalItem>();
        for (ChangeRequest changeRequest : changeRequests) {
            if (null == changeRequest) continue;
            Check.isTrue(changeRequest.getLockLevel() == LockLevel.UNCHANGED, "changeRequest.getLockLevel() == LockLevel.UNCHANGED");
            if (ServerPath.isRootFolder(changeRequest.getItemSpec().getItem())) {
                failureList.add(new Failure(Messages.getString("TeamProject.CanNotChangeRootFolderException"), "CannotChangeRootFolderException", SeverityType.ERROR, changeRequest.getItemSpec().getItem()));
                continue;
            }
            ParsedItemSpec parsedItemSpec = ParsedItemSpec.fromItemSpec(changeRequest.getItemSpec(), wp, lv, pc, ParsedItemSpecOptions.INCLUDE_DELETED, failureList);
            if (null == parsedItemSpec) continue;
            String rootTargetServerItem = parsedItemSpec.isServerItem() ? parsedItemSpec.getTargetItem() : WorkingFolder.getServerItemForLocalItem(parsedItemSpec.getTargetItem(), wp.getWorkingFolders());
            if (null != rootTargetServerItem) {
                if (rootTargetServerItem.length() > 399) {
                    failureList.add(LocalDataAccessLayer.createPathTooLongFailure(rootTargetServerItem));
                    continue;
                }
                LocalPendingChange pcEntry = pc.getByTargetServerItem(rootTargetServerItem);
                if (null != pcEntry && pcEntry.isDelete()) {
                    failureList.add(LocalDataAccessLayer.createPendingDeleteConflictChangeFailure(rootTargetServerItem));
                    continue;
                }
                if (pc.getRecursiveChangeTypeForTargetServerItem(rootTargetServerItem).contains(ChangeType.DELETE)) {
                    failureList.add(LocalDataAccessLayer.createPendingParentDeleteFailure(rootTargetServerItem));
                    continue;
                }
            }
            for (WorkspaceLocalItem lvEntry : parsedItemSpec.expandRootsFrom(lv, pc, failureList)) {
                if (!duplicatesFilter.add(lvEntry)) continue;
                String targetServerItem = pc.getTargetServerItemForLocalVersion(lvEntry);
                Failure failure = TeamProject.validateChange(targetServerItem, changeRequest.getItemType());
                if (failure != null) {
                    failureList.add(failure);
                    continue;
                }
                LocalPendingChange pcEntry = pc.getByLocalVersion(lvEntry);
                if (null != pcEntry) {
                    ChangeType remainingChangeType = pcEntry.getChangeType().remove(ChangeType.LOCK).remove(ChangeType.BRANCH).remove(ChangeType.PROPERTY);
                    if (pcEntry.isBranch()) {
                        remainingChangeType = remainingChangeType.remove(ChangeType.ENCODING).remove(ChangeType.MERGE);
                    }
                    if (pcEntry.isEdit() && lvEntry.isMissingOnDisk()) {
                        remainingChangeType = remainingChangeType.remove(ChangeType.EDIT);
                    }
                    if (!remainingChangeType.equals(ChangeType.NONE)) {
                        failureList.add(LocalDataAccessLayer.createPendingDeleteConflictChangeFailure(targetServerItem));
                        continue;
                    }
                }
                if (lvEntry.isDirectory()) {
                    boolean okayToDelete = true;
                    for (LocalPendingChange pcChildEntry : pc.queryByTargetServerItem(targetServerItem, RecursionType.FULL, null)) {
                        if (!pcChildEntry.getChangeType().containsAny(PEND_DELETE_CONFLICTING_CHANGE_TYPES)) continue;
                        failureList.add(LocalDataAccessLayer.createPendingDeleteConflictChangeFailure(targetServerItem));
                        okayToDelete = false;
                        break;
                    }
                    if (!okayToDelete) continue;
                    for (LocalPendingChange pcRenamedOut : pc.queryByCommittedServerItem(lvEntry.getServerItem(), RecursionType.FULL, null)) {
                        if (!pcRenamedOut.isRename()) continue;
                        String format = Messages.getString("LocalDataAccessLayer.PendingChildExceptionFormat");
                        failureList.add(new Failure(MessageFormat.format(format, targetServerItem), "PendingChildException", SeverityType.ERROR, targetServerItem));
                        okayToDelete = false;
                        break;
                    }
                    if (!okayToDelete) continue;
                }
                if (pc.getRecursiveChangeTypeForTargetServerItem(targetServerItem).contains(ChangeType.DELETE)) {
                    failureList.add(LocalDataAccessLayer.createPendingParentDeleteFailure(targetServerItem));
                    continue;
                }
                if (null == pcEntry) {
                    pcEntry = new LocalPendingChange(lvEntry, targetServerItem, ChangeType.DELETE);
                } else {
                    pcEntry.setChangeType(pcEntry.getChangeType().combine(ChangeType.DELETE));
                    pcEntry.setChangeType(pcEntry.getChangeType().remove(ChangeType.EDIT));
                }
                pc.pendChange(pcEntry);
                pc.removeCandidateByTargetServerItem(targetServerItem, true);
                if (lvEntry.isDirectory()) {
                    ArrayList<String> childDeletesToRemove = new ArrayList<String>();
                    for (LocalPendingChange pcChildEntry : pc.queryByTargetServerItem(targetServerItem, RecursionType.FULL, "*")) {
                        if (pcChildEntry.getChangeType().equals(ChangeType.DELETE)) {
                            childDeletesToRemove.add(pcChildEntry.getTargetServerItem());
                            continue;
                        }
                        pcChildEntry.setChangeType(pcChildEntry.getChangeType().combine(ChangeType.DELETE));
                    }
                    for (String toRemove : childDeletesToRemove) {
                        pc.removeByTargetServerItem(toRemove);
                    }
                }
                if (silent) continue;
                GetOperation rootGetOp = lvEntry.toGetOperation(pcEntry, itemPropertyFilters);
                rootGetOp.setTargetLocalItem(null);
                getOps.add(rootGetOp);
                if (!lvEntry.isDirectory()) continue;
                Iterable<WorkspaceLocalItem> lvChildEntries = lv.queryByServerItem(lvEntry.getServerItem(), RecursionType.FULL, "*");
                for (WorkspaceLocalItem lvChildEntry : lvChildEntries) {
                    if (!duplicatesFilter.add(lvChildEntry)) continue;
                    GetOperation childGetOp = lvChildEntry.toGetOperation(itemPropertyFilters);
                    childGetOp.setBaselineFileGUID(null);
                    childGetOp.setTargetLocalItem(null);
                    childGetOp.setPendingChangeID(0);
                    childGetOp.setChangeType(pc.getRecursiveChangeTypeForLocalVersion(lvChildEntry));
                    childGetOp.setProcessType(ProcessType.PEND);
                    getOps.add(childGetOp);
                }
            }
        }
        for (Failure failure : failureList) {
            failure.setRequestType(RequestType.DELETE);
        }
        failures.set(failureList.toArray(new Failure[failureList.size()]));
        return getOps.toArray(new GetOperation[getOps.size()]);
    }

    public static GetOperation[] pendEdit(Workspace workspace, LocalWorkspaceProperties wp, WorkspaceVersionTable lv, LocalPendingChangesTable pc, ChangeRequest[] changeRequests, boolean silent, AtomicReference<Failure[]> failures, String[] itemPropertyFilters) {
        Check.notNull(workspace, "workspace");
        Check.notNullOrEmpty(changeRequests, "changeRequests");
        ArrayList<Failure> failureList = new ArrayList<Failure>();
        ArrayList<GetOperation> getOps = new ArrayList<GetOperation>();
        HashSet<WorkspaceLocalItem> duplicatesFilter = new HashSet<WorkspaceLocalItem>();
        for (ChangeRequest changeRequest : changeRequests) {
            if (null == changeRequest) continue;
            Check.isTrue(changeRequest.getLockLevel() == LockLevel.UNCHANGED, "changeRequest.getLockLevel() == LockLevel.UNCHANGED");
            ParsedItemSpec parsedItemSpec = ParsedItemSpec.fromItemSpec(changeRequest.getItemSpec(), wp, lv, pc, ParsedItemSpecOptions.NONE, failureList);
            if (null == parsedItemSpec) continue;
            for (WorkspaceLocalItem lvEntry : parsedItemSpec.expandFrom(lv, pc, failureList)) {
                String format;
                String targetServerItem = pc.getTargetServerItemForLocalVersion(lvEntry);
                if (!duplicatesFilter.add(lvEntry)) continue;
                if (lvEntry.isDirectory()) {
                    if (RecursionType.NONE != parsedItemSpec.getRecursionType()) continue;
                    String format2 = Messages.getString("LocalDataAccessLayer.FolderEditExceptionFormat");
                    String message = MessageFormat.format(format2, targetServerItem);
                    failureList.add(new Failure(message, "NotAllowedOnFolderException", SeverityType.ERROR, changeRequest.getItemSpec().getItem()));
                    continue;
                }
                LocalPendingChange pcEntry = pc.getByLocalVersion(lvEntry);
                if (null != pcEntry && pcEntry.isDelete()) {
                    format = Messages.getString("LocalDataAccessLayer.IncompatibleChangeExceptionFormat");
                    String message = MessageFormat.format(format, targetServerItem);
                    failureList.add(new Failure(message, "IncompatibleChangeException", SeverityType.ERROR, changeRequest.getItemSpec().getItem()));
                    continue;
                }
                if (pc.getRecursiveChangeTypeForLocalVersion(lvEntry).contains(ChangeType.DELETE)) {
                    String changedItem = changeRequest.getItemSpec().getItem();
                    failureList.add(LocalDataAccessLayer.createPendingParentDeleteFailure(targetServerItem, changedItem));
                    continue;
                }
                if (null != pcEntry && pcEntry.isAdd() && -2 == changeRequest.getEncoding()) {
                    format = Messages.getString("LocalDataAccessLayer.IncompatibleChangeExceptionFormat");
                    String message = MessageFormat.format(format, targetServerItem);
                    failureList.add(new Failure(message, "IncompatibleChangeException", SeverityType.ERROR, changeRequest.getItemSpec().getItem()));
                    continue;
                }
                if (null == pcEntry) {
                    Check.isTrue(lvEntry.isCommitted(), "Local version is uncommitted but has no pending change.");
                    pcEntry = new LocalPendingChange(lvEntry, targetServerItem, ChangeType.EDIT);
                } else {
                    pcEntry.setChangeType(pcEntry.getChangeType().combine(ChangeType.EDIT));
                }
                if (changeRequest.getProperties() != null) {
                    for (PropertyValue value : changeRequest.getProperties()) {
                        if (!"Microsoft.TeamFoundation.VersionControl.SymbolicLink".equalsIgnoreCase(value.getPropertyName())) continue;
                        pcEntry.setChangeType(pcEntry.getChangeType().combine(ChangeType.PROPERTY));
                        pcEntry.setPropertyValues(PropertyUtils.mergePendingValues(pcEntry.getPropertyValues(), changeRequest.getProperties()));
                    }
                }
                if (-2 != changeRequest.getEncoding()) {
                    pcEntry.setEncoding(changeRequest.getEncoding());
                    pcEntry.setChangeType(pcEntry.getChangeType().combine(ChangeType.ENCODING));
                }
                pc.pendChange(pcEntry);
                if (silent) continue;
                GetOperation getop = lvEntry.toGetOperation(pcEntry, itemPropertyFilters);
                getop.setChangeType(pc.getRecursiveChangeTypeForLocalVersion(lvEntry));
                getOps.add(getop);
            }
        }
        for (Failure failure : failureList) {
            failure.setRequestType(RequestType.EDIT);
        }
        failures.set(failureList.toArray(new Failure[failureList.size()]));
        return getOps.toArray(new GetOperation[getOps.size()]);
    }

    public static GetOperation[] pendPropertyChange(Workspace workspace, LocalWorkspaceProperties wp, WorkspaceVersionTable lv, LocalPendingChangesTable pc, ChangeRequest[] changeRequests, boolean silent, AtomicReference<Failure[]> failures, AtomicBoolean onlineOperationRequired, String[] itemPropertyFilters) {
        Check.notNull(workspace, "workspace");
        Check.notNullOrEmpty(changeRequests, "changeRequests");
        ArrayList<Failure> failureList = new ArrayList<Failure>();
        ArrayList<GetOperation> getOps = new ArrayList<GetOperation>();
        HashSet<WorkspaceLocalItem> duplicatesFilter = new HashSet<WorkspaceLocalItem>();
        for (ChangeRequest changeRequest : changeRequests) {
            if (null == changeRequest) continue;
            if (changeRequest.getProperties() != null) {
                for (PropertyValue value : changeRequest.getProperties()) {
                    if ("Microsoft.TeamFoundation.VersionControl.Executable".equalsIgnoreCase(value.getPropertyName()) || "Microsoft.TeamFoundation.VersionControl.SymbolicLink".equalsIgnoreCase(value.getPropertyName())) continue;
                    return LocalDataAccessLayer.sendToServer(failures, onlineOperationRequired);
                }
            }
            Check.isTrue(changeRequest.getLockLevel() == LockLevel.UNCHANGED, "changeRequest.getLockLevel() == LockLevel.UNCHANGED");
            ParsedItemSpec parsedItemSpec = ParsedItemSpec.fromItemSpec(changeRequest.getItemSpec(), wp, lv, pc, ParsedItemSpecOptions.NONE, failureList);
            if (null == parsedItemSpec) continue;
            for (WorkspaceLocalItem lvEntry : parsedItemSpec.expandFrom(lv, pc, failureList)) {
                String targetServerItem = pc.getTargetServerItemForLocalVersion(lvEntry);
                if (!duplicatesFilter.add(lvEntry)) continue;
                LocalPendingChange pcEntry = pc.getByLocalVersion(lvEntry);
                if (null != pcEntry && pcEntry.isDelete()) {
                    String format = Messages.getString("LocalDataAccessLayer.IncompatibleChangeExceptionFormat");
                    String message = MessageFormat.format(format, targetServerItem);
                    failureList.add(new Failure(message, "IncompatibleChangeException", SeverityType.ERROR, changeRequest.getItemSpec().getItem()));
                    continue;
                }
                if (pc.getRecursiveChangeTypeForLocalVersion(lvEntry).contains(ChangeType.DELETE)) {
                    String changedItem = changeRequest.getItemSpec().getItem();
                    failureList.add(LocalDataAccessLayer.createPendingParentDeleteFailure(targetServerItem, changedItem));
                    continue;
                }
                if (null == pcEntry) {
                    Check.isTrue(lvEntry.isCommitted(), "Local version is uncommitted but has no pending change.");
                    pcEntry = new LocalPendingChange(lvEntry, targetServerItem, ChangeType.PROPERTY);
                } else {
                    pcEntry.setChangeType(pcEntry.getChangeType().combine(ChangeType.PROPERTY));
                }
                pcEntry.setPropertyValues(PropertyUtils.mergePendingValues(pcEntry.getPropertyValues(), changeRequest.getProperties()));
                pc.pendChange(pcEntry);
                if (silent) continue;
                GetOperation getop = lvEntry.toGetOperation(pcEntry, itemPropertyFilters);
                getop.setChangeType(pc.getRecursiveChangeTypeForLocalVersion(lvEntry));
                getOps.add(getop);
            }
        }
        for (Failure failure : failureList) {
            failure.setRequestType(RequestType.PROPERTY);
        }
        failures.set(failureList.toArray(new Failure[failureList.size()]));
        return getOps.toArray(new GetOperation[getOps.size()]);
    }

    public static GetOperation[] pendRename(Workspace workspace, LocalWorkspaceProperties wp, WorkspaceVersionTable lv, LocalPendingChangesTable pc, ChangeRequest[] changeRequests, boolean silent, AtomicReference<Failure[]> failures, AtomicBoolean onlineOperationRequired, String[] itemPropertyFilters) {
        Check.notNull(workspace, "workspace");
        Check.notNull(changeRequests, "changeRequests");
        workspace.getWorkspaceWatcher().scan(wp, lv, pc);
        ArrayList<Failure> failureList = new ArrayList<Failure>();
        ArrayList<GetOperation> getOps = new ArrayList<GetOperation>();
        failures.set(null);
        WorkingFolder[] workspaceMappings = wp.getWorkingFolders();
        for (int i = 0; i < changeRequests.length; ++i) {
            Failure teamProjectValidationFailure;
            boolean rootIncludedInRename;
            ParsedItemSpec parsedItemSpec;
            if (null == changeRequests[i] || null == (parsedItemSpec = ParsedItemSpec.fromItemSpec(changeRequests[i].getItemSpec(), wp, lv, pc, ParsedItemSpecOptions.NONE, failureList))) continue;
            String sourceRoot = parsedItemSpec.getTargetItem();
            String targetRoot = changeRequests[i].getTargetItem();
            String sourceServerRoot = LocalDataAccessLayer.tryGetServerItem(sourceRoot, wp, lv, pc);
            String targetServerRoot = null;
            boolean isCloaked = false;
            if (ServerPath.isServerPath(targetRoot)) {
                targetServerRoot = targetRoot;
            } else {
                PathTranslation translation = WorkingFolder.translateLocalItemToServerItem(targetRoot, workspaceMappings);
                if (translation != null) {
                    targetServerRoot = translation.getTranslatedPath();
                    isCloaked = translation.isCloaked();
                }
            }
            if (isCloaked) {
                failureList.add(LocalDataAccessLayer.createItemCloakedFailure(targetRoot));
                continue;
            }
            if (targetServerRoot == null) {
                failureList.add(LocalDataAccessLayer.createItemNotMappedFailure(targetRoot));
                continue;
            }
            String targetLocalRoot = ServerPath.isServerPath(targetRoot) ? WorkingFolder.getLocalItemForServerItem(targetRoot, workspaceMappings) : targetRoot;
            int maxServerPathLength = workspace.getClient().getMaxServerPathLength();
            AtomicReference<String> outTargetRoot = new AtomicReference<String>(targetRoot);
            ItemPath.checkItem(outTargetRoot, "changeRequest.ItemSpec.Item", false, false, false, true, maxServerPathLength);
            targetRoot = outTargetRoot.get();
            if (ServerPath.isServerPath(targetRoot)) {
                if (targetLocalRoot != null && targetLocalRoot.length() > 0) {
                    LocalPath.checkLocalItem(targetLocalRoot, "TargetItem", false, false, false, true);
                }
            } else {
                AtomicReference<String> outTargetServerRoot = new AtomicReference<String>(targetServerRoot);
                ServerPath.checkServerItem(outTargetServerRoot, "TargetItem", false, false, false, true, maxServerPathLength);
                targetServerRoot = outTargetServerRoot.get();
            }
            String targetUnrenamedServerRoot = pc.getCommittedServerItemForTargetServerItem(targetServerRoot);
            if (ItemPath.isWildcard(targetRoot)) {
                failureList.add(new Failure(Messages.getString("LocalDataAccessLayer.WildcardNotAllowedForRenameTarget"), "WildcardNotAllowedException", SeverityType.ERROR, targetRoot));
                continue;
            }
            ItemType targetItemType = changeRequests[i].getTargetItemType();
            boolean isMove = LocalDataAccessLayer.isMove(targetUnrenamedServerRoot, targetItemType, lv);
            boolean targetIsFolder = targetItemType == ItemType.ANY ? LocalDataAccessLayer.isDirectory(lv, pc, targetServerRoot) : targetItemType == ItemType.FOLDER;
            boolean bl = rootIncludedInRename = parsedItemSpec.getPattern() == null;
            if (parsedItemSpec.getPattern() != null && ItemPath.isWildcard(parsedItemSpec.getPattern()) && !isMove) {
                failureList.add(new Failure(Messages.getString("LocalDataAccessLayer.WildcardNotAllowedForRenameSource"), "WildcardNotAllowedException", SeverityType.ERROR, sourceRoot));
                continue;
            }
            if (ServerPath.isRootFolder(targetServerRoot)) {
                failureList.add(new Failure(Messages.getString("LocalDataAccessLayer.CanNotChangeRootFolderException"), "CannotChangeRootFolderException", SeverityType.ERROR, parsedItemSpec.getTargetItem()));
                continue;
            }
            if (!targetIsFolder && (teamProjectValidationFailure = TeamProject.validateChange(targetServerRoot, ItemType.FOLDER)) != null) {
                failureList.add(teamProjectValidationFailure);
                continue;
            }
            for (WorkspaceLocalItem lvEntry : parsedItemSpec.expandFrom(lv, pc, failureList)) {
                WorkspaceLocalItem conflictingItem;
                boolean caseOnlyRename;
                String sourceCommittedServerItem;
                String sourceCurrentServerItem = sourceCommittedServerItem = lvEntry.getServerItem();
                if (lvEntry.isCommitted()) {
                    sourceCurrentServerItem = pc.getTargetServerItemForCommittedServerItem(sourceCommittedServerItem);
                }
                String targetServerItem = LocalDataAccessLayer.calculateTargetServerItem(sourceServerRoot, sourceCurrentServerItem, targetServerRoot, targetIsFolder, rootIncludedInRename);
                String targetLocalItem = WorkingFolder.getLocalItemForServerItem(targetServerItem, wp.getWorkingFolders());
                boolean bl2 = caseOnlyRename = ServerPath.equals(sourceCurrentServerItem, targetServerItem) && !ServerPath.equals(sourceCurrentServerItem, targetServerItem, false);
                if (ServerPath.isRootFolder(sourceCurrentServerItem)) {
                    failureList.add(new Failure(Messages.getString("LocalDataAccessLayer.CanNotChangeRootFolderException"), "CannotChangeRootFolderException", SeverityType.ERROR, sourceCurrentServerItem));
                    continue;
                }
                Failure teamProjectValidationFailure2 = TeamProject.validateChange(sourceCommittedServerItem, lvEntry.isDirectory() ? ItemType.FOLDER : ItemType.FILE);
                if (teamProjectValidationFailure2 != null) {
                    failureList.add(teamProjectValidationFailure2);
                    continue;
                }
                if (targetServerItem.length() > 399) {
                    failureList.add(LocalDataAccessLayer.createPathTooLongFailure(targetServerItem));
                    continue;
                }
                boolean workspaceMappingFailure = false;
                for (WorkingFolder mapping : workspaceMappings) {
                    if (ServerPath.equals(mapping.getServerItem(), sourceCurrentServerItem)) {
                        String format = Messages.getString("LocalDataAccessLayer.RenameWorkingFolderExceptionFormat");
                        failureList.add(new Failure(MessageFormat.format(format, sourceCurrentServerItem), "RenameWorkingFolderException", SeverityType.ERROR, sourceCurrentServerItem));
                        workspaceMappingFailure = true;
                        break;
                    }
                    if (!ServerPath.isChild(sourceCurrentServerItem, mapping.getServerItem())) continue;
                    return LocalDataAccessLayer.sendToServer(failures, onlineOperationRequired);
                }
                if (workspaceMappingFailure) continue;
                if (!caseOnlyRename && pc.getByTargetServerItem(targetServerItem) != null) {
                    String format = Messages.getString("LocalDataAccessLayer.ChangeAlreadyPendingExceptionFormat");
                    failureList.add(new Failure(MessageFormat.format(format, targetServerItem), "ChangeAlreadyPendingException", SeverityType.ERROR, sourceCurrentServerItem));
                    continue;
                }
                if (pc.getRecursiveChangeTypeForTargetServerItem(targetServerItem).contains(ChangeType.DELETE)) {
                    failureList.add(LocalDataAccessLayer.createPendingParentDeleteFailure(targetServerItem));
                    continue;
                }
                LocalPendingChange mainPendingChange = pc.getByLocalVersion(lvEntry);
                if (null != mainPendingChange) {
                    if (mainPendingChange.isLock()) {
                        return LocalDataAccessLayer.sendToServer(failures, onlineOperationRequired);
                    }
                    if (mainPendingChange.isDelete()) {
                        String format = Messages.getString("LocalDataAccessLayer.IncompatibleChangeExceptionFormat");
                        failureList.add(new Failure(MessageFormat.format(format, targetServerItem), "IncompatibleChangeException", SeverityType.ERROR, changeRequests[i].getItemSpec().getItem()));
                        continue;
                    }
                    String targetParent = ServerPath.getParent(targetServerItem);
                    String committedParent = pc.getCommittedServerItemForTargetServerItem(targetParent);
                    String targetUnrenamedParent = null;
                    if (committedParent != null && committedParent.length() > 0) {
                        targetUnrenamedParent = committedParent + targetServerItem.substring(targetParent.length());
                    }
                    if (targetUnrenamedParent != null && ServerPath.equals(targetUnrenamedParent, sourceCommittedServerItem, false) || ServerPath.equals(sourceCommittedServerItem, targetServerItem, false)) {
                        AtomicReference<Failure[]> undoFailures = new AtomicReference<Failure[]>();
                        ArrayList<LocalPendingChange> changes = new ArrayList<LocalPendingChange>();
                        changes.add(mainPendingChange);
                        GetOperation[] undoOps = LocalDataAccessLayer.undoPendingChanges(workspace, wp, lv, pc, changes, ChangeType.RENAME, undoFailures, onlineOperationRequired);
                        if (onlineOperationRequired.get()) {
                            return LocalDataAccessLayer.sendToServer(failures, onlineOperationRequired);
                        }
                        failureList.addAll(Arrays.asList((Object[])undoFailures.get()));
                        getOps.addAll(Arrays.asList(undoOps));
                        continue;
                    }
                }
                WorkspaceLocalItem workspaceLocalItem = conflictingItem = targetLocalItem == null || targetLocalItem.length() == 0 ? null : lv.getByLocalItem(targetLocalItem);
                if (conflictingItem != null && !caseOnlyRename) {
                    String format = Messages.getString("LocalDataAccessLayer.ItemExistsExceptionFormat");
                    failureList.add(new Failure(MessageFormat.format(format, targetServerItem), "ItemExistsException", SeverityType.ERROR, conflictingItem.getLocalItem()));
                    continue;
                }
                ArrayList<GetOperation> affectedItems = new ArrayList<GetOperation>();
                HashMap<String, LocalPendingChange> affectedCommittedPendingChanges = new HashMap<String, LocalPendingChange>();
                HashMap<String, LocalPendingChange> affectedNotCommittedPendingChanges = new HashMap<String, LocalPendingChange>();
                ArrayList<KeyValuePair<String, LocalPendingChange>> updatedPendingChanges = new ArrayList<KeyValuePair<String, LocalPendingChange>>();
                if (mainPendingChange == null) {
                    mainPendingChange = new LocalPendingChange(lvEntry, targetServerItem, ChangeType.RENAME);
                    affectedCommittedPendingChanges.put(mainPendingChange.getCommittedServerItem(), mainPendingChange);
                } else if (mainPendingChange.isAdd() || mainPendingChange.isBranch()) {
                    affectedNotCommittedPendingChanges.put(mainPendingChange.getTargetServerItem(), mainPendingChange);
                } else {
                    mainPendingChange.setChangeType(mainPendingChange.getChangeType().combine(ChangeType.RENAME));
                    affectedCommittedPendingChanges.put(mainPendingChange.getCommittedServerItem(), mainPendingChange);
                }
                boolean abort = false;
                if (lvEntry.isDirectory()) {
                    for (LocalPendingChange lpEntry : pc.queryByTargetServerItem(sourceCurrentServerItem, RecursionType.FULL, "*")) {
                        if (lpEntry.isAdd() || lpEntry.isBranch()) {
                            affectedNotCommittedPendingChanges.put(lpEntry.getTargetServerItem(), lpEntry);
                            continue;
                        }
                        affectedCommittedPendingChanges.put(lpEntry.getCommittedServerItem(), lpEntry);
                    }
                }
                for (WorkspaceLocalItem workspaceLocalItem2 : ParsedItemSpec.queryLocalVersionsByTargetServerItem(lv, pc, sourceCurrentServerItem, RecursionType.FULL, null, ParsedItemSpecOptions.INCLUDE_DELETED)) {
                    String format;
                    GetOperation childGetOp;
                    String childTargetServerItem;
                    LocalPendingChange associatedPendingChange = null;
                    if (workspaceLocalItem2.isCommitted()) {
                        associatedPendingChange = (LocalPendingChange)affectedCommittedPendingChanges.get(workspaceLocalItem2.getServerItem());
                    } else if (!workspaceLocalItem2.isCommitted()) {
                        associatedPendingChange = (LocalPendingChange)affectedNotCommittedPendingChanges.get(workspaceLocalItem2.getServerItem());
                    }
                    if (associatedPendingChange != null) {
                        if (associatedPendingChange.isLock()) {
                            return LocalDataAccessLayer.sendToServer(failures, onlineOperationRequired);
                        }
                        childTargetServerItem = !ServerPath.equals(targetServerItem, associatedPendingChange.getTargetServerItem(), false) ? LocalDataAccessLayer.calculateTargetServerItem(sourceServerRoot, associatedPendingChange.getTargetServerItem(), targetServerRoot, targetIsFolder, rootIncludedInRename) : associatedPendingChange.getTargetServerItem();
                        updatedPendingChanges.add(new KeyValuePair<String, LocalPendingChange>(childTargetServerItem, associatedPendingChange));
                        childGetOp = workspaceLocalItem2.toGetOperation(associatedPendingChange, itemPropertyFilters);
                        childGetOp.setSourceServerItem(workspaceLocalItem2.isCommitted() ? childGetOp.getSourceServerItem() : childTargetServerItem);
                        childGetOp.setTargetServerItem(childTargetServerItem);
                        childGetOp.setChangeType(workspaceLocalItem2.isCommitted() ? associatedPendingChange.getChangeType().combine(ChangeType.RENAME) : childGetOp.getChangeType());
                    } else {
                        String currentServerItem = workspaceLocalItem2.isCommitted() ? pc.getTargetServerItemForCommittedServerItem(workspaceLocalItem2.getServerItem()) : workspaceLocalItem2.getServerItem();
                        childTargetServerItem = LocalDataAccessLayer.calculateTargetServerItem(sourceServerRoot, currentServerItem, targetServerRoot, targetIsFolder, rootIncludedInRename);
                        childGetOp = workspaceLocalItem2.toGetOperation(itemPropertyFilters);
                        childGetOp.setTargetServerItem(childTargetServerItem);
                        childGetOp.setChangeType(ChangeType.RENAME);
                    }
                    if (workspaceLocalItem2.isDeleted()) continue;
                    if (childTargetServerItem.length() > 399) {
                        abort = true;
                        failureList.add(LocalDataAccessLayer.createPathTooLongFailure(childTargetServerItem));
                        break;
                    }
                    String childTargetLocalItem = WorkingFolder.getLocalItemForServerItem(childTargetServerItem, wp.getWorkingFolders());
                    WorkspaceLocalItem workspaceLocalItem3 = conflictingItem = childTargetLocalItem == null || childTargetLocalItem.length() == 0 ? null : lv.getByLocalItem(childTargetLocalItem);
                    if (conflictingItem != null && !ServerPath.equals(conflictingItem.getServerItem(), workspaceLocalItem2.getServerItem())) {
                        abort = true;
                        format = Messages.getString("LocalDataAccessLayer.ItemExistsExceptionFormat");
                        failureList.add(new Failure(MessageFormat.format(format, targetServerItem), "ItemExistsException", SeverityType.ERROR, conflictingItem.getLocalItem()));
                        break;
                    }
                    if ((childTargetLocalItem == null || childTargetLocalItem.length() == 0) && childGetOp.getChangeType().contains(ChangeType.EDIT)) {
                        abort = true;
                        format = Messages.getString("LocalDataAccessLayer.TargetCloakedExceptionFormat");
                        failureList.add(new Failure(MessageFormat.format(format, sourceCurrentServerItem), "TargetCloakedException", SeverityType.ERROR, sourceCurrentServerItem));
                        break;
                    }
                    if (silent) continue;
                    childGetOp.setTargetLocalItem(childTargetLocalItem);
                    affectedItems.add(childGetOp);
                }
                if (abort) continue;
                for (KeyValuePair keyValuePair : updatedPendingChanges) {
                    String updateServerPath = (String)keyValuePair.getKey();
                    LocalPendingChange updatedPendingChange = (LocalPendingChange)keyValuePair.getValue();
                    pc.remove(updatedPendingChange);
                    updatedPendingChange.setTargetServerItem(updateServerPath);
                    pc.pendChange(updatedPendingChange);
                }
                if (!silent) {
                    for (String string : affectedNotCommittedPendingChanges.keySet()) {
                        LocalPendingChange pendingChange = (LocalPendingChange)affectedNotCommittedPendingChanges.get(string);
                        WorkspaceLocalItem addEntry = lv.getByServerItem(string, false);
                        if (addEntry == null) continue;
                        lv.removeByServerItem(string, false, true);
                        addEntry.setServerItem(pendingChange.getTargetServerItem());
                        addEntry.setLocalItem(WorkingFolder.getLocalItemForServerItem(pendingChange.getTargetServerItem(), wp.getWorkingFolders()));
                        lv.add(addEntry);
                    }
                }
                getOps.addAll(affectedItems);
            }
        }
        for (Failure failure : failureList) {
            failure.setRequestType(RequestType.RENAME);
        }
        onlineOperationRequired.set(false);
        failures.set(failureList.toArray(new Failure[failureList.size()]));
        return getOps.toArray(new GetOperation[getOps.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PendingSet[] queryPendingChanges(final Workspace workspace, final ItemSpec[] itemSpecs, AtomicReference<Failure[]> failures, final boolean includeCandidates, final String lastChange, final int pageSize, final String[] itemPropertyFilters) {
        Check.notNull(workspace, "workspace");
        final ArrayList pendingChanges = new ArrayList();
        final ArrayList candidateChanges = new ArrayList();
        failures.set(new Failure[0]);
        LocalWorkspaceTransaction transaction = new LocalWorkspaceTransaction(workspace);
        try {
            transaction.execute(new AllTablesTransaction(){

                @Override
                public void invoke(LocalWorkspaceProperties wp, WorkspaceVersionTable lv, LocalPendingChangesTable pc) {
                    for (LocalPendingChange pcEntry : LocalDataAccessLayer.queryPendingChanges(workspace, wp, lv, pc, itemSpecs, new ArrayList(), includeCandidates, itemPropertyFilters)) {
                        if (lastChange != null && lastChange.length() != 0 && !pcEntry.isCandidate() && ServerPath.compareTopDown(pcEntry.getTargetServerItem(), lastChange) <= 0) continue;
                        WorkspaceLocalItem lvEntry = pcEntry.isCandidate() ? null : lv.getByPendingChange(pcEntry);
                        String targetLocalItem = null != lvEntry && !lvEntry.isDeleted() ? lvEntry.getLocalItem() : WorkingFolder.getLocalItemForServerItem(pcEntry.getTargetServerItem(), wp.getWorkingFolders());
                        if (!pcEntry.isCandidate()) {
                            pendingChanges.add(pcEntry.toPendingChange(workspace.getClient(), targetLocalItem));
                            if (pageSize == 0 || pageSize != pendingChanges.size()) continue;
                            break;
                        }
                        candidateChanges.add(pcEntry.toPendingChange(workspace.getClient(), targetLocalItem));
                    }
                }
            });
        }
        finally {
            try {
                transaction.close();
            }
            catch (IOException e) {
                throw new VersionControlException(e);
            }
        }
        if (pendingChanges.size() == 0 && candidateChanges.size() == 0) {
            return new PendingSet[0];
        }
        return new PendingSet[]{new PendingSet(workspace.getName(), workspace.getOwnerName(), workspace.getOwnerDisplayName(), OwnershipState.OWNED_BY_AUTHORIZED_USER, workspace.getComputer(), PendingSetType.WORKSPACE, pendingChanges.toArray(new PendingChange[pendingChanges.size()]), candidateChanges.toArray(new PendingChange[candidateChanges.size()]))};
    }

    /*
     * WARNING - void declaration
     */
    private static Iterable<LocalPendingChange> queryPendingChanges(Workspace workspace, LocalWorkspaceProperties wp, WorkspaceVersionTable lv, LocalPendingChangesTable pc, ItemSpec[] itemSpecs, List<Failure> failuresAccumulator, boolean includeCandidates, String[] itemPropertyFilters) {
        void var11_13;
        Check.notNull(workspace, "workspace");
        Check.notNull(itemSpecs, "itemspecs");
        workspace.getWorkspaceWatcher().scan(wp, lv, pc);
        ArrayList itemSpecResults = new ArrayList();
        ItemSpec[] arr$ = itemSpecs;
        int len$ = arr$.length;
        boolean bl = false;
        while (var11_13 < len$) {
            block22: {
                ParsedItemSpec parsedItemSpec;
                AtomicReference<Failure> outDummy;
                ItemSpec itemSpec = arr$[var11_13];
                if (null == itemSpec) break block22;
                ArrayList<LocalPendingChange> pendingChanges = new ArrayList<LocalPendingChange>();
                ParsedItemSpecOptions flags = ParsedItemSpecOptions.INCLUDE_DELETED;
                if (ServerPath.isServerPath(itemSpec.getItem())) {
                    itemSpec.setItem(ServerPath.canonicalize(itemSpec.getItem()));
                    outDummy = new AtomicReference<Failure>();
                    parsedItemSpec = ParsedItemSpec.fromServerItemSpec(itemSpec, wp, lv, pc, flags, outDummy, includeCandidates);
                    if (null != parsedItemSpec) {
                        LocalPendingChange[] pcEntries;
                        for (LocalPendingChange pcEntry : pcEntries = pc.queryByTargetServerItem(parsedItemSpec.getTargetItem(), parsedItemSpec.getRecursionType(), parsedItemSpec.getPattern())) {
                            pendingChanges.add(pcEntry);
                        }
                        if (includeCandidates) {
                            Iterable<LocalPendingChange> entries = pc.queryCandidatesByTargetServerItem(parsedItemSpec.getTargetItem(), parsedItemSpec.getRecursionType(), parsedItemSpec.getPattern());
                            for (LocalPendingChange pcEntry : entries) {
                                pendingChanges.add(pcEntry);
                            }
                        }
                    }
                } else {
                    itemSpec.setItem(LocalPath.canonicalize(itemSpec.getItem()));
                    outDummy = new AtomicReference();
                    parsedItemSpec = ParsedItemSpec.fromLocalItemSpec(itemSpec, wp, lv, pc, flags, outDummy, includeCandidates);
                    if (null != parsedItemSpec) {
                        String targetServerItem;
                        if (RecursionType.NONE == parsedItemSpec.getRecursionType()) {
                            Iterator<WorkspaceLocalItem> items = parsedItemSpec.expandFrom(lv, pc, outDummy).iterator();
                            WorkspaceLocalItem lvEntry = items.hasNext() ? items.next() : null;
                            LocalPendingChange pcEntry = null;
                            if (null != lvEntry) {
                                pcEntry = pc.getByLocalVersion(lvEntry);
                            } else {
                                String targetServerItem2 = WorkingFolder.getServerItemForLocalItem(parsedItemSpec.getTargetItem(), wp.getWorkingFolders());
                                if (null != targetServerItem2 && (pcEntry = pc.getByTargetServerItem(targetServerItem2)) != null && null != (lvEntry = lv.getByPendingChange(pcEntry)) && !lvEntry.isDeleted()) {
                                    pcEntry = null;
                                }
                            }
                            if (null != pcEntry) {
                                pendingChanges.add(pcEntry);
                            }
                        } else {
                            for (LocalPendingChange pcEntry : pc.queryByTargetServerItem("$/", RecursionType.FULL, null)) {
                                WorkspaceLocalItem lvEntry = lv.getByPendingChange(pcEntry);
                                String targetLocalItem = null != lvEntry && !lvEntry.isDeleted() ? lvEntry.getLocalItem() : WorkingFolder.getLocalItemForServerItem(pcEntry.getTargetServerItem(), wp.getWorkingFolders());
                                if (null == targetLocalItem || !parsedItemSpec.match(targetLocalItem)) continue;
                                pendingChanges.add(pcEntry);
                            }
                        }
                        if (includeCandidates && null != (targetServerItem = WorkingFolder.getServerItemForLocalItem(parsedItemSpec.getTargetItem(), wp.getWorkingFolders()))) {
                            Iterable<LocalPendingChange> candidateEntries = pc.queryCandidatesByTargetServerItem(targetServerItem, parsedItemSpec.getRecursionType(), parsedItemSpec.getPattern());
                            for (LocalPendingChange candidateEntry : candidateEntries) {
                                pendingChanges.add(candidateEntry);
                            }
                        }
                    }
                }
                if (pendingChanges.size() > 0) {
                    itemSpecResults.add(pendingChanges);
                } else {
                    String format = Messages.getString("LocalDataAccessLayer.NoPendingChangesMatchingItemSpecFormat");
                    failuresAccumulator.add(new Failure(MessageFormat.format(format, itemSpec.getItem()), "ItemNotCheckedOutException", SeverityType.ERROR, itemSpec.getItem()));
                }
            }
            ++var11_13;
        }
        if (itemSpecResults.size() == 1) {
            return (Iterable)itemSpecResults.get(0);
        }
        TreeSet<LocalPendingChange> toReturn = new TreeSet<LocalPendingChange>(LocalPendingChange.SERVER_ITEM_COMPARATOR);
        for (List list : itemSpecResults) {
            for (LocalPendingChange pendingChange : list) {
                toReturn.add(pendingChange);
            }
        }
        return toReturn;
    }

    public static GetOperation[] undoPendingChanges(Workspace workspace, LocalWorkspaceProperties wp, WorkspaceVersionTable lv, LocalPendingChangesTable pc, ItemSpec[] itemSpecs, AtomicReference<Failure[]> failures, AtomicBoolean onlineOperationRequired, String[] itemPropertyFilters) {
        Check.notNull(workspace, "workspace");
        Check.notNullOrEmpty(itemSpecs, "itemSpecs");
        ArrayList<Failure> failuresList = new ArrayList<Failure>();
        GetOperation[] toReturn = LocalDataAccessLayer.undoPendingChanges(workspace, wp, lv, pc, LocalDataAccessLayer.queryPendingChanges(workspace, wp, lv, pc, itemSpecs, failuresList, false, itemPropertyFilters), ChangeType.ALL, failures, onlineOperationRequired);
        for (Failure failure : failures.get()) {
            failuresList.add(failure);
        }
        failures.set(failuresList.toArray(new Failure[failuresList.size()]));
        return toReturn;
    }

    public static GetOperation[] undoPendingChanges(Workspace workspace, LocalWorkspaceProperties wp, WorkspaceVersionTable lv, LocalPendingChangesTable pc, Iterable<LocalPendingChange> pendingChanges, ChangeType selectiveUndo, AtomicReference<Failure[]> failures, AtomicBoolean onlineOperationRequired) {
        HashMap<ServerItemIsCommittedTuple, GetOperation> getOps = new HashMap<ServerItemIsCommittedTuple, GetOperation>();
        ArrayList<UndoneChange> undoneChanges = new ArrayList<UndoneChange>();
        HashMap<String, UndoneChange> undoneChangesMap = new HashMap<String, UndoneChange>();
        ArrayList<RenamedPendingChange> renamedPendingChanges = new ArrayList<RenamedPendingChange>();
        ArrayList<String> workingFolderServerItems = null;
        ArrayList<Failure> failureList = new ArrayList<Failure>();
        int undoRenameCount = 0;
        for (LocalPendingChange pcEntry : pendingChanges) {
            int index;
            ChangeType changeType = pcEntry.getChangeType().retain(selectiveUndo);
            UndoneChange undoneChange = new UndoneChange(pcEntry, pcEntry.getServerItem(), changeType);
            undoneChanges.add(undoneChange);
            undoneChangesMap.put(undoneChange.getPendingChange().getTargetServerItem(), undoneChange);
            if (undoneChange.isUndoingLock() || undoneChange.isUndoingRename() && undoneChange.getPendingChange().isLock()) {
                return LocalDataAccessLayer.sendToServer(failures, onlineOperationRequired);
            }
            if (!undoneChange.isUndoingRename()) continue;
            ++undoRenameCount;
            if (null == workingFolderServerItems) {
                WorkingFolder[] workingFolders = wp.getWorkingFolders();
                workingFolderServerItems = new ArrayList<String>(workingFolders.length);
                for (WorkingFolder workingFolder : workingFolders) {
                    workingFolderServerItems.add(workingFolder.getServerItem());
                }
                Collections.sort(workingFolderServerItems, new Comparator<String>(){

                    @Override
                    public int compare(String x, String y) {
                        return ServerPath.compareTopDown(x, y);
                    }
                });
            }
            if ((index = Collections.binarySearch(workingFolderServerItems, pcEntry.getTargetServerItem(), ServerPath.TOP_DOWN_COMPARATOR)) < 0 && (~index >= workingFolderServerItems.size() || !ServerPath.isChild(pcEntry.getTargetServerItem(), (String)workingFolderServerItems.get(~index)))) continue;
            return LocalDataAccessLayer.sendToServer(failures, onlineOperationRequired);
        }
        Collections.sort(undoneChanges, new Comparator<UndoneChange>(){

            @Override
            public int compare(UndoneChange x, UndoneChange y) {
                return ServerPath.compareTopDown(y.getPendingChange().getTargetServerItem(), x.getPendingChange().getTargetServerItem());
            }
        });
        if (undoRenameCount > 0) {
            int totalRenameCount = 0;
            ArrayList<LocalPendingChange> remainingFolderRenames = new ArrayList<LocalPendingChange>();
            for (LocalPendingChange pcEntry : pc.queryByTargetServerItem("$/", RecursionType.FULL, null)) {
                UndoneChange undoneChange;
                if (!pcEntry.isRename()) continue;
                ++totalRenameCount;
                if (!pcEntry.isRecursiveChange() || (undoneChange = (UndoneChange)undoneChangesMap.get(pcEntry.getTargetServerItem())) != null && undoneChange.isUndoingRename()) continue;
                remainingFolderRenames.add(pcEntry);
            }
            if (undoneChanges.size() != pc.getCount()) {
                for (UndoneChange undoneChange : undoneChanges) {
                    LocalPendingChange lpc = undoneChange.getPendingChange();
                    if (0 != lpc.getDeletionID() || !lpc.isCommitted() || !undoneChange.isUndoingRename() || ServerPath.equals(lpc.getCommittedServerItem(), lpc.getTargetServerItem())) continue;
                    for (WebServiceObjectWrapper webServiceObjectWrapper : pc.queryByTargetServerItem(undoneChange.getPendingChange().getCommittedServerItem(), RecursionType.FULL, null)) {
                        UndoneChange collision;
                        if (!((LocalPendingChange)webServiceObjectWrapper).isAdd() && !((LocalPendingChange)webServiceObjectWrapper).isBranch() && !((LocalPendingChange)webServiceObjectWrapper).isRename() || (collision = (UndoneChange)undoneChangesMap.get(((LocalPendingChange)webServiceObjectWrapper).getTargetServerItem())) != null && collision.getUndoneChangeType().containsAny(ChangeType.ADD_BRANCH_OR_RENAME)) continue;
                        String format = Messages.getString("LocalDataAccessLayer.PartialRenameConflictExceptionFormat");
                        throw new PartialRenameConflictException(MessageFormat.format(format, ((LocalPendingChange)webServiceObjectWrapper).getTargetServerItem()));
                    }
                }
            }
            if (undoRenameCount != totalRenameCount) {
                for (LocalPendingChange remainingFolderRename : remainingFolderRenames) {
                    for (LocalPendingChange pcEntry : pc.queryByCommittedServerItem(remainingFolderRename.getCommittedServerItem(), RecursionType.FULL, null)) {
                        if (!pcEntry.isRename() || !pcEntry.isRecursiveChange()) continue;
                        UndoneChange undoneChange = (UndoneChange)undoneChangesMap.get(pcEntry.getTargetServerItem());
                        int targetFolderDepth = ServerPath.getFolderDepth(pcEntry.getTargetServerItem());
                        int n = ServerPath.getFolderDepth(remainingFolderRename.getTargetServerItem());
                        if (undoneChange == null || !undoneChange.isUndoingRename() || targetFolderDepth >= n) continue;
                        String format = Messages.getString("LocalDataAccessLayer.PartialRenameConflictExceptionFormat");
                        throw new PartialRenameConflictException(MessageFormat.format(format, pcEntry.getCommittedServerItem()));
                    }
                }
                HashMap<String, RenameCalculationEntry> newNames = new HashMap<String, RenameCalculationEntry>();
                ArrayList<RenameCalculationEntry> pendingRenamesOnly = new ArrayList<RenameCalculationEntry>(totalRenameCount);
                for (UndoneChange undoneChange : undoneChanges) {
                    RenameCalculationEntry rcEntry = new RenameCalculationEntry(undoneChange.getPendingChange().getTargetServerItem(), undoneChange.getPendingChange().getServerItem(), undoneChange.getPendingChange(), undoneChange.isUndoingRename());
                    newNames.put(undoneChange.getPendingChange().getTargetServerItem(), rcEntry);
                    if (!undoneChange.getPendingChange().isRename()) continue;
                    pendingRenamesOnly.add(rcEntry);
                }
                for (LocalPendingChange pcEntry : pc.queryByTargetServerItem("$/", RecursionType.FULL, null)) {
                    if (!pcEntry.isRename() && !pcEntry.isAdd() && !pcEntry.isBranch() || undoneChangesMap.containsKey(pcEntry.getTargetServerItem())) continue;
                    RenameCalculationEntry renameCalculationEntry = new RenameCalculationEntry(pcEntry.getTargetServerItem(), pcEntry.getServerItem(), pcEntry, false);
                    newNames.put(pcEntry.getTargetServerItem(), renameCalculationEntry);
                    if (!pcEntry.isRename()) continue;
                    pendingRenamesOnly.add(renameCalculationEntry);
                }
                Collections.sort(pendingRenamesOnly, new Comparator<RenameCalculationEntry>(){

                    @Override
                    public int compare(RenameCalculationEntry x, RenameCalculationEntry y) {
                        return ServerPath.compareTopDown(x.getPendingChange().getCommittedServerItem(), y.getPendingChange().getCommittedServerItem());
                    }
                });
                for (RenameCalculationEntry newName : pendingRenamesOnly) {
                    String pendingTargetServerItem;
                    String sourceServerItem = newName.getSourceServerItem();
                    String targetServerItem = newName.getTargetServerItem();
                    if (!newName.isUndoingChange()) {
                        for (RenameCalculationEntry rcEntry : newNames.values()) {
                            String entrySourceServerItem = rcEntry.getSourceServerItem();
                            if (!ServerPath.isChild(sourceServerItem, entrySourceServerItem)) continue;
                            String entryTargetServerItem = rcEntry.getTargetServerItem();
                            pendingTargetServerItem = rcEntry.getPendingChange().getTargetServerItem();
                            if (ServerPath.equals(entrySourceServerItem, entryTargetServerItem) && !ServerPath.equals(pendingTargetServerItem, entrySourceServerItem)) continue;
                            rcEntry.setSourceServerItem(targetServerItem + entrySourceServerItem.substring(sourceServerItem.length()));
                        }
                        continue;
                    }
                    for (RenameCalculationEntry rcEntry : newNames.values()) {
                        String entryTargetServerItem = rcEntry.getTargetServerItem();
                        if (!ServerPath.isChild(targetServerItem, entryTargetServerItem)) continue;
                        String entrySourceServerItem = rcEntry.getSourceServerItem();
                        pendingTargetServerItem = rcEntry.getPendingChange().getTargetServerItem();
                        if (ServerPath.equals(entrySourceServerItem, entryTargetServerItem) && !ServerPath.equals(pendingTargetServerItem, entrySourceServerItem)) continue;
                        rcEntry.setTargetServerItem(sourceServerItem + entryTargetServerItem.substring(targetServerItem.length()));
                    }
                }
                RenameCalculationEntry[] rcEntries = newNames.values().toArray(new RenameCalculationEntry[newNames.size()]);
                Arrays.sort(rcEntries, new Comparator<RenameCalculationEntry>(){

                    @Override
                    public int compare(RenameCalculationEntry x, RenameCalculationEntry y) {
                        return ServerPath.compareTopDown(x.getTargetServerItem(), y.getTargetServerItem());
                    }
                });
                int duplicateCheckIndex = -1;
                for (int i = 1; i < rcEntries.length; ++i) {
                    if (rcEntries[i - 1].getPendingChange().getDeletionID() == 0 || !rcEntries[i - 1].getPendingChange().isRename()) {
                        duplicateCheckIndex = i - 1;
                    }
                    if (duplicateCheckIndex < 0 || rcEntries[i].getPendingChange().getDeletionID() != 0 && rcEntries[i].getPendingChange().isRename() || !ServerPath.equals(rcEntries[i].getTargetServerItem(), rcEntries[duplicateCheckIndex].getTargetServerItem())) continue;
                    throw new PartialRenameConflictException(MessageFormat.format(Messages.getString("LocalDataAccessLayer.PartialRenameConflictExceptionFormat"), rcEntries[i].getTargetServerItem()));
                }
                for (UndoneChange undoneChange : undoneChanges) {
                    RenameCalculationEntry renameCalculationEntry = (RenameCalculationEntry)newNames.get(undoneChange.getPendingChange().getTargetServerItem());
                    if (renameCalculationEntry == null) continue;
                    undoneChange.setRevertToServerItem(renameCalculationEntry.getTargetServerItem());
                }
            } else {
                for (UndoneChange undoneChange : undoneChanges) {
                    if (undoneChange.getPendingChange().isCommitted()) {
                        undoneChange.setRevertToServerItem(undoneChange.getPendingChange().getCommittedServerItem());
                        continue;
                    }
                    undoneChange.setRevertToServerItem(pc.getCommittedServerItemForTargetServerItem(undoneChange.getPendingChange().getTargetServerItem()));
                }
            }
        } else {
            for (UndoneChange undoneChange : undoneChanges) {
                undoneChange.setRevertToServerItem(undoneChange.getPendingChange().getTargetServerItem());
            }
        }
        for (UndoneChange undoneChange : undoneChanges) {
            if (undoneChange.getRevertToServerItem().length() > 399) {
                throw LocalDataAccessLayer.createPathTooLongException(undoneChange.getRevertToServerItem());
            }
            LocalPendingChange pcEntry = undoneChange.getPendingChange();
            WorkspaceLocalItem lvEntry = lv.getByPendingChange(undoneChange.getPendingChange());
            GetOperation getOp = new GetOperation();
            getOp.setTargetServerItem(undoneChange.getRevertToServerItem());
            getOp.setSourceServerItem(pcEntry.isCommitted() ? pcEntry.getCommittedServerItem() : pcEntry.getTargetServerItem());
            if (null != lvEntry && !lvEntry.isDeleted()) {
                getOp.setSourceLocalItem(lvEntry.getLocalItem());
                if (undoneChange.isUndoingAdd()) {
                    workspace.getWorkspaceWatcher().markPathChanged(lvEntry.getLocalItem());
                    LocalWorkspaceTransaction.getCurrent().setRaisePendingChangeCandidatesChanged(true);
                }
            }
            if ((0 == pcEntry.getDeletionID() || undoneChange.getRemainingChangeType().contains(ChangeType.UNDELETE)) && !undoneChange.isUndoingBranch()) {
                String targetLocalItem = WorkingFolder.getLocalItemForServerItem(undoneChange.getRevertToServerItem(), wp.getWorkingFolders());
                if (null != lvEntry) {
                    getOp.setTargetLocalItem(targetLocalItem);
                    if (pcEntry.isAdd() && null == getOp.getTargetLocalItem()) {
                        getOp.setTargetLocalItem(getOp.getSourceLocalItem());
                    }
                } else {
                    getOp.setTargetLocalItem(null);
                    if (null != targetLocalItem) {
                        String format = "OfflineUndoNoLocalVersionEntry";
                        failureList.add(new Failure(MessageFormat.format("OfflineUndoNoLocalVersionEntry", undoneChange.getRevertToServerItem()), "BaselineUnavailableException", SeverityType.WARNING, undoneChange.getRevertToServerItem()));
                    }
                }
                if (null != getOp.getTargetLocalItem()) {
                    getOp.setLocalVersionEntry(lv.getByLocalItem(getOp.getTargetLocalItem()));
                }
            }
            if (!pcEntry.getChangeType().contains(ChangeType.ENCODING)) {
                getOp.setEncoding(pcEntry.getEncoding());
            } else if (null != lvEntry) {
                getOp.setEncoding(lvEntry.getEncoding());
            } else {
                return LocalDataAccessLayer.sendToServer(failures, onlineOperationRequired);
            }
            getOp.setChangeType(undoneChange.getUndoneChangeType());
            if (!undoneChange.isUndoingAdd() && !undoneChange.isUndoingBranch()) {
                ChangeType inheritedChangeType = ChangeType.NONE;
                for (LocalPendingChange parentPcEntry : pc.queryParentsOfTargetServerItem(pcEntry.getTargetServerItem())) {
                    UndoneChange undoneChange2 = (UndoneChange)undoneChangesMap.get(parentPcEntry.getTargetServerItem());
                    if (!parentPcEntry.isRecursiveChange() || undoneChange2 == null) continue;
                    if (undoneChange2.getUndoneChangeType().contains(ChangeType.RENAME)) {
                        inheritedChangeType = inheritedChangeType.combine(ChangeType.RENAME);
                    }
                    if (!undoneChange2.getUndoneChangeType().contains(ChangeType.DELETE)) continue;
                    inheritedChangeType = inheritedChangeType.combine(ChangeType.DELETE);
                }
                getOp.setChangeType(inheritedChangeType.combine(getOp.getChangeType()));
            }
            getOp.setDeletionID(pcEntry.getDeletionID());
            getOp.setItemType(pcEntry.getItemType());
            getOp.setPendingChangeID(-123);
            getOp.setItemID(pcEntry.getItemID());
            if (null != lvEntry) {
                if (lvEntry.isCommitted() && !lvEntry.isDirectory()) {
                    getOp.setBaselineFileGUID(lvEntry.hasBaselineFileGUID() ? lvEntry.getBaselineFileGUID() : new byte[16]);
                }
                getOp.setHashValue(lvEntry.getHashValue());
                getOp.setVersionLocal(lvEntry.isDeleted() ? 0 : lvEntry.getVersion());
                getOp.setVersionServer(lvEntry.getVersion());
                getOp.setVersionServerDate(-1L == lvEntry.getCheckinDate() ? DotNETDate.MIN_CALENDAR : DotNETDate.fromWindowsFileTimeUTC(lvEntry.getCheckinDate()));
                getOp.setPropertyValues(pcEntry.getPropertyValues());
            } else {
                getOp.setVersionServer(pcEntry.getVersion());
            }
            getOps.put(new ServerItemIsCommittedTuple(getOp.getSourceServerItem(), pcEntry.isCommitted()), getOp);
            if (!undoneChange.isUndoingAdd() && (!undoneChange.isUndoingBranch() || getOp.getTargetLocalItem() == null) || null == lvEntry) continue;
            lv.removeByServerItem(lvEntry.getServerItem(), lvEntry.isCommitted(), true);
        }
        for (UndoneChange undoneChange : undoneChanges) {
            if (!undoneChange.isUndoingRecursiveChange()) continue;
            for (WorkspaceLocalItem lvEntry : ParsedItemSpec.queryLocalVersionsByTargetServerItem(lv, pc, undoneChange.getPendingChange().getTargetServerItem(), RecursionType.FULL, null, ParsedItemSpecOptions.INCLUDE_DELETED)) {
                if (getOps.containsKey(new ServerItemIsCommittedTuple(lvEntry.getServerItem(), lvEntry.isCommitted()))) continue;
                String currentServerItem = lvEntry.isCommitted() ? pc.getTargetServerItemForCommittedServerItem(lvEntry.getServerItem()) : lvEntry.getServerItem();
                GetOperation getOp = new GetOperation();
                getOp.setSourceLocalItem(lvEntry.isDeleted() ? null : lvEntry.getLocalItem());
                getOp.setTargetServerItem(undoneChange.getRevertToServerItem() + currentServerItem.substring(undoneChange.getPendingChange().getTargetServerItem().length()));
                if (getOp.getTargetServerItem().length() > 399) {
                    throw LocalDataAccessLayer.createPathTooLongException(getOp.getTargetServerItem());
                }
                getOp.setSourceServerItem(lvEntry.isCommitted() ? lvEntry.getServerItem() : getOp.getTargetServerItem());
                getOp.setTargetLocalItem(WorkingFolder.getLocalItemForServerItem(getOp.getTargetServerItem(), wp.getWorkingFolders()));
                if (null != getOp.getTargetLocalItem()) {
                    getOp.setLocalVersionEntry(lv.getByLocalItem(getOp.getTargetLocalItem()));
                }
                getOp.setDeletionID(0);
                getOp.setEncoding(lvEntry.getEncoding());
                getOp.setItemType(lvEntry.isDirectory() ? ItemType.FOLDER : ItemType.FILE);
                getOp.setPropertyValues(lvEntry.getPropertyValues());
                getOp.setPendingChangeID(0);
                getOp.setItemID(lvEntry.getItemID());
                if (!ServerPath.equals(currentServerItem, getOp.getTargetServerItem())) {
                    LocalPendingChange pcEntry;
                    if (!lvEntry.isCommitted() && !ServerPath.equals(currentServerItem, getOp.getTargetServerItem())) {
                        getOp.setItemID(0);
                    }
                    if (null != (pcEntry = pc.getByTargetServerItem(currentServerItem))) {
                        if (pcEntry.isLock()) {
                            return LocalDataAccessLayer.sendToServer(failures, onlineOperationRequired);
                        }
                        if (pcEntry.hasMergeConflict()) {
                            throw new CannotRenameDueToChildConflictException(undoneChange.getPendingChange().getTargetServerItem(), pcEntry.getTargetServerItem());
                        }
                        renamedPendingChanges.add(new RenamedPendingChange(currentServerItem, getOp.getTargetServerItem()));
                    }
                }
                if (lvEntry.isCommitted() && !lvEntry.isDirectory()) {
                    getOp.setBaselineFileGUID(lvEntry.hasBaselineFileGUID() ? lvEntry.getBaselineFileGUID() : new byte[16]);
                }
                getOp.setHashValue(lvEntry.getHashValue());
                getOp.setVersionLocal(lvEntry.isDeleted() ? 0 : lvEntry.getVersion());
                getOp.setVersionServer(lvEntry.getVersion());
                getOp.setVersionServerDate(-1L == lvEntry.getCheckinDate() ? DotNETDate.MIN_CALENDAR : DotNETDate.fromWindowsFileTimeUTC(lvEntry.getCheckinDate()));
                getOp.setChangeType(ChangeType.NONE);
                boolean stillDeleted = false;
                for (LocalPendingChange localPendingChange : pc.queryParentsOfTargetServerItem(currentServerItem)) {
                    UndoneChange checkChange = (UndoneChange)undoneChangesMap.get(localPendingChange.getTargetServerItem());
                    if (checkChange == null) {
                        if (!localPendingChange.isDelete()) continue;
                        stillDeleted = true;
                        break;
                    }
                    ChangeType changeType = getOp.getChangeType();
                    changeType = changeType.combine(checkChange.getUndoneChangeType());
                    changeType = changeType.combine(ChangeType.RENAME_OR_DELETE);
                    getOp.setChangeType(changeType);
                }
                if (lvEntry.isDeleted() && stillDeleted || null == getOp.getTargetLocalItem() && null == getOp.getSourceLocalItem()) continue;
                getOps.put(new ServerItemIsCommittedTuple(lvEntry.getServerItem(), lvEntry.isCommitted()), getOp);
            }
        }
        ArrayList<LocalPendingChange> selectiveUndoChanges = new ArrayList<LocalPendingChange>();
        for (UndoneChange undoneChange : undoneChanges) {
            pc.remove(undoneChange.getPendingChange());
            if (undoneChange.getUndoneChangeType().equals(undoneChange.getPendingChange().getChangeType())) continue;
            LocalPendingChange newChange = undoneChange.getPendingChange().clone();
            newChange.setChangeType(undoneChange.getPendingChange().getChangeType().remove(undoneChange.getUndoneChangeType()));
            newChange.setTargetServerItem(undoneChange.getRevertToServerItem());
            selectiveUndoChanges.add(newChange);
        }
        for (LocalPendingChange pcEntry : selectiveUndoChanges) {
            pc.pendChange(pcEntry);
        }
        for (RenamedPendingChange renamedPendingChange : renamedPendingChanges) {
            WorkspaceLocalItem lvEntry;
            LocalPendingChange pcEntry = pc.getByTargetServerItem(renamedPendingChange.getOldTargetServerItem());
            if (null == pcEntry) continue;
            pc.remove(pcEntry);
            renamedPendingChange.setPendingChange(pcEntry);
            if (pcEntry.isCommitted() || null == (lvEntry = lv.getByServerItem(renamedPendingChange.getOldTargetServerItem(), false))) continue;
            renamedPendingChange.setLocalVersion(lvEntry);
            lv.removeByServerItem(lvEntry.getServerItem(), lvEntry.isCommitted(), true);
        }
        for (RenamedPendingChange renamedPendingChange : renamedPendingChanges) {
            LocalPendingChange pcEntry = renamedPendingChange.getPendingChange();
            WorkspaceLocalItem lvEntry = renamedPendingChange.getLocalVersion();
            if (null != pcEntry) {
                pcEntry.setTargetServerItem(renamedPendingChange.getTargetServerItem());
                if (!pcEntry.isCommitted()) {
                    pcEntry.setItemID(0);
                }
                pc.pendChange(pcEntry);
            }
            if (null == lvEntry) continue;
            lvEntry.setServerItem(renamedPendingChange.getTargetServerItem());
            lvEntry.setItemID(0);
            lv.add(lvEntry);
        }
        failures.set(failureList.toArray(new Failure[failureList.size()]));
        onlineOperationRequired.set(false);
        return getOps.values().toArray(new GetOperation[getOps.size()]);
    }

    private static GetOperation[] sendToServer(AtomicReference<Failure[]> failures, AtomicBoolean onlineOperationRequired) {
        failures.set(new Failure[0]);
        onlineOperationRequired.set(true);
        return null;
    }

    public static boolean reconcileLocalWorkspace(Workspace workspace, WebServiceLayer webServiceLayer, boolean unscannedReconcile, boolean reconcileMissingFromDisk, AtomicReference<Failure[]> failures, AtomicBoolean pendingChangesUpdatedByServer) {
        int previousProjectRevisionId = -1;
        boolean processedProjectRenames = false;
        while (true) {
            try {
                boolean reconciled = LocalDataAccessLayer.reconcileLocalWorkspaceHelper(workspace, webServiceLayer, unscannedReconcile, reconcileMissingFromDisk, failures, pendingChangesUpdatedByServer);
                pendingChangesUpdatedByServer.set(pendingChangesUpdatedByServer.get() || processedProjectRenames);
                return reconciled;
            }
            catch (ReconcileBlockedByProjectRenameException renameEx) {
                if (previousProjectRevisionId >= 0 && previousProjectRevisionId == renameEx.getNewProjectRevisionId()) {
                    Failure failure = new Failure(MessageFormat.format(Messages.getString("LocalDataAccessLayer.RepeatedProjectRevisionIdFormat"), renameEx.getNewProjectRevisionId()), null, SeverityType.ERROR, null);
                    throw new ReconcileFailedException(new Failure[]{failure});
                }
                ArrayList<KeyValuePair<String, String>> projectRenames = new ArrayList<KeyValuePair<String, String>>();
                for (int i = 0; i < renameEx.getOldProjectNames().length; ++i) {
                    projectRenames.add(new KeyValuePair<String, String>(renameEx.getOldProjectNames()[i], renameEx.getNewProjectNames()[i]));
                }
                LocalDataAccessLayer.ProcessProjectRenames(workspace, webServiceLayer, projectRenames, renameEx.getNewProjectRevisionId());
                previousProjectRevisionId = renameEx.getNewProjectRevisionId();
                processedProjectRenames = true;
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean reconcileLocalWorkspaceHelper(final Workspace workspace, final WebServiceLayer webServiceLayer, final boolean unscannedReconcile, final boolean reconcileMissingFromDisk, AtomicReference<Failure[]> failures, AtomicBoolean pendingChangesUpdatedByServer) {
        LocalWorkspaceTransaction transaction;
        Check.notNull(workspace, "workspace");
        pendingChangesUpdatedByServer.set(false);
        final ArrayList convertedAdds = new ArrayList();
        final boolean throwOnProjectRenamed = !EnvironmentVariables.isDefined("TF_DD_SUITES_PROJECT_RENAME_UNPATCHED_CLIENT");
        final AtomicReference<GUID> serverPendingChangeSignature = new AtomicReference<GUID>(GUID.EMPTY);
        if (!(!unscannedReconcile && workspace.getWorkspaceWatcher().isScanNecessary() || reconcileMissingFromDisk)) {
            final AtomicBoolean hasPendingLocalVersionRows = new AtomicBoolean(true);
            transaction = new LocalWorkspaceTransaction(workspace);
            try {
                transaction.execute(new LocalVersionHeaderTransaction(){

                    @Override
                    public void invoke(WorkspaceVersionTableHeader lvh) {
                        hasPendingLocalVersionRows.set(lvh.getPendingReconcile());
                    }
                });
            }
            finally {
                try {
                    transaction.close();
                }
                catch (IOException e) {
                    throw new VersionControlException(e);
                }
            }
            final AtomicReference<GUID> clientPendingChangeSignature = new AtomicReference<GUID>(GUID.EMPTY);
            if (!hasPendingLocalVersionRows.get()) {
                transaction = new LocalWorkspaceTransaction(workspace);
                try {
                    transaction.execute(new PendingChangesHeaderTransaction(){

                        @Override
                        public void invoke(LocalPendingChangesTableHeader pch) {
                            clientPendingChangeSignature.set(pch.getClientSignature());
                        }
                    });
                }
                finally {
                    try {
                        transaction.close();
                    }
                    catch (IOException e) {
                        throw new VersionControlException(e);
                    }
                }
                GUID lastServerPendingChangeGuid = workspace.getOfflineCacheData().getLastServerPendingChangeSignature();
                Calendar lastReconcileTime = workspace.getOfflineCacheData().getLastReconcileTime();
                lastReconcileTime.add(13, 8);
                if (lastServerPendingChangeGuid != GUID.EMPTY && clientPendingChangeSignature.get().equals(lastServerPendingChangeGuid) && lastReconcileTime.after(Calendar.getInstance())) {
                    failures.set(new Failure[0]);
                    return false;
                }
                serverPendingChangeSignature.set(webServiceLayer.queryPendingChangeSignature(workspace.getName(), workspace.getOwnerName()));
                if (serverPendingChangeSignature.get() != GUID.EMPTY && clientPendingChangeSignature.get().equals(serverPendingChangeSignature)) {
                    workspace.getOfflineCacheData().setLastServerPendingChangeSignature(serverPendingChangeSignature.get());
                    workspace.getOfflineCacheData().setLastReconcileTime(Calendar.getInstance());
                    failures.set(new Failure[0]);
                    return false;
                }
            }
        }
        final AtomicBoolean toReturn = new AtomicBoolean(true);
        transaction = new LocalWorkspaceTransaction(workspace);
        try {
            final AtomicReference<Failure[]> delegateFailures = new AtomicReference<Failure[]>(new Failure[0]);
            final AtomicBoolean delegatePCUpdated = new AtomicBoolean(false);
            transaction.execute(new AllTablesTransaction(){

                @Override
                public void invoke(LocalWorkspaceProperties wp, WorkspaceVersionTable lv, LocalPendingChangesTable pc) {
                    if (!unscannedReconcile) {
                        workspace.getWorkspaceWatcher().scan(wp, lv, pc);
                    }
                    if (!lv.getPendingReconcile() && !reconcileMissingFromDisk && GUID.EMPTY == serverPendingChangeSignature.get()) {
                        serverPendingChangeSignature.set(webServiceLayer.queryPendingChangeSignature(workspace.getName(), workspace.getOwnerName()));
                        if (serverPendingChangeSignature.get() != GUID.EMPTY && pc.getClientSignature().equals(serverPendingChangeSignature.get())) {
                            delegateFailures.set(new Failure[0]);
                            workspace.getOfflineCacheData().setLastServerPendingChangeSignature((GUID)serverPendingChangeSignature.get());
                            workspace.getOfflineCacheData().setLastReconcileTime(Calendar.getInstance());
                            toReturn.set(true);
                            return;
                        }
                    }
                    if (wp.getNewProjectRevisionId() > 0) {
                        webServiceLayer.promotePendingWorkspaceMappings(workspace.getName(), workspace.getOwnerName(), wp.getNewProjectRevisionId());
                        wp.setNewProjectRevisionId(0);
                    }
                    LocalPendingChange[] pendingChanges = pc.queryByTargetServerItem("$/", RecursionType.FULL, null);
                    ArrayList<ChangeRequest> propertyRequests = new ArrayList<ChangeRequest>();
                    for (LocalPendingChange lpc : pendingChanges) {
                        if (!lpc.getChangeType().contains(ChangeType.PROPERTY)) continue;
                        PropertyValue[] pv = lpc.getPropertyValues();
                        String serverItem = lpc.getTargetServerItem();
                        if (pv == null || pv.length <= 0 || serverItem == null) continue;
                        ChangeRequest request = new ChangeRequest(new ItemSpec(serverItem, RecursionType.NONE), new WorkspaceVersionSpec(workspace), RequestType.PROPERTY, ItemType.ANY, -2, LockLevel.UNCHANGED, 0, null, false);
                        request.setProperties(pv);
                        propertyRequests.add(request);
                    }
                    if (propertyRequests.size() > 0) {
                        ((WebServiceLayerLocalWorkspaces)webServiceLayer).pendChangesInLocalWorkspace(workspace.getName(), workspace.getOwnerName(), propertyRequests.toArray(new ChangeRequest[propertyRequests.size()]), PendChangesOptions.NONE, SupportedFeatures.ALL, new AtomicReference<Failure[]>(), null, null, new AtomicBoolean(), new AtomicReference<ChangePendedFlags>());
                    }
                    AtomicBoolean outClearLocalVersionTable = new AtomicBoolean();
                    ServerItemLocalVersionUpdate[] lvUpdates = lv.getUpdatesForReconcile(pendingChanges, reconcileMissingFromDisk, outClearLocalVersionTable);
                    ReconcileResult result = webServiceLayer.reconcileLocalWorkspace(workspace.getName(), workspace.getOwnerName(), pc.getClientSignature(), pendingChanges, lvUpdates, outClearLocalVersionTable.get(), throwOnProjectRenamed);
                    Failure[] reconcileFailures = result.getFailures();
                    workspace.getClient().reportFailures(workspace, reconcileFailures);
                    if (reconcileFailures.length > 0) {
                        throw new ReconcileFailedException(reconcileFailures);
                    }
                    GUID newSignature = new GUID(result.getNewSignature());
                    PendingChange[] newPendingChanges = result.getNewPendingChanges();
                    if (result.isReplayLocalVersionsRequired()) {
                        if (!outClearLocalVersionTable.get()) {
                            result = webServiceLayer.reconcileLocalWorkspace(workspace.getName(), workspace.getOwnerName(), pc.getClientSignature(), pendingChanges, lvUpdates, true, throwOnProjectRenamed);
                            reconcileFailures = result.getFailures();
                            workspace.getClient().reportFailures(workspace, reconcileFailures);
                            if (reconcileFailures.length > 0) {
                                throw new ReconcileFailedException(reconcileFailures);
                            }
                            newSignature = new GUID(result.getNewSignature());
                            newPendingChanges = result.getNewPendingChanges();
                        }
                        ArrayList<ServerItemLocalVersionUpdate> replayUpdates = new ArrayList<ServerItemLocalVersionUpdate>(Math.min(lv.getLocalItemsCount(), 1000));
                        for (WorkspaceLocalItem lvEntry : lv.queryByServerItem("$/", RecursionType.FULL, null, true)) {
                            ServerItemLocalVersionUpdate replayUpdate = lvEntry.getLocalVersionUpdate(reconcileMissingFromDisk, true);
                            if (replayUpdate == null) continue;
                            replayUpdates.add(replayUpdate);
                            if (replayUpdates.size() < 1000) continue;
                            webServiceLayer.updateLocalVersion(workspace.getName(), workspace.getOwnerName(), replayUpdates.toArray(new ServerItemLocalVersionUpdate[replayUpdates.size()]));
                            replayUpdates.clear();
                        }
                        if (replayUpdates.size() > 0) {
                            webServiceLayer.updateLocalVersion(workspace.getName(), workspace.getOwnerName(), replayUpdates.toArray(new ServerItemLocalVersionUpdate[replayUpdates.size()]));
                        }
                    }
                    if (result.isPendingChangesUpdated()) {
                        delegatePCUpdated.set(true);
                        TreeMap<String, ItemType> newPendingDeletes = new TreeMap<String, ItemType>(String.CASE_INSENSITIVE_ORDER);
                        for (PendingChange pendingChange : newPendingChanges) {
                            if (pendingChange.isAdd()) {
                                LocalPendingChange oldPendingChange = pc.getByTargetServerItem(pendingChange.getServerItem());
                                if (null != oldPendingChange && oldPendingChange.isAdd()) continue;
                                convertedAdds.add(pendingChange);
                                continue;
                            }
                            if (!pendingChange.isDelete()) continue;
                            newPendingDeletes.put(pendingChange.getSourceServerItem() == null ? pendingChange.getServerItem() : pendingChange.getSourceServerItem(), pendingChange.getItemType());
                        }
                        for (LocalPendingChange oldPendingChange : pc.queryByCommittedServerItem("$/", RecursionType.FULL, null)) {
                            if (!oldPendingChange.isDelete() || newPendingDeletes.containsKey(oldPendingChange.getCommittedServerItem())) continue;
                            ArrayList<ServerItemIsCommittedTuple> lvRowsToRemove = new ArrayList<ServerItemIsCommittedTuple>();
                            RecursionType recursion = oldPendingChange.isRecursiveChange() ? RecursionType.FULL : RecursionType.NONE;
                            for (WorkspaceLocalItem lvEntry : lv.queryByServerItem(oldPendingChange.getCommittedServerItem(), recursion, null, true)) {
                                if (!lvEntry.isDeleted()) continue;
                                lvRowsToRemove.add(new ServerItemIsCommittedTuple(lvEntry.getServerItem(), lvEntry.isCommitted()));
                            }
                            for (ServerItemIsCommittedTuple tuple : lvRowsToRemove) {
                                lv.removeByServerItem(tuple.getCommittedServerItem(), tuple.isCommitted(), false);
                            }
                        }
                        pc.replacePendingChanges(newPendingChanges);
                    }
                    if (!lv.isDirty()) {
                        transaction.setAllowTxF(false);
                    }
                    if (lvUpdates.length > 0) {
                        lv.markAsReconciled(wp, reconcileMissingFromDisk);
                        if (reconcileMissingFromDisk) {
                            ArrayList<String> candidatesToRemove = null;
                            for (LocalPendingChange candidateChange : pc.queryCandidatesByTargetServerItem("$/", RecursionType.FULL, null)) {
                                if (!candidateChange.isDelete()) continue;
                                if (null == candidatesToRemove) {
                                    candidatesToRemove = new ArrayList<String>();
                                }
                                candidatesToRemove.add(candidateChange.getTargetServerItem());
                            }
                            if (null != candidatesToRemove) {
                                for (String candidateDeleteTargetServerItem : candidatesToRemove) {
                                    pc.removeCandidateByTargetServerItem(candidateDeleteTargetServerItem);
                                }
                                LocalWorkspaceTransaction.getCurrent().setRaisePendingChangeCandidatesChanged(true);
                            }
                        }
                    }
                    if (!(newSignature = webServiceLayer.queryPendingChangeSignature(workspace.getName(), workspace.getOwnerName())).equals(pc.getClientSignature())) {
                        pc.setClientSignature(newSignature);
                        workspace.getOfflineCacheData().setLastServerPendingChangeSignature(newSignature);
                    }
                    if (!newSignature.equals(pc.getClientSignature())) {
                        pc.setClientSignature(newSignature);
                        workspace.getOfflineCacheData().setLastServerPendingChangeSignature(newSignature);
                    }
                    workspace.getOfflineCacheData().setLastReconcileTime(Calendar.getInstance());
                }
            });
            failures.set(delegateFailures.get());
            pendingChangesUpdatedByServer.set(delegatePCUpdated.get());
        }
        finally {
            try {
                transaction.close();
            }
            catch (IOException e) {
                throw new VersionControlException(e);
            }
        }
        if (convertedAdds.size() > 0) {
            UpdateLocalVersionQueueOptions options = UpdateLocalVersionQueueOptions.UPDATE_BOTH;
            UpdateLocalVersionQueue ulvq = new UpdateLocalVersionQueue(workspace, options);
            try {
                for (PendingChange pc : convertedAdds) {
                    ulvq.queueUpdate(new ClientLocalVersionUpdate(pc.getServerItem(), pc.getItemID(), pc.getLocalItem(), 0, DotNETDate.MIN_CALENDAR, pc.getEncoding(), null, 0L, null, null, null));
                }
            }
            finally {
                ulvq.close();
            }
        }
        return toReturn.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void syncPendingChanges(Workspace workspace, GetOperation[] getOperations, String[] itemPropertyFilters) {
        AtomicReference<GUID> outServerPendingChangeSignature = new AtomicReference<GUID>();
        PendingChange[] pendingChanges = workspace.getClient().getWebServiceLayer().queryServerPendingChanges(workspace, outServerPendingChangeSignature);
        final GUID serverPendingChangeSignature = outServerPendingChangeSignature.get();
        final SparseTree<LocalPendingChange> pendingChangesTarget = new SparseTree<LocalPendingChange>('/', (Comparator<String>)String.CASE_INSENSITIVE_ORDER);
        for (PendingChange pendingChange : pendingChanges) {
            LocalPendingChange pcEntry = LocalPendingChange.fromPendingChange(pendingChange);
            pendingChangesTarget.set(pcEntry.getTargetServerItem(), pcEntry);
        }
        if (null != getOperations) {
            final ArrayList<KeyValuePair<String, Boolean>> localVersionsToRemove = new ArrayList<KeyValuePair<String, Boolean>>();
            final ArrayList<String> localVersionsToUpdate = new ArrayList<String>();
            for (GetOperation getOp : getOperations) {
                LocalPendingChange pcEntry;
                if ((getOp.getChangeType().contains(ChangeType.ADD) || getOp.getChangeType().contains(ChangeType.BRANCH) && null != getOp.getTargetLocalItem()) && (pcEntry = (LocalPendingChange)pendingChangesTarget.get(getOp.getTargetServerItem())) == null) {
                    localVersionsToRemove.add(new KeyValuePair<String, Boolean>(getOp.getSourceServerItem(), getOp.getVersionLocal() != 0));
                }
                if (getOp.getVersionLocal() != -1) continue;
                localVersionsToUpdate.add(getOp.getSourceServerItem());
            }
            if (localVersionsToRemove.size() > 0 || localVersionsToUpdate.size() > 0) {
                LocalWorkspaceTransaction lvTrans = new LocalWorkspaceTransaction(workspace);
                try {
                    lvTrans.execute(new LocalVersionTransaction(){

                        @Override
                        public void invoke(WorkspaceVersionTable lv) {
                            for (KeyValuePair item : localVersionsToRemove) {
                                lv.removeByServerItem((String)item.getKey(), (Boolean)item.getValue(), false);
                            }
                            for (String serverItem : localVersionsToUpdate) {
                                WorkspaceLocalItem item = lv.getByServerItem(serverItem, true);
                                if (item == null || item.getVersion() == -1) continue;
                                lv.removeByServerItem(item.getServerItem(), item.isCommitted(), false);
                                item.setVersion(-1);
                                lv.add(item);
                            }
                        }
                    });
                }
                finally {
                    try {
                        lvTrans.close();
                    }
                    catch (IOException e) {
                        throw new VersionControlException(e);
                    }
                }
            }
        }
        LocalWorkspaceTransaction transaction = new LocalWorkspaceTransaction(workspace);
        try {
            transaction.execute(new PendingChangesTransaction(){

                @Override
                public void invoke(LocalPendingChangesTable pc) {
                    pc.replacePendingChanges(pendingChangesTarget);
                    pc.setClientSignature(serverPendingChangeSignature);
                }
            });
        }
        finally {
            try {
                transaction.close();
            }
            catch (IOException e) {
                throw new VersionControlException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void snapBackToCheckinDate(Workspace workspace, final GetRequest[] requests) {
        if (null == requests) {
            return;
        }
        LocalWorkspaceTransaction transaction = new LocalWorkspaceTransaction(workspace);
        try {
            transaction.execute(new AllTablesTransaction(){

                @Override
                public void invoke(LocalWorkspaceProperties wp, WorkspaceVersionTable lv, LocalPendingChangesTable pc) {
                    for (GetRequest getRequest : requests) {
                        if (null == getRequest) continue;
                        Iterable<WorkspaceLocalItem> lvEntrySource = null;
                        if (null == getRequest.getItemSpec()) {
                            lvEntrySource = lv.queryByLocalItem(null, RecursionType.FULL, null);
                        } else {
                            AtomicReference<Failure> dummy = new AtomicReference<Failure>();
                            ParsedItemSpec parsedItemSpec = ParsedItemSpec.fromItemSpec(getRequest.getItemSpec(), wp, lv, pc, ParsedItemSpecOptions.NONE, dummy);
                            if (null != parsedItemSpec) {
                                lvEntrySource = parsedItemSpec.expandFrom(lv, pc, dummy);
                            }
                        }
                        if (null == lvEntrySource) continue;
                        for (WorkspaceLocalItem lvEntry : lvEntrySource) {
                            LocalPendingChange pcEntry;
                            if (-1L == lvEntry.getCheckinDate() || lvEntry.getCheckinDate() == lvEntry.getLastModifiedTime() || null != (pcEntry = pc.getByLocalVersion(lvEntry)) && pcEntry.isEdit() || !new File(lvEntry.getLocalItem()).exists()) continue;
                            try {
                                FileSystemAttributes attrs = FileSystemUtils.getInstance().getAttributes(lvEntry.getLocalItem());
                                boolean restoreReadOnly = false;
                                if (attrs != null && attrs.isReadOnly()) {
                                    attrs.setReadOnly(false);
                                    FileSystemUtils.getInstance().setAttributes(lvEntry.getLocalItem(), attrs);
                                    restoreReadOnly = true;
                                }
                                new File(lvEntry.getLocalItem()).setLastModified(DotNETDate.fromWindowsFileTimeUTC(lvEntry.getCheckinDate()).getTimeInMillis());
                                if (restoreReadOnly) {
                                    attrs.setReadOnly(true);
                                    FileSystemUtils.getInstance().setAttributes(lvEntry.getLocalItem(), attrs);
                                }
                                lvEntry.setLastModifiedTime(lvEntry.getCheckinDate());
                                lv.setDirty(true);
                            }
                            catch (Exception ex) {
                                log.warn((Object)"Error snapping back to checkin date", (Throwable)ex);
                            }
                        }
                    }
                }
            });
        }
        finally {
            try {
                transaction.close();
            }
            catch (IOException e) {
                throw new VersionControlException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void afterAdd(Workspace workspace, final GetOperation[] getOperations) {
        LocalWorkspaceTransaction transaction = new LocalWorkspaceTransaction(workspace);
        try {
            transaction.execute(new LocalVersionTransaction(){

                @Override
                public void invoke(WorkspaceVersionTable lv) {
                    for (GetOperation getOp : getOperations) {
                        WorkspaceLocalItem lvEntry = new WorkspaceLocalItem();
                        lvEntry.setServerItem(getOp.getSourceServerItem());
                        lvEntry.setVersion(0);
                        lvEntry.setLocalItem(getOp.getTargetLocalItem());
                        lvEntry.setEncoding(getOp.getEncoding());
                        lvEntry.setPendingReconcile(true);
                        lvEntry.setPropertyValues(getOp.getPropertyValues());
                        lv.add(lvEntry);
                    }
                }
            });
        }
        finally {
            try {
                transaction.close();
            }
            catch (IOException e) {
                throw new VersionControlException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void afterCheckin(final Workspace workspace, int changesetId, Calendar checkinDate, final GetOperation[] localVersionUpdates, final PendingChange[] newPendingChanges, final UploadedBaselinesCollection uploadedBaselinesCollection) {
        final ArrayList baselineRequests = new ArrayList();
        final HashMap operationLengths = new HashMap();
        LocalWorkspaceTransaction transaction = new LocalWorkspaceTransaction(workspace);
        try {
            transaction.execute(new AllTablesTransaction(){

                @Override
                public void invoke(LocalWorkspaceProperties wp, WorkspaceVersionTable lv, LocalPendingChangesTable pc) {
                    for (GetOperation operation : localVersionUpdates) {
                        WorkspaceLocalItem lvEntry = lv.getByServerItem(operation.getSourceServerItem(), operation.getVersionLocal() != 0);
                        if (null != lvEntry) {
                            BaselineRequest baselineRequest = null;
                            if (null == operation.getTargetLocalItem() && null != lvEntry.getBaselineFileGUID()) {
                                baselineRequest = BaselineRequest.makeRemoveRequest(lvEntry.getBaselineFileGUID());
                                continue;
                            }
                            if (operation.getChangeType().contains(ChangeType.EDIT)) {
                                long uncompressedLength;
                                byte[] uploadedBaselineFileGuid;
                                if (null != uploadedBaselinesCollection) {
                                    String targetItem = operation.getTargetLocalItem();
                                    AtomicLong out = new AtomicLong(-1L);
                                    uploadedBaselineFileGuid = uploadedBaselinesCollection.getUploadedBaseline(targetItem, out);
                                    uncompressedLength = out.get();
                                } else {
                                    uploadedBaselineFileGuid = null;
                                    uncompressedLength = -1L;
                                }
                                if (null != uploadedBaselineFileGuid && uncompressedLength >= 0L) {
                                    operation.setBaselineFileGUID(uploadedBaselineFileGuid);
                                    operationLengths.put(operation, uncompressedLength);
                                    uploadedBaselinesCollection.removeUploadedBaseline(operation.getTargetLocalItem());
                                    continue;
                                }
                                operation.setBaselineFileGUID(GUID.newGUID().getGUIDBytes());
                                baselineRequest = BaselineRequest.fromDisk(operation.getBaselineFileGUID(), operation.getTargetLocalItem(), operation.getTargetLocalItem(), operation.getHashValue());
                                baselineRequests.add(baselineRequest);
                                try {
                                    File file = new File(operation.getTargetLocalItem());
                                    operationLengths.put(operation, new Long(file.length()));
                                }
                                catch (Throwable t) {
                                    log.warn((Object)t);
                                    operationLengths.put(operation, new Long(-1L));
                                }
                                continue;
                            }
                            operation.setBaselineFileGUID(lvEntry.getBaselineFileGUID());
                            operationLengths.put(operation, new Long(lvEntry.getLength()));
                            continue;
                        }
                        if (operation.getTargetLocalItem() == null || operation.getTargetLocalItem().length() <= 0) continue;
                        boolean setTargetLocalItemToNull = true;
                        if (ItemType.FOLDER == operation.getItemType() && null == operation.getSourceLocalItem() && operation.getChangeType().contains(ChangeType.ADD)) {
                            File directory = new File(operation.getTargetLocalItem());
                            if (!directory.exists()) {
                                try {
                                    directory.mkdirs();
                                    setTargetLocalItemToNull = false;
                                }
                                catch (Throwable t) {
                                    log.warn((Object)t);
                                }
                            } else {
                                setTargetLocalItemToNull = false;
                            }
                        }
                        if (!setTargetLocalItemToNull) continue;
                        operation.setTargetLocalItem(null);
                    }
                    pc.replacePendingChanges(newPendingChanges);
                    if (baselineRequests.size() != 0) {
                        new BaselineFolderCollection(workspace, wp.getBaselineFolders()).processBaselineRequests(workspace, baselineRequests);
                    }
                }
            });
        }
        finally {
            try {
                transaction.close();
            }
            catch (IOException e) {
                throw new VersionControlException(e);
            }
        }
        UpdateLocalVersionQueue ulvQueue = new UpdateLocalVersionQueue(workspace, UpdateLocalVersionQueueOptions.UPDATE_BOTH, null, 5000, 10000, Integer.MAX_VALUE);
        try {
            for (GetOperation operation : localVersionUpdates) {
                ClientLocalVersionUpdate lvUpdate;
                String targetLocalItem = operation.getTargetLocalItem();
                if (targetLocalItem == null || targetLocalItem.length() == 0) {
                    lvUpdate = new ClientLocalVersionUpdate(operation.getSourceServerItem(), operation.getItemID(), null, operation.getVersionLocal(), null);
                } else {
                    FileSystemAttributes attrs;
                    Long length = (Long)operationLengths.get(operation);
                    if (length == null) {
                        length = new Long(-1L);
                    }
                    PropertyValue[] detectedItemProperties = null;
                    if (Platform.isCurrentPlatform(Platform.GENERIC_UNIX) && (attrs = FileSystemUtils.getInstance().getAttributes(targetLocalItem)).exists()) {
                        if (attrs.isSymbolicLink()) {
                            detectedItemProperties = new PropertyValue[]{PropertyConstants.IS_SYMLINK};
                        } else if (!attrs.isDirectory() && attrs.isExecutable()) {
                            detectedItemProperties = new PropertyValue[]{PropertyConstants.EXECUTABLE_ENABLED_VALUE};
                        }
                    }
                    lvUpdate = new ClientLocalVersionUpdate(operation.getTargetServerItem(), operation.getItemID(), operation.getTargetLocalItem(), operation.getVersionServer(), checkinDate, operation.getEncoding(), operation.getHashValue(), length, operation.getBaselineFileGUID(), null, detectedItemProperties);
                    if (workspace.getOptions().contains(WorkspaceOptions.SET_FILE_TO_CHECKIN)) {
                        lvUpdate.setLastModifiedDate(DotNETDate.toWindowsFileTimeUTC(checkinDate));
                    }
                }
                ulvQueue.queueUpdate(lvUpdate);
            }
        }
        finally {
            ulvQueue.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LocalVersion[][] queryLocalVersions(Workspace workspace, final ItemSpec[] itemSpecs) {
        final LocalVersion[][] toReturn = new LocalVersion[itemSpecs.length][];
        LocalWorkspaceTransaction transaction = new LocalWorkspaceTransaction(workspace);
        try {
            transaction.execute(new WorkspacePropertiesLocalVersionTransaction(){

                @Override
                public void invoke(LocalWorkspaceProperties wp, WorkspaceVersionTable lv) {
                    for (int i = 0; i < itemSpecs.length; ++i) {
                        ArrayList<LocalVersion> localVersions = new ArrayList<LocalVersion>();
                        AtomicReference<Failure> dummy = new AtomicReference<Failure>();
                        ParsedItemSpec parsedItemSpec = ParsedItemSpec.fromLocalItemSpec(itemSpecs[i], wp, lv, null, ParsedItemSpecOptions.NONE, dummy, false);
                        if (null != parsedItemSpec) {
                            for (WorkspaceLocalItem lvEntry : parsedItemSpec.expandFrom(lv, null, dummy)) {
                                localVersions.add(new LocalVersion(lvEntry.getLocalItem(), lvEntry.getVersion()));
                            }
                        }
                        toReturn[i] = localVersions.toArray(new LocalVersion[localVersions.size()]);
                    }
                }
            });
        }
        finally {
            try {
                transaction.close();
            }
            catch (IOException e) {
                throw new VersionControlException(e);
            }
        }
        return toReturn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ExtendedItem[][] queryItemsExtended(final Workspace workspace, final ItemSpec[] items, final DeletedState deletedState, final ItemType itemType, GetItemsOptions options) {
        final ExtendedItem[][] toReturn = new ExtendedItem[items.length][];
        final AtomicReference dummy = new AtomicReference();
        LocalWorkspaceTransaction transaction = new LocalWorkspaceTransaction(workspace);
        try {
            transaction.execute(new AllTablesTransaction(){

                @Override
                public void invoke(LocalWorkspaceProperties wp, WorkspaceVersionTable lv, LocalPendingChangesTable pc) {
                    workspace.getWorkspaceWatcher().scan(wp, lv, pc);
                    for (int i = 0; i < items.length; ++i) {
                        ArrayList<ExtendedItem> extendedItems = new ArrayList<ExtendedItem>();
                        ParsedItemSpec parsedItemSpec = ParsedItemSpec.fromItemSpec(items[i], wp, lv, pc, ParsedItemSpecOptions.INCLUDE_DELETED, dummy);
                        if (null != parsedItemSpec && deletedState != DeletedState.DELETED) {
                            for (WorkspaceLocalItem lvEntry : parsedItemSpec.expandFrom(lv, pc, dummy)) {
                                LocalPendingChange pcEntry = pc.getByLocalVersion(lvEntry);
                                if (!ParsedItemSpec.matchItemType(lvEntry, itemType)) continue;
                                extendedItems.add(new ExtendedItem(pc, lvEntry, pcEntry));
                            }
                        }
                        toReturn[i] = extendedItems.toArray(new ExtendedItem[extendedItems.size()]);
                    }
                }
            });
        }
        finally {
            try {
                transaction.close();
            }
            catch (IOException e) {
                throw new VersionControlException(e);
            }
        }
        return toReturn;
    }

    public static void updateLocalVersion(Workspace workspace, LocalWorkspaceProperties wp, WorkspaceVersionTable lv, LocalPendingChangesTable pc, ILocalVersionUpdate[] localVersionUpdates, Set<byte[]> persistedDisplacedBaselines, AtomicReference<IPopulatableLocalVersionUpdate[]> updateMissingBaselines) {
        boolean setFileTimeToCheckin = workspace.getOptions().contains(WorkspaceOptions.SET_FILE_TO_CHECKIN);
        ArrayList<IPopulatableLocalVersionUpdate> updatesMissingBaselinesList = new ArrayList<IPopulatableLocalVersionUpdate>();
        Set<byte[]> displacedBaselines = persistedDisplacedBaselines;
        if (displacedBaselines == null) {
            displacedBaselines = new TreeSet<byte[]>(new BaselineFileGUIDComparer());
        }
        for (ILocalVersionUpdate update : localVersionUpdates) {
            ClientLocalVersionUpdate cUpdate;
            boolean updateIsMissingBaseline;
            if (update instanceof MoveUncommittedLocalVersionUpdate) {
                LocalDataAccessLayer.handleMoveUncommittedUpdate(wp, lv, (MoveUncommittedLocalVersionUpdate)update);
                continue;
            }
            if (update instanceof InitiallyDeletedLocalVersionUpdate) {
                InitiallyDeletedLocalVersionUpdate idUpdate = (InitiallyDeletedLocalVersionUpdate)update;
                updateIsMissingBaseline = LocalDataAccessLayer.handleInitiallyDeletedLocalVersionUpdate(wp, lv, pc, idUpdate, setFileTimeToCheckin, displacedBaselines);
                if (!updateIsMissingBaseline) continue;
                updatesMissingBaselinesList.add(idUpdate);
                continue;
            }
            if (!(update instanceof ClientLocalVersionUpdate) || !(updateIsMissingBaseline = LocalDataAccessLayer.handleClientLocalVersionUpdate(wp, lv, pc, cUpdate = (ClientLocalVersionUpdate)update, setFileTimeToCheckin, displacedBaselines))) continue;
            updatesMissingBaselinesList.add(cUpdate);
        }
        if (null == persistedDisplacedBaselines) {
            for (byte[] baselineFileGuid : displacedBaselines) {
                wp.deleteBaseline(baselineFileGuid);
            }
        }
        updateMissingBaselines.set(updatesMissingBaselinesList.toArray(new IPopulatableLocalVersionUpdate[updatesMissingBaselinesList.size()]));
    }

    public static void acknowledgeUpdateLocalVersion(WorkspaceVersionTable lv, ILocalVersionUpdate[] updates) {
        for (ILocalVersionUpdate update : updates) {
            WorkspaceLocalItem lvEntry;
            if (!update.isSendToServer() || null == (lvEntry = lv.getByServerItem(update.getSourceServerItem(), update.isCommitted())) || !lvEntry.isPendingReconcile()) continue;
            lv.removeByServerItem(lvEntry.getServerItem(), lvEntry.isCommitted(), false);
            lvEntry.setPendingReconcile(false);
            lv.add(lvEntry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WorkingFolder[] queryWorkingFolders(Workspace workspace) {
        final AtomicReference<Object> toReturn = new AtomicReference<Object>(null);
        LocalWorkspaceTransaction transaction = new LocalWorkspaceTransaction(workspace);
        try {
            transaction.execute(new WorkspacePropertiesTransaction(){

                @Override
                public void invoke(LocalWorkspaceProperties wp) {
                    toReturn.set(WorkingFolder.clone(wp.getWorkingFolders()));
                }
            });
        }
        finally {
            try {
                transaction.close();
            }
            catch (IOException e) {
                throw new VersionControlException(e);
            }
        }
        return toReturn.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setWorkingFolders(Workspace workspace, final WorkingFolder[] workingFolders) {
        LocalWorkspaceTransaction transaction = new LocalWorkspaceTransaction(workspace);
        try {
            transaction.execute(new WorkspacePropertiesTransaction(){

                @Override
                public void invoke(LocalWorkspaceProperties wp) {
                    wp.setWorkingFolders(workingFolders);
                }
            });
        }
        finally {
            try {
                transaction.close();
            }
            catch (IOException e) {
                throw new VersionControlException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void markReadOnlyBit(Workspace workspace, final boolean setReadOnly, final TaskMonitor taskMonitor) {
        Check.notNull(workspace, "workspace");
        Check.notNull(taskMonitor, "taskMonitor");
        LocalWorkspaceTransaction transaction = new LocalWorkspaceTransaction(workspace);
        try {
            transaction.execute(new AllTablesTransaction(){

                @Override
                public void invoke(LocalWorkspaceProperties wp, WorkspaceVersionTable lv, LocalPendingChangesTable pc) {
                    taskMonitor.begin("", lv.getLocalItemsCount());
                    for (WorkspaceLocalItem lvEntry : lv.queryByLocalItem(null, RecursionType.FULL, null)) {
                        taskMonitor.setCurrentWorkDescription(lvEntry.getLocalItem());
                        FileSystemAttributes attrs = FileSystemUtils.getInstance().getAttributes(lvEntry.getLocalItem());
                        if (attrs != null && attrs.exists() && !attrs.isSymbolicLink() && !attrs.isDirectory()) {
                            if (!attrs.isReadOnly() && setReadOnly) {
                                LocalPendingChange pcEntry = pc.getByLocalVersion(lvEntry);
                                if (null == pcEntry || !pcEntry.isEdit()) {
                                    attrs.setReadOnly(true);
                                    if (!FileSystemUtils.getInstance().setAttributes(lvEntry.getLocalItem(), attrs)) {
                                        throw new VersionControlException(MessageFormat.format(Messages.getString("LocalDataAccessLayer.ErrorSettingAttributesOnPathFormat"), lvEntry.getLocalItem()));
                                    }
                                }
                            } else if (attrs.isReadOnly() && !setReadOnly) {
                                attrs.setReadOnly(false);
                                if (!FileSystemUtils.getInstance().setAttributes(lvEntry.getLocalItem(), attrs)) {
                                    throw new VersionControlException(MessageFormat.format(Messages.getString("LocalDataAccessLayer.ErrorSettingAttributesOnPathFormat"), lvEntry.getLocalItem()));
                                }
                            }
                        }
                        taskMonitor.worked(1);
                    }
                }
            });
        }
        finally {
            try {
                transaction.close();
            }
            catch (IOException e) {
                throw new VersionControlException(e);
            }
            taskMonitor.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] getBaselineFolders(Workspace workspace) {
        final ArrayList toReturn = new ArrayList();
        LocalWorkspaceTransaction transaction = new LocalWorkspaceTransaction(workspace);
        try {
            transaction.execute(new WorkspacePropertiesTransaction(){

                @Override
                public void invoke(LocalWorkspaceProperties wp) {
                    for (BaselineFolder folder : wp.getBaselineFolders()) {
                        toReturn.add(folder.getPath());
                    }
                }
            });
        }
        finally {
            try {
                transaction.close();
            }
            catch (IOException e) {
                throw new VersionControlException(e);
            }
        }
        return toReturn.toArray(new String[toReturn.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BaselineRequest[] populateLocalVersionTable(final Workspace workspace, final WorkspaceItem[] workspaceItems, final TaskMonitor taskMonitor) {
        Check.notNull(taskMonitor, "taskMonitor");
        taskMonitor.begin("", workspaceItems.length);
        final ArrayList toReturn = new ArrayList();
        final boolean saveCheckinDate = workspace.getOptions().contains(WorkspaceOptions.SET_FILE_TO_CHECKIN);
        LocalWorkspaceTransaction transaction = new LocalWorkspaceTransaction(workspace);
        try {
            transaction.execute(new LocalVersionTransaction(){

                @Override
                public void invoke(WorkspaceVersionTable lv) {
                    for (WorkspaceItem workspaceItem : workspaceItems) {
                        WorkspaceLocalItem lvEntry = new WorkspaceLocalItem();
                        lvEntry.setServerItem(workspaceItem.getCommittedServerItem() != null ? workspaceItem.getCommittedServerItem() : workspaceItem.getServerItem());
                        lvEntry.setItemID(workspaceItem.getItemID());
                        lvEntry.setVersion(workspaceItem.getChangeSetID());
                        lvEntry.setEncoding(workspaceItem.getEncoding().getCodePage());
                        lvEntry.setCheckinDate(saveCheckinDate ? DotNETDate.toWindowsFileTimeUTC(workspaceItem.getCheckinDate()) : -1L);
                        lvEntry.setDeleted(workspaceItem.getRecursiveChangeType().contains(ChangeType.DELETE));
                        if (!lvEntry.isDeleted()) {
                            lvEntry.setLocalItem(workspaceItem.getLocalItem());
                        }
                        if (!lvEntry.isDirectory()) {
                            FileSystemAttributes attrs;
                            lvEntry.setLastModifiedTime(-1L);
                            lvEntry.setLength(workspaceItem.getContentLength());
                            lvEntry.setHashValue(workspaceItem.getContentHashValue());
                            lvEntry.setBaselineFileGUID(GUID.newGUID().getGUIDBytes());
                            ItemSet[] items = workspace.getClient().getItems(new ItemSpec[]{new ItemSpec(lvEntry.getServerItem(), RecursionType.NONE)}, (VersionSpec)LatestVersionSpec.INSTANCE, DeletedState.ANY, ItemType.ANY, GetItemsOptions.NONE, PropertyConstants.QUERY_ALL_PROPERTIES_FILTERS);
                            if (items != null && items.length > 0 && items[0] != null && items[0].getItems() != null && items[0].getItems().length > 0 && items[0].getItems()[0] != null && items[0].getItems()[0].getPropertyValues() != null) {
                                lvEntry.setPropertyValues(items[0].getItems()[0].getPropertyValues());
                            }
                            BaselineRequest baselineOp = new BaselineRequest();
                            baselineOp.setDownloadURL(workspaceItem.getDownloadURL());
                            baselineOp.setHashValue(workspaceItem.getContentHashValue());
                            baselineOp.setBaselineFileGUID(lvEntry.getBaselineFileGUID());
                            if (!lvEntry.isDeleted() && (attrs = FileSystemUtils.getInstance().getAttributes(lvEntry.getLocalItem())) != null && attrs.getSize() == lvEntry.getLength()) {
                                if (attrs.getModificationTime() != null) {
                                    lvEntry.setLastModifiedTime(attrs.getModificationTime().getWindowsFilesystemTime());
                                }
                                if (!workspaceItem.getChangeType().contains(ChangeType.EDIT)) {
                                    baselineOp.setSourceLocalItem(lvEntry.getLocalItem());
                                }
                            }
                            if (!workspaceItem.getChangeType().contains(ChangeType.ADD) && null != workspaceItem.getLocalItem()) {
                                baselineOp.setBaselinePartitionLocalItem(lvEntry.getLocalItem());
                                toReturn.add(baselineOp);
                            }
                        }
                        lv.add(lvEntry);
                        taskMonitor.worked(1);
                    }
                }
            });
        }
        finally {
            try {
                transaction.close();
            }
            catch (IOException e) {
                throw new VersionControlException(e);
            }
            taskMonitor.done();
        }
        return toReturn.toArray(new BaselineRequest[toReturn.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void processConversionBaselineRequests(final Workspace workspace, Iterable<BaselineRequest> requests) throws CoreCancelException {
        Check.notNull(workspace, "workspace");
        Check.notNull(requests, "requests");
        final AtomicReference baselineFolderCollection = new AtomicReference();
        LocalWorkspaceTransaction transaction = new LocalWorkspaceTransaction(workspace);
        try {
            transaction.execute(new WorkspacePropertiesTransaction(){

                @Override
                public void invoke(LocalWorkspaceProperties wp) {
                    baselineFolderCollection.set(new BaselineFolderCollection(workspace, wp.getBaselineFolders()));
                }
            });
        }
        finally {
            try {
                transaction.close();
            }
            catch (IOException e) {
                throw new VersionControlException(e);
            }
        }
        final AtomicReference<Iterable<BaselineRequest>> failedLocal = new AtomicReference<Iterable<BaselineRequest>>();
        ((BaselineFolderCollection)baselineFolderCollection.get()).processBaselineRequests(workspace, requests, true, failedLocal);
        boolean hasAnyFailed = false;
        if (failedLocal.get() != null) {
            for (BaselineRequest r : failedLocal.get()) {
                if (r == null) continue;
                hasAnyFailed = true;
                break;
            }
        }
        if (hasAnyFailed) {
            transaction = new LocalWorkspaceTransaction(workspace);
            try {
                transaction.execute(new LocalVersionTransaction(){

                    @Override
                    public void invoke(WorkspaceVersionTable lv) {
                        for (BaselineRequest request : (Iterable)failedLocal.get()) {
                            WorkspaceLocalItem lvEntry = lv.getByLocalItem(request.getSourceLocalItem());
                            if (null == lvEntry) continue;
                            lv.removeByLocalItem(request.getSourceLocalItem(), false);
                            lvEntry.setLastModifiedTime(-1L);
                            lv.add(lvEntry);
                        }
                    }
                });
            }
            finally {
                try {
                    transaction.close();
                }
                catch (IOException e) {
                    throw new VersionControlException(e);
                }
            }
        }
    }

    private static void handleMoveUncommittedUpdate(LocalWorkspaceProperties wp, WorkspaceVersionTable lv, MoveUncommittedLocalVersionUpdate update) {
        WorkspaceLocalItem lvExisting = lv.getByLocalItem(update.getSourceLocalItem());
        if (null != lvExisting && !ServerPath.equals(update.getSourceServerItem(), lvExisting.getServerItem())) {
            Check.isTrue(!lvExisting.isCommitted(), "!lvExisting.isCommitted()");
            lv.removeByServerItem(lvExisting.getServerItem(), lvExisting.isCommitted(), true);
            WorkspaceLocalItem lvEntry = lvExisting.clone();
            lvEntry.setServerItem(update.getSourceServerItem());
            lvEntry.setPendingReconcile(true);
            lv.add(lvEntry);
        }
    }

    private static boolean handleInitiallyDeletedLocalVersionUpdate(LocalWorkspaceProperties wp, WorkspaceVersionTable lv, LocalPendingChangesTable pc, InitiallyDeletedLocalVersionUpdate update, boolean setFileTimeToCheckin, Set<byte[]> displacedBaselines) {
        Check.isTrue(update.isFullyPopulated(setFileTimeToCheckin), "update.isFullyPopulated(setFileTimeToCheckin)");
        WorkspaceLocalItem lvExisting = lv.getByServerItem(update.getSourceServerItem(), update.isCommitted());
        boolean updateMissingBaseline = false;
        if (!update.isCommitted() && null == pc.getByTargetServerItem(update.getSourceServerItem())) {
            return updateMissingBaseline;
        }
        if (null != lvExisting && lvExisting.hasBaselineFileGUID()) {
            wp.deleteBaseline(lvExisting.getBaselineFileGUID());
        }
        WorkspaceLocalItem lvEntry = new WorkspaceLocalItem();
        lvEntry.setServerItem(update.getSourceServerItem());
        lvEntry.setVersion(update.getVersionLocal());
        lvEntry.setLocalItem(null);
        lvEntry.setItemID(update.getItemID());
        lvEntry.setHashValue(update.getBaselineHashValue());
        lvEntry.setEncoding(update.getEncoding());
        lvEntry.setBaselineFileGUID(update.getBaselineFileGUID());
        lvEntry.setPendingReconcile(true);
        lvEntry.setLength(update.getBaselineFileLength());
        lvEntry.setCheckinDate(update.getVersionLocalDate());
        lvEntry.setDeleted(true);
        if (-3 != lvEntry.getEncoding() && (0 != lvEntry.getVersion() || null != update.getDownloadURL())) {
            update.generateNewBaselineFileGuid();
            lvEntry.setBaselineFileGUID(update.getBaselineFileGUID());
            updateMissingBaseline = true;
        }
        lv.add(lvEntry);
        return updateMissingBaseline;
    }

    private static boolean handleClientLocalVersionUpdate(LocalWorkspaceProperties wp, WorkspaceVersionTable lv, LocalPendingChangesTable pc, ClientLocalVersionUpdate update, boolean setFileTimeToCheckin, Set<byte[]> displacedBaselines) {
        Check.isTrue(update.isFullyPopulated(setFileTimeToCheckin), "update.isFullyPopulated(setFileTimeToCheckin)");
        WorkspaceLocalItem lvExisting = lv.getByServerItem(update.getSourceServerItem(), update.isCommitted());
        boolean updateMissingBaseline = false;
        if (update.getTargetLocalItem() != null && update.getTargetLocalItem().length() > 0) {
            if (!update.isCommitted() && null == pc.getByTargetServerItem(update.getSourceServerItem())) {
                return updateMissingBaseline;
            }
            WorkspaceLocalItem lvLocalPathCollision = lv.getByLocalItem(update.getTargetLocalItem());
            if (null != lvLocalPathCollision && (null == lvExisting || lvLocalPathCollision != lvExisting)) {
                if (null != lvLocalPathCollision.getBaselineFileGUID()) {
                    displacedBaselines.add(lvLocalPathCollision.getBaselineFileGUID());
                }
                lv.removeByServerItem(lvLocalPathCollision.getServerItem(), lvLocalPathCollision.isCommitted(), false);
            }
            WorkspaceLocalItem lvEntry = new WorkspaceLocalItem();
            lvEntry.setServerItem(update.getSourceServerItem());
            lvEntry.setVersion(update.getVersionLocal());
            lvEntry.setLocalItem(update.getTargetLocalItem());
            lvEntry.setItemID(update.getItemID());
            lvEntry.setHashValue(update.getBaselineHashValue());
            lvEntry.setEncoding(update.getEncoding());
            lvEntry.setBaselineFileGUID(update.getBaselineFileGUID());
            lvEntry.setPendingReconcile(true);
            lvEntry.setLength(update.getBaselineFileLength());
            lvEntry.setCheckinDate(update.getVersionLocalDate());
            lvEntry.setPropertyValues(update.getPropertyValues());
            if (null != lvExisting && lvExisting.hasBaselineFileGUID()) {
                if (!lvEntry.hasBaselineFileGUID() && -1L != lvExisting.getLength() && lvExisting.getLength() == lvEntry.getLength() && lvExisting.hasHashValue() && lvEntry.hasHashValue() && Arrays.equals(lvExisting.getHashValue(), lvEntry.getHashValue())) {
                    lvEntry.setBaselineFileGUID(lvExisting.getBaselineFileGUID());
                } else if (!lvEntry.hasBaselineFileGUID() || !Arrays.equals(lvExisting.getBaselineFileGUID(), lvEntry.getBaselineFileGUID())) {
                    wp.deleteBaseline(lvExisting.getBaselineFileGUID());
                }
            }
            if (-3 != update.getEncoding() && update.getTargetLocalItem() != null && update.getTargetLocalItem().length() > 0) {
                FileSystemAttributes attrs;
                File file = new File(update.getTargetLocalItem());
                if (-1L != update.getLastModifiedDate()) {
                    lvEntry.setLastModifiedTime(update.getLastModifiedDate());
                } else if (file.exists() && (attrs = FileSystemUtils.getInstance().getAttributes(file)) != null && attrs.getModificationTime() != null) {
                    lvEntry.setLastModifiedTime(attrs.getModificationTime().getWindowsFilesystemTime());
                }
            }
            if (null != lvEntry.getBaselineFileGUID()) {
                displacedBaselines.remove(lvEntry.getBaselineFileGUID());
            } else if (-3 != lvEntry.getEncoding() && (0 != lvEntry.getVersion() || null != update.getDownloadURL())) {
                update.generateNewBaselineFileGUID();
                lvEntry.setBaselineFileGUID(update.getBaselineFileGUID());
                updateMissingBaseline = true;
            }
            lv.add(lvEntry);
        } else if (null != lvExisting) {
            if (update.getKeepLocalVersionEntryOnDelete()) {
                lv.markAsDeleted(lvExisting.getServerItem(), lvExisting.isCommitted(), true);
            } else {
                lv.removeByServerItem(lvExisting.getServerItem(), lvExisting.isCommitted(), true);
                if (null != lvExisting.getBaselineFileGUID()) {
                    wp.deleteBaseline(lvExisting.getBaselineFileGUID());
                }
            }
        }
        if (LocalWorkspaceTransaction.getCurrent().ownsWorkspaceLock()) {
            if (null != lvExisting && null != lvExisting.getLocalItem() && !LocalPath.equals(lvExisting.getLocalItem(), update.getTargetLocalItem())) {
                LocalWorkspaceTransaction.getCurrent().getWorkspace().getWorkspaceWatcher().markPathChanged(lvExisting.getLocalItem());
            }
            if (!(null == update.getTargetLocalItem() || null != lvExisting && null != lvExisting.getLocalItem() && LocalPath.equals(lvExisting.getLocalItem(), update.getTargetLocalItem()))) {
                LocalWorkspaceTransaction.getCurrent().getWorkspace().getWorkspaceWatcher().markPathChanged(update.getTargetLocalItem());
            }
        }
        return updateMissingBaseline;
    }

    private static boolean isDirectory(WorkspaceVersionTable lv, LocalPendingChangesTable pc, String targetServerItem) {
        if (ServerPath.isTeamProject(targetServerItem)) {
            return true;
        }
        Iterable<WorkspaceLocalItem> list = ParsedItemSpec.queryLocalVersionsByTargetServerItem(lv, pc, targetServerItem, RecursionType.NONE, null, ParsedItemSpecOptions.INCLUDE_DELETED);
        if (list.iterator().hasNext()) {
            WorkspaceLocalItem lvEntry = list.iterator().next();
            return lvEntry.isDirectory();
        }
        return false;
    }

    private static boolean isMove(String committedTargetServerItem, ItemType specifiedType, WorkspaceVersionTable lv) {
        if (specifiedType != ItemType.ANY) {
            return specifiedType == ItemType.FOLDER;
        }
        WorkspaceLocalItem lvEntry = null;
        boolean itemFound = true;
        lvEntry = lv.getByServerItem(committedTargetServerItem, true);
        if (lvEntry == null) {
            lvEntry = lv.getByServerItem(committedTargetServerItem, false);
        }
        if (lvEntry == null) {
            lvEntry = lv.getByServerItem(ServerPath.getParent(committedTargetServerItem), true);
            itemFound = false;
        }
        if (lvEntry != null && itemFound) {
            return lvEntry.isDirectory();
        }
        return lvEntry == null;
    }

    private static String calculateTargetServerItem(String sourceServerRoot, String sourceServerItem, String targetServerRoot, boolean targetIsFolder, boolean rootIsRenamed) {
        String sourceSuffix = "";
        String targetFolder = "";
        boolean sourceRenamedIntoTargetRoot = ServerPath.equals(sourceServerItem, targetServerRoot);
        if (targetIsFolder && rootIsRenamed && !ServerPath.equals(sourceServerRoot, targetServerRoot) && !sourceRenamedIntoTargetRoot) {
            targetFolder = ServerPath.getFileName(sourceServerRoot);
        }
        if (!ServerPath.equals(sourceServerItem, sourceServerRoot) && !sourceRenamedIntoTargetRoot) {
            sourceSuffix = ServerPath.makeRelative(sourceServerItem, sourceServerRoot);
        }
        String result = ServerPath.combine(ServerPath.combine(targetServerRoot, targetFolder), sourceSuffix);
        return result;
    }

    private static String tryGetServerItem(String item, LocalWorkspaceProperties wp, WorkspaceVersionTable lv, LocalPendingChangesTable pc) {
        if (ServerPath.isServerPath(item)) {
            return item;
        }
        WorkspaceLocalItem lvEntry = lv.getByLocalItem(item);
        if (lvEntry != null && lvEntry.isCommitted()) {
            return pc.getTargetServerItemForCommittedServerItem(lvEntry.getServerItem());
        }
        if (lvEntry != null) {
            return lvEntry.getServerItem();
        }
        return WorkingFolder.getServerItemForLocalItem(item, wp.getWorkingFolders());
    }

    private static Failure createPathTooLongFailure(String repositoryPath) {
        return new Failure(LocalDataAccessLayer.createPathTooLongErrorText(repositoryPath), "RepositoryPathTooLongException", SeverityType.ERROR, repositoryPath);
    }

    private static Failure createPendingDeleteConflictChangeFailure(String repositoryPath) {
        String format = Messages.getString("LocalDataAccessLayer.PendingDeleteConflictChangeFormat");
        return new Failure(MessageFormat.format(format, repositoryPath), "PendingDeleteConflictChangeException", SeverityType.ERROR, repositoryPath);
    }

    private static Failure createItemNotMappedFailure(String repositoryPath) {
        String format = Messages.getString("LocalDataAccessLayer.ItemNotMappedExceptionFormat");
        return new Failure(MessageFormat.format(format, repositoryPath), "ItemNotMappedException", SeverityType.ERROR, repositoryPath);
    }

    private static Failure createItemCloakedFailure(String repositoryPath) {
        String format = Messages.getString("LocalDataAccessLayer.ItemCloakedExceptionFormat");
        return new Failure(MessageFormat.format(format, repositoryPath), "ItemCloakedException", SeverityType.ERROR, repositoryPath);
    }

    private static Failure createPendingParentDeleteFailure(String repositoryPath) {
        return LocalDataAccessLayer.createPendingParentDeleteFailure(repositoryPath, repositoryPath);
    }

    private static Failure createPendingParentDeleteFailure(String path1, String path2) {
        String format = Messages.getString("LocalDataAccessLayer.PendingParentDeleteExceptionFormat");
        return new Failure(MessageFormat.format(format, path1), "PendingParentDeleteException", SeverityType.ERROR, path2);
    }

    private static RepositoryPathTooLongException createPathTooLongException(String repositoryPath) {
        return new RepositoryPathTooLongException(LocalDataAccessLayer.createPathTooLongErrorText(repositoryPath));
    }

    private static String createPathTooLongErrorText(String repositoryPath) {
        String format = Messages.getString("LocalDataAccessLayer.RepositoryPathTooLongFormat");
        return MessageFormat.format(format, repositoryPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void ProcessProjectRenames(final Workspace workspace, WebServiceLayer webServiceLayer, final List<KeyValuePair<String, String>> serverRenames, final int newProjectRevisionId) {
        log.info((Object)"Process project renames");
        if (serverRenames.isEmpty()) {
            log.warn((Object)"Expected to receive at least one rename instruction, but none have bee received");
            Check.isTrue(false, "Expected to receive at least one rename instruction");
            webServiceLayer.promotePendingWorkspaceMappings(workspace.getName(), workspace.getOwnerName(), newProjectRevisionId);
            return;
        }
        LocalWorkspaceTransaction transaction = new LocalWorkspaceTransaction(workspace);
        try {
            transaction.execute(new AllTablesTransaction(){

                /*
                 * WARNING - void declaration
                 */
                @Override
                public void invoke(LocalWorkspaceProperties wp, WorkspaceVersionTable lv, LocalPendingChangesTable pc) {
                    void var10_17;
                    TreeSet currentProjectNames = new TreeSet(String.CASE_INSENSITIVE_ORDER);
                    currentProjectNames.addAll(LocalDataAccessLayer.getCurrentProjectNames(wp, lv, pc));
                    TreeSet<Object> newProjectNames = new TreeSet<Object>(String.CASE_INSENSITIVE_ORDER);
                    newProjectNames.addAll(currentProjectNames);
                    for (KeyValuePair rename : serverRenames) {
                        newProjectNames.remove(rename.getKey());
                    }
                    for (KeyValuePair rename : serverRenames) {
                        newProjectNames.add(rename.getValue());
                    }
                    final TreeMap allRenames = new TreeMap(String.CASE_INSENSITIVE_ORDER);
                    TreeSet renamesFrom = new TreeSet(String.CASE_INSENSITIVE_ORDER);
                    for (KeyValuePair rename : serverRenames) {
                        renamesFrom.add(rename.getKey());
                    }
                    ArrayList<KeyValuePair<String, String>> injectedRenames = new ArrayList<KeyValuePair<String, String>>();
                    for (KeyValuePair keyValuePair : serverRenames) {
                        String renameTo = (String)keyValuePair.getValue();
                        if (!currentProjectNames.contains(renameTo) || renamesFrom.contains(renameTo)) continue;
                        String replacementName = LocalDataAccessLayer.createProjectName(renameTo.length(), newProjectNames);
                        injectedRenames.add(new KeyValuePair<String, String>(renameTo, replacementName));
                        newProjectNames.add(replacementName);
                    }
                    for (KeyValuePair keyValuePair : serverRenames) {
                        allRenames.put(keyValuePair.getKey(), keyValuePair.getValue());
                    }
                    for (KeyValuePair keyValuePair : injectedRenames) {
                        allRenames.put(keyValuePair.getKey(), keyValuePair.getValue());
                    }
                    ArrayList<WorkingFolder> newWorkingFolders = new ArrayList<WorkingFolder>();
                    WorkingFolder[] arr$ = wp.getWorkingFolders();
                    int len$ = arr$.length;
                    boolean bl = false;
                    while (var10_17 < len$) {
                        WorkingFolder wf = arr$[var10_17];
                        newWorkingFolders.add(new WorkingFolder(LocalDataAccessLayer.mapServerItem(wf.getServerItem(), allRenames), wf.getLocalItem(), wf.getType(), wf.getDepth()));
                        ++var10_17;
                    }
                    wp.setWorkingFolders(newWorkingFolders.toArray(new WorkingFolder[newWorkingFolders.size()]));
                    workspace.getWebServiceObject().setFolders((_WorkingFolder[])WrapperUtils.unwrap(_WorkingFolder.class, wp.getWorkingFolders()));
                    lv.renameTeamProjects(new ServerItemMapper(){

                        @Override
                        public String map(String itemPath) {
                            return LocalDataAccessLayer.mapServerItem(itemPath, allRenames);
                        }
                    });
                    pc.renameTeamProjects(new ServerItemMapper(){

                        @Override
                        public String map(String itemPath) {
                            return LocalDataAccessLayer.mapServerItem(itemPath, allRenames);
                        }
                    });
                    wp.setNewProjectRevisionId(newProjectRevisionId);
                }
            });
        }
        finally {
            try {
                transaction.close();
            }
            catch (IOException e) {
                throw new VersionControlException(e);
            }
        }
    }

    private static String createProjectName(int length, Set<String> extantNames) {
        if (length < 1) {
            throw new IllegalArgumentException(MessageFormat.format(Messages.getString("LocalDataAccessLayer.ValueOutOfRangeFormat"), "length"));
        }
        for (int i = 0; i < 1024; ++i) {
            StringBuilder sb = new StringBuilder(length);
            Random r = new Random();
            for (int j = 0; j < length; ++j) {
                sb.append(characterCorpus.charAt(r.nextInt(characterCorpus.length())));
            }
            String toReturn = sb.toString();
            if (extantNames.contains(toReturn)) continue;
            return toReturn;
        }
        throw new RuntimeException(MessageFormat.format(Messages.getString("LocalDataAccessLayer.UnableToFormReplacementTeamProjectNameFormat"), length));
    }

    private static String mapServerItem(String serverItem, Map<String, String> projectRenames) {
        String teamProjectName = ServerPath.getTeamProjectName(serverItem);
        if (StringUtil.isNullOrEmpty(teamProjectName) || !projectRenames.containsKey(teamProjectName)) {
            return serverItem;
        }
        String newTeamProjectName = projectRenames.get(teamProjectName);
        return "$/" + newTeamProjectName + serverItem.substring(2 + teamProjectName.length());
    }

    private static List<String> getCurrentProjectNames(LocalWorkspaceProperties wp, WorkspaceVersionTable lv, LocalPendingChangesTable pc) {
        ArrayList<String> projectNames = new ArrayList<String>();
        for (String currentServerItem : LocalDataAccessLayer.getCurrentServerItems(wp, lv, pc)) {
            String teamProjectName = ServerPath.getTeamProjectName(currentServerItem);
            if (StringUtil.isNullOrEmpty(teamProjectName)) continue;
            projectNames.add(teamProjectName);
        }
        return projectNames;
    }

    private static List<String> getCurrentServerItems(LocalWorkspaceProperties wp, WorkspaceVersionTable lv, LocalPendingChangesTable pc) {
        ArrayList<String> serverItems = new ArrayList<String>();
        for (WorkingFolder folder : wp.getWorkingFolders()) {
            serverItems.add(folder.getServerItem());
        }
        serverItems.addAll(lv.getKnownServerItems());
        serverItems.addAll(pc.getKnownServerItems());
        return serverItems;
    }
}

