/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace;

import com.microsoft.tfs.core.Messages;
import com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace.ApplicableRename;
import com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace.CommittedServerItemQuery;
import com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace.ExistenceCheckResult;
import com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace.LocalPendingChangesTable;
import com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace.LocalWorkspaceProperties;
import com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace.ParsedItemSpecOptions;
import com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace.QueryLocalVersionsByTargetServerItemEnumerable;
import com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace.RenameType;
import com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace.WorkspaceLocalItem;
import com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace.WorkspaceVersionTable;
import com.microsoft.tfs.core.clients.versioncontrol.path.ItemPath;
import com.microsoft.tfs.core.clients.versioncontrol.path.LocalPath;
import com.microsoft.tfs.core.clients.versioncontrol.path.ServerPath;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.Failure;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.ItemType;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.LocalPendingChange;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.RecursionType;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.SeverityType;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.WorkingFolder;
import com.microsoft.tfs.core.clients.versioncontrol.specs.ItemSpec;
import com.microsoft.tfs.jni.FileSystemAttributes;
import com.microsoft.tfs.jni.FileSystemUtils;
import com.microsoft.tfs.util.Check;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import java.util.concurrent.atomic.AtomicReference;

public class ParsedItemSpec {
    private final String targetItem;
    private final RecursionType recursion;
    private final String pattern;
    private final ParsedItemSpecOptions options;

    private ParsedItemSpec(String targetItem, String targetItemPattern, RecursionType recursion, ParsedItemSpecOptions options) {
        Check.notNullOrEmpty(targetItem, "targetItem");
        this.targetItem = targetItem;
        this.pattern = targetItemPattern;
        this.recursion = recursion;
        this.options = options;
    }

    public boolean isServerItem() {
        return ServerPath.isServerPath(this.targetItem);
    }

    private String getUnparsedItem() {
        if (this.isServerItem()) {
            return this.getPattern() == null ? this.getTargetItem() : ServerPath.combine(this.getTargetItem(), this.getPattern());
        }
        return this.getPattern() == null ? this.getTargetItem() : LocalPath.combine(this.getTargetItem(), this.getPattern());
    }

    public boolean match(String itemToMatch) {
        Check.notNullOrEmpty(itemToMatch, "itemToMatch");
        if (this.isServerItem()) {
            if (RecursionType.FULL == this.getRecursionType()) {
                return ServerPath.isChild(this.getTargetItem(), itemToMatch) && (null == this.getPattern() || ItemPath.matchesWildcardFile(ServerPath.getFileName(itemToMatch), this.getPattern()));
            }
            if (RecursionType.ONE_LEVEL == this.getRecursionType()) {
                return !(!ServerPath.equals(itemToMatch, this.getTargetItem()) && !ServerPath.isDirectChild(this.getTargetItem(), itemToMatch) || null != this.getPattern() && !ItemPath.matchesWildcardFile(ServerPath.getFileName(itemToMatch), this.getPattern()));
            }
            if (RecursionType.NONE == this.getRecursionType()) {
                if (null != this.getPattern()) {
                    return ServerPath.isDirectChild(this.getTargetItem(), itemToMatch) && ItemPath.matchesWildcardFile(ServerPath.getFileName(itemToMatch), this.getPattern());
                }
                return ServerPath.equals(itemToMatch, this.getTargetItem());
            }
        } else {
            if (RecursionType.FULL == this.getRecursionType()) {
                return LocalPath.isChild(this.getTargetItem(), itemToMatch) && (null == this.getPattern() || ItemPath.matchesWildcardFile(LocalPath.getFileName(itemToMatch), this.getPattern()));
            }
            if (RecursionType.ONE_LEVEL == this.getRecursionType()) {
                return !(!LocalPath.equals(itemToMatch, this.getTargetItem()) && !LocalPath.isDirectChild(this.getTargetItem(), itemToMatch) || null != this.getPattern() && !ItemPath.matchesWildcardFile(LocalPath.getFileName(itemToMatch), this.getPattern()));
            }
            if (RecursionType.NONE == this.getRecursionType()) {
                if (null != this.getPattern()) {
                    return LocalPath.isDirectChild(this.getTargetItem(), itemToMatch) && ItemPath.matchesWildcardFile(LocalPath.getFileName(itemToMatch), this.getPattern());
                }
                return LocalPath.equals(itemToMatch, this.getTargetItem());
            }
        }
        return false;
    }

    public Iterable<WorkspaceLocalItem> expandRootsFrom(WorkspaceVersionTable lv, LocalPendingChangesTable pc, List<Failure> failuresAccumulator) {
        HashMap<String, WorkspaceLocalItem> expandedRootItems = new HashMap<String, WorkspaceLocalItem>();
        for (WorkspaceLocalItem lvEntry : this.expandFrom(lv, pc, failuresAccumulator)) {
            String targetServerItem = pc.getTargetServerItemForLocalVersion(lvEntry);
            ArrayList<String> itemsToRemove = null;
            boolean parentExist = false;
            for (String expandedRoot : expandedRootItems.keySet()) {
                if (ServerPath.isChild(expandedRoot, targetServerItem)) {
                    parentExist = true;
                    break;
                }
                if (!ServerPath.isChild(targetServerItem, expandedRoot)) continue;
                if (itemsToRemove == null) {
                    itemsToRemove = new ArrayList<String>();
                }
                itemsToRemove.add(expandedRoot);
            }
            if (itemsToRemove != null) {
                for (String serverItem : itemsToRemove) {
                    expandedRootItems.remove(serverItem);
                }
            }
            if (parentExist) continue;
            expandedRootItems.put(targetServerItem, lvEntry);
        }
        return expandedRootItems.values();
    }

    public Iterable<WorkspaceLocalItem> expandFrom(WorkspaceVersionTable lv, LocalPendingChangesTable pc, List<Failure> failuresAccumulator) {
        AtomicReference<Failure> failureOut = new AtomicReference<Failure>();
        Iterable<WorkspaceLocalItem> toReturn = this.expandFrom(lv, pc, failureOut);
        Failure failure = failureOut.get();
        if (null != failure) {
            failuresAccumulator.add(failure);
        }
        return toReturn;
    }

    public Iterable<WorkspaceLocalItem> expandFrom(WorkspaceVersionTable lv, LocalPendingChangesTable pc, AtomicReference<Failure> failureOut) {
        failureOut.set(null);
        if (!this.isServerItem()) {
            return this.expandFromLocal(lv, failureOut);
        }
        return this.expandFromServer(lv, pc, failureOut);
    }

    private Iterable<WorkspaceLocalItem> expandFromLocal(WorkspaceVersionTable lv, AtomicReference<Failure> failureOut) {
        failureOut.set(null);
        WorkspaceLocalItem firstItem = null;
        boolean includeDeleted = this.options.contains(ParsedItemSpecOptions.INCLUDE_DELETED);
        Iterable<WorkspaceLocalItem> lvEntries = lv.queryByLocalItem(this.getTargetItem(), this.getRecursionType(), this.getPattern(), includeDeleted);
        Iterator<WorkspaceLocalItem> i$ = lvEntries.iterator();
        if (i$.hasNext()) {
            WorkspaceLocalItem lvEntry;
            firstItem = lvEntry = i$.next();
        }
        if (null == firstItem) {
            String format;
            if (RecursionType.FULL != this.getRecursionType()) {
                format = Messages.getString("ParsedItemSpec.WorkspaceItemNotFoundFormat");
                failureOut.set(new Failure(MessageFormat.format(format, this.getUnparsedItem()), "ItemNotFoundException", SeverityType.ERROR, this.getUnparsedItem()));
            } else {
                format = Messages.getString("ParsedItemSpec.WorkspaceItemNotFoundRecursiveFormat");
                failureOut.set(new Failure(MessageFormat.format(format, this.getUnparsedItem()), "ItemNotFoundException", SeverityType.ERROR, this.getUnparsedItem()));
            }
            return new ArrayList<WorkspaceLocalItem>(0);
        }
        return lv.queryByLocalItem(this.getTargetItem(), this.getRecursionType(), this.getPattern(), includeDeleted);
    }

    private Iterable<WorkspaceLocalItem> expandFromServer(WorkspaceVersionTable lv, LocalPendingChangesTable pc, AtomicReference<Failure> failureOut) {
        failureOut.set(null);
        WorkspaceLocalItem firstItem = null;
        Iterable<WorkspaceLocalItem> lvEntries = ParsedItemSpec.queryLocalVersionsByTargetServerItem(lv, pc, this.getTargetItem(), this.getRecursionType(), this.getPattern(), this.options);
        Iterator<WorkspaceLocalItem> i$ = lvEntries.iterator();
        if (i$.hasNext()) {
            WorkspaceLocalItem lvEntry;
            firstItem = lvEntry = i$.next();
        }
        if (null == firstItem) {
            String format;
            if (RecursionType.FULL != this.getRecursionType()) {
                format = Messages.getString("ParsedItemSpec.WorkspaceItemNotFoundFormat");
                failureOut.set(new Failure(MessageFormat.format(format, this.getUnparsedItem()), "ItemNotFoundException", SeverityType.ERROR, this.getUnparsedItem()));
            } else {
                format = Messages.getString("ParsedItemSpec.WorkspaceItemNotFoundRecursiveFormat");
                failureOut.set(new Failure(MessageFormat.format(format, this.getUnparsedItem()), "ItemNotFoundException", SeverityType.ERROR, this.getUnparsedItem()));
            }
            return new ArrayList<WorkspaceLocalItem>(0);
        }
        return ParsedItemSpec.queryLocalVersionsByTargetServerItem(lv, pc, this.getTargetItem(), this.getRecursionType(), this.getPattern(), this.options);
    }

    public static ParsedItemSpec fromItemSpec(ItemSpec itemSpec, LocalWorkspaceProperties wp, WorkspaceVersionTable lv, LocalPendingChangesTable pc, ParsedItemSpecOptions options, List<Failure> failuresAccumulator) {
        AtomicReference<Failure> failureOut = new AtomicReference<Failure>();
        ParsedItemSpec toReturn = ParsedItemSpec.fromItemSpec(itemSpec, wp, lv, pc, options, failureOut);
        Failure failure = failureOut.get();
        if (null != failure) {
            failuresAccumulator.add(failure);
        }
        return toReturn;
    }

    public static ParsedItemSpec fromItemSpec(ItemSpec itemSpec, LocalWorkspaceProperties wp, WorkspaceVersionTable lv, LocalPendingChangesTable pc, ParsedItemSpecOptions options, AtomicReference<Failure> failureOut) {
        Check.notNull(itemSpec, "itemSpec");
        if (ServerPath.isServerPath(itemSpec.getItem())) {
            return ParsedItemSpec.fromServerItemSpec(itemSpec, wp, lv, pc, options, failureOut, false);
        }
        return ParsedItemSpec.fromLocalItemSpec(itemSpec, wp, lv, pc, options, failureOut, false);
    }

    public static ParsedItemSpec fromLocalItemSpec(ItemSpec itemSpec, LocalWorkspaceProperties wp, WorkspaceVersionTable lv, LocalPendingChangesTable pc, ParsedItemSpecOptions options, List<Failure> failuresAccumulator) {
        AtomicReference<Failure> failure = new AtomicReference<Failure>();
        ParsedItemSpec toReturn = ParsedItemSpec.fromItemSpec(itemSpec, wp, lv, pc, options, failure);
        if (null != failure.get()) {
            failuresAccumulator.add(failure.get());
        }
        return toReturn;
    }

    public static ParsedItemSpec fromLocalItemSpec(ItemSpec itemSpec, LocalWorkspaceProperties wp, WorkspaceVersionTable lv, LocalPendingChangesTable pc, ParsedItemSpecOptions options, AtomicReference<Failure> failureOut, boolean checkLocalDiskIfNotFound) {
        Check.notNull(itemSpec, "itemSpec");
        ParsedItemSpec toReturn = null;
        RecursionType recursion = itemSpec.getRecursionType();
        failureOut.set(null);
        String pathPart = LocalPath.getParent(itemSpec.getItem());
        String patternPart = LocalPath.getFileName(itemSpec.getItem());
        if (0 == patternPart.length()) {
            patternPart = null;
        }
        if (null != patternPart && LocalPath.isWildcard(patternPart)) {
            ExistenceCheckResult checkResult;
            if (RecursionType.NONE == recursion) {
                recursion = RecursionType.ONE_LEVEL;
            }
            if ((checkResult = ParsedItemSpec.localItemExists(wp, lv, pc, pathPart, options)) == ExistenceCheckResult.DOES_NOT_EXIST && checkLocalDiskIfNotFound) {
                checkResult = ParsedItemSpec.localItemExistsOnDisk(pathPart);
            }
            if (ExistenceCheckResult.DOES_NOT_EXIST == checkResult) {
                String format = Messages.getString("ParsedItemSpec.WorkspaceItemNotFoundRecursiveFormat");
                failureOut.set(new Failure(MessageFormat.format(format, itemSpec.getItem()), "ItemNotFoundException", SeverityType.ERROR, itemSpec.getItem()));
            } else {
                toReturn = new ParsedItemSpec(pathPart, patternPart, recursion, options);
            }
        } else {
            ExistenceCheckResult checkResult = ParsedItemSpec.localItemExists(wp, lv, pc, itemSpec.getItem(), options);
            if (checkResult == ExistenceCheckResult.DOES_NOT_EXIST && checkLocalDiskIfNotFound) {
                checkResult = ParsedItemSpec.localItemExistsOnDisk(itemSpec.getItem());
            }
            if (ExistenceCheckResult.DOES_NOT_EXIST == checkResult) {
                if (RecursionType.NONE == recursion) {
                    String format = Messages.getString("ParsedItemSpec.WorkspaceItemNotFoundFormat");
                    failureOut.set(new Failure(MessageFormat.format(format, itemSpec.getItem()), "ItemNotFoundException", SeverityType.ERROR, itemSpec.getItem()));
                } else {
                    checkResult = ParsedItemSpec.localItemExists(wp, lv, pc, pathPart, options);
                    if (checkResult == ExistenceCheckResult.DOES_NOT_EXIST && checkLocalDiskIfNotFound) {
                        checkResult = ParsedItemSpec.localItemExistsOnDisk(pathPart);
                    }
                    if (ExistenceCheckResult.DOES_NOT_EXIST == checkResult) {
                        String format = Messages.getString("ParsedItemSpec.WorkspaceItemNotFoundRecursiveFormat");
                        failureOut.set(new Failure(MessageFormat.format(format, itemSpec.getItem()), "ItemNotFoundException", SeverityType.ERROR, itemSpec.getItem()));
                    } else {
                        toReturn = new ParsedItemSpec(pathPart, patternPart, recursion, options);
                    }
                }
            } else {
                toReturn = RecursionType.FULL == recursion && ExistenceCheckResult.IS_FILE == checkResult ? new ParsedItemSpec(pathPart, patternPart, recursion, options) : new ParsedItemSpec(itemSpec.getItem(), null, recursion, options);
            }
        }
        return toReturn;
    }

    public static ParsedItemSpec FromServerItemSpec(ItemSpec itemSpec, LocalWorkspaceProperties wp, WorkspaceVersionTable lv, LocalPendingChangesTable pc, ParsedItemSpecOptions options, List<Failure> failuresAccumulator) {
        AtomicReference<Failure> failureOut = new AtomicReference<Failure>();
        ParsedItemSpec toReturn = ParsedItemSpec.fromServerItemSpec(itemSpec, wp, lv, pc, options, failureOut, false);
        Failure failure = failureOut.get();
        if (null != failure) {
            failuresAccumulator.add(failure);
        }
        return toReturn;
    }

    public static ParsedItemSpec fromServerItemSpec(ItemSpec itemSpec, LocalWorkspaceProperties wp, WorkspaceVersionTable lv, LocalPendingChangesTable pc, ParsedItemSpecOptions options, AtomicReference<Failure> failureOut, boolean checkLocalDiskIfNotFound) {
        Check.notNull(itemSpec, "itemSpec");
        Check.notNull(pc, "pc");
        ParsedItemSpec toReturn = null;
        RecursionType recursion = itemSpec.getRecursionType();
        failureOut.set(null);
        String pathPart = ServerPath.getParent(itemSpec.getItem());
        String patternPart = ServerPath.getFileName(itemSpec.getItem());
        if (0 == patternPart.length()) {
            patternPart = null;
        }
        if (null != patternPart && ItemPath.isWildcard(patternPart)) {
            ExistenceCheckResult checkResult;
            if (RecursionType.NONE == recursion) {
                recursion = RecursionType.ONE_LEVEL;
            }
            if ((checkResult = ParsedItemSpec.targetServerItemExists(lv, pc, pathPart, options)) == ExistenceCheckResult.DOES_NOT_EXIST && checkLocalDiskIfNotFound) {
                checkResult = ParsedItemSpec.localItemExistsOnDisk(WorkingFolder.getLocalItemForServerItem(pathPart, wp.getWorkingFolders()));
            }
            if (ExistenceCheckResult.DOES_NOT_EXIST == checkResult) {
                String format = Messages.getString("ParsedItemSpec.WorkspaceItemNotFoundRecursiveFormat");
                failureOut.set(new Failure(MessageFormat.format(format, itemSpec.getItem()), "ItemNotFoundException", SeverityType.ERROR, itemSpec.getItem()));
            } else {
                toReturn = new ParsedItemSpec(pathPart, patternPart, recursion, options);
            }
        } else {
            ExistenceCheckResult checkResult = ParsedItemSpec.targetServerItemExists(lv, pc, itemSpec.getItem(), options);
            if (checkResult == ExistenceCheckResult.DOES_NOT_EXIST && checkLocalDiskIfNotFound) {
                checkResult = ParsedItemSpec.localItemExistsOnDisk(WorkingFolder.getLocalItemForServerItem(itemSpec.getItem(), wp.getWorkingFolders()));
            }
            if (ExistenceCheckResult.DOES_NOT_EXIST == checkResult) {
                if (RecursionType.NONE == recursion) {
                    String format = Messages.getString("ParsedItemSpec.WorkspaceItemNotFoundFormat");
                    failureOut.set(new Failure(MessageFormat.format(format, itemSpec.getItem()), "ItemNotFoundException", SeverityType.ERROR, itemSpec.getItem()));
                } else {
                    checkResult = ParsedItemSpec.targetServerItemExists(lv, pc, pathPart, options);
                    if (checkResult == ExistenceCheckResult.DOES_NOT_EXIST && checkLocalDiskIfNotFound) {
                        checkResult = ParsedItemSpec.localItemExistsOnDisk(WorkingFolder.getLocalItemForServerItem(pathPart, wp.getWorkingFolders()));
                    }
                    if (ExistenceCheckResult.DOES_NOT_EXIST == checkResult) {
                        String format = Messages.getString("ParsedItemSpec.WorkspaceItemNotFoundRecursiveFormat");
                        failureOut.set(new Failure(MessageFormat.format(format, itemSpec.getItem()), "ItemNotFoundException", SeverityType.ERROR, itemSpec.getItem()));
                    } else {
                        toReturn = new ParsedItemSpec(pathPart, patternPart, recursion, options);
                    }
                }
            } else {
                toReturn = RecursionType.FULL == recursion && ExistenceCheckResult.IS_FILE == checkResult ? new ParsedItemSpec(pathPart, patternPart, recursion, options) : new ParsedItemSpec(itemSpec.getItem(), null, recursion, options);
            }
        }
        return toReturn;
    }

    public RecursionType getRecursionType() {
        return this.recursion;
    }

    public String getTargetItem() {
        return this.targetItem;
    }

    public String getPattern() {
        return this.pattern;
    }

    public static Iterable<WorkspaceLocalItem> queryLocalVersionsByTargetServerItem(WorkspaceVersionTable lv, LocalPendingChangesTable pc, String targetServerItem, RecursionType recursion, String pattern, ParsedItemSpecOptions options) {
        Check.notNull(lv, "lv");
        Check.notNull(pc, "pc");
        Check.notNull(targetServerItem, "targetServerItem");
        boolean includeDeleted = options.contains(ParsedItemSpecOptions.INCLUDE_DELETED);
        if (ServerPath.isRootFolder(targetServerItem) || !pc.hasRenames()) {
            return lv.queryByServerItem(targetServerItem, recursion, pattern, includeDeleted);
        }
        String committedServerItem = pc.getCommittedServerItemForTargetServerItem(targetServerItem);
        ArrayList<ApplicableRename> additiveRenames = new ArrayList<ApplicableRename>();
        if (!ServerPath.equals(targetServerItem, committedServerItem)) {
            if (ServerPath.equals(targetServerItem, pc.getTargetServerItemForCommittedServerItem(committedServerItem))) {
                additiveRenames.add(new ApplicableRename(committedServerItem, RenameType.ADDITIVE, recursion));
            }
            additiveRenames.add(new ApplicableRename(targetServerItem, RenameType.ADDITIVE, recursion));
        } else if (ServerPath.equals(targetServerItem, pc.getTargetServerItemForCommittedServerItem(targetServerItem))) {
            additiveRenames.add(new ApplicableRename(committedServerItem, RenameType.ADDITIVE, recursion));
        }
        for (LocalPendingChange pendingChange : pc.queryByTargetServerItem(targetServerItem, recursion, null)) {
            if (!pendingChange.isRename()) continue;
            additiveRenames.add(new ApplicableRename(pendingChange.getCommittedServerItem(), RenameType.ADDITIVE, RecursionType.ONE_LEVEL == recursion ? RecursionType.NONE : recursion));
        }
        ArrayList<ApplicableRename> applicableRenames = new ArrayList<ApplicableRename>();
        for (ApplicableRename additiveRename : additiveRenames) {
            for (LocalPendingChange pendingChange : pc.queryByCommittedServerItem(additiveRename.getCommittedServerItem(), recursion, null)) {
                if (ServerPath.isChild(targetServerItem, pendingChange.getTargetServerItem())) continue;
                applicableRenames.add(new ApplicableRename(pendingChange.getCommittedServerItem(), RenameType.SUBTRACTIVE, RecursionType.FULL));
            }
        }
        for (ApplicableRename additiveRename : additiveRenames) {
            applicableRenames.add(additiveRename);
        }
        Collections.sort(applicableRenames, Collections.reverseOrder());
        RenameType previousRenameType = RenameType.SUBTRACTIVE;
        String previousServerItem = null;
        for (int i = applicableRenames.size() - 1; i >= 0; --i) {
            ApplicableRename applicableRename = (ApplicableRename)applicableRenames.get(i);
            if (null != previousServerItem && ServerPath.isChild(previousServerItem, applicableRename.getCommittedServerItem()) && (previousRenameType == applicableRename.getRenameType() || ServerPath.equals(applicableRename.getCommittedServerItem(), previousServerItem))) {
                applicableRenames.remove(i);
                continue;
            }
            previousRenameType = applicableRename.getRenameType();
            previousServerItem = applicableRename.getCommittedServerItem();
        }
        Collections.sort(applicableRenames, Collections.reverseOrder());
        ArrayList<CommittedServerItemQuery> queries = new ArrayList<CommittedServerItemQuery>();
        Stack<CommittedServerItemQuery> queryStack = new Stack<CommittedServerItemQuery>();
        CommittedServerItemQuery currentQuery = null;
        for (ApplicableRename applicableRename : applicableRenames) {
            while (null != currentQuery && !ServerPath.isChild(currentQuery.getCommittedServerItem(), applicableRename.getCommittedServerItem())) {
                queries.add(currentQuery);
                if (queryStack.size() > 0) {
                    currentQuery = (CommittedServerItemQuery)queryStack.pop();
                    continue;
                }
                currentQuery = null;
            }
            if (RenameType.ADDITIVE == applicableRename.getRenameType()) {
                if (null != currentQuery) {
                    queryStack.push(currentQuery);
                }
                currentQuery = new CommittedServerItemQuery(applicableRename.getCommittedServerItem(), applicableRename.getRecursionType());
                continue;
            }
            if (RenameType.SUBTRACTIVE != applicableRename.getRenameType() || null == currentQuery) continue;
            currentQuery.getExcludedItems().add(applicableRename.getCommittedServerItem());
        }
        while (queryStack.size() > 0) {
            queries.add((CommittedServerItemQuery)queryStack.pop());
        }
        if (null != currentQuery) {
            queries.add(currentQuery);
        }
        return new QueryLocalVersionsByTargetServerItemEnumerable(lv, targetServerItem, recursion, pattern, includeDeleted, queries);
    }

    private static ExistenceCheckResult localItemExistsOnDisk(String localItem) {
        if (localItem == null || localItem.length() == 0) {
            return ExistenceCheckResult.DOES_NOT_EXIST;
        }
        FileSystemAttributes attrs = FileSystemUtils.getInstance().getAttributes(localItem);
        if (!attrs.exists()) {
            return ExistenceCheckResult.DOES_NOT_EXIST;
        }
        if (attrs.isDirectory()) {
            return ExistenceCheckResult.IS_FOLDER;
        }
        return ExistenceCheckResult.IS_FILE;
    }

    private static ExistenceCheckResult localItemExists(LocalWorkspaceProperties wp, WorkspaceVersionTable lv, LocalPendingChangesTable pc, String localItem, ParsedItemSpecOptions options) {
        Iterator<WorkspaceLocalItem> i$;
        String pendingServerItem;
        Check.notNull(lv, "lv");
        Check.notNull(localItem, "localItem");
        boolean includeDeleted = options.contains(ParsedItemSpecOptions.INCLUDE_DELETED);
        if (null != pc && null != (pendingServerItem = WorkingFolder.getServerItemForLocalItem(localItem, wp.getWorkingFolders()))) {
            LocalPendingChange pcEntry = pc.getByTargetServerItem(pendingServerItem);
            if (null != pcEntry) {
                if (ItemType.FILE == pcEntry.getItemType()) {
                    return ExistenceCheckResult.IS_FILE;
                }
                return ExistenceCheckResult.IS_FOLDER;
            }
            if (pc.hasSubItemOfTargetServerItem(pendingServerItem)) {
                return ExistenceCheckResult.IS_FOLDER;
            }
        }
        if ((i$ = lv.queryByLocalItem(localItem, RecursionType.FULL, null, includeDeleted).iterator()).hasNext()) {
            WorkspaceLocalItem lvEntry = i$.next();
            if (LocalPath.equals(lvEntry.getLocalItem(), localItem) && ItemType.FILE == lvEntry.getItemType()) {
                return ExistenceCheckResult.IS_FILE;
            }
            return ExistenceCheckResult.IS_FOLDER;
        }
        return ExistenceCheckResult.DOES_NOT_EXIST;
    }

    private static ExistenceCheckResult targetServerItemExists(WorkspaceVersionTable lv, LocalPendingChangesTable pc, String targetServerItem, ParsedItemSpecOptions options) {
        Check.notNull(lv, "lv");
        Check.notNull(pc, "pc");
        Check.notNull(targetServerItem, "targetServerItem");
        if (ServerPath.isRootFolder(targetServerItem)) {
            return ExistenceCheckResult.IS_FOLDER;
        }
        LocalPendingChange pcEntry = pc.getByTargetServerItem(targetServerItem);
        if (null != pcEntry) {
            if (ItemType.FILE == pcEntry.getItemType()) {
                return ExistenceCheckResult.IS_FILE;
            }
            return ExistenceCheckResult.IS_FOLDER;
        }
        if (pc.hasSubItemOfTargetServerItem(targetServerItem)) {
            return ExistenceCheckResult.IS_FOLDER;
        }
        Iterator<WorkspaceLocalItem> i$ = ParsedItemSpec.queryLocalVersionsByTargetServerItem(lv, pc, targetServerItem, RecursionType.FULL, null, options).iterator();
        if (i$.hasNext()) {
            WorkspaceLocalItem lvEntry = i$.next();
            if (ServerPath.equals(pc.getTargetServerItemForLocalVersion(lvEntry), targetServerItem) && ItemType.FILE == lvEntry.getItemType()) {
                return ExistenceCheckResult.IS_FILE;
            }
            return ExistenceCheckResult.IS_FOLDER;
        }
        return ExistenceCheckResult.DOES_NOT_EXIST;
    }

    public static boolean matchItemType(WorkspaceLocalItem localItem, ItemType itemType) {
        if (itemType == ItemType.ANY) {
            return true;
        }
        if (itemType == ItemType.FILE) {
            return !localItem.isDirectory();
        }
        if (itemType == ItemType.FOLDER) {
            return localItem.isDirectory();
        }
        throw new IllegalArgumentException("Unknown itemType: " + itemType.toString());
    }
}

