/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.versioncontrol.soapextensions;

import com.microsoft.tfs.core.Messages;
import com.microsoft.tfs.core.clients.versioncontrol.path.LocalPath;
import com.microsoft.tfs.core.clients.versioncontrol.path.ServerPath;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.ChangeType;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.RequestType;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.SeverityType;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.Warning;
import com.microsoft.tfs.core.clients.versioncontrol.specs.WorkspaceSpec;
import com.microsoft.tfs.core.internal.wrappers.WebServiceObjectWrapper;
import com.microsoft.tfs.core.internal.wrappers.WrapperUtils;
import java.text.MessageFormat;
import ms.tfs.versioncontrol.clientservices._03._Failure;
import ms.tfs.versioncontrol.clientservices._03._Warning;
import ms.tfs.versioncontrol.clientservices._03._WarningType;

public class Failure
extends WebServiceObjectWrapper {
    private static final String NEWLINE = System.getProperty("line.separator");
    private static final String INDENT = "   ";

    public Failure(_Failure failure) {
        super(failure);
    }

    public Failure(String message, String code, SeverityType severity, String item) {
        this(new _Failure(null, code, severity.getWebServiceObject(), null, null, null, null, null, 0, null, null, null, message));
        if (item != null && ServerPath.isServerPath(item)) {
            this.setServerItem(item);
        } else {
            this.setLocalItem(item);
        }
    }

    public _Failure getWebServiceObject() {
        return (_Failure)this.webServiceObject;
    }

    public SeverityType getSeverity() {
        return SeverityType.fromWebServiceObject(this.getWebServiceObject().getSev());
    }

    public String getCode() {
        return this.getWebServiceObject().getCode();
    }

    public String getServerItem() {
        return this.getWebServiceObject().getItem();
    }

    public void setServerItem(String item) {
        this.getWebServiceObject().setItem(item);
    }

    public RequestType getRequestType() {
        return RequestType.fromWebServiceObject(this.getWebServiceObject().getReq());
    }

    public void setRequestType(RequestType type) {
        this.getWebServiceObject().setReq(type != null ? type.getWebServiceObject() : null);
    }

    public String getLocalItem() {
        return LocalPath.tfsToNative(this.getWebServiceObject().getLocal());
    }

    public void setLocalItem(String item) {
        this.getWebServiceObject().setLocal(LocalPath.nativeToTFS(item));
    }

    public String getMessage() {
        return this.getWebServiceObject().getMessage();
    }

    public Warning[] getWarnings() {
        return (Warning[])WrapperUtils.wrap(Warning.class, this.getWebServiceObject().getWarnings());
    }

    public String getFormattedMessage() {
        _Failure failure = this.getWebServiceObject();
        if (failure.getWarnings() == null || failure.getWarnings().length == 0) {
            return failure.getMessage();
        }
        StringBuffer message = new StringBuffer(failure.getItem() + ":" + NEWLINE);
        boolean firstWarning = true;
        _Warning[] warnings = failure.getWarnings();
        for (int i = 0; i < warnings.length; ++i) {
            if (firstWarning) {
                firstWarning = false;
            } else {
                message.append(NEWLINE);
            }
            if (_WarningType.NamespacePendingChangeWarning.equals(warnings[i].getWrn())) {
                message.append(INDENT);
                message.append(MessageFormat.format(Messages.getString("Failure.ItemOpenedForChangeInWorkspaceFormat"), warnings[i].getCpp(), new ChangeType(warnings[i].getChg(), warnings[i].getChgEx()).toUIString(true), this.getFormattedWorkspaceName(warnings[i])));
                continue;
            }
            if (_WarningType.StaleVersionWarning.equals(warnings[i].getWrn())) {
                message.append(INDENT);
                message.append(Messages.getString("Failure.NewerVersionExistsInSourceControl"));
                continue;
            }
            message.append(INDENT);
            message.append(MessageFormat.format(Messages.getString("Failure.OpenedForChangeInWorkspaceFormat"), new ChangeType(warnings[i].getChg(), warnings[i].getChgEx()).toUIString(true), this.getFormattedWorkspaceName(warnings[i])));
        }
        return message.toString();
    }

    private String getFormattedWorkspaceName(_Warning warning) {
        return WorkspaceSpec.parse(warning.getWs(), warning.getUserdisp()).toString();
    }

    @Override
    public String toString() {
        return this.getFormattedMessage();
    }
}

