/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.versioncontrol.soapextensions;

import com.microsoft.tfs.core.Messages;
import com.microsoft.tfs.core.clients.versioncontrol.PropertyUtils;
import com.microsoft.tfs.core.clients.versioncontrol.VersionControlClient;
import com.microsoft.tfs.core.clients.versioncontrol.exceptions.DestroyedContentUnavailableException;
import com.microsoft.tfs.core.clients.versioncontrol.exceptions.ItemNotFoundException;
import com.microsoft.tfs.core.clients.versioncontrol.exceptions.VersionControlException;
import com.microsoft.tfs.core.clients.versioncontrol.path.ServerPath;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.ItemType;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.PropertyValue;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.internal.DownloadURL;
import com.microsoft.tfs.core.clients.versioncontrol.specs.DownloadSpec;
import com.microsoft.tfs.core.internal.wrappers.WebServiceObjectWrapper;
import com.microsoft.tfs.core.internal.wrappers.WrapperUtils;
import com.microsoft.tfs.core.util.FileEncoding;
import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.temp.TempStorageService;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Calendar;
import ms.tfs.versioncontrol.clientservices._03._Item;
import ms.tfs.versioncontrol.clientservices._03._PropertyValue;

public class Item
extends WebServiceObjectWrapper
implements Comparable<Item> {
    private DownloadURL downloadURLObject;

    public Item() {
        this(new _Item());
    }

    public Item(ItemType itemType, String serverItem, int encoding) {
        this(new _Item(0, null, 0, encoding, itemType.getWebServiceObject(), 0, serverItem, null, null, null, 0L, null, false, null, null));
    }

    public Item(_Item item) {
        super(item);
        this.setDownloadURL(item.getDurl());
    }

    public _Item getWebServiceObject() {
        return (_Item)this.webServiceObject;
    }

    @Override
    public int compareTo(Item other) {
        int res = ServerPath.compareTopDown(this.getServerItem(), other.getServerItem());
        if (res != 0) {
            return res;
        }
        if (this.getDeletionID() < other.getDeletionID()) {
            return -1;
        }
        if (this.getDeletionID() > other.getDeletionID()) {
            return 1;
        }
        return 0;
    }

    public int getChangeSetID() {
        return this.getWebServiceObject().getCs();
    }

    public void setChangeSetID(int cs) {
        this.getWebServiceObject().setCs(cs);
    }

    public Calendar getCheckinDate() {
        return (Calendar)this.getWebServiceObject().getDate().clone();
    }

    public void setCheckinDate(Calendar date) {
        this.getWebServiceObject().setDate((Calendar)date.clone());
    }

    public int getDeletionID() {
        return this.getWebServiceObject().getDid();
    }

    public void setDeletionID(int did) {
        this.getWebServiceObject().setDid(did);
    }

    public FileEncoding getEncoding() {
        return new FileEncoding(this.getWebServiceObject().getEnc());
    }

    public void setEncoding(FileEncoding encoding) {
        this.getWebServiceObject().setEnc(encoding.getCodePage());
    }

    public byte[] getContentHashValue() {
        return this.getWebServiceObject().getHash();
    }

    public void setContentHashValue(byte[] hash) {
        this.getWebServiceObject().setHash(hash);
    }

    public String getServerItem() {
        return this.getWebServiceObject().getItem();
    }

    public void setServerItem(String item) {
        this.getWebServiceObject().setItem(item);
    }

    public int getItemID() {
        return this.getWebServiceObject().getItemid();
    }

    public void setItemID(int itemid) {
        this.getWebServiceObject().setItemid(itemid);
    }

    public long getContentLength() {
        return this.getWebServiceObject().getLen();
    }

    public void setContentLength(long len) {
        this.getWebServiceObject().setLen(len);
    }

    public ItemType getItemType() {
        return ItemType.fromWebServiceObject(this.getWebServiceObject().getType());
    }

    public void setItemType(ItemType type) {
        this.getWebServiceObject().setType(type.getWebServiceObject());
    }

    public void setDownloadURL(String url) {
        this.getWebServiceObject().setDurl(url);
        this.downloadURLObject = new DownloadURL(url);
    }

    public String getDownloadURL() {
        return this.getWebServiceObject().getDurl();
    }

    public String getTimeZone() {
        return this.getWebServiceObject().getTz();
    }

    public String getTimeZoneO() {
        return this.getWebServiceObject().getTzo();
    }

    public PropertyValue[] getPropertyValues() {
        return PropertyUtils.selectUnique((PropertyValue[])WrapperUtils.wrap(PropertyValue.class, this.getWebServiceObject().getPropertyValues()));
    }

    public void setPropertyValues(PropertyValue[] properties) {
        this.getWebServiceObject().setPropertyValues((_PropertyValue[])WrapperUtils.unwrap(_PropertyValue.class, properties));
    }

    public boolean isBranch() {
        return this.getWebServiceObject().isIsbranch();
    }

    public synchronized File downloadFileToTempLocation(VersionControlClient client, String fileName) {
        Check.notNullOrEmpty(fileName, "fileName");
        Check.notNull(client, "client");
        try {
            File file = new File(TempStorageService.getInstance().createTempDirectory(), fileName);
            this.downloadFile(client, file.getAbsolutePath());
            return file;
        }
        catch (IOException e) {
            throw new VersionControlException(e);
        }
    }

    public synchronized void downloadFile(VersionControlClient client, String filePath) {
        Check.notNull(filePath, "filePath");
        Check.notNull(client, "client");
        this.prepareForDownload(client);
        client.downloadFile(new DownloadSpec(this.getDownloadURL()), new File(filePath), true);
    }

    private void prepareForDownload(VersionControlClient client) {
        Check.notNull(client, "client");
        if (this.getItemType() != ItemType.FILE) {
            throw new VersionControlException(MessageFormat.format(Messages.getString("PendingChange.PathIsNotAFileFormat"), this.getServerItem()));
        }
        if (this.getChangeSetID() == -1) {
            throw new VersionControlException(MessageFormat.format(Messages.getString("Item.ItemChangesetIndeterminateFormat"), this.getServerItem()));
        }
        if (this.getDownloadURL() == null || this.getDownloadURL().length() == 0) {
            Item item = client.getItem(this.getItemID(), this.getChangeSetID(), true);
            if (item == null) {
                throw new ItemNotFoundException(MessageFormat.format(Messages.getString("Item.ItemNotFoundExceptionFormat"), this.getServerItem()));
            }
            if (null == item.getDownloadURL()) {
                throw new VersionControlException(MessageFormat.format(Messages.getString("Item.ItemCannotBeDownloadReadPermissionRequiredFormat"), item.getServerItem()));
            }
            this.cloneDownloadURLFromItem(item);
        }
        if (this.isContentDestroyed(client)) {
            throw new DestroyedContentUnavailableException(MessageFormat.format(Messages.getString("Item.DestroyedContentUnavailableExceptionFormat"), this.getChangeSetID(), this.getServerItem()));
        }
    }

    public synchronized boolean isContentDestroyed(VersionControlClient client) {
        Check.notNull(client, "client");
        if (this.getDownloadURL() == null || this.getDownloadURL().length() == 0) {
            Item item = client.getItem(this.getItemID(), this.getChangeSetID(), true);
            this.cloneDownloadURLFromItem(item);
        }
        return this.downloadURLObject.isContentDestroyed();
    }

    private void cloneDownloadURLFromItem(Item item) {
        Check.notNull(item, "item");
        this.getWebServiceObject().setDurl(item.getDownloadURL());
        this.downloadURLObject = item.downloadURLObject;
    }
}

