/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.versioncontrol.soapextensions;

import com.microsoft.tfs.core.Messages;
import com.microsoft.tfs.core.clients.versioncontrol.ProcessType;
import com.microsoft.tfs.core.clients.versioncontrol.PropertyConstants;
import com.microsoft.tfs.core.clients.versioncontrol.PropertyUtils;
import com.microsoft.tfs.core.clients.versioncontrol.VersionControlClient;
import com.microsoft.tfs.core.clients.versioncontrol.WorkspaceLocation;
import com.microsoft.tfs.core.clients.versioncontrol.WorkspaceOptions;
import com.microsoft.tfs.core.clients.versioncontrol.engines.internal.CheckinEngine;
import com.microsoft.tfs.core.clients.versioncontrol.events.EventSource;
import com.microsoft.tfs.core.clients.versioncontrol.events.NonFatalErrorEvent;
import com.microsoft.tfs.core.clients.versioncontrol.exceptions.VersionControlException;
import com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace.LocalWorkspaceProperties;
import com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace.LocalWorkspaceTransaction;
import com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace.WorkspaceLocalItem;
import com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace.WorkspacePropertiesLocalVersionTransaction;
import com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace.WorkspaceVersionTable;
import com.microsoft.tfs.core.clients.versioncontrol.path.LocalPath;
import com.microsoft.tfs.core.clients.versioncontrol.path.ServerPath;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.ChangeType;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.ConflictType;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.GetOperation;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.Item;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.ItemType;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.LockLevel;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.MergeSource;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.PendingSet;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.PropertyValue;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.RecursionType;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.Workspace;
import com.microsoft.tfs.core.clients.versioncontrol.specs.DownloadSpec;
import com.microsoft.tfs.core.clients.versioncontrol.specs.ItemSpec;
import com.microsoft.tfs.core.clients.versioncontrol.specs.version.ChangesetVersionSpec;
import com.microsoft.tfs.core.clients.versioncontrol.specs.version.VersionSpec;
import com.microsoft.tfs.core.exceptions.internal.CoreCancelException;
import com.microsoft.tfs.core.internal.wrappers.WebServiceObjectWrapper;
import com.microsoft.tfs.core.internal.wrappers.WrapperUtils;
import com.microsoft.tfs.jni.FileSystemAttributes;
import com.microsoft.tfs.jni.FileSystemUtils;
import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.datetime.DotNETDate;
import com.microsoft.tfs.util.tasks.CanceledException;
import com.microsoft.tfs.util.tasks.TaskMonitorService;
import com.microsoft.tfs.util.temp.TempStorageService;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.concurrent.atomic.AtomicBoolean;
import ms.tfs.versioncontrol.clientservices._03._ChangeType;
import ms.tfs.versioncontrol.clientservices._03._MergeSource;
import ms.tfs.versioncontrol.clientservices._03._PendingChange;
import ms.tfs.versioncontrol.clientservices._03._PropertyValue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class PendingChange
extends WebServiceObjectWrapper
implements Comparable<PendingChange>,
Cloneable {
    private static final Log log = LogFactory.getLog(PendingChange.class);
    private boolean undone;
    private boolean localItemDelete;
    private boolean isCandidate;
    private String pendingSetName;
    private String pendingSetOwner;
    private String pendingSetOwnerDisplay;
    private boolean inShelveset;
    private volatile boolean hashCodeValid = false;
    private volatile int hashCode;

    public PendingChange(_PendingChange change) {
        super(change);
    }

    public PendingChange(PendingChange change) {
        this(PendingChange.cloneWebServiceObject(change.getWebServiceObject()));
    }

    private static _PendingChange cloneWebServiceObject(_PendingChange change) {
        Check.notNull(change, "change");
        _MergeSource[] mergeSources = null;
        if (change.getMergeSources() != null) {
            mergeSources = new _MergeSource[change.getMergeSources().length];
            for (int i = 0; i < mergeSources.length; ++i) {
                mergeSources[i] = new _MergeSource(change.getMergeSources()[i].getS(), change.getMergeSources()[i].getVf(), change.getMergeSources()[i].getVt(), change.getMergeSources()[i].isR());
            }
        }
        return new _PendingChange(change.getChgEx(), change.getChg() != null ? (_ChangeType)change.getChg().clone() : null, change.getDate() != null ? (Calendar)change.getDate().clone() : null, change.getDid(), change.getType(), change.getEnc(), change.getItemid(), change.getLocal(), change.getLock(), change.getItem(), change.getSrclocal(), change.getSrcitem(), change.getSvrfm(), change.getSdi(), change.getVer(), change.getHash() != null ? (byte[])change.getHash().clone() : null, change.getLen(), change.getUhash() != null ? (byte[])change.getUhash().clone() : null, change.getPcid(), change.getDurl(), change.getShelvedurl(), change.getCt(), mergeSources, change.getPropertyValues() != null ? (_PropertyValue[])change.getPropertyValues().clone() : null);
    }

    public PendingChange(Workspace workspace, GetOperation operation, ProcessType processType) {
        super(new _PendingChange(operation.getChangeType().getWebServiceObjectExtendedFlags(), operation.getChangeType().getWebServiceObject(), Calendar.getInstance(), operation.getDeletionID(), operation.getItemType().getWebServiceObject(), -2, operation.getItemID(), LocalPath.nativeToTFS(operation.getTargetLocalItem()), operation.getLockLevel().getWebServiceObject(), operation.getTargetServerItem(), LocalPath.nativeToTFS(operation.getSourceLocalItem()), null, 0, 0, operation.getVersionServer(), operation.getHashValue(), -1L, null, operation.getPendingChangeID(), null, null, ConflictType.NONE.getValue(), new _MergeSource[0], (_PropertyValue[])WrapperUtils.unwrap(_PropertyValue.class, operation.getPropertyValues())));
        Check.notNull(workspace, "workspace");
        this.undone = operation.isUndo();
        this.localItemDelete = operation.isDelete();
        this.pendingSetName = workspace.getName();
        this.pendingSetOwner = workspace.getOwnerName();
        this.pendingSetOwnerDisplay = workspace.getOwnerDisplayName();
        this.inShelveset = false;
        if (this.getLocalItem() == null) {
            if (this.getSourceLocalItem() != null) {
                this.setLocalItem(this.getSourceLocalItem());
            } else {
                this.setLocalItem(workspace.getMappedLocalPath(this.getServerItem()));
            }
            if (!operation.isUndo() && this.isDelete() || operation.isUndo() && (this.isUndelete() || this.isBranch())) {
                this.setSourceLocalItem(null);
            }
        }
    }

    public PendingChange(String serverItem, String sourceServerItem, int sourceVersionFrom, int sourceDeletionID, int deletionID, LockLevel lockLevel, String localItem, ItemType itemType, int itemID, Calendar creationDate, int version, ChangeType changeType, byte[] hashValue, byte[] uploadHashValue, int encoding, int pendingChangeID, PropertyValue[] properties, boolean isCandidate) {
        this(new _PendingChange(changeType.getWebServiceObjectExtendedFlags(), changeType.getWebServiceObject(), creationDate, deletionID, itemType.getWebServiceObject(), encoding, itemID, LocalPath.nativeToTFS(localItem), lockLevel.getWebServiceObject(), serverItem, null, sourceServerItem, sourceVersionFrom, sourceDeletionID, version, hashValue, -1L, uploadHashValue, pendingChangeID, null, null, 0, null, (_PropertyValue[])WrapperUtils.unwrap(_PropertyValue.class, properties)));
        this.isCandidate = isCandidate;
    }

    public _PendingChange getWebServiceObject() {
        return (_PendingChange)this.webServiceObject;
    }

    public synchronized File downloadShelvedFileToTempLocation(VersionControlClient client, String fileName) {
        Check.notNullOrEmpty(fileName, "fileName");
        Check.notNull(client, "client");
        try {
            File file = new File(TempStorageService.getInstance().createTempDirectory(), fileName);
            this.downloadShelvedFile(client, file.getAbsolutePath());
            return file;
        }
        catch (IOException e) {
            throw new VersionControlException(e);
        }
    }

    public synchronized void downloadShelvedFile(VersionControlClient client, String localFileName) {
        Check.notNull(client, "client");
        Check.notNull(localFileName, "localFileName");
        if (this.getItemType() != ItemType.FILE) {
            throw new VersionControlException(MessageFormat.format(Messages.getString("PendingChange.PendingChangeIsNotAShelvedFileFormat"), this.getLocalOrServerItem()));
        }
        if (this.getShelvedDownloadURL() == null || this.getShelvedDownloadURL().length() == 0) {
            this.updateMissingProperties(client);
        }
        if (this.getShelvedDownloadURL() == null || this.getShelvedDownloadURL().length() == 0) {
            throw new VersionControlException(MessageFormat.format(Messages.getString("PendingChange.PendingChangeIsNotAShelvedFileFormat"), this.getLocalOrServerItem()));
        }
        client.downloadFile(new DownloadSpec(this.getShelvedDownloadURL()), new File(localFileName), true);
    }

    public synchronized File downloadBaseFileToTempLocation(VersionControlClient client, String fileName) {
        Check.notNullOrEmpty(fileName, "fileName");
        Check.notNull(client, "client");
        try {
            File file = new File(TempStorageService.getInstance().createTempDirectory(), fileName);
            this.downloadBaseFile(client, file.getAbsolutePath());
            return file;
        }
        catch (IOException e) {
            throw new VersionControlException(e);
        }
    }

    public synchronized void downloadBaseFile(VersionControlClient client, String localFileName) {
        Check.notNull(client, "client");
        Check.notNull(localFileName, "localFileName");
        if (this.getItemType() != ItemType.FILE) {
            throw new VersionControlException(MessageFormat.format(Messages.getString("PendingChange.PathIsNotAFileFormat"), this.getLocalOrServerItem()));
        }
        if (this.copyLocalBaseline(client, localFileName)) {
            return;
        }
        if (this.getDownloadURL() == null || this.getDownloadURL().length() == 0) {
            this.updateMissingProperties(client);
        }
        if (this.getDownloadURL() == null || this.getDownloadURL().length() == 0) {
            throw new VersionControlException(MessageFormat.format(Messages.getString("PendingChange.NoBaseFileForPendingChangeFormat"), this.getLocalOrServerItem()));
        }
        client.downloadFile(new DownloadSpec(this.getDownloadURL()), new File(localFileName), true);
    }

    public void updateMissingProperties(VersionControlClient client) {
        if (this.pendingSetName != null && this.pendingSetName.length() > 0 && this.pendingSetOwner != null && this.pendingSetOwner.length() > 0 && client != null) {
            PendingSet[] pss = null;
            pss = this.inShelveset ? client.queryShelvedChanges(this.pendingSetName, this.pendingSetOwner, new ItemSpec[]{new ItemSpec(this)}, true) : client.queryPendingSets(new ItemSpec[]{new ItemSpec(this)}, true, this.pendingSetName, this.pendingSetOwner, true);
            Check.isTrue(pss.length == 1, MessageFormat.format("Received more than one PendingSet in UpdateMissingProperties. ServerItem: {0}", this.getServerItem()));
            block0: for (PendingSet ps : pss) {
                for (PendingChange pc : ps.getPendingChanges()) {
                    boolean matchingVersion;
                    boolean bl = matchingVersion = this.getVersion() == pc.getVersion();
                    if (!matchingVersion) continue;
                    this.setShelvedDownloadURL(pc.getShelvedDownloadURL());
                    this.setDownloadURL(pc.getDownloadURL());
                    this.setSourceServerItem(pc.getSourceServerItem());
                    this.setSourceLocalItem(pc.getSourceLocalItem());
                    continue block0;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean copyLocalBaseline(VersionControlClient client, final String localFileName) {
        Check.notNull(client, "client");
        Check.notNull(localFileName, "localFileName");
        final AtomicBoolean handled = new AtomicBoolean(false);
        Check.isTrue(this.pendingSetName != null && this.pendingSetName.length() > 0 && this.pendingSetOwner != null && this.pendingSetOwner.length() > 0, MessageFormat.format("PendingSetName or PendingSetOwner were not populated for pending change {0}", this.toString()));
        if (this.inShelveset || this.pendingSetName == null || this.pendingSetName.length() == 0 || this.pendingSetOwner == null || this.pendingSetOwner.length() == 0) {
            return handled.get();
        }
        Workspace workspace = client.getRuntimeWorkspaceCache().tryGetWorkspace(this.pendingSetName, this.pendingSetOwner);
        if (workspace != null && workspace.getLocation() == WorkspaceLocation.LOCAL) {
            if (this.isAdd()) {
                throw new VersionControlException(MessageFormat.format(Messages.getString("PendingChange.NoBaseFileForPendingChangeFormat"), this.getLocalOrServerItem()));
            }
            LocalWorkspaceTransaction transaction = new LocalWorkspaceTransaction(workspace);
            try {
                transaction.execute(new WorkspacePropertiesLocalVersionTransaction(){

                    @Override
                    public void invoke(LocalWorkspaceProperties wp, WorkspaceVersionTable lv) {
                        WorkspaceLocalItem lvEntry = lv.getByPendingChange(PendingChange.this);
                        if (null != lvEntry && null != lvEntry.getBaselineFileGUID()) {
                            try {
                                boolean symlink = PropertyConstants.IS_SYMLINK.equals(PropertyUtils.selectMatching(lvEntry.getPropertyValues(), "Microsoft.TeamFoundation.VersionControl.SymbolicLink"));
                                wp.copyBaselineToTarget(lvEntry.getBaselineFileGUID(), localFileName, lvEntry.getLength(), lvEntry.getHashValue(), symlink);
                                handled.set(true);
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                        }
                    }
                });
            }
            finally {
                try {
                    transaction.close();
                }
                catch (IOException e) {
                    throw new VersionControlException(e);
                }
            }
            if (!handled.get()) {
                String serverItem = this.getSourceServerItem() == null || this.getSourceServerItem().length() == 0 ? this.getServerItem() : this.getSourceServerItem();
                int versionToDownload = this.isBranch() ? this.getSourceVersionFrom() : this.getVersion();
                Item item = client.getItem(serverItem, (VersionSpec)new ChangesetVersionSpec(versionToDownload), this.getDeletionID(), true);
                client.downloadFile(new DownloadSpec(item.getDownloadURL()), new File(localFileName), true);
                handled.set(true);
            }
        }
        return handled.get();
    }

    public synchronized ChangeType getChangeType() {
        return new ChangeType(this.getWebServiceObject().getChg(), this.getWebServiceObject().getChgEx());
    }

    public synchronized void setChangeType(ChangeType changeType) {
        this.hashCodeValid = false;
        this.getWebServiceObject().setChg(changeType.getWebServiceObject());
        this.getWebServiceObject().setChgEx(changeType.getWebServiceObjectExtendedFlags());
    }

    public synchronized ConflictType getConflictType() {
        return ConflictType.fromInteger(this.getWebServiceObject().getCt());
    }

    public synchronized void setConflictType(ConflictType conflictType) {
        this.getWebServiceObject().setCt(conflictType.getValue());
    }

    public synchronized Calendar getCreationDate() {
        return this.getWebServiceObject().getDate();
    }

    public synchronized void setCreationDate(Calendar date) {
        this.getWebServiceObject().setDate(date);
    }

    public synchronized int getDeletionID() {
        return this.getWebServiceObject().getDid();
    }

    public synchronized void setDeletionID(int did) {
        this.hashCodeValid = false;
        this.getWebServiceObject().setDid(did);
    }

    public synchronized int getEncoding() {
        return this.getWebServiceObject().getEnc();
    }

    public synchronized void setEncoding(int enc) {
        this.getWebServiceObject().setEnc(enc);
    }

    public synchronized byte[] getHashValue() {
        return this.getWebServiceObject().getHash();
    }

    public synchronized void setHashValue(byte[] hash) {
        this.getWebServiceObject().setHash(hash);
    }

    public synchronized String getServerItem() {
        return this.getWebServiceObject().getItem();
    }

    public synchronized void setServerItem(String item) {
        this.hashCodeValid = false;
        this.getWebServiceObject().setItem(item);
    }

    public synchronized int getItemID() {
        return this.getWebServiceObject().getItemid();
    }

    public synchronized void setItemID(int itemid) {
        this.hashCodeValid = false;
        this.getWebServiceObject().setItemid(itemid);
    }

    public synchronized boolean hasLocalItem() {
        return this.getWebServiceObject().getLocal() != null;
    }

    public synchronized String getLocalItem() {
        return LocalPath.tfsToNative(this.getWebServiceObject().getLocal());
    }

    public synchronized void setLocalItem(String item) {
        this.hashCodeValid = false;
        this.getWebServiceObject().setLocal(LocalPath.nativeToTFS(item));
    }

    public synchronized LockLevel getLockLevel() {
        return LockLevel.fromWebServiceObject(this.getWebServiceObject().getLock());
    }

    public synchronized void setLockLevel(LockLevel lock) {
        this.getWebServiceObject().setLock(lock.getWebServiceObject());
    }

    public synchronized int getSourceVersionFrom() {
        return this.getWebServiceObject().getSvrfm();
    }

    @Deprecated
    public synchronized int getPendingChangeID() {
        return this.getWebServiceObject().getPcid();
    }

    @Deprecated
    public synchronized void setPendingChangeID(int pcid) {
        this.getWebServiceObject().setPcid(pcid);
    }

    public synchronized String getSourceServerItem() {
        return this.getWebServiceObject().getSrcitem();
    }

    public synchronized void setSourceServerItem(String item) {
        this.hashCodeValid = false;
        this.getWebServiceObject().setSrcitem(item);
    }

    public synchronized String getSourceLocalItem() {
        return LocalPath.tfsToNative(this.getWebServiceObject().getSrclocal());
    }

    public synchronized void setSourceLocalItem(String item) {
        this.getWebServiceObject().setSrclocal(LocalPath.nativeToTFS(item));
    }

    public synchronized ItemType getItemType() {
        return ItemType.fromWebServiceObject(this.getWebServiceObject().getType());
    }

    public synchronized void setItemType(ItemType type) {
        this.hashCodeValid = false;
        this.getWebServiceObject().setType(type.getWebServiceObject());
    }

    public synchronized byte[] getUploadContentHashValue() {
        return this.getWebServiceObject().getUhash();
    }

    public synchronized void setUploadContentHashValue(byte[] hash) {
        this.getWebServiceObject().setUhash(hash);
    }

    public synchronized int getVersion() {
        return this.getWebServiceObject().getVer();
    }

    public synchronized void setVersion(int version) {
        this.hashCodeValid = false;
        this.getWebServiceObject().setVer(version);
    }

    public synchronized boolean isCandidate() {
        return this.isCandidate;
    }

    public synchronized void setCandidate(boolean value) {
        this.isCandidate = value;
    }

    public synchronized String getPendingSetName() {
        return this.pendingSetName;
    }

    public synchronized void setPendingSetName(String name) {
        this.pendingSetName = name;
    }

    public synchronized String getPendingSetOwner() {
        return this.pendingSetOwner;
    }

    public synchronized void setPendingSetOwner(String owner) {
        this.pendingSetOwner = owner;
    }

    public synchronized String getPendingSetOwnerDisplay() {
        return this.pendingSetOwnerDisplay;
    }

    public synchronized void setPendingSetOwnerDisplay(String owner) {
        this.pendingSetOwnerDisplay = owner;
    }

    public synchronized boolean isInShelveset() {
        return this.inShelveset;
    }

    public synchronized void setInShelveset(boolean value) {
        this.inShelveset = value;
    }

    @Override
    public int compareTo(PendingChange other) {
        int result = ServerPath.compareTopDown(this.getServerItem(), other.getServerItem());
        if (result != 0) {
            return result;
        }
        if (this.getDeletionID() < other.getDeletionID()) {
            return -1;
        }
        if (this.getDeletionID() > other.getDeletionID()) {
            return 1;
        }
        return 0;
    }

    public static String[] toServerItems(PendingChange[] changes) {
        if (changes == null) {
            return new String[0];
        }
        ArrayList<String> items = new ArrayList<String>(changes.length);
        for (int i = 0; i < changes.length; ++i) {
            if (changes[i].getServerItem() == null) continue;
            items.add(changes[i].getServerItem());
        }
        return items.toArray(new String[items.size()]);
    }

    public static String[] toLocalItems(PendingChange[] changes) {
        if (changes == null) {
            return new String[0];
        }
        ArrayList<String> items = new ArrayList<String>(changes.length);
        for (int i = 0; i < changes.length; ++i) {
            if (changes[i].getLocalItem() == null) continue;
            items.add(changes[i].getLocalItem());
        }
        return items.toArray(new String[items.size()]);
    }

    public boolean equalsIgnoringLockLevelAndVersion(Object obj) {
        return this.equals(obj, true, true);
    }

    @Override
    public boolean equals(Object obj) {
        return this.equals(obj, false, false);
    }

    private boolean equals(Object obj, boolean ignoreLockLevel, boolean ignoreVersion) {
        PropertyValue[] otherPropertyValues;
        boolean versionsEqual;
        boolean sourceServerItemsEqual;
        boolean localItemsEqual;
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PendingChange)) {
            return false;
        }
        PendingChange other = (PendingChange)obj;
        String thisLocalRawItem = this.getWebServiceObject().getLocal();
        String otherLocalRawItem = other.getWebServiceObject().getLocal();
        boolean bl = localItemsEqual = thisLocalRawItem == null || otherLocalRawItem == null || otherLocalRawItem.equals(thisLocalRawItem);
        if (!localItemsEqual) {
            return false;
        }
        String thisSourceServerItem = this.getSourceServerItem();
        String otherSourceServerItem = other.getSourceServerItem();
        boolean bl2 = otherSourceServerItem == null || thisSourceServerItem == null ? otherSourceServerItem == thisSourceServerItem : (sourceServerItemsEqual = otherSourceServerItem.equals(thisSourceServerItem));
        if (!sourceServerItemsEqual) {
            return false;
        }
        boolean lockLevelsEqual = true;
        if (!ignoreLockLevel) {
            LockLevel thisLockLevel = this.getLockLevel();
            LockLevel otherLockLevel = other.getLockLevel();
            boolean bl3 = otherLockLevel == null || thisLockLevel == null ? otherLockLevel == thisLockLevel : (lockLevelsEqual = otherLockLevel == thisLockLevel);
        }
        boolean bl4 = ignoreVersion ? true : (versionsEqual = other.getVersion() == this.getVersion());
        if (other.getChangeType().equals(ChangeType.PROPERTY) && (otherPropertyValues = other.getPropertyValues()) != null && !otherPropertyValues.equals(this.getPropertyValues())) {
            return false;
        }
        return other.getChangeType().equals(this.getChangeType()) && other.getDeletionID() == this.getDeletionID() && other.getItemType() == this.getItemType() && other.getItemID() == this.getItemID() && localItemsEqual && lockLevelsEqual && other.getServerItem().equals(this.getServerItem()) && sourceServerItemsEqual && versionsEqual;
    }

    @Override
    public int hashCode() {
        if (!this.hashCodeValid) {
            int result = 17;
            String sourceServerItem = this.getSourceServerItem();
            ChangeType changeType = this.getChangeType();
            ItemType itemType = this.getItemType();
            String localItem = this.getLocalItem();
            String serverItem = this.getServerItem();
            result = 37 * result + (sourceServerItem == null ? 0 : sourceServerItem.hashCode());
            result = 37 * result + (changeType == null ? 0 : changeType.hashCode());
            result = 37 * result + this.getDeletionID();
            result = 37 * result + (itemType == null ? 0 : itemType.hashCode());
            result = 37 * result + this.getItemID();
            result = 37 * result + (localItem == null ? 0 : localItem.hashCode());
            result = 37 * result + (serverItem == null ? 0 : serverItem.hashCode());
            this.hashCode = result = 37 * result + this.getVersion();
            this.hashCodeValid = true;
        }
        return this.hashCode;
    }

    public String getLockLevelName() {
        return this.getLockLevel().toUIString();
    }

    public String getLockLevelShortName() {
        return this.getLockLevel().toShortUIString();
    }

    @Override
    public String toString() {
        return this.getWebServiceObject().getItem() + ":" + (this.getWebServiceObject().getLock() != null ? this.getWebServiceObject().getLock().getName() : "null");
    }

    public synchronized boolean isUndone() {
        return this.undone;
    }

    public synchronized boolean isLocalItemDelete() {
        return this.localItemDelete;
    }

    public synchronized long getLength() {
        return this.getWebServiceObject().getLen();
    }

    public synchronized void setLength(long value) {
        this.getWebServiceObject().setLen(value);
    }

    public synchronized String getDownloadURL() {
        return this.getWebServiceObject().getDurl();
    }

    public synchronized void setDownloadURL(String url) {
        this.getWebServiceObject().setDurl(url);
    }

    public synchronized String getShelvedDownloadURL() {
        return this.getWebServiceObject().getShelvedurl();
    }

    public synchronized void setShelvedDownloadURL(String url) {
        this.getWebServiceObject().setShelvedurl(url);
    }

    public static boolean isSourceRename(ChangeType changeType) {
        Check.notNull(changeType, "changeType");
        return changeType.contains(ChangeType.SOURCE_RENAME) && !changeType.contains(ChangeType.BRANCH) && !changeType.contains(ChangeType.RENAME) && !changeType.contains(ChangeType.ADD);
    }

    public synchronized MergeSource[] getMergeSources() {
        return (MergeSource[])WrapperUtils.wrap(MergeSource.class, this.getWebServiceObject().getMergeSources());
    }

    public synchronized boolean hasContentChange() throws CanceledException {
        ChangeType changeType = this.getChangeType();
        String localItem = this.getLocalItem();
        if (!changeType.contains(ChangeType.EDIT) || changeType.contains(ChangeType.ADD) || localItem == null) {
            return false;
        }
        if (changeType.contains(ChangeType.BRANCH)) {
            return true;
        }
        if (!new File(localItem).exists()) {
            return false;
        }
        try {
            return !Arrays.equals(CheckinEngine.computeMD5Hash(localItem, TaskMonitorService.getTaskMonitor()), this.getHashValue());
        }
        catch (CoreCancelException e) {
            throw new CanceledException();
        }
    }

    public boolean isUnchanged(Workspace workspace) {
        ChangeType changeType = this.getChangeType();
        if (!changeType.remove(ChangeType.LOCK).equals(ChangeType.EDIT)) {
            return false;
        }
        if (workspace.isLocalWorkspace()) {
            return this.isUnchangedInLocalWorkspace(workspace);
        }
        return this.isUnchangedInServerWorkspace();
    }

    public boolean isUnchangedInServerWorkspace() throws CanceledException {
        return !this.hasContentChange();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean isUnchangedInLocalWorkspace(Workspace workspace) throws CanceledException {
        Check.notNull(workspace, "workspace");
        Check.isTrue(workspace.isLocalWorkspace());
        LocalWorkspaceTransaction transaction = new LocalWorkspaceTransaction(workspace);
        final byte[][] hashValues = new byte[2][];
        try {
            transaction.execute(new WorkspacePropertiesLocalVersionTransaction(){

                @Override
                public void invoke(LocalWorkspaceProperties wp, WorkspaceVersionTable lv) {
                    WorkspaceLocalItem lvEntry = lv.getByPendingChange(PendingChange.this);
                    String localItem = PendingChange.this.getLocalItem();
                    if (localItem != null && lvEntry != null && lvEntry.hasBaselineFileGUID() && lvEntry.hasHashValue()) {
                        try {
                            hashValues[0] = lvEntry.getHashValue();
                            hashValues[1] = CheckinEngine.computeMD5Hash(localItem, TaskMonitorService.getTaskMonitor());
                        }
                        catch (CoreCancelException e) {
                            throw new CanceledException();
                        }
                    }
                }
            });
        }
        finally {
            try {
                transaction.close();
            }
            catch (IOException e) {
                throw new VersionControlException(e);
            }
        }
        return Arrays.equals(hashValues[0], hashValues[1]);
    }

    public boolean isAdd() {
        return this.getChangeType().contains(ChangeType.ADD);
    }

    public boolean isEdit() {
        return this.getChangeType().contains(ChangeType.EDIT);
    }

    public boolean isRename() {
        return this.getChangeType().contains(ChangeType.RENAME);
    }

    public boolean isEncoding() {
        return this.getChangeType().contains(ChangeType.ENCODING);
    }

    public boolean isDelete() {
        return this.getChangeType().contains(ChangeType.DELETE);
    }

    public boolean isUndelete() {
        return this.getChangeType().contains(ChangeType.UNDELETE);
    }

    public boolean isBranch() {
        return this.getChangeType().contains(ChangeType.BRANCH);
    }

    public boolean isMerge() {
        return this.getChangeType().contains(ChangeType.MERGE);
    }

    public boolean isRollback() {
        return this.getChangeType().contains(ChangeType.ROLLBACK);
    }

    public boolean isLock() {
        return this.getChangeType().contains(ChangeType.LOCK);
    }

    private String getLocalOrServerItem() {
        String localItem = this.getLocalItem();
        if (localItem != null && localItem.length() > 0) {
            return localItem;
        }
        return this.getServerItem();
    }

    public PropertyValue[] getPropertyValues() {
        return PropertyUtils.selectUnique((PropertyValue[])WrapperUtils.wrap(PropertyValue.class, this.getWebServiceObject().getPropertyValues()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restoreCandidateDelete(final Workspace workspace) {
        Check.notNull(workspace, "workspace");
        if (!this.isCandidate || !this.getChangeType().contains(ChangeType.DELETE)) {
            throw new VersionControlException(Messages.getString("PendingChange.ChangeNotACandidateDelete"));
        }
        if (workspace.getLocation() == WorkspaceLocation.LOCAL) {
            LocalWorkspaceTransaction transaction = new LocalWorkspaceTransaction(workspace);
            try {
                transaction.execute(new WorkspacePropertiesLocalVersionTransaction(){

                    @Override
                    public void invoke(LocalWorkspaceProperties wp, WorkspaceVersionTable lv) {
                        for (WorkspaceLocalItem lvEntry : lv.queryByLocalItem(PendingChange.this.getLocalItem(), PendingChange.this.getItemType() == ItemType.FILE ? RecursionType.NONE : RecursionType.FULL, null)) {
                            if (null != lvEntry.getBaselineFileGUID()) {
                                try {
                                    boolean symlink = PropertyConstants.IS_SYMLINK.equals(PropertyUtils.selectMatching(lvEntry.getPropertyValues(), "Microsoft.TeamFoundation.VersionControl.SymbolicLink"));
                                    wp.copyBaselineToTarget(lvEntry.getBaselineFileGUID(), lvEntry.getLocalItem(), lvEntry.getLength(), lvEntry.getHashValue(), symlink);
                                    if (!workspace.getOptions().contains(WorkspaceOptions.SET_FILE_TO_CHECKIN) || lvEntry.getCheckinDate() == -1L) continue;
                                    FileSystemAttributes attrs = FileSystemUtils.getInstance().getAttributes(lvEntry.getLocalItem());
                                    boolean restoreReadOnly = false;
                                    if (attrs != null && attrs.isReadOnly()) {
                                        attrs.setReadOnly(false);
                                        FileSystemUtils.getInstance().setAttributes(lvEntry.getLocalItem(), attrs);
                                        restoreReadOnly = true;
                                    }
                                    new File(lvEntry.getLocalItem()).setLastModified(DotNETDate.fromWindowsFileTimeUTC(lvEntry.getCheckinDate()).getTimeInMillis());
                                    if (!restoreReadOnly) continue;
                                    attrs.setReadOnly(true);
                                    FileSystemUtils.getInstance().setAttributes(lvEntry.getLocalItem(), attrs);
                                }
                                catch (Exception e) {
                                    workspace.getClient().getEventEngine().fireNonFatalError(new NonFatalErrorEvent(EventSource.newFromHere(), workspace, (Throwable)e));
                                }
                                continue;
                            }
                            if (lvEntry.getItemType() != ItemType.FOLDER || new File(lvEntry.getLocalItem()).exists()) continue;
                            new File(lvEntry.getLocalItem()).mkdirs();
                        }
                    }
                });
            }
            finally {
                try {
                    transaction.close();
                }
                catch (IOException e) {
                    throw new VersionControlException(e);
                }
            }
        }
    }
}

