/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.versioncontrol.soapextensions;

import com.microsoft.tfs.core.artifact.ArtifactID;
import com.microsoft.tfs.core.artifact.ArtifactIDFactory;
import com.microsoft.tfs.core.clients.versioncontrol.PropertyUtils;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.CheckinNote;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.PropertyValue;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.VersionControlLink;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.VersionControlLinkType;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.WorkItemCheckinInfo;
import com.microsoft.tfs.core.clients.versioncontrol.workspacecache.WorkItemCheckedInfo;
import com.microsoft.tfs.core.clients.workitem.CheckinWorkItemAction;
import com.microsoft.tfs.core.clients.workitem.WorkItem;
import com.microsoft.tfs.core.clients.workitem.WorkItemClient;
import com.microsoft.tfs.core.internal.wrappers.WebServiceObjectWrapper;
import com.microsoft.tfs.core.internal.wrappers.WrapperUtils;
import com.microsoft.tfs.util.Check;
import java.util.ArrayList;
import java.util.Calendar;
import ms.tfs.versioncontrol.clientservices._03._PropertyValue;
import ms.tfs.versioncontrol.clientservices._03._Shelveset;
import ms.tfs.versioncontrol.clientservices._03._VersionControlLink;

public final class Shelveset
extends WebServiceObjectWrapper {
    private WorkItemCheckinInfo[] workItemInfo = null;

    public Shelveset() {
        this(new _Shelveset());
    }

    public Shelveset(_Shelveset shelveset) {
        super(shelveset);
        String displayName = shelveset.getOwnerdisp();
        if (displayName == null || displayName.length() == 0) {
            shelveset.setOwnerdisp(shelveset.getOwner());
        }
    }

    public Shelveset(String name, String owner, String ownerDisplayName, String comment, String policyOverrideComment, CheckinNote checkinNote, VersionControlLink[] links, Calendar creationDate, boolean changesExcluded, PropertyValue[] propertyValues) {
        this(new _Shelveset(creationDate, name, owner, ownerDisplayName, owner, changesExcluded, comment, policyOverrideComment, checkinNote != null ? checkinNote.getWebServiceObject() : null, (_VersionControlLink[])WrapperUtils.unwrap(_VersionControlLink.class, links), (_PropertyValue[])WrapperUtils.unwrap(_PropertyValue.class, propertyValues)));
    }

    public Shelveset(String name, String owner, String ownerDisplayName, String comment, String policyOverrideComment, CheckinNote checkinNote, WorkItemCheckedInfo[] checkedInfo, Calendar creationDate, boolean changesExcluded, PropertyValue[] propertyValues) {
        this(new _Shelveset(creationDate, name, owner, ownerDisplayName, owner, changesExcluded, comment, policyOverrideComment, checkinNote != null ? checkinNote.getWebServiceObject() : null, Shelveset.createVersionControlLinks(checkedInfo), (_PropertyValue[])WrapperUtils.unwrap(_PropertyValue.class, propertyValues)));
    }

    public Shelveset(String name, String owner, String ownerDisplayName, String comment, String policyOverrideComment, CheckinNote checkinNote, WorkItemCheckinInfo[] checkedInfo, Calendar creationDate, boolean changesExcluded, PropertyValue[] propertyValues) {
        this(new _Shelveset(creationDate, name, owner, ownerDisplayName, owner, changesExcluded, comment, policyOverrideComment, checkinNote != null ? checkinNote.getWebServiceObject() : null, Shelveset.createVersionControlLinks(checkedInfo), (_PropertyValue[])WrapperUtils.unwrap(_PropertyValue.class, propertyValues)));
    }

    private static _VersionControlLink[] createVersionControlLinks(WorkItemCheckedInfo[] checkedInfo) {
        if (checkedInfo == null || checkedInfo.length == 0) {
            return null;
        }
        ArrayList<_VersionControlLink> links = new ArrayList<_VersionControlLink>();
        for (int i = 0; i < checkedInfo.length; ++i) {
            VersionControlLinkType linkType;
            if (checkedInfo[i].getCheckinAction() == CheckinWorkItemAction.ASSOCIATE) {
                linkType = VersionControlLinkType.ASSOCIATE;
            } else {
                if (checkedInfo[i].getCheckinAction() != CheckinWorkItemAction.RESOLVE) continue;
                linkType = VersionControlLinkType.RESOLVE;
            }
            ArtifactID artifactID = ArtifactIDFactory.newWorkItemArtifactID(checkedInfo[i].getID());
            links.add(new _VersionControlLink(linkType.getValue(), artifactID.encodeURI()));
        }
        return links.toArray(new _VersionControlLink[links.size()]);
    }

    private static _VersionControlLink[] createVersionControlLinks(WorkItemCheckinInfo[] checkinInfo) {
        if (checkinInfo == null || checkinInfo.length == 0) {
            return null;
        }
        ArrayList<_VersionControlLink> links = new ArrayList<_VersionControlLink>();
        for (int i = 0; i < checkinInfo.length; ++i) {
            VersionControlLinkType linkType;
            if (checkinInfo[i].getAction() == CheckinWorkItemAction.ASSOCIATE) {
                linkType = VersionControlLinkType.ASSOCIATE;
            } else {
                if (checkinInfo[i].getAction() != CheckinWorkItemAction.RESOLVE) continue;
                linkType = VersionControlLinkType.RESOLVE;
            }
            links.add(new _VersionControlLink(linkType.getValue(), checkinInfo[i].getWorkItem().getURI()));
        }
        return links.toArray(new _VersionControlLink[links.size()]);
    }

    public _Shelveset getWebServiceObject() {
        return (_Shelveset)this.webServiceObject;
    }

    public String getName() {
        return this.getWebServiceObject().getName();
    }

    public String getOwnerName() {
        return this.getWebServiceObject().getOwner();
    }

    public void setOwnerName(String owner) {
        this.getWebServiceObject().setOwner(owner);
    }

    public String getOwnerDisplayName() {
        String displayName = this.getWebServiceObject().getOwnerdisp();
        if (displayName != null && displayName.length() > 0) {
            return this.getWebServiceObject().getOwnerdisp();
        }
        return this.getOwnerName();
    }

    public void setOwnerDisplayName(String owner) {
        this.getWebServiceObject().setOwnerdisp(owner);
    }

    public Calendar getCreationDate() {
        return this.getWebServiceObject().getDate();
    }

    public String getComment() {
        return this.getWebServiceObject().getComment();
    }

    public CheckinNote getCheckinNote() {
        return new CheckinNote(this.getWebServiceObject().getCheckinNote());
    }

    public String getPolicyOverrideComment() {
        return this.getWebServiceObject().getPolicyOverrideComment();
    }

    public PropertyValue[] getPropertyValues() {
        return PropertyUtils.selectUnique((PropertyValue[])WrapperUtils.wrap(PropertyValue.class, this.getWebServiceObject().getProperties()));
    }

    public synchronized WorkItemCheckedInfo[] getBriefWorkItemInfo() {
        ArrayList<WorkItemCheckedInfo> workItemList = new ArrayList<WorkItemCheckedInfo>();
        _VersionControlLink[] links = this.getWebServiceObject().getLinks();
        if (links != null) {
            for (_VersionControlLink _link : links) {
                VersionControlLink link = new VersionControlLink(_link);
                if (link.getLinkType() != VersionControlLinkType.ASSOCIATE && link.getLinkType() != VersionControlLinkType.RESOLVE) continue;
                ArtifactID artifactID = new ArtifactID(link.getURL());
                int id = Integer.parseInt(artifactID.getToolSpecificID());
                CheckinWorkItemAction action = CheckinWorkItemAction.NONE;
                if (link.getLinkType() == VersionControlLinkType.ASSOCIATE) {
                    action = CheckinWorkItemAction.ASSOCIATE;
                } else if (link.getLinkType() == VersionControlLinkType.RESOLVE) {
                    action = CheckinWorkItemAction.RESOLVE;
                }
                workItemList.add(new WorkItemCheckedInfo(id, true, action));
            }
        }
        return workItemList.toArray(new WorkItemCheckedInfo[workItemList.size()]);
    }

    public synchronized WorkItemCheckinInfo[] getWorkItemInfo(WorkItemClient workItemClient) {
        Check.notNull(workItemClient, "workItemClient");
        if (this.workItemInfo == null) {
            _VersionControlLink[] links = this.getWebServiceObject().getLinks();
            if (links != null) {
                this.workItemInfo = new WorkItemCheckinInfo[links.length];
                for (int i = 0; i < links.length; ++i) {
                    VersionControlLink link = new VersionControlLink(links[i]);
                    if (link.getLinkType() != VersionControlLinkType.ASSOCIATE && link.getLinkType() != VersionControlLinkType.RESOLVE) continue;
                    ArtifactID linkArtifact = new ArtifactID(link.getURL());
                    WorkItem wi = workItemClient.getWorkItemByID(Integer.parseInt(linkArtifact.getToolSpecificID()));
                    CheckinWorkItemAction action = CheckinWorkItemAction.NONE;
                    if (link.getLinkType() == VersionControlLinkType.ASSOCIATE) {
                        action = CheckinWorkItemAction.ASSOCIATE;
                    } else if (link.getLinkType() == VersionControlLinkType.RESOLVE) {
                        action = CheckinWorkItemAction.RESOLVE;
                    }
                    this.workItemInfo[i] = new WorkItemCheckinInfo(wi, action);
                }
            } else {
                this.workItemInfo = new WorkItemCheckinInfo[0];
            }
        }
        return this.workItemInfo;
    }

    public boolean areChangesExcluded() {
        return this.getWebServiceObject().isCe();
    }
}

