/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.versioncontrol.specs;

import com.microsoft.tfs.core.Messages;
import com.microsoft.tfs.core.clients.versioncontrol.specs.WorkspaceSpecParseException;
import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.FileHelpers;
import java.text.MessageFormat;

public final class WorkspaceSpec {
    private final String workspaceName;
    private final String owner;
    private static final char WORKSPACE_AND_OWNER_SEPARATOR = ';';

    public WorkspaceSpec(String workspaceName, String owner) {
        Check.notNullOrEmpty(workspaceName, "workspaceName");
        this.workspaceName = workspaceName;
        this.owner = owner;
    }

    public static WorkspaceSpec parse(String specString, String fallbackOwner) throws WorkspaceSpecParseException {
        return WorkspaceSpec.parse(specString, fallbackOwner, false);
    }

    public static WorkspaceSpec parse(String specString, String fallbackOwner, boolean permitWildcards) throws WorkspaceSpecParseException {
        int sep = specString.indexOf(59);
        if (sep == -1) {
            if (!FileHelpers.isValidNTFSFileName(specString, permitWildcards)) {
                throw new WorkspaceSpecParseException(MessageFormat.format(Messages.getString("WorkspaceSpec.WorkspaceNamecontainsInvalidCharactersFormat"), specString));
            }
            return new WorkspaceSpec(specString, fallbackOwner);
        }
        if (sep == 0) {
            throw new WorkspaceSpecParseException(MessageFormat.format(Messages.getString("WorkspaceSpec.CouldNotParseAWorkspaceNameFromSpecFormat"), specString));
        }
        String workspaceName = specString.substring(0, sep);
        if (!FileHelpers.isValidNTFSFileName(workspaceName, permitWildcards)) {
            throw new WorkspaceSpecParseException(MessageFormat.format(Messages.getString("WorkspaceSpec.WorkspaceNamecontainsInvalidCharactersFormat"), workspaceName));
        }
        String owner = sep + 1 == specString.length() ? fallbackOwner : specString.substring(sep + 1);
        return new WorkspaceSpec(workspaceName, owner);
    }

    public String getName() {
        return this.workspaceName;
    }

    public String getOwner() {
        return this.owner;
    }

    public synchronized String toString() {
        if (this.owner != null) {
            return this.workspaceName + ';' + this.owner;
        }
        return this.workspaceName;
    }
}

