/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.webservices;

import com.microsoft.tfs.core.clients.webservices.IdentityDescriptor;
import com.microsoft.tfs.core.clients.webservices.SIDIdentityHelper;
import com.microsoft.tfs.core.clients.webservices.TeamFoundationIdentity;
import com.microsoft.tfs.core.util.TFSUser;
import com.microsoft.tfs.core.util.UserNameUtil;
import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.StringUtil;
import java.util.concurrent.atomic.AtomicReference;

public class IdentityHelper {
    public static IdentityDescriptor createDescriptorFromSID(String sid) {
        Check.notNullOrEmpty(sid, "sid");
        if (sid.toLowerCase().startsWith(SIDIdentityHelper.TEAM_FOUNDATION_SID_PREFIX.toLowerCase())) {
            return IdentityHelper.createTeamFoundationDescriptor(sid);
        }
        return IdentityHelper.createWindowsDescriptor(sid);
    }

    public static IdentityDescriptor createWindowsDescriptor(String sid) {
        return new IdentityDescriptor("System.Security.Principal.WindowsIdentity", sid);
    }

    public static IdentityDescriptor createTeamFoundationDescriptor(String sid) {
        return new IdentityDescriptor("Microsoft.TeamFoundation.Identity", sid);
    }

    public static boolean identityHasName(TeamFoundationIdentity identity, String name) {
        Check.notNull(identity, "identity");
        Check.notNull(name, "name");
        if (identity.getUniqueName().equalsIgnoreCase(name)) {
            return true;
        }
        if (identity.getDisplayName().equalsIgnoreCase(name)) {
            return true;
        }
        String accountName = identity.getAttribute("Account", null);
        if (accountName != null && accountName.equalsIgnoreCase(name)) {
            return true;
        }
        String domainName = identity.getAttribute("Domain", null);
        TFSUser user = new TFSUser(accountName, domainName);
        return user.toString().equalsIgnoreCase(name);
    }

    public static String getUniqueNameIfCurrentUser(TeamFoundationIdentity identity, String userName) {
        Check.notNull(identity, "identity");
        if (StringUtil.isNullOrEmpty(userName)) {
            return userName;
        }
        if (userName.equals(".") || IdentityHelper.identityHasName(identity, userName)) {
            return identity.getUniqueName();
        }
        return userName;
    }

    public static String getDomainUserName(TeamFoundationIdentity identity) {
        Check.notNull(identity, "identity");
        AtomicReference<String> outResolvableName = new AtomicReference<String>();
        AtomicReference<String> outDisplayableName = new AtomicReference<String>();
        UserNameUtil.getIdentityName(identity.getDescriptor().getIdentityType(), identity.getDisplayName(), identity.getAttribute("Domain", ""), identity.getAttribute("Account", ""), identity.getUniqueUserID(), outResolvableName, outDisplayableName);
        return outDisplayableName.get();
    }

    public static String createSecurityToken(TeamFoundationIdentity group) {
        return group.getAttribute("Domain", "") + '\\' + group.getTeamFoundationID();
    }

    public static void checkDescriptor(IdentityDescriptor descriptor, String parameterName) {
        Check.notNull(descriptor, parameterName);
        Check.notNullOrEmpty(descriptor.getIdentityType(), "descriptor.getIdentityType()");
        Check.notNullOrEmpty(descriptor.getIdentifier(), "descriptor.getIdentifier()");
    }
}

