/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.webservices;

import com.microsoft.tfs.core.Messages;
import com.microsoft.tfs.core.clients.webservices.IdentityAttributeTags;
import com.microsoft.tfs.core.clients.webservices.IdentityDescriptor;
import com.microsoft.tfs.core.clients.webservices.IdentityPropertyScope;
import com.microsoft.tfs.core.clients.webservices.PropertyValidation;
import com.microsoft.tfs.core.exceptions.NotSupportedException;
import com.microsoft.tfs.core.internal.wrappers.WebServiceObjectWrapper;
import com.microsoft.tfs.core.internal.wrappers.WrapperUtils;
import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.GUID;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicReference;
import ms.ws._IdentityDescriptor;
import ms.ws._KeyValueOfStringString;
import ms.ws._PropertyValue;
import ms.ws._TeamFoundationIdentity;

public class TeamFoundationIdentity
extends WebServiceObjectWrapper {
    private final Map<String, Object> properties = new HashMap<String, Object>();
    private final Map<String, Object> localProperties = new HashMap<String, Object>();
    private final Set<String> modifiedPropertiesLog = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
    private final Set<String> modifiedLocalPropertiesLog = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
    private String clientSideUniqueName;

    public TeamFoundationIdentity(IdentityDescriptor descriptor, String displayName, boolean isActive, IdentityDescriptor[] members, IdentityDescriptor[] memberOf) {
        this(new _TeamFoundationIdentity(displayName, false, isActive, GUID.EMPTY.getGUIDString(), null, 0, descriptor.getWebServiceObject(), new _KeyValueOfStringString[]{}, new _PropertyValue[]{}, new _PropertyValue[]{}, members != null ? (_IdentityDescriptor[])WrapperUtils.unwrap(_IdentityDescriptor.class, members) : new _IdentityDescriptor[]{}, memberOf != null ? (_IdentityDescriptor[])WrapperUtils.unwrap(_IdentityDescriptor.class, memberOf) : new _IdentityDescriptor[]{}));
        Check.notNull(descriptor, "descriptor");
        Check.notNull(displayName, "displayName");
    }

    public TeamFoundationIdentity(_TeamFoundationIdentity webServiceObject) {
        super(webServiceObject);
        _KeyValueOfStringString[] wsoAttributes;
        _PropertyValue[] wsoLocalProperties;
        _PropertyValue[] wsoProperties = webServiceObject.getProperties();
        if (wsoProperties != null && wsoProperties.length > 0) {
            for (_PropertyValue property : wsoProperties) {
                this.properties.put(property.getPname(), property.getVal());
            }
        }
        if ((wsoLocalProperties = webServiceObject.getLocalProperties()) != null && wsoLocalProperties.length > 0) {
            for (_PropertyValue property : wsoLocalProperties) {
                this.localProperties.put(property.getPname(), property.getVal());
            }
        }
        if ((wsoAttributes = webServiceObject.getAttributes()) != null && wsoAttributes.length > 0) {
            for (_KeyValueOfStringString attribute2 : wsoAttributes) {
                this.properties.put(attribute2.getKey(), attribute2.getValue());
            }
        }
        this.getWebServiceObject().setProperties(null);
        this.getWebServiceObject().setLocalProperties(null);
        this.getWebServiceObject().setAttributes(null);
    }

    public synchronized _TeamFoundationIdentity getWebServiceObject() {
        return (_TeamFoundationIdentity)this.webServiceObject;
    }

    public synchronized boolean tryGetProperty(String name, AtomicReference<Object> value) {
        return this.tryGetProperty(IdentityPropertyScope.BOTH, name, value);
    }

    public synchronized boolean tryGetProperty(IdentityPropertyScope propertyScope, String name, AtomicReference<Object> value) {
        if (propertyScope == IdentityPropertyScope.LOCAL) {
            if (this.localProperties.containsKey(name)) {
                value.set(this.localProperties.get(name));
                return true;
            }
            return false;
        }
        if (propertyScope == IdentityPropertyScope.GLOBAL) {
            if (this.properties.containsKey(name)) {
                value.set(this.properties.get(name));
                return true;
            }
            return false;
        }
        if (!this.tryGetProperty(IdentityPropertyScope.LOCAL, name, value) || value.get() == null) {
            return this.tryGetProperty(IdentityPropertyScope.GLOBAL, name, value);
        }
        return true;
    }

    public synchronized Object getProperty(String name) {
        return this.getProperty(IdentityPropertyScope.BOTH, name);
    }

    public synchronized Object getProperty(IdentityPropertyScope propertyScope, String name) {
        if (propertyScope == IdentityPropertyScope.LOCAL) {
            return this.localProperties.get(name);
        }
        if (propertyScope == IdentityPropertyScope.GLOBAL) {
            return this.properties.get(name);
        }
        AtomicReference<Object> value = new AtomicReference<Object>();
        if (!this.tryGetProperty(IdentityPropertyScope.LOCAL, name, value) || value.get() == null) {
            return this.properties.get(name);
        }
        return value.get();
    }

    public synchronized Iterable<Map.Entry<String, Object>> getProperties() {
        return this.getProperties(IdentityPropertyScope.BOTH);
    }

    public synchronized Iterable<Map.Entry<String, Object>> getProperties(IdentityPropertyScope propertyScope) {
        if (propertyScope == IdentityPropertyScope.LOCAL) {
            return Collections.unmodifiableSet(this.localProperties.entrySet());
        }
        if (propertyScope == IdentityPropertyScope.GLOBAL) {
            return Collections.unmodifiableSet(this.properties.entrySet());
        }
        ArrayList<Map.Entry<String, Object>> copy = new ArrayList<Map.Entry<String, Object>>();
        copy.addAll(this.localProperties.entrySet());
        for (Map.Entry<String, Object> e : this.properties.entrySet()) {
            if (this.localProperties.containsKey(e.getKey())) continue;
            copy.add(e);
        }
        return Collections.unmodifiableList(copy);
    }

    public synchronized void setProperty(String name, Object value) {
        this.setProperty(IdentityPropertyScope.GLOBAL, name, value);
    }

    public synchronized void setProperty(IdentityPropertyScope propertyScope, String name, Object value) {
        PropertyValidation.validatePropertyName(name);
        PropertyValidation.validatePropertyValue(name, value);
        if (IdentityAttributeTags.READ_ONLY_PROPERTIES.contains(name)) {
            throw new NotSupportedException(MessageFormat.format(Messages.getString("TeamFoundationIdentity.IdentityPropertyReadOnlyFormat"), name));
        }
        if (propertyScope == IdentityPropertyScope.LOCAL) {
            this.setLocalProperty(name, value);
        } else if (propertyScope == IdentityPropertyScope.GLOBAL) {
            this.setGlobalProperty(name, value);
            this.removeProperty(IdentityPropertyScope.LOCAL, name);
        } else {
            throw new IllegalArgumentException(Messages.getString("TeamFoundationIdentity.InvalidPropertyScope"));
        }
    }

    private synchronized void setGlobalProperty(String name, Object value) {
        this.properties.put(name, value);
        this.modifiedPropertiesLog.add(name);
    }

    private synchronized void setLocalProperty(String name, Object value) {
        this.localProperties.put(name, value);
        this.modifiedLocalPropertiesLog.add(name);
    }

    public synchronized void removeProperty(String name) {
        this.setProperty(IdentityPropertyScope.GLOBAL, name, null);
    }

    public synchronized void removeProperty(IdentityPropertyScope propertyScope, String name) {
        this.setProperty(propertyScope, name, null);
    }

    @Deprecated
    public synchronized String getAttribute(String name, String defaultValue) {
        if (this.properties.containsKey(name)) {
            return this.properties.get(name).toString();
        }
        return defaultValue;
    }

    @Deprecated
    public synchronized void setAttribute(String name, String value) {
        Check.notNullOrEmpty(name, "name");
        this.properties.put(name, value);
        this.clientSideUniqueName = null;
    }

    public synchronized boolean isContainer() {
        Object value;
        boolean result = false;
        if (this.properties.containsKey("SchemaClassName") && (value = this.properties.get("SchemaClassName")) != null && value.toString().equalsIgnoreCase("Group")) {
            result = true;
        }
        return result;
    }

    public synchronized Set<String> getModifiedPropertiesLog(IdentityPropertyScope propertyScope) {
        if (propertyScope == IdentityPropertyScope.LOCAL) {
            return this.modifiedLocalPropertiesLog;
        }
        if (propertyScope == IdentityPropertyScope.GLOBAL) {
            return this.modifiedPropertiesLog;
        }
        throw new IllegalArgumentException(Messages.getString("TeamFoundationIdentity.InvalidPropertyScope"));
    }

    public synchronized void resetModifiedProperties() {
        this.modifiedPropertiesLog.clear();
        this.modifiedLocalPropertiesLog.clear();
    }

    public synchronized boolean isActive() {
        return this.getWebServiceObject().isIsActive();
    }

    public synchronized GUID getTeamFoundationID() {
        return new GUID(this.getWebServiceObject().getTeamFoundationId());
    }

    public synchronized String getDisplayName() {
        return this.getWebServiceObject().getDisplayName();
    }

    public synchronized void setDisplayName(String displayName) {
        this.getWebServiceObject().setDisplayName(displayName);
    }

    public synchronized String getUniqueName() {
        String uniqueName = this.getWebServiceObject().getUniqueName();
        if (uniqueName != null && uniqueName.length() > 0) {
            return uniqueName;
        }
        if (this.clientSideUniqueName == null) {
            int uniqueId = this.getUniqueUserID();
            String domain = this.getAttribute("Domain", "");
            String account = this.getAttribute("Account", "");
            Check.notNull(account, "account");
            this.clientSideUniqueName = uniqueId == 0 ? (domain == null || domain.length() == 0 ? account : MessageFormat.format("{0}\\{1}", domain, account)) : (domain == null || domain.length() == 0 ? MessageFormat.format("{0}:{1}", account, Integer.toString(uniqueId)) : MessageFormat.format("{0}\\{1}:{2}", domain, account, Integer.toString(uniqueId)));
        }
        return this.clientSideUniqueName;
    }

    public synchronized int getUniqueUserID() {
        return this.getWebServiceObject().getUniqueUserId();
    }

    public synchronized IdentityDescriptor getDescriptor() {
        return new IdentityDescriptor(this.getWebServiceObject().getDescriptor());
    }

    public synchronized IdentityDescriptor[] getMembers() {
        return (IdentityDescriptor[])WrapperUtils.wrap(IdentityDescriptor.class, this.getWebServiceObject().getMembers());
    }

    public IdentityDescriptor[] getMemberOf() {
        return (IdentityDescriptor[])WrapperUtils.wrap(IdentityDescriptor.class, this.getWebServiceObject().getMemberOf());
    }
}

