/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.workitem.internal.fields;

import com.microsoft.tfs.core.clients.workitem.fields.FieldDefinition;
import com.microsoft.tfs.core.clients.workitem.internal.WITContext;
import com.microsoft.tfs.core.clients.workitem.internal.fields.DatastoreItemFieldUsage;
import com.microsoft.tfs.core.clients.workitem.internal.fields.FieldDefinitionImpl;
import com.microsoft.tfs.core.clients.workitem.internal.fields.FieldReferenceBasedCache;
import com.microsoft.tfs.core.clients.workitem.internal.metadata.dao.FieldUsageMetadata;
import java.util.HashSet;
import java.util.Set;

public class DatastoreItemFieldUsagesCollection {
    private final FieldReferenceBasedCache<DatastoreItemFieldUsage> cache = new FieldReferenceBasedCache();
    private final Set<FieldDefinition> fieldDefinitions = new HashSet<FieldDefinition>();
    private final Set<DatastoreItemFieldUsage> fieldUsages = new HashSet<DatastoreItemFieldUsage>();

    public DatastoreItemFieldUsagesCollection(int fieldId, WITContext context) {
        FieldUsageMetadata[] fieldUsagesMetadata = context.getMetadata().getFieldUsagesTable().getFieldUsagesForObjectID(fieldId);
        for (int i = 0; i < fieldUsagesMetadata.length; ++i) {
            DatastoreItemFieldUsage fieldUsage = new DatastoreItemFieldUsage(fieldUsagesMetadata[i], context);
            FieldDefinitionImpl fieldDefinition = fieldUsage.getFieldDefinition();
            this.cache.put(fieldUsage, fieldDefinition.getName(), fieldDefinition.getReferenceName(), fieldDefinition.getID());
            this.fieldUsages.add(fieldUsage);
            this.fieldDefinitions.add(fieldDefinition);
        }
    }

    public FieldDefinitionImpl[] getFieldDefinitions() {
        return this.fieldDefinitions.toArray(new FieldDefinitionImpl[0]);
    }

    public DatastoreItemFieldUsage[] getFieldUsages() {
        return this.fieldUsages.toArray(new DatastoreItemFieldUsage[0]);
    }

    public DatastoreItemFieldUsage getUsageByFieldID(int fieldId) {
        return this.cache.get(fieldId);
    }

    public FieldDefinitionImpl getFieldDefinitionByName(String fieldName) {
        DatastoreItemFieldUsage fieldUsage = this.cache.get(fieldName);
        if (fieldUsage == null) {
            return null;
        }
        return fieldUsage.getFieldDefinition();
    }

    public FieldDefinitionImpl getFieldDefinitionByID(int id) {
        DatastoreItemFieldUsage fieldUsage = this.cache.get(id);
        if (fieldUsage == null) {
            return null;
        }
        return fieldUsage.getFieldDefinition();
    }
}

