/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.workitem.internal.fields;

import com.microsoft.tfs.core.Messages;
import com.microsoft.tfs.core.clients.workitem.WorkItem;
import com.microsoft.tfs.core.clients.workitem.fields.AllowedValuesCollection;
import com.microsoft.tfs.core.clients.workitem.fields.Field;
import com.microsoft.tfs.core.clients.workitem.fields.FieldChangeListener;
import com.microsoft.tfs.core.clients.workitem.fields.FieldDefinition;
import com.microsoft.tfs.core.clients.workitem.fields.FieldStatus;
import com.microsoft.tfs.core.clients.workitem.fields.ValuesCollection;
import com.microsoft.tfs.core.clients.workitem.internal.WITContext;
import com.microsoft.tfs.core.clients.workitem.internal.WorkItemImpl;
import com.microsoft.tfs.core.clients.workitem.internal.fields.FieldChangeListenerSupport;
import com.microsoft.tfs.core.clients.workitem.internal.fields.FieldCollectionImpl;
import com.microsoft.tfs.core.clients.workitem.internal.fields.FieldDefinitionImpl;
import com.microsoft.tfs.core.clients.workitem.internal.fields.FieldModificationType;
import com.microsoft.tfs.core.clients.workitem.internal.fields.ServerComputedFieldType;
import com.microsoft.tfs.core.clients.workitem.internal.metadata.dao.LookupFailedException;
import com.microsoft.tfs.core.clients.workitem.internal.node.NodeImpl;
import com.microsoft.tfs.core.clients.workitem.internal.rules.FieldPickListSupport;
import com.microsoft.tfs.core.clients.workitem.internal.rules.IFieldPickListSupport;
import com.microsoft.tfs.core.clients.workitem.internal.rules.IRuleTargetField;
import com.microsoft.tfs.core.clients.workitem.internal.rules.RuleEngine;
import com.microsoft.tfs.core.clients.workitem.internal.type.WITypeConverterException;
import com.microsoft.tfs.core.clients.workitem.internal.type.WIValueSource;
import com.microsoft.tfs.core.clients.workitem.link.ExternalLink;
import com.microsoft.tfs.core.clients.workitem.link.Hyperlink;
import com.microsoft.tfs.core.clients.workitem.link.RelatedLink;
import com.microsoft.tfs.core.clients.workitem.node.Node;
import com.microsoft.tfs.core.clients.workitem.project.Project;
import java.text.MessageFormat;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FieldImpl
implements Field,
IRuleTargetField {
    private static final Log log = LogFactory.getLog(FieldImpl.class);
    private final FieldDefinitionImpl fieldDefinition;
    private final FieldCollectionImpl fieldCollection;
    private final WorkItemImpl workItem;
    private final WITContext witContext;
    private Object originalValue = null;
    private boolean originalValueSet = false;
    private Object newValue;
    private boolean newValueSet = false;
    private FieldModificationType fieldModificationType;
    private ServerComputedFieldType serverComputedValueType = null;
    private FieldStatus fieldStatus = FieldStatus.VALID;
    private String helpText;
    private final FieldChangeListenerSupport changeListeners = new FieldChangeListenerSupport(this);
    private final FieldPickListSupport pickListSupport;
    private boolean ruleReadOnly = false;

    public FieldImpl(FieldDefinitionImpl fieldDefinition, FieldCollectionImpl fieldCollection, WorkItemImpl workItem, WITContext witContext) {
        this.fieldDefinition = fieldDefinition;
        this.fieldCollection = fieldCollection;
        this.workItem = workItem;
        this.witContext = witContext;
        this.pickListSupport = new FieldPickListSupport(fieldDefinition.getPSType(), "field [" + fieldDefinition.getID() + "]");
        if (fieldDefinition.getID() == 54) {
            this.newValue = null;
            this.newValueSet = true;
        }
    }

    public String toString() {
        return MessageFormat.format("FieldImpl({0},{1})@{2}", Integer.toString(this.fieldDefinition.getID()), this.fieldDefinition.getReferenceName(), Integer.toHexString(System.identityHashCode(this)));
    }

    @Override
    public void addFieldChangeListener(FieldChangeListener listener) {
        this.changeListeners.addFieldChangeListener(listener);
    }

    @Override
    public void removeFieldChangeListener(FieldChangeListener listener) {
        this.changeListeners.removeFieldChangeListener(listener);
    }

    @Override
    public int getID() {
        return this.fieldDefinition.getID();
    }

    @Override
    public String getName() {
        return this.fieldDefinition.getName();
    }

    @Override
    public String getReferenceName() {
        return this.fieldDefinition.getReferenceName();
    }

    @Override
    public AllowedValuesCollection getAllowedValues() {
        return this.pickListSupport.getAllowedValues();
    }

    @Override
    public ValuesCollection getProhibitedValues() {
        return this.pickListSupport.getProhibitedValues();
    }

    @Override
    public Object getOriginalValue() {
        if (this.originalValueSet) {
            return this.originalValue;
        }
        int id = this.fieldDefinition.getID();
        if (id == -7 || id == -105 || id == -12 || id == -42) {
            int idField = id == -105 ? -104 : -2;
            Integer originalId = (Integer)this.fieldCollection.getFieldInternal(idField).getOriginalValue();
            if (originalId == null) {
                return null;
            }
            NodeImpl node = this.witContext.getRootNode().findNodeDownwards(originalId);
            if (node == null) {
                return null;
            }
            if (id == -42) {
                node = node.getProjectNodeParent();
            }
            if (id == -12 || id == -42) {
                return node.getName();
            }
            return node.getPath();
        }
        if (id == -1) {
            Integer personId = (Integer)this.fieldCollection.getFieldInternal(-6).getOriginalValue();
            if (personId == null) {
                return null;
            }
            try {
                return this.witContext.getMetadata().getConstantsTable().getConstantByID(personId);
            }
            catch (LookupFailedException ex) {
                return null;
            }
        }
        if (id == -31) {
            if (this.workItem.getFieldsInternal().getFieldInternal(-3).isDirty()) {
                return null;
            }
            return this.getAttachmentCount(true);
        }
        if (this.isLinkCountField()) {
            if (this.workItem.getFieldsInternal().getFieldInternal(-3).isDirty()) {
                return null;
            }
            return this.getLinkCount(true);
        }
        return this.originalValue;
    }

    @Override
    public Object getValue() {
        int id = this.fieldDefinition.getID();
        if (this.isLinkCountField()) {
            return this.getLinkCount(false);
        }
        if (id == -31) {
            return this.getAttachmentCount(false);
        }
        if (id == 54 && this.workItem.isOpen()) {
            return this.newValue;
        }
        if (this.isDirty()) {
            if (id == -7 || id == -105 || id == -12 || id == -42) {
                int idField = id == -105 ? -104 : -2;
                Integer currentId = (Integer)this.fieldCollection.getFieldInternal(idField).getValue();
                if (currentId == null) {
                    return null;
                }
                NodeImpl node = this.witContext.getRootNode().findNodeDownwards(currentId);
                if (id == -42) {
                    node = node.getProjectNodeParent();
                }
                if (id == -12 || id == -42) {
                    return node.getName();
                }
                return node.getPath();
            }
            if (id == -1) {
                Integer personId = (Integer)this.fieldCollection.getFieldInternal(-6).getValue();
                if (personId == null) {
                    return null;
                }
                try {
                    return this.witContext.getMetadata().getConstantsTable().getConstantByID(personId);
                }
                catch (LookupFailedException ex) {
                    return null;
                }
            }
            return this.newValue;
        }
        return this.getOriginalValue();
    }

    @Override
    public void setValue(Object value) {
        this.setValue(null, value);
    }

    @Override
    public void setValue(Object source, Object data) {
        int id = this.fieldDefinition.getID();
        if (id == -7 || id == -105) {
            String inputPath = null;
            try {
                inputPath = (String)this.fieldDefinition.getTypeConverter().translate(data, WIValueSource.LOCAL);
            }
            catch (WITypeConverterException e) {
                throw new RuntimeException(e);
            }
            Node.TreeType treeType = id == -7 ? Node.TreeType.AREA : Node.TreeType.ITERATION;
            Object resolvedObject = this.workItem.getTypeInternal().getProjectInternal().resolvePath(inputPath, treeType);
            if (resolvedObject != null) {
                int resolvedId = resolvedObject instanceof Project ? ((Project)resolvedObject).getID() : ((Node)resolvedObject).getID();
                FieldImpl targetField = this.fieldCollection.getFieldInternal(id == -7 ? -2 : -104);
                targetField.setValue(source, new Integer(resolvedId));
                if (this.fieldStatus == FieldStatus.INVALID_PATH) {
                    this.fieldStatus = FieldStatus.VALID;
                    this.fireFieldChangeListeners(source);
                }
            } else if (this.fieldStatus != FieldStatus.INVALID_PATH) {
                log.trace((Object)MessageFormat.format("(non-rule) setting field [{0}] invalid: invalid path", Integer.toString(this.fieldDefinition.getID())));
                this.setStatus(FieldStatus.INVALID_PATH);
                this.fireFieldChangeListeners(source);
            }
        } else {
            this.setValue(source, data, FieldModificationType.USER);
        }
        this.workItem.fireStateListenersIfNeeded();
    }

    @Override
    public FieldStatus getStatus() {
        return this.fieldStatus;
    }

    @Override
    public WorkItem getWorkItem() {
        return this.workItem;
    }

    @Override
    public boolean isDirty() {
        int id = this.fieldDefinition.getID();
        if (id == 54) {
            return this.newValue != null;
        }
        if (!this.originalValueSet) {
            if (id == -7 || id == -12 || id == -42) {
                return this.fieldCollection.getFieldInternal(-2).isDirty();
            }
            if (id == -105) {
                return this.fieldCollection.getFieldInternal(-104).isDirty();
            }
            if (id == -1) {
                return this.fieldCollection.getFieldInternal(-6).isDirty();
            }
        }
        return this.newValueSet;
    }

    @Override
    public boolean isEditable() {
        int id = this.fieldDefinition.getID();
        if (id == -7) {
            return this.fieldCollection.getFieldInternal(-2).isEditable();
        }
        if (id == -105) {
            return this.fieldCollection.getFieldInternal(-104).isEditable();
        }
        if (id == 25 || id == 33) {
            return false;
        }
        if (this.fieldDefinition.isIgnored() || this.fieldDefinition.isReadonly()) {
            return false;
        }
        return !this.ruleReadOnly && this.serverComputedValueType == null;
    }

    @Override
    public FieldDefinition getFieldDefinition() {
        return this.fieldDefinition;
    }

    @Override
    public String getHelpText() {
        return this.helpText;
    }

    public String getNewValueAsString() {
        if (this.fieldStatus == FieldStatus.INVALID_TYPE) {
            return MessageFormat.format(Messages.getString("FieldImpl.WarningFieldIsInvalidWithStatusInvalidTypeFormat"), Integer.toString(this.getID()));
        }
        return this.fieldDefinition.getTypeConverter().toString(this.newValue);
    }

    public boolean isComputed() {
        return this.fieldDefinition.isComputed();
    }

    public void setOriginalValue(String value) {
        try {
            this.originalValue = this.fieldDefinition.getTypeConverter().translate(value, WIValueSource.SERVER);
        }
        catch (WITypeConverterException e) {
            log.warn((Object)MessageFormat.format("type conversion error setting original value \"{0}\" for field [{1}]", value, this.fieldDefinition.getReferenceName()), (Throwable)e);
        }
        this.originalValueSet = true;
    }

    public void setOriginalValueLocal(Object value) {
        if (value != null && !this.fieldDefinition.isValidType(value)) {
            throw new IllegalArgumentException(MessageFormat.format("the input value is of type [{0}], which is invalid for field [{1}] (System type [{2}])", value.getClass().getName(), Integer.toString(this.getID()), this.fieldDefinition.getSystemType().getName()));
        }
        this.originalValue = value;
        this.originalValueSet = true;
    }

    public FieldModificationType getModificationType() {
        return this.fieldModificationType;
    }

    public void setValue(Object value, FieldModificationType modificationType) {
        this.setValue(null, value, modificationType);
    }

    public void setValue(Object source, Object value, FieldModificationType modificationType) {
        FieldStatus invalidTypeStatus;
        boolean invalidType;
        block13: {
            invalidType = false;
            invalidTypeStatus = null;
            try {
                value = this.fieldDefinition.getTypeConverter().translate(value, modificationType == FieldModificationType.SERVER ? WIValueSource.SERVER : WIValueSource.LOCAL);
            }
            catch (WITypeConverterException ex) {
                invalidType = true;
                invalidTypeStatus = ex.getInvalidStatus();
                if (!ex.containsInvalidValue()) break block13;
                value = ex.getInvalidValue();
            }
        }
        boolean updated = false;
        if (this.newValueSet) {
            if (this.fieldDefinition.getID() != 54 && this.valuesEqual(this.originalValue, value)) {
                this.newValueSet = false;
                updated = true;
            } else if (!this.valuesEqual(this.newValue, value)) {
                this.newValue = value;
                updated = true;
            }
        } else if (!this.valuesEqual(this.originalValue, value)) {
            this.newValueSet = true;
            this.newValue = value;
            updated = true;
        }
        if (updated) {
            this.fieldModificationType = modificationType;
            this.fireFieldChangeListeners(source);
        }
        if (updated && modificationType == FieldModificationType.USER && !invalidType) {
            boolean updatedByRules = this.fireRules();
            if (!(updatedByRules || this.fieldStatus != FieldStatus.INVALID_TYPE && this.fieldStatus != FieldStatus.INVALID_DATE && this.fieldStatus != FieldStatus.INVALID_CHARACTERS)) {
                log.trace((Object)MessageFormat.format("(non-rule) setting field [{0}] valid since it was previously invalid due to a type conversion", Integer.toString(this.fieldDefinition.getID())));
                this.setStatus(FieldStatus.VALID);
                this.fireFieldChangeListeners(source);
            }
        } else if (invalidType && this.fieldStatus != invalidTypeStatus) {
            log.trace((Object)MessageFormat.format("(non-rule) setting field [{0}] invalid because of type conversion: {1}", Integer.toString(this.fieldDefinition.getID()), invalidTypeStatus.toString()));
            this.setStatus(invalidTypeStatus);
            this.fireFieldChangeListeners(source);
        }
    }

    private boolean fireRules() {
        RuleEngine ruleEngine = new RuleEngine(this.workItem, this.witContext);
        return ruleEngine.fieldChanged(this.fieldDefinition.getID());
    }

    private boolean valuesEqual(Object val1, Object val2) {
        return val1 == null ? val2 == null : val1.equals(val2);
    }

    @Override
    public void setStatus(FieldStatus status) {
        this.fieldStatus = status;
    }

    @Override
    public void overrideStatus(FieldStatus status) {
        this.setStatus(status);
        this.fireFieldChangeListeners();
        this.workItem.fireStateListenersIfNeeded();
    }

    public FieldDefinitionImpl getFieldDefinitionInternal() {
        return this.fieldDefinition;
    }

    public void resetAfterUpdate() {
        if (this.fieldDefinition.getID() == 54) {
            this.newValue = null;
        } else if (this.newValueSet) {
            this.serverComputedValueType = null;
            this.originalValue = this.newValue;
            this.newValueSet = false;
        }
    }

    public void reset() {
        if (this.fieldDefinition.getID() == 54) {
            this.newValue = null;
        }
        if (this.newValueSet) {
            this.serverComputedValueType = null;
            this.newValueSet = false;
            this.fieldStatus = FieldStatus.VALID;
        }
    }

    private boolean isLinkCountField() {
        int id = this.fieldDefinition.getID();
        return id == -32 || id == -57 || id == 75;
    }

    private Integer getAttachmentCount(boolean oldCount) {
        int count = this.workItem.getAttachmentsInternal().getCount(null, oldCount);
        return new Integer(count);
    }

    private Integer getLinkCount(boolean oldCount) {
        int id = this.fieldDefinition.getID();
        Class type = id == -32 ? Hyperlink.class : (id == -57 ? ExternalLink.class : RelatedLink.class);
        int count = this.workItem.getLinksInternal().getCount(type, oldCount);
        return new Integer(count);
    }

    public void fireFieldChangeListeners() {
        this.fireFieldChangeListeners(null);
    }

    public void fireFieldChangeListeners(Object source) {
        this.changeListeners.fireListeners(source);
    }

    @Override
    public boolean isNewValueSet() {
        return this.newValueSet;
    }

    @Override
    public void setReadOnly(boolean readOnly) {
        this.ruleReadOnly = readOnly;
    }

    @Override
    public void setServerComputed(ServerComputedFieldType serverComputedType) {
        this.serverComputedValueType = serverComputedType;
        this.newValueSet = true;
    }

    @Override
    public void setValueFromRule(Object value) {
        this.setValue(value, FieldModificationType.RULE);
    }

    @Override
    public IFieldPickListSupport getPickListSupport() {
        return this.pickListSupport;
    }

    @Override
    public ServerComputedFieldType getServerComputedType() {
        return this.serverComputedValueType;
    }

    @Override
    public void postProcessAfterRuleRun() {
        this.fireFieldChangeListeners();
    }

    @Override
    public void unsetNewValue() {
        this.newValueSet = false;
    }

    @Override
    public void setHelpText(String helpText) {
        this.helpText = helpText;
    }
}

