/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.workitem.internal.files;

import com.microsoft.tfs.core.Messages;
import com.microsoft.tfs.core.TFSTeamProjectCollection;
import com.microsoft.tfs.core.clients.workitem.exceptions.UnableToSaveException;
import com.microsoft.tfs.core.clients.workitem.files.DownloadException;
import com.microsoft.tfs.core.httpclient.HttpClient;
import com.microsoft.tfs.core.httpclient.methods.GetMethod;
import com.microsoft.tfs.core.httpclient.methods.PostMethod;
import com.microsoft.tfs.core.httpclient.methods.multipart.FilePart;
import com.microsoft.tfs.core.httpclient.methods.multipart.MultipartRequestEntity;
import com.microsoft.tfs.core.httpclient.methods.multipart.Part;
import com.microsoft.tfs.core.httpclient.methods.multipart.StringPart;
import com.microsoft.tfs.util.GUID;
import com.microsoft.tfs.util.tasks.TaskMonitor;
import com.microsoft.tfs.util.tasks.TaskMonitorService;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.text.MessageFormat;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AttachmentUpDownHelper {
    private static final int DOWNLOAD_BUFFER_SIZE = 2048;
    private static final Log log = LogFactory.getLog(AttachmentUpDownHelper.class);

    public static void download(URL attachmentUrl, File localTarget, TFSTeamProjectCollection connection) throws DownloadException {
        TaskMonitor taskMonitor = TaskMonitorService.getTaskMonitor();
        HttpClient httpClient = connection.getHTTPClient();
        GetMethod method = new GetMethod(attachmentUrl.toExternalForm());
        boolean cancelled = false;
        OutputStream outputStream = null;
        try {
            int len;
            int statusCode = httpClient.executeMethod(method);
            if (statusCode != 200) {
                throw new DownloadException(MessageFormat.format(Messages.getString("AttachmentUpDownHelper.ServerReturnedHTTPStatusFormat"), Integer.toString(statusCode)));
            }
            taskMonitor.begin(Messages.getString("AttachmentUpDownHelper.Downloading"), AttachmentUpDownHelper.computeTaskSize(method.getResponseContentLength()));
            InputStream input = method.getResponseBodyAsStream();
            outputStream = new FileOutputStream(localTarget);
            outputStream = new BufferedOutputStream(outputStream);
            byte[] buffer = new byte[2048];
            long totalBytesDownloaded = 0L;
            while ((len = input.read(buffer)) != -1) {
                outputStream.write(buffer, 0, len);
                taskMonitor.worked(1);
                taskMonitor.setCurrentWorkDescription(MessageFormat.format(Messages.getString("AttachmentUpDownHelper.DownloadedCountBytesFormat"), totalBytesDownloaded += (long)len));
                if (taskMonitor.isCanceled()) {
                    cancelled = true;
                    break;
                }
                Thread.sleep(10L);
            }
        }
        catch (Exception ex) {
            throw new DownloadException(ex);
        }
        finally {
            method.releaseConnection();
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException e) {}
            }
        }
        if (cancelled) {
            localTarget.delete();
        }
    }

    private static int computeTaskSize(long responseContentLength) {
        return (int)Math.ceil((double)responseContentLength / 2048.0);
    }

    public static String upload(String areaNodeUri, String projectUri, File fileToUpload, String uploadUrl, TFSTeamProjectCollection connection) throws UnableToSaveException {
        int status;
        String guid = GUID.newGUIDString();
        HttpClient httpClient = connection.getHTTPClient();
        Part[] parts = new Part[4];
        parts[0] = new StringPart("AreaNodeUri", areaNodeUri);
        parts[1] = new StringPart("ProjectUri", projectUri);
        parts[2] = new StringPart("FileNameGUID", guid);
        try {
            parts[3] = new FilePart("Content", "FileNameGUID", fileToUpload);
        }
        catch (FileNotFoundException ex) {
            throw new UnableToSaveException(MessageFormat.format(Messages.getString("AttachmentUpDownHelper.FileNotFoundFormat"), fileToUpload.getAbsolutePath()), ex);
        }
        PostMethod method = new PostMethod(uploadUrl);
        method.setRequestEntity(new MultipartRequestEntity(parts, method.getParams()));
        try {
            status = httpClient.executeMethod(method);
        }
        catch (Exception ex) {
            throw new UnableToSaveException(Messages.getString("AttachmentUpDownHelper.ErrorUploadingFile"), ex);
        }
        finally {
            method.releaseConnection();
        }
        if (status != 200) {
            throw new UnableToSaveException(MessageFormat.format(Messages.getString("AttachmentUpDownHelper.ServerReturnedHTTPStatusFormat"), Integer.toString(status)));
        }
        return guid;
    }
}

