/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.workitem.internal.form;

import com.microsoft.tfs.core.clients.workitem.form.WIFormLinksControlFilterOnEnum;
import com.microsoft.tfs.core.clients.workitem.form.WIFormLinksControlWILinkFilter;
import com.microsoft.tfs.core.clients.workitem.form.WIFormLinksControlWILinkFilterEnum;
import com.microsoft.tfs.core.clients.workitem.form.WIFormLinksControlWILinkFilters;
import com.microsoft.tfs.core.clients.workitem.internal.form.WIFormElementImpl;
import com.microsoft.tfs.core.clients.workitem.internal.form.WIFormLinksControlWILinkFilterEnumFactory;
import org.xml.sax.Attributes;

public class WIFormLinksControlWILinkFiltersImpl
extends WIFormElementImpl
implements WIFormLinksControlWILinkFilters {
    private WIFormLinksControlWILinkFilter[] filters;
    private WIFormLinksControlWILinkFilterEnum filterType;

    @Override
    void startLoading(Attributes attributes) {
        this.filterType = WIFormLinksControlWILinkFilterEnumFactory.fromType(attributes.getValue("FilterType"));
        this.setAttributes(attributes);
    }

    @Override
    void endLoading() {
        this.filters = (WIFormLinksControlWILinkFilter[])this.childrenToArray(new WIFormLinksControlWILinkFilter[0]);
    }

    @Override
    public WIFormLinksControlWILinkFilter[] getFilters() {
        return this.filters;
    }

    @Override
    public WIFormLinksControlWILinkFilterEnum getFilterType() {
        return this.filterType;
    }

    @Override
    public boolean includes(String linkReferenceName, boolean isForward, boolean isReverse) {
        if (this.filterType.equals(WIFormLinksControlWILinkFilterEnum.INCLUDEALL)) {
            return true;
        }
        if (this.filterType.equals(WIFormLinksControlWILinkFilterEnum.EXCLUDEALL)) {
            return false;
        }
        if (this.filterType.equals(WIFormLinksControlWILinkFilterEnum.EXCLUDE)) {
            WIFormLinksControlWILinkFilter filter = this.getFilterForReferenceName(linkReferenceName);
            if (filter == null) {
                return true;
            }
            WIFormLinksControlFilterOnEnum filterOn = filter.getLinksControlFilterOn();
            if (filterOn == null) {
                return false;
            }
            if (filterOn == WIFormLinksControlFilterOnEnum.FORWARDNAME) {
                return !isForward;
            }
            return !isReverse;
        }
        WIFormLinksControlWILinkFilter filter = this.getFilterForReferenceName(linkReferenceName);
        if (filter != null) {
            WIFormLinksControlFilterOnEnum filterOn = filter.getLinksControlFilterOn();
            if (filterOn == null) {
                return true;
            }
            if (filterOn == WIFormLinksControlFilterOnEnum.FORWARDNAME) {
                return isForward;
            }
            return isReverse;
        }
        return false;
    }

    private WIFormLinksControlWILinkFilter getFilterForReferenceName(String referenceName) {
        for (int i = 0; i < this.filters.length; ++i) {
            if (!referenceName.equalsIgnoreCase(this.filters[i].getLinkType())) continue;
            return this.filters[i];
        }
        return null;
    }
}

