/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.workitem.internal.link;

import com.microsoft.tfs.core.clients.workitem.WorkItem;
import com.microsoft.tfs.core.clients.workitem.internal.link.LinkImpl;
import com.microsoft.tfs.core.clients.workitem.internal.link.RegisteredLinkTypeImpl;
import com.microsoft.tfs.core.clients.workitem.link.Link;
import com.microsoft.tfs.core.clients.workitem.link.RelatedLink;
import com.microsoft.tfs.util.xml.DOMUtils;
import org.w3c.dom.Element;

public class RelatedLinkImpl
extends LinkImpl
implements RelatedLink {
    private WorkItem sourceWorkItem;
    private final int targetWorkItemId;
    private final int workItemLinkTypeId;
    private WorkItem targetWorkItem;

    public RelatedLinkImpl(WorkItem sourceWorkItem, int targetWorkItemId, int workItemLinkTypeId, String comment, boolean newComponent, boolean readOnly) {
        super(new RegisteredLinkTypeImpl("Related Workitem"), comment, -1, newComponent, readOnly);
        this.sourceWorkItem = sourceWorkItem;
        this.targetWorkItemId = targetWorkItemId;
        this.workItemLinkTypeId = workItemLinkTypeId;
    }

    @Override
    public LinkImpl cloneLink() {
        return new RelatedLinkImpl(this.sourceWorkItem, this.targetWorkItemId, this.workItemLinkTypeId, this.getComment(), true, this.isReadOnly());
    }

    @Override
    public WorkItem getSourceWorkItem() {
        return this.sourceWorkItem;
    }

    @Override
    public int getTargetWorkItemID() {
        return this.targetWorkItemId;
    }

    @Override
    public int getWorkItemLinkTypeID() {
        return this.workItemLinkTypeId;
    }

    @Override
    public WorkItem getTargetWorkItem() {
        return this.targetWorkItem;
    }

    @Override
    public void setSourceWorkItem(WorkItem value) {
        this.sourceWorkItem = value;
    }

    public void setWorkItem(WorkItem value) {
        this.targetWorkItem = value;
    }

    @Override
    public boolean isEquivalent(Link link) {
        if (link instanceof RelatedLinkImpl) {
            RelatedLinkImpl other = (RelatedLinkImpl)link;
            return this.sourceWorkItem.getID() == other.sourceWorkItem.getID() && this.targetWorkItemId == other.targetWorkItemId && this.workItemLinkTypeId == other.workItemLinkTypeId;
        }
        return false;
    }

    @Override
    protected String getFallbackDescription() {
        return String.valueOf(this.targetWorkItemId);
    }

    @Override
    protected void createXMLForAdd(Element parentElement) {
        Element element;
        if (this.workItemLinkTypeId == 0) {
            element = DOMUtils.appendChild(parentElement, "CreateRelation");
            element.setAttribute("WorkItemID", String.valueOf(this.targetWorkItemId));
        } else {
            Element rootElement = DOMUtils.getRootElement(parentElement);
            int sourceWorkItemId = this.sourceWorkItem.getID() == 0 ? this.sourceWorkItem.getTemporaryID() : this.sourceWorkItem.getID();
            element = DOMUtils.appendChild(rootElement, "InsertWorkItemLink");
            element.setAttribute("SourceID", String.valueOf(sourceWorkItemId));
            element.setAttribute("TargetID", String.valueOf(this.targetWorkItemId));
            element.setAttribute("LinkType", String.valueOf(this.workItemLinkTypeId));
            element.setAttribute("AutoMerge", String.valueOf(true));
        }
        if (this.getComment() != null && this.getComment().trim().length() > 0) {
            element.setAttribute("Comment", this.getComment().trim());
        }
    }

    @Override
    protected void createXMLForRemove(Element parentElement) {
        if (this.workItemLinkTypeId == 0) {
            Element element = DOMUtils.appendChild(parentElement, "RemoveRelation");
            element.setAttribute("WorkItemID", String.valueOf(this.targetWorkItemId));
        } else {
            Element rootElement = DOMUtils.getRootElement(parentElement);
            int sourceWorkItemId = this.sourceWorkItem.getID() == 0 ? this.sourceWorkItem.getTemporaryID() : this.sourceWorkItem.getID();
            Element element = DOMUtils.appendChild(rootElement, "DeleteWorkItemLink");
            element.setAttribute("SourceID", String.valueOf(sourceWorkItemId));
            element.setAttribute("TargetID", String.valueOf(this.targetWorkItemId));
            element.setAttribute("LinkType", String.valueOf(this.workItemLinkTypeId));
            element.setAttribute("AutoMerge", String.valueOf(true));
        }
    }

    @Override
    protected String getInsertTagName() {
        return null;
    }
}

