/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.workitem.internal.links;

import com.microsoft.tfs.core.clients.workitem.WorkItem;
import com.microsoft.tfs.core.clients.workitem.exceptions.UnableToSaveException;
import com.microsoft.tfs.core.clients.workitem.internal.WorkItemImpl;
import com.microsoft.tfs.core.clients.workitem.internal.links.WITComponent;
import com.microsoft.tfs.core.clients.workitem.internal.update.ElementHandler;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.w3c.dom.Element;

public abstract class WITComponentCollection<T> {
    private final Set<T> components = new HashSet<T>();
    private final WorkItemImpl workItem;

    protected WITComponentCollection(WorkItemImpl workItem) {
        this.workItem = workItem;
    }

    public void preSave() throws UnableToSaveException {
    }

    public final WorkItem getWorkItem() {
        return this.workItem;
    }

    public final Set<T> getComponentSet() {
        return this.components;
    }

    public final WorkItemImpl getWorkItemInternal() {
        return this.workItem;
    }

    protected final boolean containsEquivalent(WITComponent component) {
        for (WITComponent collectionComponent : this.components) {
            if (collectionComponent.isPendingDelete() || !collectionComponent.isEquivalentTo(component)) continue;
            return true;
        }
        return false;
    }

    protected final boolean addComponent(WITComponent component) {
        if (component.isNewlyCreated()) {
            if (this.components.contains(component)) {
                return false;
            }
            if (this.containsEquivalent(component)) {
                return false;
            }
        }
        component.associate(this);
        this.possiblyChangedDirtyState();
        return true;
    }

    protected final Object[] getPublicComponents(Object[] arrayType) {
        HashSet<T> returnedComponents = new HashSet<T>();
        for (T component : this.components) {
            WITComponent witComponent = (WITComponent)component;
            if (!witComponent.shouldIncludeAsPartOfPublicCollection()) continue;
            returnedComponents.add(component);
        }
        return returnedComponents.toArray(arrayType);
    }

    public final int getCount(Class<WITComponent> type, boolean oldCount) {
        int count = 0;
        for (T component : this.components) {
            if (type != null && !type.isAssignableFrom(component.getClass())) continue;
            WITComponent witComponent = (WITComponent)component;
            if ((!oldCount || !witComponent.shouldIncludeInOldCount()) && (oldCount || !witComponent.shouldIncludeInNewCount())) continue;
            ++count;
        }
        return count;
    }

    public final ElementHandler[] addUpdateXML(Element parentElement) {
        ArrayList<ElementHandler> elementHandlers = new ArrayList<ElementHandler>();
        for (T component : this.components) {
            WITComponent witComponent = (WITComponent)component;
            ElementHandler handler = witComponent.createXMLForUpdatePackage(parentElement);
            if (handler == null) continue;
            elementHandlers.add(handler);
        }
        return elementHandlers.toArray(new ElementHandler[0]);
    }

    public final void update() {
        HashSet<T> copy = new HashSet<T>(this.components);
        for (Object component : copy) {
            WITComponent witComponent = (WITComponent)component;
            witComponent.update();
        }
    }

    public void reset() {
        HashSet<T> copy = new HashSet<T>(this.components);
        for (Object component : copy) {
            WITComponent witComponent = (WITComponent)component;
            witComponent.reset();
        }
    }

    protected final void removeComponent(WITComponent component) {
        if (!this.components.contains(component)) {
            throw new IllegalArgumentException("this collection does not contain the specified component");
        }
        component.delete();
        this.possiblyChangedDirtyState();
    }

    public final boolean isDirty() {
        for (T component : this.components) {
            WITComponent witComponent = (WITComponent)component;
            if (!witComponent.isDirty()) continue;
            return true;
        }
        return false;
    }

    public final void possiblyChangedDirtyState() {
        this.workItem.fireStateListenersIfNeeded();
    }

    public void internalClear() {
        this.components.clear();
    }
}

