/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.workitem.internal.metadata.impl;

import com.microsoft.tfs.core.Messages;
import com.microsoft.tfs.core.clients.workitem.internal.metadata.dao.ConstantMetadata;
import com.microsoft.tfs.core.clients.workitem.internal.metadata.dao.ConstantsTable;
import com.microsoft.tfs.core.clients.workitem.internal.metadata.dao.LookupFailedException;
import com.microsoft.tfs.core.clients.workitem.internal.metadata.impl.BaseMetadataDAO;
import com.microsoft.tfs.core.internal.db.ResultHandler;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;

public class ConstantsTableImpl
extends BaseMetadataDAO
implements ConstantsTable {
    @Override
    public ConstantMetadata getConstantByString(final String string) {
        final ConstantMetadata[] constantMetadata = new ConstantMetadata[1];
        this.getConnection().createStatement("select ConstID,DisplayName,String from Constants where lower(String) = lower(?)").executeQuery(new Object[]{string}, new ResultHandler(){

            @Override
            public void handleRow(ResultSet rset) throws SQLException {
                if (constantMetadata[0] != null) {
                    throw new IllegalStateException(MessageFormat.format("constant [{0}] returned more than one result", string));
                }
                constantMetadata[0] = ConstantMetadata.fromRow(rset);
            }
        });
        return constantMetadata[0];
    }

    @Override
    public String getConstantByID(int id) {
        Object[] results = this.getConnection().createStatement("select String, DisplayName from Constants where ConstID = ?").executeMultiColumnQuery(new Integer(id));
        if (results == null) {
            throw new LookupFailedException(MessageFormat.format(Messages.getString("ConstantsTableImpl.NoConstantExistsWithConstIDFormat"), Integer.toString(id)));
        }
        return (String)(results[1] != null ? results[1] : results[0]);
    }

    @Override
    public Integer getIDByConstant(String constant) {
        return this.getConnection().createStatement("select ConstID from Constants where lower(String) = lower(?)").executeIntQuery(new Object[]{constant});
    }

    @Override
    public String[] getUserGroupDisplayNames(final String serverGuid, final String projectGuid) {
        final HashSet set = new HashSet();
        String sql = "select ConstID from ConstantSets where ParentId = -1 and fDeleted = 0 and ConstID not in (select ConstID From ConstantSets where ParentId = -2 and fDeleted = 0)";
        this.getConnection().createStatement("select ConstID from ConstantSets where ParentId = -1 and fDeleted = 0 and ConstID not in (select ConstID From ConstantSets where ParentId = -2 and fDeleted = 0)").executeQuery(new Object[0], new ResultHandler(){

            @Override
            public void handleRow(ResultSet rset) throws SQLException {
                set.add(new Integer(rset.getInt(1)));
            }
        });
        boolean needComma = false;
        StringBuffer sb = new StringBuffer("(");
        Iterator it = set.iterator();
        while (it.hasNext()) {
            if (needComma) {
                sb.append(",");
            }
            sb.append((Integer)it.next());
            needComma = true;
        }
        sb.append(")");
        String SQL = "select ConstID, String, DisplayName from Constants where ConstID in " + sb.toString();
        final ArrayList displayNames = new ArrayList();
        this.getConnection().createStatement(SQL).executeQuery(new ResultHandler(){

            @Override
            public void handleRow(ResultSet rset) throws SQLException {
                rset.getInt(1);
                String string = rset.getString(2);
                String displayName = rset.getString(3);
                if (string.indexOf(serverGuid) >= 0 || string.indexOf(projectGuid) >= 0) {
                    displayNames.add(displayName != null ? displayName : string);
                }
            }
        });
        Object[] values = displayNames.toArray(new String[displayNames.size()]);
        Arrays.sort(values);
        return values;
    }
}

