/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.workitem.internal.node;

import com.microsoft.tfs.core.artifact.ArtifactID;
import com.microsoft.tfs.core.clients.workitem.internal.WITContext;
import com.microsoft.tfs.core.clients.workitem.internal.metadata.dao.NodeMetadata;
import com.microsoft.tfs.core.clients.workitem.internal.node.NodeCollectionImpl;
import com.microsoft.tfs.core.clients.workitem.internal.node.NodePathUtils;
import com.microsoft.tfs.core.clients.workitem.node.Node;
import com.microsoft.tfs.core.clients.workitem.node.NodeCollection;
import com.microsoft.tfs.util.GUID;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;

public class NodeImpl
implements Node {
    private final WITContext witContext;
    private final NodeMetadata nodeMetadata;
    private final NodeImpl parentNode;
    private NodeCollectionImpl childNodes;

    public NodeImpl(NodeMetadata nodeMetadata, NodeImpl parentNode, WITContext witContext) {
        this.nodeMetadata = nodeMetadata;
        this.parentNode = parentNode;
        this.witContext = witContext;
    }

    public String toString() {
        return MessageFormat.format("node: {0} ({1})", Integer.toString(this.nodeMetadata.getID()), this.nodeMetadata.getName());
    }

    @Override
    public String getURI() {
        String artifactType = null;
        artifactType = this.isProjectNode() ? "TeamProject" : "Node";
        ArtifactID artifactId = new ArtifactID("Classification", artifactType, this.nodeMetadata.getGUID().getGUIDString());
        return artifactId.encodeURI();
    }

    @Override
    public synchronized NodeCollection getChildNodes() {
        if (this.childNodes == null) {
            NodeMetadata[] childNodesMetadata = this.witContext.getMetadata().getHierarchyTable().getNodesWithParentID(this.nodeMetadata.getID());
            HashSet<Node> childNodeSet = new HashSet<Node>();
            for (int i = 0; i < childNodesMetadata.length; ++i) {
                NodeImpl childNode = new NodeImpl(childNodesMetadata[i], this, this.witContext);
                childNodeSet.add(childNode);
            }
            this.childNodes = new NodeCollectionImpl(childNodeSet);
        }
        return this.childNodes;
    }

    @Override
    public int getID() {
        return this.nodeMetadata.getID();
    }

    @Override
    public GUID getGUID() {
        return this.nodeMetadata.getGUID();
    }

    @Override
    public String getName() {
        return this.nodeMetadata.getName();
    }

    @Override
    public Node getParent() {
        if (this.parentNode != null && this.parentNode.isAreaOrIterationRootNode()) {
            return null;
        }
        return this.parentNode;
    }

    @Override
    public String getPath() {
        if (this.isProjectNode()) {
            return this.nodeMetadata.getName();
        }
        ArrayList<String> segments = new ArrayList<String>();
        NodeImpl currentNode = this;
        while (!currentNode.isRootNode()) {
            if (!currentNode.isAreaOrIterationRootNode()) {
                segments.add(0, currentNode.getName());
            }
            currentNode = currentNode.getParentInternal();
        }
        return NodePathUtils.createPathFromSegments(segments.toArray(new String[0]), 0);
    }

    @Override
    public int compareTo(Node o) {
        return this.getName().compareToIgnoreCase(o.getName());
    }

    public NodeImpl findFirstChildOfStructureType(int structureType) {
        Iterator<Node> it = this.getChildNodes().iterator();
        while (it.hasNext()) {
            Node child = it.next();
            if (((NodeImpl)child).getStructureType() != structureType) continue;
            return (NodeImpl)child;
        }
        throw new IllegalStateException(MessageFormat.format("unable to find any child node of [{0}] with structure type [{1}]", this, structureType));
    }

    public NodeImpl findNodeDownwards(String path, boolean includeThisNode, int structureType) {
        String[] pathSegments = NodePathUtils.splitPathIntoSegments(path);
        if (pathSegments.length == 0) {
            return null;
        }
        int startingIx = 0;
        if (includeThisNode) {
            if (!pathSegments[0].equalsIgnoreCase(this.nodeMetadata.getName())) {
                return null;
            }
            startingIx = 1;
        }
        NodeImpl currentNode = this;
        for (int i = startingIx; i < pathSegments.length; ++i) {
            NodeImpl childNode;
            if (currentNode.isProjectNode() && (structureType == 1 || structureType == 2)) {
                currentNode = currentNode.findFirstChildOfStructureType(structureType);
            }
            if ((childNode = currentNode.getChildNodesInternal().getByNameInternal(pathSegments[i])) == null) {
                return null;
            }
            currentNode = childNode;
        }
        return currentNode;
    }

    public NodeImpl findNodeDownwards(int id) {
        Node child;
        if (this.nodeMetadata.getID() == id) {
            return this;
        }
        Iterator<Node> it = this.getChildNodes().iterator();
        while (it.hasNext()) {
            child = it.next();
            if (!(child instanceof NodeImpl) || ((NodeImpl)child).nodeMetadata.getID() != id) continue;
            return (NodeImpl)child;
        }
        it = this.getChildNodes().iterator();
        while (it.hasNext()) {
            NodeImpl target;
            child = it.next();
            if (!(child instanceof NodeImpl) || (target = ((NodeImpl)child).findNodeDownwards(id)) == null || !(target instanceof NodeImpl)) continue;
            return target;
        }
        return null;
    }

    public NodeImpl getProjectNodeParent() {
        if (this.isProjectNode()) {
            return this;
        }
        if (this.isRootNode()) {
            throw new IllegalStateException("getProjectNodeParent is illegal for root node");
        }
        return this.parentNode.getProjectNodeParent();
    }

    private boolean isProjectNode() {
        return this.nodeMetadata.getNodeType() == -42;
    }

    private boolean isAreaOrIterationRootNode() {
        return this.parentNode != null && this.parentNode.isProjectNode();
    }

    private boolean isRootNode() {
        return this.parentNode == null;
    }

    public int getStructureType() {
        return this.nodeMetadata.getStructureType();
    }

    public NodeCollectionImpl getChildNodesInternal() {
        return (NodeCollectionImpl)this.getChildNodes();
    }

    public NodeImpl getParentInternal() {
        return this.parentNode;
    }
}

