/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.workitem.internal.rowset;

import com.microsoft.tfs.core.clients.workitem.internal.WITContext;
import com.microsoft.tfs.core.clients.workitem.internal.project.ProjectImpl;
import com.microsoft.tfs.core.clients.workitem.internal.query.StoredQueryImpl;
import com.microsoft.tfs.core.clients.workitem.internal.rowset.BaseRowSetHandler;
import com.microsoft.tfs.core.clients.workitem.project.ProjectCollection;
import com.microsoft.tfs.core.clients.workitem.query.QueryScope;
import com.microsoft.tfs.util.GUID;
import java.util.HashSet;
import java.util.Set;

public class GetStoredQueriesRowSetHandler
extends BaseRowSetHandler {
    private final WITContext witContext;
    private final Set<StoredQueryImpl> storedQueries = new HashSet<StoredQueryImpl>();

    public GetStoredQueriesRowSetHandler(WITContext witContext) {
        this.witContext = witContext;
    }

    @Override
    public void handleBeginParsing() {
        super.handleBeginParsing();
        this.storedQueries.clear();
    }

    @Override
    protected void doHandleRow() {
        QueryScope queryScope = this.getBooleanValue("fPublic") ? QueryScope.PUBLIC : QueryScope.PRIVATE;
        int projectId = this.getIntValue("ProjectID");
        ProjectImpl project = null;
        if (projectId != 0) {
            ProjectCollection projects = this.witContext.getClient().getProjects();
            for (ProjectImpl currentProject : projects) {
                if (currentProject.getID() != projectId) continue;
                project = currentProject;
                break;
            }
        }
        GUID id = new GUID(this.getStringValue("ID"));
        StoredQueryImpl query = new StoredQueryImpl(id, this.getStringValue("QueryName"), this.getStringValue("QueryText"), this.getStringValue("Description"), this.getStringValue("Owner"), this.getDateValue("CreateTime"), this.getDateValue("LastWriteTime"), queryScope, projectId, project, this.getBooleanValue("fDeleted"), this.getLongValue("CacheStamp"), this.witContext.getQueryProvider(), this.witContext);
        this.storedQueries.add(query);
    }

    public StoredQueryImpl[] getQueries() {
        return this.storedQueries.toArray(new StoredQueryImpl[0]);
    }
}

