/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.workitem.internal.type;

import com.microsoft.tfs.core.clients.workitem.internal.type.WITypeConverter;
import com.microsoft.tfs.core.clients.workitem.internal.type.WITypeConverterException;
import com.microsoft.tfs.core.clients.workitem.internal.type.WIValueSource;
import java.text.MessageFormat;

public class WIIntegerTypeConverter
implements WITypeConverter {
    @Override
    public Object translate(Object input, WIValueSource valueSource) throws WITypeConverterException {
        Integer translatedValue = null;
        if (input != null) {
            if (input instanceof Integer) {
                translatedValue = (Integer)input;
            } else if (input instanceof String) {
                String trimmed = ((String)input).trim();
                if (trimmed.length() == 0) {
                    return null;
                }
                try {
                    translatedValue = Integer.valueOf(trimmed);
                }
                catch (NumberFormatException ex) {
                    throw new WITypeConverterException("unable to convert input to an int", ex);
                }
            } else {
                throw new WITypeConverterException(MessageFormat.format("unable to convert [{0}] to an int", input.getClass().getName()));
            }
        }
        return translatedValue;
    }

    @Override
    public String toString(Object data) {
        if (data == null) {
            return null;
        }
        return data.toString();
    }
}

