/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.workitem.internal.type;

import com.microsoft.tfs.core.clients.workitem.fields.FieldStatus;
import com.microsoft.tfs.core.clients.workitem.internal.type.WITypeConverter;
import com.microsoft.tfs.core.clients.workitem.internal.type.WITypeConverterException;
import com.microsoft.tfs.core.clients.workitem.internal.type.WIValueSource;

public class WIStringTypeConverter
implements WITypeConverter {
    private final boolean isLargeText;
    private final boolean trimOnTranslate;

    public WIStringTypeConverter(boolean isLargeText, boolean trimOnTranslate) {
        this.isLargeText = isLargeText;
        this.trimOnTranslate = trimOnTranslate;
    }

    @Override
    public Object translate(Object data, WIValueSource valueSource) {
        String translatedValue = null;
        if (data != null) {
            if (data instanceof String) {
                translatedValue = (String)data;
                if (this.trimOnTranslate) {
                    translatedValue = translatedValue.trim();
                }
                if (translatedValue.length() == 0) {
                    translatedValue = null;
                }
            } else {
                translatedValue = String.valueOf(data);
            }
        }
        if (translatedValue != null && !WIStringTypeConverter.isValidFieldValueString(translatedValue, this.isLargeText)) {
            throw new WITypeConverterException("translated value string contains invalid characters (likely control, whitespace, or invalid surrogate pairs)", FieldStatus.INVALID_CHARACTERS, translatedValue);
        }
        return translatedValue;
    }

    @Override
    public String toString(Object data) {
        return (String)data;
    }

    private static boolean isValidFieldValueString(String s, boolean isLongText) {
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (Character.isISOControl(c) && (!isLongText || c != '\r' && c != '\n' && c != '\t')) {
                return false;
            }
            if (Character.isLowSurrogate(c)) {
                return false;
            }
            if (!Character.isHighSurrogate(c)) continue;
            if (++i == s.length()) {
                return false;
            }
            if (Character.isLowSurrogate(s.charAt(i))) continue;
            return false;
        }
        return true;
    }
}

