/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.workitem.internal.update;

import com.microsoft.tfs.core.clients.webservices.IdentityDescriptor;
import com.microsoft.tfs.core.clients.workitem.internal.WITContext;
import com.microsoft.tfs.core.clients.workitem.internal.update.BaseUpdatePackage;
import com.microsoft.tfs.core.clients.workitem.queryhierarchy.QueryDefinition;
import com.microsoft.tfs.core.clients.workitem.queryhierarchy.QueryItem;
import com.microsoft.tfs.core.ws.runtime.types.DOMAnyContentType;
import com.microsoft.tfs.util.GUID;
import com.microsoft.tfs.util.xml.DOMUtils;
import org.w3c.dom.Element;

public class UpdateQueryItemUpdatePackage
extends BaseUpdatePackage {
    public UpdateQueryItemUpdatePackage(WITContext context, QueryItem queryItem) {
        super(context);
        UpdateQueryItemUpdatePackage.populate(this.getRoot(), queryItem);
    }

    static final Element populate(Element parent, QueryItem queryItem) {
        Element queryElement = DOMUtils.appendChild(parent, "UpdateQueryItem");
        queryElement.setAttribute("QueryID", queryItem.getID().getGUIDString(GUID.GUIDStringFormat.NONE));
        if (queryItem.getParent() != queryItem.getOriginalParent()) {
            queryElement.setAttribute("QueryParentID", queryItem.getParent().getID().getGUIDString(GUID.GUIDStringFormat.NONE));
        }
        if (!queryItem.getName().equals(queryItem.getOriginalName())) {
            DOMUtils.appendChildWithText(queryElement, "Name", queryItem.getName());
        }
        IdentityDescriptor owner = queryItem.getOwnerDescriptor();
        IdentityDescriptor originalOwner = queryItem.getOriginalOwnerDescriptor();
        if (owner != null && !owner.equals(originalOwner) || owner == null && originalOwner != null) {
            String ownerIdentifier = owner == null ? "" : owner.getIdentifier();
            String ownerIdentityType = owner == null ? "" : owner.getIdentityType();
            DOMUtils.appendChildWithText(queryElement, "OwnerIdentifier", ownerIdentifier);
            DOMUtils.appendChildWithText(queryElement, "OwnerType", ownerIdentityType);
        }
        if (queryItem instanceof QueryDefinition && !((QueryDefinition)queryItem).getQueryText().equals(((QueryDefinition)queryItem).getOriginalQueryText())) {
            DOMUtils.appendChildWithText(queryElement, "QueryText", ((QueryDefinition)queryItem).getQueryText());
        }
        return queryElement;
    }

    @Override
    protected void handleUpdateResponse(DOMAnyContentType response) {
    }
}

