/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.workitem.internal.wiqlparse;

import com.microsoft.tfs.core.clients.workitem.exceptions.WorkItemException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;

public class DateTime {
    private static final String ROUNDTRIP_FORMAT_UNIVERSAL = "yyyy-MM-dd'T'HH:mm:ss.S'Z'";
    private static final String ROUNDTRIP_FORMAT_LOCAL = "yyyy-MM-dd'T'HH:mm:ss.S z";
    private static final String ROUNDTRIP_FORMAT_UNSPECIFIED = "yyyy-MM-dd'T'HH:mm:ss.S";

    public static Date today(TimeZone timeZone) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeZone(timeZone);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static String formatRoundTripUniversal(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat(ROUNDTRIP_FORMAT_UNIVERSAL);
        sdf.setTimeZone(DateTime.getUniversalTimeZone());
        return sdf.format(date);
    }

    public static String formatRoundTripLocal(Date date, TimeZone timeZone) {
        SimpleDateFormat sdf = new SimpleDateFormat(ROUNDTRIP_FORMAT_LOCAL);
        sdf.setTimeZone(timeZone);
        return sdf.format(date);
    }

    public static String formatRoundTripUnspecified(Date date, TimeZone timeZone) {
        SimpleDateFormat sdf = new SimpleDateFormat(ROUNDTRIP_FORMAT_UNSPECIFIED);
        sdf.setTimeZone(timeZone);
        return sdf.format(date);
    }

    public static Date parse(String input, Locale locale, TimeZone timeZone) {
        DateFormat[] formats = DateTime.createDateFormatsForLocaleAndTimeZone(locale, timeZone);
        return DateTime.parseWithFormats(input, formats);
    }

    public static Date parseRoundtripFormat(String input, TimeZone timeZone) {
        ArrayList<DateFormat> formats = new ArrayList<DateFormat>();
        DateTime.addRoundtripFormats(formats, timeZone);
        return DateTime.parseWithFormats(input, formats.toArray(new DateFormat[formats.size()]));
    }

    private static Date parseWithFormats(String input, DateFormat[] formats) {
        input = DateTime.massageDateTimeString(input);
        for (int i = 0; i < formats.length; ++i) {
            try {
                return formats[i].parse(input);
            }
            catch (ParseException parseException) {
                continue;
            }
        }
        throw new UncheckedParseException(input);
    }

    private static String massageDateTimeString(String input) {
        if (input.length() > 6) {
            boolean dotNetLocalTZFormat;
            String possibleTZSuffix = input.substring(input.length() - 6);
            boolean bl = dotNetLocalTZFormat = possibleTZSuffix.charAt(0) == '-' && Character.isDigit(possibleTZSuffix.charAt(1)) && Character.isDigit(possibleTZSuffix.charAt(2)) && possibleTZSuffix.charAt(3) == ':' && Character.isDigit(possibleTZSuffix.charAt(4)) && Character.isDigit(possibleTZSuffix.charAt(5));
            if (dotNetLocalTZFormat) {
                return input.substring(0, input.length() - 6) + " GMT" + possibleTZSuffix;
            }
        }
        return input;
    }

    private static DateFormat[] createDateFormatsForLocaleAndTimeZone(Locale locale, TimeZone timeZone) {
        int dateStyle;
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if (timeZone == null) {
            timeZone = TimeZone.getDefault();
        }
        ArrayList<DateFormat> formats = new ArrayList<DateFormat>();
        DateTime.addRoundtripFormats(formats, timeZone);
        for (dateStyle = 0; dateStyle <= 3; ++dateStyle) {
            for (int timeStyle = 0; timeStyle <= 3; ++timeStyle) {
                DateFormat df = DateFormat.getDateTimeInstance(dateStyle, timeStyle, locale);
                if (timeZone != null) {
                    df.setTimeZone(timeZone);
                }
                formats.add(df);
            }
        }
        for (dateStyle = 0; dateStyle <= 3; ++dateStyle) {
            DateFormat df = DateFormat.getDateInstance(dateStyle, locale);
            df.setTimeZone(timeZone);
            formats.add(df);
        }
        return formats.toArray(new DateFormat[formats.size()]);
    }

    private static void addRoundtripFormats(List<DateFormat> formats, TimeZone timeZone) {
        SimpleDateFormat sdf = new SimpleDateFormat(ROUNDTRIP_FORMAT_UNIVERSAL);
        sdf.setTimeZone(DateTime.getUniversalTimeZone());
        formats.add(sdf);
        sdf = new SimpleDateFormat(ROUNDTRIP_FORMAT_LOCAL);
        formats.add(sdf);
        sdf = new SimpleDateFormat(ROUNDTRIP_FORMAT_UNSPECIFIED);
        sdf.setTimeZone(timeZone);
        formats.add(sdf);
    }

    private static TimeZone getUniversalTimeZone() {
        return TimeZone.getTimeZone("UTC");
    }

    public static class UncheckedParseException
    extends WorkItemException {
        private static final long serialVersionUID = -4518926626595967173L;

        public UncheckedParseException(String message) {
            super(message);
        }
    }
}

