/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.workitem.internal.wiqlparse;

import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.DataType;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.IExternal;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.Node;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.NodeBoolConst;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.NodeFieldName;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.NodeTableName;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.NodeType;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.Priority;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.SyntaxError;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.Tools;

public class NodeNotOperator
extends Node {
    private Node child;

    public NodeNotOperator() {
        super(NodeType.NOT);
    }

    public NodeNotOperator(Node node) {
        super(NodeType.NOT);
        this.child = node;
    }

    @Override
    public void bind(IExternal e, NodeTableName tableContext, NodeFieldName fieldContext) {
        this.getValue().bind(e, tableContext, fieldContext);
        Tools.ensureSyntax(this.getValue().getDataType() == DataType.BOOL, SyntaxError.EXPECTING_BOOLEAN, this);
        super.bind(e, tableContext, fieldContext);
    }

    @Override
    public Node optimize(IExternal e, NodeTableName tableContext, NodeFieldName fieldContext) {
        this.setValue(this.getValue().optimize(e, tableContext, fieldContext));
        if (this.getValue().getNodeType() == NodeType.BOOL_CONST) {
            return new NodeBoolConst(!((NodeBoolConst)this.getValue()).getValue());
        }
        if (this.getValue().getNodeType() == NodeType.NOT) {
            return ((NodeNotOperator)this.getValue()).getValue();
        }
        return super.optimize(e, tableContext, fieldContext);
    }

    @Override
    public void appendTo(StringBuffer b) {
        b.append("not ");
        super.appendChildren(b, "");
    }

    @Override
    public int getCount() {
        return 1;
    }

    @Override
    public DataType getDataType() {
        return DataType.BOOL;
    }

    @Override
    public boolean isConst() {
        return this.child.isConst();
    }

    @Override
    public boolean isScalar() {
        return false;
    }

    @Override
    public Node getItem(int i) {
        return this.child;
    }

    @Override
    public void setItem(int i, Node value) {
        this.child = value;
    }

    @Override
    public Priority getPriority() {
        return Priority.UNARY_BOOL_OPERATOR;
    }

    public Node getValue() {
        return this.child;
    }

    public void setValue(Node value) {
        this.child = value;
    }
}

