/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.workitem.internal.wittype;

import com.microsoft.tfs.core.clients.workitem.internal.metadata.IMetadata;
import java.util.HashMap;
import java.util.Map;

public class NextStateCache {
    private final Map<Key, String> cache = new HashMap<Key, String>();
    private final int workItemTypeId;
    private final IMetadata metadata;

    public NextStateCache(int workItemTypeId, IMetadata metadata) {
        this.workItemTypeId = workItemTypeId;
        this.metadata = metadata;
    }

    public synchronized String getNextState(String currentState, String action) {
        Key key = new Key(currentState, action);
        if (!this.cache.containsKey(key)) {
            this.cache.put(key, this.computeNextState(currentState, action));
        }
        return this.cache.get(key);
    }

    public synchronized void clearCache() {
        this.cache.clear();
    }

    private String computeNextState(String currentState, String action) {
        return this.metadata.getActionsTable().getNextStateForAction(currentState, action, this.workItemTypeId);
    }

    private static class Key {
        private final String currentState;
        private final String action;

        public Key(String currentState, String action) {
            this.currentState = currentState;
            this.action = action;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof Key) {
                Key key = (Key)obj;
                return this.currentState.equals(key.currentState) && this.action.equals(key.action);
            }
            return false;
        }

        public int hashCode() {
            return this.currentState.hashCode() + this.action.hashCode();
        }
    }
}

