/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.workitem.link;

public class Topology {
    private static final int TOPOLOGY_MASK = 28;
    private static final int UNKNOWN_VALUE = -1;
    private static final int NETWORK_VALUE = 0;
    private static final int DIRECTED_NETWORK_VALUE = 4;
    private static final int DEPENDENCY_VALUE = 12;
    private static final int TREE_VALUE = 28;
    public static final Topology UNKNOWN = new Topology("Unknown", -1);
    public static final Topology NETWORK = new Topology("Network", 0);
    public static final Topology DIRECTED_NETWORK = new Topology("DirectedNetwork", 4);
    public static final Topology DEPENDENCY = new Topology("Dependency", 12);
    public static final Topology TREE = new Topology("Tree", 28);
    private final String name;
    private final int value;

    private Topology(String name, int value) {
        this.name = name;
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public int getValue() {
        return this.value;
    }

    public int hashCode() {
        return this.value;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Topology other = (Topology)obj;
        return this.value == other.value;
    }

    public static Topology getTopology(int topology) {
        switch (topology & 0x1C) {
            case 0: {
                return NETWORK;
            }
            case 4: {
                return DIRECTED_NETWORK;
            }
            case 12: {
                return DEPENDENCY;
            }
            case 28: {
                return TREE;
            }
        }
        return UNKNOWN;
    }
}

