/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.config.httpclient.internal;

import com.microsoft.tfs.core.config.EnvironmentVariables;
import com.microsoft.tfs.core.config.httpclient.internal.DefaultX509TrustManager;
import com.microsoft.tfs.core.config.httpclient.internal.SelfSignedX509TrustManager;
import com.microsoft.tfs.core.httpclient.ConnectTimeoutException;
import com.microsoft.tfs.core.httpclient.params.HttpConnectionParams;
import com.microsoft.tfs.core.httpclient.protocol.SecureProtocolSocketFactory;
import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.StringUtil;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultSSLProtocolSocketFactory
implements SecureProtocolSocketFactory {
    public static final String ACCEPT_UNTRUSTED_CERTIFICATES_PARAMETER = "DefaultSSLProtocolSocketFactory.acceptUntrustedCertificates";
    public static final String DISABLE_PROPERTY_NAME = "com.microsoft.tfs.core.config.httpclient.sslsocketfactory.disable";
    public static final String SSL_PROTOCOL_PROPERTY_NAME = "com.microsoft.tfs.core.config.httpclient.sslsocketfactory.sslprotocol";
    private static final Log log = LogFactory.getLog(DefaultSSLProtocolSocketFactory.class);
    private static final Object lock = new Object();
    private static SSLSocketFactory standardSocketFactory;
    private static SSLSocketFactory selfSignedSocketFactory;

    @Override
    public Socket createSocket(String host, int port, InetAddress localAddress, int localPort, HttpConnectionParams params) throws IOException, UnknownHostException, ConnectTimeoutException {
        Check.notNull(params, "params");
        int timeout = params.getConnectionTimeout();
        Socket socket = this.getSocketFactory(params).createSocket();
        this.configureSNI(socket, host);
        socket.bind(new InetSocketAddress(localAddress, localPort));
        socket.connect(new InetSocketAddress(host, port), timeout);
        return socket;
    }

    @Override
    public Socket createSocket(Socket socket, String host, int port, HttpConnectionParams params, boolean autoClose) throws IOException, UnknownHostException {
        Check.notNull(params, "params");
        Socket ssocket = this.getSocketFactory(params).createSocket(socket, host, port, autoClose);
        this.configureSNI(ssocket, host);
        return ssocket;
    }

    private SSLSocketFactory getSocketFactory(HttpConnectionParams params) {
        if (this.isEnabled()) {
            try {
                SSLSocketFactory socketFactory = params.getBooleanParameter(ACCEPT_UNTRUSTED_CERTIFICATES_PARAMETER, false) ? this.getSelfSignedSocketFactory(params) : this.getStandardSocketFactory(params);
                if (socketFactory != null) {
                    return socketFactory;
                }
            }
            catch (Exception e) {
                log.warn((Object)"Could not create SSL socket factory, falling back to default", (Throwable)e);
            }
        } else {
            log.info((Object)"SSLSocketFactory is disabled, falling back to system");
        }
        return (SSLSocketFactory)SSLSocketFactory.getDefault();
    }

    private boolean isEnabled() {
        return System.getProperty(DISABLE_PROPERTY_NAME) == null;
    }

    private SSLContext getSSLContext() throws NoSuchAlgorithmException {
        String requestedProtocol = this.getRequestedProtocol();
        try {
            return SSLContext.getInstance(requestedProtocol);
        }
        catch (NoSuchAlgorithmException e) {
            log.error((Object)("Cannot create SSL context with the requested protocol " + requestedProtocol), (Throwable)e);
            log.info((Object)"Using SSL context with the default protocol TLS");
            return SSLContext.getInstance("TLS");
        }
    }

    private String getRequestedProtocol() {
        String protocol = System.getProperty(SSL_PROTOCOL_PROPERTY_NAME);
        if (StringUtil.isNullOrEmpty(protocol)) {
            return EnvironmentVariables.getString("TF_SSL_PROTOCOL_NAME", "TLS");
        }
        return protocol;
    }

    private void configureSNI(Socket socket, String host) {
        if (System.getProperty("java.version").compareTo("1.8") < 0) {
            return;
        }
        try {
            SSLSocket sslSocket = (SSLSocket)socket;
            SSLParameters params = sslSocket.getSSLParameters();
            Class<?> sniHostNameClass = Class.forName("javax.net.ssl.SNIHostName");
            Constructor<?> sniHostNameClassConstructor = sniHostNameClass.getConstructor(String.class);
            Object serverName = sniHostNameClassConstructor.newInstance(host);
            ArrayList serverNames = new ArrayList(1);
            serverNames.add(serverName);
            Class<?> paramsClass = params.getClass();
            Method setServerNames = paramsClass.getMethod("setServerNames", List.class);
            setServerNames.invoke((Object)params, serverNames);
            sslSocket.setSSLParameters(params);
        }
        catch (Exception e) {
            log.error((Object)"Eror configuring SSL socket with SNI cipher extension:", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SSLSocketFactory getStandardSocketFactory(HttpConnectionParams params) throws NoSuchAlgorithmException, KeyManagementException, KeyStoreException, CertificateException, IOException {
        Object object = lock;
        synchronized (object) {
            if (standardSocketFactory == null) {
                SSLContext context = this.getSSLContext();
                context.init(this.getDefaultKeyManagers(), new TrustManager[]{new DefaultX509TrustManager(null)}, null);
                standardSocketFactory = context.getSocketFactory();
            }
            return standardSocketFactory;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SSLSocketFactory getSelfSignedSocketFactory(HttpConnectionParams params) throws NoSuchAlgorithmException, KeyManagementException, KeyStoreException {
        Object object = lock;
        synchronized (object) {
            if (selfSignedSocketFactory == null) {
                SSLContext context = this.getSSLContext();
                context.init(this.getDefaultKeyManagers(), new TrustManager[]{new SelfSignedX509TrustManager(null)}, null);
                selfSignedSocketFactory = context.getSocketFactory();
            }
            return selfSignedSocketFactory;
        }
    }

    private KeyManager[] getDefaultKeyManagers() throws KeyStoreException, NoSuchAlgorithmException {
        String keyStorePath = System.getProperty("javax.net.ssl.keyStore");
        if (!StringUtil.isNullOrEmpty(keyStorePath)) {
            String keyStoreType = System.getProperty("javax.net.ssl.keyStoreType", "JKS");
            char[] keyStorePassword = System.getProperty("javax.net.ssl.keyStorePassword", "").toCharArray();
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            KeyStore keyStore = KeyStore.getInstance(keyStoreType);
            try {
                FileInputStream keyStoreFile = new FileInputStream(keyStorePath);
                keyStore.load(keyStoreFile, keyStorePassword);
                keyManagerFactory.init(keyStore, keyStorePassword);
                KeyManager[] managers = keyManagerFactory.getKeyManagers();
                return managers;
            }
            catch (Exception e) {
                log.warn((Object)MessageFormat.format("Error accessing the client key store {0}", keyStorePath), (Throwable)e);
            }
        }
        return null;
    }
}

