/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.externaltools;

import com.microsoft.tfs.core.Messages;
import com.microsoft.tfs.core.externaltools.WindowsStyleArgumentTokenizer;
import com.microsoft.tfs.core.externaltools.internal.PlistHandler;
import com.microsoft.tfs.core.externaltools.validators.ExternalToolException;
import com.microsoft.tfs.core.memento.Memento;
import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.Platform;
import com.microsoft.tfs.util.xml.SAXUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class ExternalTool {
    private static final Log log = LogFactory.getLog(ExternalTool.class);
    private static final String ORIGINAL_COMMAND_AND_ARGUMENTS_MEMENTO_NAME = "commandAndArguments";
    private final String originalCommandAndArguments;
    private final String command;
    private final String[] arguments;

    public ExternalTool(String commandAndArguments) throws ExternalToolException {
        Check.notNullOrEmpty(commandAndArguments, ORIGINAL_COMMAND_AND_ARGUMENTS_MEMENTO_NAME);
        this.originalCommandAndArguments = commandAndArguments;
        String[] tokens = WindowsStyleArgumentTokenizer.tokenizeArguments(commandAndArguments);
        if (tokens.length == 0 || tokens[0] == null || tokens[0].length() == 0) {
            throw new ExternalToolException(MessageFormat.format(Messages.getString("ExternalTool.CommandCouldNotBeParsedFromStringFormat"), commandAndArguments));
        }
        this.command = tokens[0];
        if (tokens.length > 1) {
            this.arguments = new String[tokens.length - 1];
            System.arraycopy(tokens, 1, this.arguments, 0, tokens.length - 1);
        } else {
            this.arguments = new String[0];
        }
    }

    public final String getOriginalCommand() {
        return this.command;
    }

    public final String getCommand() {
        String macCommand;
        if (Platform.isCurrentPlatform(Platform.MAC_OS_X) && this.command.endsWith(".app") && (macCommand = ExternalTool.getMacCommand(this.command)) != null) {
            return macCommand;
        }
        return this.command;
    }

    public final String[] getArguments() {
        String[] ret = new String[this.arguments.length];
        System.arraycopy(this.arguments, 0, ret, 0, this.arguments.length);
        return ret;
    }

    public final String getOriginalCommandAndArguments() {
        return this.originalCommandAndArguments;
    }

    public String toString() {
        return this.getOriginalCommandAndArguments();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof ExternalTool)) {
            return false;
        }
        ExternalTool other = (ExternalTool)o;
        return !this.command.equals(other.command) && Arrays.equals(this.arguments, other.arguments);
    }

    public int hashCode() {
        int result = 17;
        result = result * 37 + this.command.hashCode();
        result = result * 37 + Arrays.hashCode(this.arguments);
        return result;
    }

    public void saveToMemento(Memento memento) {
        Check.notNull(memento, "memento");
        memento.putString(ORIGINAL_COMMAND_AND_ARGUMENTS_MEMENTO_NAME, this.originalCommandAndArguments);
    }

    public static ExternalTool loadFromMemento(Memento memento) {
        Check.notNull(memento, "memento");
        String commandAndArguments = memento.getString(ORIGINAL_COMMAND_AND_ARGUMENTS_MEMENTO_NAME);
        if (commandAndArguments == null) {
            return null;
        }
        return new ExternalTool(commandAndArguments);
    }

    private static String getMacCommand(String appBundle) {
        Map plistDict;
        Check.notNull(appBundle, "appBundle");
        String plistPath = appBundle + "/Contents/Info.plist";
        File plistFile = new File(plistPath);
        if (!plistFile.exists() || !plistFile.canRead()) {
            return null;
        }
        try {
            FileInputStream plistStream = new FileInputStream(plistFile);
            SAXParser plistParser = SAXUtils.newSAXParser();
            PlistHandler plistHandler = new PlistHandler();
            plistParser.parse((InputStream)plistStream, (DefaultHandler)plistHandler);
            Object plist = plistHandler.getPlist();
            if (!(plist instanceof Map)) {
                log.error((Object)MessageFormat.format("Plist {0} does not contain dict", plistPath));
                return null;
            }
            plistDict = (Map)plist;
        }
        catch (IOException e) {
            log.error((Object)MessageFormat.format("Could not read plist {0}", plistPath), (Throwable)e);
            return null;
        }
        catch (ParserConfigurationException e) {
            log.error((Object)MessageFormat.format("Could not parse plist {0}", plistPath), (Throwable)e);
            return null;
        }
        catch (SAXException e) {
            log.error((Object)MessageFormat.format("Could not parse plist {0}", plistPath), (Throwable)e);
            return null;
        }
        Object executable = plistDict.get("CFBundleExecutable");
        if (executable == null || !(executable instanceof String)) {
            log.error((Object)MessageFormat.format("Plist {0} contains no string entry for CFBundleExecutable", plistPath));
            return null;
        }
        return appBundle + "/Contents/MacOS/" + (String)executable;
    }
}

