/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.externaltools.formatters;

import com.microsoft.tfs.core.externaltools.ExternalTool;
import com.microsoft.tfs.util.Check;

public class AbstractToolArgumentFormatter {
    public final String[] formatArguments(ExternalTool tool, String[] substitutes) {
        Check.notNull(tool, "tool");
        Check.notNull(substitutes, "substitutes");
        String[] arguments = tool.getArguments();
        String[] escapedSubstitutes = new String[substitutes.length];
        for (int i = 0; i < escapedSubstitutes.length; ++i) {
            escapedSubstitutes[i] = AbstractToolArgumentFormatter.escapeForRegularExpression(substitutes[i]);
        }
        String[] ret = new String[arguments.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = arguments[i];
            for (int j = 0; j < escapedSubstitutes.length; ++j) {
                String token = "%" + (j + 1);
                ret[i] = ret[i].replaceAll(token, escapedSubstitutes[j]);
            }
        }
        return ret;
    }

    private static String escapeForRegularExpression(String string) {
        Check.notNull(string, "string");
        return string.replaceAll("\\\\", "\\\\\\\\").replaceAll("\\$", "\\\\\\$");
    }
}

