/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.httpclient;

import com.microsoft.tfs.core.httpclient.Cookie;
import com.microsoft.tfs.core.httpclient.Credentials;
import com.microsoft.tfs.core.httpclient.auth.AuthScope;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HttpState {
    protected HashMap<AuthScope, Credentials> credMap = new HashMap();
    protected HashMap<AuthScope, Credentials> proxyCred = new HashMap();
    protected ArrayList<Cookie> cookies = new ArrayList();
    private static final Log LOG = LogFactory.getLog(HttpState.class);

    public synchronized void addCookie(Cookie cookie) {
        LOG.trace((Object)"enter HttpState.addCookie(Cookie)");
        if (cookie != null) {
            Iterator<Cookie> it = this.cookies.iterator();
            while (it.hasNext()) {
                Cookie tmp = it.next();
                if (!cookie.equals(tmp)) continue;
                it.remove();
                break;
            }
            if (!cookie.isExpired()) {
                this.cookies.add(cookie);
            }
        }
    }

    public synchronized void addCookies(Cookie[] cookies) {
        LOG.trace((Object)"enter HttpState.addCookies(Cookie[])");
        if (cookies != null) {
            for (int i = 0; i < cookies.length; ++i) {
                LOG.trace((Object)cookies[i]);
                this.addCookie(cookies[i]);
            }
        }
        LOG.trace((Object)"leave HttpState.addCookies(Cookie[])");
    }

    public synchronized Cookie[] getCookies() {
        LOG.trace((Object)"enter HttpState.getCookies()");
        return this.cookies.toArray(new Cookie[this.cookies.size()]);
    }

    public synchronized boolean purgeExpiredCookies() {
        LOG.trace((Object)"enter HttpState.purgeExpiredCookies()");
        return this.purgeExpiredCookies(new Date());
    }

    public synchronized boolean purgeExpiredCookies(Date date) {
        LOG.trace((Object)"enter HttpState.purgeExpiredCookies(Date)");
        boolean removed = false;
        Iterator<Cookie> it = this.cookies.iterator();
        while (it.hasNext()) {
            if (!it.next().isExpired(date)) continue;
            it.remove();
            removed = true;
        }
        return removed;
    }

    public synchronized void setCredentials(AuthScope authscope, Credentials credentials) {
        if (authscope == null) {
            throw new IllegalArgumentException("Authentication scope may not be null");
        }
        LOG.trace((Object)"enter HttpState.setCredentials(AuthScope, Credentials)");
        this.credMap.put(authscope, credentials);
    }

    private static Credentials matchCredentials(HashMap<AuthScope, Credentials> map, AuthScope authscope) {
        Credentials creds = map.get(authscope);
        if (creds == null) {
            int bestMatchFactor = -1;
            AuthScope bestMatch = null;
            for (AuthScope current : map.keySet()) {
                int factor = authscope.match(current);
                if (factor <= bestMatchFactor) continue;
                bestMatchFactor = factor;
                bestMatch = current;
            }
            if (bestMatch != null) {
                creds = map.get(bestMatch);
            }
        }
        return creds;
    }

    public synchronized Credentials getCredentials(AuthScope authscope) {
        if (authscope == null) {
            throw new IllegalArgumentException("Authentication scope may not be null");
        }
        LOG.trace((Object)"enter HttpState.getCredentials(AuthScope)");
        return HttpState.matchCredentials(this.credMap, authscope);
    }

    public synchronized void setProxyCredentials(AuthScope authscope, Credentials credentials) {
        if (authscope == null) {
            throw new IllegalArgumentException("Authentication scope may not be null");
        }
        LOG.trace((Object)"enter HttpState.setProxyCredentials(AuthScope, Credentials)");
        this.proxyCred.put(authscope, credentials);
    }

    public synchronized Credentials getProxyCredentials(AuthScope authscope) {
        if (authscope == null) {
            throw new IllegalArgumentException("Authentication scope may not be null");
        }
        LOG.trace((Object)"enter HttpState.getProxyCredentials(AuthScope)");
        return HttpState.matchCredentials(this.proxyCred, authscope);
    }

    public synchronized String toString() {
        StringBuffer sbResult = new StringBuffer();
        sbResult.append("[");
        sbResult.append(HttpState.getCredentialsStringRepresentation(this.proxyCred));
        sbResult.append(" | ");
        sbResult.append(HttpState.getCredentialsStringRepresentation(this.credMap));
        sbResult.append(" | ");
        sbResult.append(HttpState.getCookiesStringRepresentation(this.cookies));
        sbResult.append("]");
        String strResult = sbResult.toString();
        return strResult;
    }

    private static String getCredentialsStringRepresentation(Map<AuthScope, Credentials> credMap) {
        StringBuffer sbResult = new StringBuffer();
        for (AuthScope key : credMap.keySet()) {
            Credentials cred = credMap.get(key);
            if (sbResult.length() > 0) {
                sbResult.append(", ");
            }
            sbResult.append(key);
            sbResult.append("#");
            sbResult.append(cred.toString());
        }
        return sbResult.toString();
    }

    private static String getCookiesStringRepresentation(List<Cookie> cookies) {
        StringBuffer sbResult = new StringBuffer();
        for (Cookie ck : cookies) {
            if (sbResult.length() > 0) {
                sbResult.append("#");
            }
            sbResult.append(ck.toExternalForm());
        }
        return sbResult.toString();
    }

    public void clearCredentials() {
        this.credMap.clear();
    }

    public void clearProxyCredentials() {
        this.proxyCred.clear();
    }

    public synchronized void clearCookies() {
        this.cookies.clear();
    }

    public void clear() {
        this.clearCookies();
        this.clearCredentials();
        this.clearProxyCredentials();
    }
}

