/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.httpclient;

import com.microsoft.tfs.core.httpclient.ConnectMethod;
import com.microsoft.tfs.core.httpclient.HostConfiguration;
import com.microsoft.tfs.core.httpclient.HttpConnection;
import com.microsoft.tfs.core.httpclient.HttpConnectionManager;
import com.microsoft.tfs.core.httpclient.HttpException;
import com.microsoft.tfs.core.httpclient.HttpMethodDirector;
import com.microsoft.tfs.core.httpclient.HttpState;
import com.microsoft.tfs.core.httpclient.params.HttpClientParams;
import com.microsoft.tfs.core.httpclient.params.HttpConnectionManagerParams;
import com.microsoft.tfs.core.httpclient.params.HttpParams;
import java.io.IOException;
import java.net.Socket;

public class ProxyClient {
    private HttpState state = new HttpState();
    private HttpClientParams params = null;
    private HostConfiguration hostConfiguration = new HostConfiguration();

    public ProxyClient() {
        this(new HttpClientParams());
    }

    public ProxyClient(HttpClientParams params) {
        if (params == null) {
            throw new IllegalArgumentException("Params may not be null");
        }
        this.params = params;
    }

    public synchronized HttpState getState() {
        return this.state;
    }

    public synchronized void setState(HttpState state) {
        this.state = state;
    }

    public synchronized HostConfiguration getHostConfiguration() {
        return this.hostConfiguration;
    }

    public synchronized void setHostConfiguration(HostConfiguration hostConfiguration) {
        this.hostConfiguration = hostConfiguration;
    }

    public synchronized HttpClientParams getParams() {
        return this.params;
    }

    public synchronized void setParams(HttpClientParams params) {
        if (params == null) {
            throw new IllegalArgumentException("Parameters may not be null");
        }
        this.params = params;
    }

    public ConnectResponse connect() throws IOException, HttpException {
        HostConfiguration hostconf = this.getHostConfiguration();
        if (hostconf.getProxyHost() == null) {
            throw new IllegalStateException("proxy host must be configured");
        }
        if (hostconf.getHost() == null) {
            throw new IllegalStateException("destination host must be configured");
        }
        if (hostconf.getProtocol().isSecure()) {
            throw new IllegalStateException("secure protocol socket factory may not be used");
        }
        ConnectMethod method = new ConnectMethod(this.getHostConfiguration());
        method.getParams().setDefaults(this.getParams());
        DummyConnectionManager connectionManager = new DummyConnectionManager();
        connectionManager.setConnectionParams(this.getParams());
        HttpMethodDirector director = new HttpMethodDirector(connectionManager, hostconf, this.getParams(), this.getState());
        director.executeMethod(method);
        ConnectResponse response = new ConnectResponse();
        response.setConnectMethod(method);
        if (method.getStatusCode() == 200) {
            response.setSocket(connectionManager.getConnection().getSocket());
        } else {
            connectionManager.getConnection().close();
        }
        return response;
    }

    static class DummyConnectionManager
    implements HttpConnectionManager {
        private HttpConnection httpConnection;
        private HttpParams connectionParams;

        DummyConnectionManager() {
        }

        @Override
        public void closeIdleConnections(long idleTimeout) {
        }

        public HttpConnection getConnection() {
            return this.httpConnection;
        }

        public void setConnectionParams(HttpParams httpParams) {
            this.connectionParams = httpParams;
        }

        @Override
        public HttpConnection getConnectionWithTimeout(HostConfiguration hostConfiguration, long timeout) {
            this.httpConnection = new HttpConnection(hostConfiguration);
            this.httpConnection.setHttpConnectionManager(this);
            this.httpConnection.getParams().setDefaults(this.connectionParams);
            return this.httpConnection;
        }

        @Override
        @Deprecated
        public HttpConnection getConnection(HostConfiguration hostConfiguration, long timeout) throws HttpException {
            return this.getConnectionWithTimeout(hostConfiguration, timeout);
        }

        @Override
        public HttpConnection getConnection(HostConfiguration hostConfiguration) {
            return this.getConnectionWithTimeout(hostConfiguration, -1L);
        }

        @Override
        public void releaseConnection(HttpConnection conn) {
        }

        @Override
        public HttpConnectionManagerParams getParams() {
            return null;
        }

        @Override
        public void setParams(HttpConnectionManagerParams params) {
        }
    }

    public static class ConnectResponse {
        private ConnectMethod connectMethod;
        private Socket socket;

        private ConnectResponse() {
        }

        public ConnectMethod getConnectMethod() {
            return this.connectMethod;
        }

        private void setConnectMethod(ConnectMethod connectMethod) {
            this.connectMethod = connectMethod;
        }

        public Socket getSocket() {
            return this.socket;
        }

        private void setSocket(Socket socket) {
            this.socket = socket;
        }
    }
}

