/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.httpclient.auth;

import com.microsoft.tfs.core.httpclient.Credentials;
import com.microsoft.tfs.core.httpclient.HttpMethod;
import com.microsoft.tfs.core.httpclient.URIException;
import com.microsoft.tfs.core.httpclient.UsernamePasswordCredentials;
import com.microsoft.tfs.core.httpclient.auth.AuthScope;
import com.microsoft.tfs.core.httpclient.auth.AuthenticationException;
import com.microsoft.tfs.core.httpclient.auth.AuthenticationSecurityException;
import com.microsoft.tfs.core.httpclient.auth.InvalidCredentialsException;
import com.microsoft.tfs.core.httpclient.auth.MalformedChallengeException;
import com.microsoft.tfs.core.httpclient.auth.RFC2617Scheme;
import com.microsoft.tfs.core.httpclient.util.EncodingUtil;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BasicScheme
extends RFC2617Scheme {
    private static final String INSECURE_BASIC_PROPERTY = "com.microsoft.tfs.client.allowInsecureBasic";
    private static final Log LOG = LogFactory.getLog(BasicScheme.class);
    private boolean complete;

    public BasicScheme() {
        this.complete = false;
    }

    @Deprecated
    public BasicScheme(String challenge) throws MalformedChallengeException {
        super(challenge);
        this.complete = true;
    }

    @Override
    public boolean supportsCredentials(Credentials credentials) {
        if (credentials == null) {
            return false;
        }
        return credentials instanceof UsernamePasswordCredentials;
    }

    @Override
    public String getSchemeName() {
        return "basic";
    }

    @Override
    public void processChallenge(String challenge) throws MalformedChallengeException {
        this.complete = true;
    }

    @Override
    public boolean isComplete() {
        return this.complete;
    }

    @Override
    public boolean isConnectionBased() {
        return false;
    }

    @Override
    public String authenticate(AuthScope authscope, Credentials credentials, HttpMethod method) throws AuthenticationException {
        LOG.trace((Object)"enter BasicScheme.authenticate(Credentials, HttpMethod)");
        if (method == null) {
            throw new IllegalArgumentException("Method may not be null");
        }
        UsernamePasswordCredentials usernamepassword = null;
        try {
            usernamepassword = (UsernamePasswordCredentials)credentials;
        }
        catch (ClassCastException e) {
            throw new InvalidCredentialsException("Credentials cannot be used for basic authentication: " + credentials.getClass().getName());
        }
        try {
            if (!"https".equalsIgnoreCase(method.getURI().getScheme()) && !"true".equalsIgnoreCase(System.getProperty(INSECURE_BASIC_PROPERTY))) {
                throw new AuthenticationSecurityException("Basic credentials are only supported over HTTPS secured connections.");
            }
        }
        catch (URIException e) {
            throw new AuthenticationException("Invalid URI in method", e);
        }
        return BasicScheme.authenticate(usernamepassword, method.getParams().getCredentialCharset());
    }

    @Deprecated
    public static String authenticate(UsernamePasswordCredentials credentials) {
        return BasicScheme.authenticate(credentials, "ISO-8859-1");
    }

    public static String authenticate(UsernamePasswordCredentials credentials, String charset) {
        LOG.trace((Object)"enter BasicScheme.authenticate(UsernamePasswordCredentials, String)");
        if (credentials == null) {
            throw new IllegalArgumentException("Credentials may not be null");
        }
        if (charset == null || charset.length() == 0) {
            throw new IllegalArgumentException("charset may not be null or empty");
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append(credentials.getUsername());
        buffer.append(":");
        buffer.append(credentials.getPassword());
        return "Basic " + EncodingUtil.getAsciiString(Base64.encodeBase64((byte[])EncodingUtil.getBytes(buffer.toString(), charset)));
    }

    @Override
    public void cleanup() {
    }
}

