/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.product;

import com.microsoft.tfs.core.Messages;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.Properties;

public abstract class CoreVersionInfo {
    private static final String VERSION_PROPERTIES_RESOURCE = "/com.microsoft.tfs.core-version.properties";
    private static String major = "";
    private static String minor = "";
    private static String service = "";
    private static String build = "";
    private static Throwable loadException;

    public static String getMajorVersion() {
        if (loadException != null) {
            throw new RuntimeException(loadException);
        }
        return major;
    }

    public static String getMinorVersion() {
        if (loadException != null) {
            throw new RuntimeException(loadException);
        }
        return minor;
    }

    public static String getServiceVersion() {
        if (loadException != null) {
            throw new RuntimeException(loadException);
        }
        return service;
    }

    public static String getBuildVersion() {
        if (loadException != null) {
            throw new RuntimeException(loadException);
        }
        return build;
    }

    public static String getVersion() {
        return MessageFormat.format("{0}.{1}.{2}.{3}", CoreVersionInfo.getMajorVersion(), CoreVersionInfo.getMinorVersion(), CoreVersionInfo.getServiceVersion(), CoreVersionInfo.getBuildVersion());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        InputStream in = CoreVersionInfo.class.getResourceAsStream(VERSION_PROPERTIES_RESOURCE);
        if (in != null) {
            try {
                Properties props = new Properties();
                try {
                    props.load(in);
                    major = props.getProperty("number.version.major");
                    minor = props.getProperty("number.version.minor");
                    service = props.getProperty("number.version.service");
                    build = props.getProperty("number.version.build");
                }
                catch (IOException e) {
                    loadException = e;
                }
            }
            finally {
                try {
                    in.close();
                }
                catch (IOException e) {
                    loadException = e;
                }
            }
        } else {
            loadException = new Exception(MessageFormat.format(Messages.getString("CoreVersionInfo.UnableToLoadVersionPropertiesResourceFormat"), VERSION_PROPERTIES_RESOURCE));
        }
    }
}

