/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.util;

import com.microsoft.tfs.core.Messages;
import com.microsoft.tfs.util.xml.SAXUtils;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.SAXParser;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class CodePageData {
    private static final Log log = LogFactory.getLog(CodePageData.class);
    private static final Object lock = new Object();
    private static boolean initialized = false;
    private static Map codePageToCharsetNames = new HashMap();
    private static Map charsetNameToCodePage = new HashMap();

    CodePageData() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String[] getCharsetNames() {
        Object object = lock;
        synchronized (object) {
            if (!initialized) {
                CodePageData.initialize();
            }
            Set charsetNameSet = charsetNameToCodePage.keySet();
            return charsetNameSet.toArray(new String[charsetNameSet.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Integer[] getCodePages() {
        Object object = lock;
        synchronized (object) {
            if (!initialized) {
                CodePageData.initialize();
            }
            Set codePageSet = codePageToCharsetNames.keySet();
            return codePageSet.toArray(new Integer[codePageSet.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String[] getCharsetNames(int codePage) {
        Integer key = new Integer(codePage);
        Object object = lock;
        synchronized (object) {
            if (!initialized) {
                CodePageData.initialize();
            }
            return (String[])codePageToCharsetNames.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Integer getCodePage(String charsetName) {
        Object object = lock;
        synchronized (object) {
            if (!initialized) {
                CodePageData.initialize();
            }
            return (Integer)charsetNameToCodePage.get(charsetName.toLowerCase());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initialize() {
        initialized = true;
        InputStream inputStream = CodePageData.class.getResourceAsStream("codepages.xml");
        if (inputStream == null) {
            log.error((Object)"Unable to load the codepages.xml resource");
            return;
        }
        try {
            SAXParser parser = SAXUtils.newSAXParser();
            InputSource inputSource = new InputSource(inputStream);
            parser.parse(inputSource, (DefaultHandler)new CodePagesHandler());
        }
        catch (Exception e) {
            log.error((Object)Messages.getString("CodePageData.ErrorDuringParsing"), (Throwable)e);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    private static class CodePagesHandler
    extends DefaultHandler {
        private int currentCodePage = -1;
        private final List currentCharsetNames = new ArrayList();

        private CodePagesHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            String name;
            if ("codePage".equals(qName)) {
                try {
                    this.currentCodePage = Integer.parseInt(attributes.getValue("value"));
                    this.currentCharsetNames.clear();
                }
                catch (NumberFormatException ex) {}
            } else if ("charset".equals(qName) && this.currentCodePage != -1 && (name = attributes.getValue("name")) != null) {
                boolean reverseMapping;
                this.currentCharsetNames.add(name);
                String sReverseMapping = attributes.getValue("reverseMapping");
                boolean bl = reverseMapping = !"false".equalsIgnoreCase(sReverseMapping);
                if (reverseMapping) {
                    if (charsetNameToCodePage.containsKey(name.toLowerCase())) {
                        log.warn((Object)MessageFormat.format("charset name [{0}] is mapped to more than one code page: {1} {2}", name, charsetNameToCodePage.get(name).toString(), Integer.toString(this.currentCodePage)));
                    } else {
                        charsetNameToCodePage.put(name.toLowerCase(), new Integer(this.currentCodePage));
                    }
                }
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if ("codePage".equals(qName) && this.currentCodePage != -1) {
                Integer codePageKey = new Integer(this.currentCodePage);
                if (codePageToCharsetNames.containsKey(codePageKey)) {
                    log.warn((Object)MessageFormat.format("code page [{0}] is duplicated in the mappings", Integer.toString(this.currentCodePage)));
                } else if (this.currentCharsetNames.size() == 0) {
                    log.warn((Object)MessageFormat.format("code page [{0}] had no charset mappings", Integer.toString(this.currentCodePage)));
                } else {
                    String[] charsetNames = this.currentCharsetNames.toArray(new String[this.currentCharsetNames.size()]);
                    codePageToCharsetNames.put(codePageKey, charsetNames);
                }
                this.currentCodePage = -1;
            }
        }
    }
}

