/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.util;

import com.microsoft.tfs.core.Messages;
import com.microsoft.tfs.core.util.CodePageMapping;
import com.microsoft.tfs.jni.PlatformMiscUtils;
import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.Platform;
import com.microsoft.tfs.util.StringUtil;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class FileEncoding {
    private static final Log log = LogFactory.getLog(FileEncoding.class);
    protected static final int AUTO_DETECT_SPECIAL_VALUE = -9999;
    protected static final int TEXT_SPECIAL_VALUE = -9998;
    public static final String ENCODING_ERROR_MESSAGE_FORMAT = Messages.getString("FileEncoding.EncodingErrorMessageFormat");
    private final int tfsCodePage;
    public static final FileEncoding BINARY = new FileEncoding(-1);
    public static final FileEncoding AUTOMATICALLY_DETECT = new FileEncoding(-9999);
    public static final FileEncoding DEFAULT_TEXT = new FileEncoding(-9998);
    public static final FileEncoding UTF_8 = new FileEncoding(CodePageMapping.getCodePage("UTF-8"));
    public static final FileEncoding UTF_16 = new FileEncoding(CodePageMapping.getCodePage("UTF-16LE"));
    public static final FileEncoding UTF_16BE = new FileEncoding(CodePageMapping.getCodePage("UTF-16BE"));
    public static final FileEncoding UTF_32 = new FileEncoding(CodePageMapping.getCodePage("UTF-32LE"));
    public static final FileEncoding UTF_32BE = new FileEncoding(CodePageMapping.getCodePage("UTF-32BE"));

    public FileEncoding(int codePage) {
        this.tfsCodePage = codePage;
    }

    public static FileEncoding getDefaultTextEncoding() {
        try {
            Charset defaultCharset = Charset.defaultCharset();
            int cp = CodePageMapping.getCodePage(defaultCharset);
            log.trace((Object)MessageFormat.format("Detected default encoding from Charset.defaultCharset(): {0} -> {1}", defaultCharset, Integer.toString(cp)));
            return new FileEncoding(cp);
        }
        catch (CodePageMapping.UnknownEncodingException e) {
            log.warn((Object)"Could not parse Charset.defaultCharset() value", (Throwable)e);
        }
        catch (Throwable t) {
            // empty catch block
        }
        String fileEncodingValue = System.getProperty("file.encoding");
        if (!StringUtil.isNullOrEmpty(fileEncodingValue)) {
            try {
                int cp = CodePageMapping.getCodePage(fileEncodingValue);
                log.trace((Object)MessageFormat.format("Detected default encoding from system property file.encoding: {0} -> {1}", fileEncodingValue, Integer.toString(cp)));
                return new FileEncoding(cp);
            }
            catch (CodePageMapping.UnknownEncodingException e) {
                log.warn((Object)"Could not parse file.encoding value", (Throwable)e);
            }
        }
        if (Platform.isCurrentPlatform(Platform.WINDOWS)) {
            int cp = PlatformMiscUtils.getInstance().getDefaultCodePage();
            if (cp == -1) {
                log.trace((Object)"FileSystem.getDefaultCodePage() returned -1, assuming Windows-1252");
                cp = CodePageMapping.getCodePage("Windows-1252");
            }
            log.trace((Object)("Detected default encoding for Windows: " + cp));
            return new FileEncoding(cp);
        }
        if (Platform.isCurrentPlatform(Platform.Z_OS)) {
            int cp = 1047;
            log.trace((Object)"Detected default encoding for z/OS: 1047");
            return new FileEncoding(1047);
        }
        log.trace((Object)"Could not determine a default encoding for this platform, assuming UTF-8");
        return UTF_8;
    }

    public String toString() {
        return Integer.toString(this.tfsCodePage);
    }

    public int getCodePage() {
        return this.tfsCodePage;
    }

    public String getName() {
        return this.getName(Locale.getDefault());
    }

    public String getName(Locale locale) {
        Check.notNull(locale, "locale");
        if (this.equals(BINARY)) {
            return "binary";
        }
        if (this.equals(AUTOMATICALLY_DETECT)) {
            return "auto";
        }
        if (this.equals(DEFAULT_TEXT)) {
            return "text";
        }
        Charset c = CodePageMapping.getCharset(this.tfsCodePage, false);
        if (c != null) {
            return c.displayName(locale);
        }
        return this.toString();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FileEncoding)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        FileEncoding other = (FileEncoding)obj;
        return other.tfsCodePage == this.tfsCodePage;
    }

    public int hashCode() {
        int result = 17;
        result = result * 37 + this.tfsCodePage;
        return result;
    }
}

