/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.util;

import com.microsoft.tfs.core.util.ServerURIComparator;
import com.microsoft.tfs.util.LocaleInvariantStringHelpers;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Locale;

public class ServerURIUtils {
    public static final String[] HOSTED_SERVICE_DOMAIN_SUFFIXES = new String[]{".tfsallin.net", ".visualstudio.com"};
    public static final String HOSTED_SERVICE_DEFAULT_SCHEME = "https";

    private ServerURIUtils() {
    }

    public static URI normalizeURI(URI uri) {
        return ServerURIUtils.normalizeURI(uri, false);
    }

    public static URI normalizeURI(URI uri, boolean lowercase) {
        String pathPart;
        if (uri == null) {
            return null;
        }
        String string = pathPart = uri.getPath() == null || uri.getPath().length() == 0 ? "/" : uri.getPath();
        while (pathPart.length() > 1 && pathPart.endsWith("/")) {
            pathPart = pathPart.substring(0, pathPart.length() - 1);
        }
        String scheme = uri.getScheme() == null ? null : uri.getScheme().toLowerCase(Locale.ENGLISH);
        String host = uri.getHost();
        if (lowercase) {
            pathPart = pathPart.toLowerCase(Locale.ENGLISH);
            host = host == null ? null : host.toLowerCase(Locale.ENGLISH);
        }
        try {
            return new URI(scheme, uri.getUserInfo(), host, uri.getPort(), pathPart, null, null);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean equals(URI one, URI two) {
        return ServerURIComparator.INSTANCE.compare(one, two) == 0;
    }

    public static boolean isHosted(URI uri) {
        return ServerURIUtils.isHosted(uri.getHost());
    }

    public static boolean isHosted(String uriServerName) {
        for (int i = 0; i < HOSTED_SERVICE_DOMAIN_SUFFIXES.length; ++i) {
            if (!LocaleInvariantStringHelpers.caseInsensitiveEndsWith(uriServerName, HOSTED_SERVICE_DOMAIN_SUFFIXES[i]) && !LocaleInvariantStringHelpers.caseInsensitiveEndsWith(uriServerName, HOSTED_SERVICE_DOMAIN_SUFFIXES[i] + ".")) continue;
            return true;
        }
        return false;
    }
}

