/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.util.serverlist.internal;

import com.microsoft.tfs.core.config.RegistryUtils;
import com.microsoft.tfs.core.util.URIUtils;
import com.microsoft.tfs.core.util.serverlist.ServerList;
import com.microsoft.tfs.core.util.serverlist.ServerListCollectionEntry;
import com.microsoft.tfs.core.util.serverlist.ServerListConfigurationEntry;
import com.microsoft.tfs.core.util.serverlist.ServerListEntryType;
import com.microsoft.tfs.core.util.serverlist.ServerListManager;
import com.microsoft.tfs.jni.RegistryKey;
import com.microsoft.tfs.jni.RegistryValue;
import com.microsoft.tfs.jni.ValueType;
import java.net.URI;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WindowsRegistryServerListManager
implements ServerListManager {
    private static final Log log = LogFactory.getLog(WindowsRegistryServerListManager.class);
    private static final String REGISTRY_PATH = "TeamFoundation\\Instances";
    private static final String COLLECTIONS_KEY_NAME = "Collections";
    private static final String OFFLINE_ATTRIBUTE_VALUE = "Offline";
    private static final String TYPE_ATTRIBUTE_VALUE = "Type";
    private static final String URI_ATTRIBUTE_VALUE = "Uri";

    @Override
    public ServerList getServerList() {
        RegistryKey registryKey;
        ServerList serverList = new ServerList();
        RegistryKey userKey = RegistryUtils.openOrCreateRootUserRegistryKey();
        if (userKey != null && (registryKey = userKey.getSubkey(REGISTRY_PATH)) != null) {
            for (RegistryKey server : registryKey.subkeys()) {
                String serverName = server.getName();
                ServerListEntryType serverType = WindowsRegistryServerListManager.getType(server);
                URI serverURI = WindowsRegistryServerListManager.getURI(server);
                if (serverName == null || serverType == null || serverURI == null) continue;
                ServerListConfigurationEntry serverListEntry = new ServerListConfigurationEntry(serverName, serverType, serverURI);
                RegistryKey collectionsKey = server.getSubkey(COLLECTIONS_KEY_NAME);
                if (collectionsKey != null) {
                    for (RegistryKey collection : collectionsKey.subkeys()) {
                        String collectionName = collection.getName();
                        Boolean collectionOffline = WindowsRegistryServerListManager.getOffline(collection);
                        ServerListEntryType collectionType = WindowsRegistryServerListManager.getType(collection);
                        URI collectionURI = WindowsRegistryServerListManager.getURI(collection);
                        if (collectionName == null || collectionType == null || collectionURI == null) continue;
                        serverListEntry.getCollections().add(new ServerListCollectionEntry(collectionName, collectionType, collectionURI, collectionOffline));
                    }
                }
                serverList.add(serverListEntry);
            }
        }
        return serverList;
    }

    private static ServerListEntryType getType(RegistryKey key) {
        RegistryValue typeValue = key.getValue(TYPE_ATTRIBUTE_VALUE);
        if (typeValue == null || typeValue.getType() != ValueType.REG_DWORD) {
            log.info((Object)MessageFormat.format("Expected DWORD for server instance type for server {0}", key.getName()));
            return null;
        }
        ServerListEntryType type = ServerListEntryType.fromValue(typeValue.getIntegerValue());
        if (type == null) {
            log.info((Object)MessageFormat.format("Unknown server instance type {0} for server {1}", typeValue.getIntegerValue(), key.getName()));
        }
        return type;
    }

    private static URI getURI(RegistryKey key) {
        URI uri;
        RegistryValue uriValue = key.getValue(URI_ATTRIBUTE_VALUE);
        if (uriValue == null || uriValue.getType() != ValueType.REG_SZ || uriValue.getStringValue() == null || uriValue.getStringValue().length() == 0) {
            log.info((Object)MessageFormat.format("Expected non-empty string for server instance uri for server {0}", key.getName()));
            return null;
        }
        try {
            uri = URIUtils.newURI(uriValue.getStringValue());
        }
        catch (Exception e) {
            log.info((Object)MessageFormat.format("Invalid URI for server {0}", key.getName()), (Throwable)e);
            return null;
        }
        return uri;
    }

    private static Boolean getOffline(RegistryKey key) {
        RegistryValue offlineValue = key.getValue(OFFLINE_ATTRIBUTE_VALUE);
        if (offlineValue == null || offlineValue.getType() != ValueType.REG_DWORD) {
            return null;
        }
        return offlineValue.getIntegerValue() == 0 ? Boolean.FALSE : Boolean.TRUE;
    }

    @Override
    public boolean setServerList(ServerList serverList) {
        RegistryKey userKey = RegistryUtils.openOrCreateRootUserRegistryKey();
        if (userKey == null) {
            log.warn((Object)"Could not create registry key while saving server list");
            return false;
        }
        RegistryKey registryKey = userKey.getSubkey(REGISTRY_PATH);
        Set<String> removeServers = WindowsRegistryServerListManager.getSubkeyNames(registryKey);
        if (registryKey == null) {
            registryKey = userKey.createSubkey(REGISTRY_PATH);
        }
        for (ServerListConfigurationEntry server : serverList.getServers()) {
            RegistryKey serverKey = registryKey.getSubkey(server.getName());
            if (serverKey == null) {
                serverKey = registryKey.createSubkey(server.getName());
            }
            serverKey.setValue(new RegistryValue(TYPE_ATTRIBUTE_VALUE, server.getType().getValue()));
            serverKey.setValue(new RegistryValue(URI_ATTRIBUTE_VALUE, server.getURI().toString()));
            RegistryKey collectionsKey = serverKey.getSubkey(COLLECTIONS_KEY_NAME);
            Set<String> removeCollections = WindowsRegistryServerListManager.getSubkeyNames(collectionsKey);
            if (server.getCollections().size() > 0) {
                if (collectionsKey == null) {
                    collectionsKey = serverKey.createSubkey(COLLECTIONS_KEY_NAME);
                }
                for (ServerListCollectionEntry collection : server.getCollections()) {
                    RegistryKey collectionKey = collectionsKey.getSubkey(collection.getName());
                    if (collectionKey == null) {
                        collectionKey = collectionsKey.createSubkey(collection.getName());
                    }
                    if (collection.getOffline() != null) {
                        collectionKey.setValue(new RegistryValue(OFFLINE_ATTRIBUTE_VALUE, collection.getOffline() != false ? 1 : 0));
                    } else if (collectionKey.hasValue(OFFLINE_ATTRIBUTE_VALUE)) {
                        collectionKey.deleteValue(OFFLINE_ATTRIBUTE_VALUE);
                    }
                    collectionKey.setValue(new RegistryValue(TYPE_ATTRIBUTE_VALUE, collection.getType().getValue()));
                    collectionKey.setValue(new RegistryValue(URI_ATTRIBUTE_VALUE, collection.getURI().toString()));
                    removeCollections.remove(collection.getName());
                }
            }
            for (String removeCollection : removeCollections) {
                collectionsKey.deleteSubkeyRecursive(removeCollection);
            }
            removeServers.remove(server.getName());
        }
        for (String removeServer : removeServers) {
            registryKey.deleteSubkeyRecursive(removeServer);
        }
        return true;
    }

    private static Set<String> getSubkeyNames(RegistryKey key) {
        HashSet<String> subkeySet = new HashSet<String>();
        if (key == null) {
            return subkeySet;
        }
        for (RegistryKey subkey : key.subkeys()) {
            subkeySet.add(subkey.getName());
        }
        return subkeySet;
    }
}

