/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.ws.runtime.client;

import com.microsoft.tfs.core.httpclient.methods.RequestEntity;
import com.microsoft.tfs.core.ws.runtime.client.SOAPHeaderProvider;
import com.microsoft.tfs.core.ws.runtime.client.SOAPRequestEntity;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.MessageFormat;

public class BufferedSOAPRequestEntity
implements RequestEntity {
    private ByteArrayOutputStream buffer;
    private final SOAPRequestEntity delegate;

    public BufferedSOAPRequestEntity(SOAPRequestEntity entity) {
        this.delegate = entity;
    }

    public void setSOAPHeaderProvider(SOAPHeaderProvider soapHeaderProvider) {
        this.delegate.setSOAPHeaderProvider(soapHeaderProvider);
    }

    @Override
    public long getContentLength() {
        try {
            this.ensureRequestIsBuffered();
        }
        catch (IOException e) {
            String messageFormat = "Content length not available because buffering of request body failed: {0}";
            String message = MessageFormat.format("Content length not available because buffering of request body failed: {0}", e.getMessage());
            throw new RuntimeException(message);
        }
        return this.buffer.size();
    }

    @Override
    public String getContentType() {
        return this.delegate.getContentType();
    }

    @Override
    public boolean isRepeatable() {
        return true;
    }

    public String getMethodName() {
        return this.delegate.getMethodName();
    }

    @Override
    public void writeRequest(OutputStream out) throws IOException {
        this.ensureRequestIsBuffered();
        this.buffer.writeTo(out);
    }

    private synchronized void ensureRequestIsBuffered() throws IOException {
        if (this.buffer == null) {
            this.buffer = new ByteArrayOutputStream();
            this.delegate.writeRequest(this.buffer);
        }
    }
}

