/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.ws.runtime.exceptions;

import com.microsoft.tfs.core.httpclient.Credentials;
import com.microsoft.tfs.core.httpclient.UsernamePasswordCredentials;
import com.microsoft.tfs.core.ws.runtime.Messages;
import com.microsoft.tfs.core.ws.runtime.exceptions.TransportAuthException;
import com.microsoft.tfs.util.Check;
import java.text.MessageFormat;

public class ProxyUnauthorizedException
extends TransportAuthException {
    private static final long serialVersionUID = 8688156619317277334L;
    private final String proxyHost;
    private final int proxyPort;
    private final Credentials credentials;

    public ProxyUnauthorizedException(String proxyHost, int proxyPort, Credentials credentials) {
        Check.notNull(proxyHost, "proxyHost");
        this.proxyHost = proxyHost;
        this.proxyPort = proxyPort;
        this.credentials = credentials;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public Credentials getCredentials() {
        return this.credentials;
    }

    @Override
    public String getMessage() {
        String message;
        if (this.credentials instanceof UsernamePasswordCredentials) {
            UsernamePasswordCredentials upCrendentials = (UsernamePasswordCredentials)this.credentials;
            String messageFormat = Messages.getString("ProxyUnauthorizedException.AuthorizationFailedAsFormat");
            message = MessageFormat.format(messageFormat, this.getHostForMessage(), upCrendentials.getUsername());
        } else if (this.credentials != null) {
            String messageFormat = Messages.getString("ProxyUnauthorizedException.AuthorizationFailedWithCredentialsFormat");
            message = MessageFormat.format(messageFormat, this.getHostForMessage(), this.credentials);
        } else {
            String messageFormat = Messages.getString("ProxyUnauthorizedException.AuthorizationFailedWithNoCredentialsFormat");
            message = MessageFormat.format(messageFormat, this.getHostForMessage());
        }
        return message;
    }

    private String getHostForMessage() {
        if (this.proxyPort != 80) {
            return MessageFormat.format("{0}:{1}", this.proxyHost, Integer.toString(this.proxyPort));
        }
        return this.proxyHost;
    }
}

