/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.ws.runtime.xml;

import com.microsoft.tfs.core.ws.runtime.xml.XMLConvert;
import com.microsoft.tfs.util.Check;
import java.util.ArrayList;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public abstract class XMLStreamReaderHelper {
    public static final void readUntilElementEnd(XMLStreamReader reader) throws XMLStreamException {
        int event = reader.getEventType();
        Check.isTrue(event == 1, "event == XMLStreamConstants.START_ELEMENT");
        int elementDepth = 1;
        boolean firstTime = true;
        while (true) {
            switch (event) {
                case 1: {
                    if (firstTime) {
                        firstTime = false;
                        break;
                    }
                    ++elementDepth;
                    break;
                }
                case 2: {
                    if (--elementDepth >= 1) break;
                    return;
                }
            }
            event = reader.next();
        }
    }

    public static final Object readObjectElement(XMLStreamReader reader) throws XMLStreamException {
        String typeString = reader.getAttributeValue("http://www.w3.org/2001/XMLSchema-instance", "type");
        if (typeString != null && typeString.length() > 0) {
            String[] components = typeString.split(":");
            if (components.length == 2) {
                typeString = components[1];
            }
            if (typeString.equals("base64Binary")) {
                return XMLConvert.toByteArray(reader.getElementText());
            }
            if (typeString.equals("boolean")) {
                return XMLConvert.toBoolean(reader.getElementText());
            }
            if (typeString.equals("char")) {
                return new Character(XMLConvert.toCharacter(reader.getElementText()));
            }
            if (typeString.equals("date")) {
                return XMLConvert.toCalendar(reader.getElementText(), false);
            }
            if (typeString.equals("dateTime")) {
                return XMLConvert.toCalendar(reader.getElementText(), true);
            }
            if (typeString.equals("decimal")) {
                return XMLConvert.toBigDecimal(reader.getElementText());
            }
            if (typeString.equals("double")) {
                return new Double(XMLConvert.toDouble(reader.getElementText()));
            }
            if (typeString.equals("float")) {
                return new Float(XMLConvert.toFloat(reader.getElementText()));
            }
            if (typeString.equals("int")) {
                return new Integer(XMLConvert.toInt(reader.getElementText()));
            }
            if (typeString.equals("guid")) {
                return XMLConvert.toGUID(reader.getElementText());
            }
            if (typeString.equals("long")) {
                return new Long(XMLConvert.toLong(reader.getElementText()));
            }
            if (typeString.equals("short")) {
                return new Short(XMLConvert.toShort(reader.getElementText()));
            }
            if (typeString.equals("string")) {
                return reader.getElementText();
            }
            if (typeString.equals("unsignedByte")) {
                return new Byte((byte)XMLConvert.toShort(reader.getElementText()));
            }
            if (typeString.equals("ArrayOfAnyType")) {
                return XMLStreamReaderHelper.readObjectArray(reader);
            }
            XMLStreamReaderHelper.readUntilElementEnd(reader);
        } else {
            String nilAttribute = reader.getAttributeValue("http://www.w3.org/2001/XMLSchema-instance", "nil");
            if (nilAttribute != null && nilAttribute.equals("true")) {
                XMLStreamReaderHelper.readUntilElementEnd(reader);
                return null;
            }
        }
        return null;
    }

    private static Object[] readObjectArray(XMLStreamReader reader) throws XMLStreamException {
        int event;
        ArrayList<Object> ret = new ArrayList<Object>();
        do {
            if ((event = reader.next()) != 1) continue;
            String nilAttribute = reader.getAttributeValue("http://www.w3.org/2001/XMLSchema-instance", "nil");
            if (nilAttribute != null && nilAttribute.equals("true")) {
                ret.add(null);
                continue;
            }
            ret.add(XMLStreamReaderHelper.readObjectElement(reader));
        } while (event != 2);
        return ret.toArray(new Object[ret.size()]);
    }
}

