/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.jni.appleforked.stream.encoder.entry;

import com.microsoft.tfs.jni.appleforked.fileformat.entry.AppleForkedFilenameEntry;
import com.microsoft.tfs.jni.appleforked.stream.encoder.entry.AppleForkedEntryEncoder;
import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.chunkingcodec.ByteArrayChunkedEncoder;
import java.io.File;
import java.io.IOException;

public class AppleForkedFilenameEncoder
extends ByteArrayChunkedEncoder
implements AppleForkedEntryEncoder {
    private final AppleForkedFilenameEntry filenameEntry;

    public AppleForkedFilenameEncoder(File file) {
        Check.notNull(file, "file");
        this.filenameEntry = new AppleForkedFilenameEntry(file.getName());
    }

    public AppleForkedFilenameEncoder(String filename) {
        this.filenameEntry = new AppleForkedFilenameEntry(AppleForkedFilenameEncoder.getFilename(filename));
    }

    private static String getFilename(String filename) {
        if (filename == null) {
            return "";
        }
        int lastSlash = filename.lastIndexOf(File.separator);
        if (lastSlash == -1) {
            return filename;
        }
        if (lastSlash + 1 < filename.length()) {
            return filename.substring(lastSlash + 1);
        }
        return "";
    }

    @Override
    public long getType() {
        return 3L;
    }

    @Override
    public long getLength() {
        return this.filenameEntry.encode().length;
    }

    @Override
    protected byte[] start() throws IOException {
        return this.filenameEntry.encode();
    }

    @Override
    public void close() {
    }
}

