/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.jni.loader;

import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.Platform;
import com.microsoft.tfs.util.StringUtil;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NativeLoader {
    private static final Log log = LogFactory.getLog(NativeLoader.class);
    public static final String RESOURCE_PATH_PREFIX = "/native";
    public static final String NATIVE_LIBRARY_BASE_DIRECTORY_PROPERTY = "com.microsoft.tfs.jni.native.base-directory";
    private static final String[] X86_SYNONYMS = new String[]{"i386", "x86"};
    private static final String[] AMD64_SYNONYMS = new String[]{"amd64", "x86_64"};
    private static final String[] SPARC_32_SYNONYMS = new String[]{"sparc"};
    private static final String[] SPARC_64_SYNONYMS = new String[]{"sparcv9"};
    private static final String[] POWERPC_32_SYNONYMS = new String[]{"ppc"};
    private static final String[] POWERPC_64_SYNONYMS = new String[]{"ppc64"};
    private static final String[] PA_RISC_20_SYNONYMS = new String[]{"PA_RISC2.0"};
    private static final String[] ITANIUM_32_SYNONYMS = new String[]{"IA64N"};
    private static final String[] ITANIUM_64_SYNONYMS = new String[]{"IA64W"};
    private static final String[] Z_ARCH_SYNONYMS = new String[]{"390", "s390"};
    private static final String[] ARM_32_SYNONYMS = new String[]{"arm", "armv6l"};

    private static String getOSGIOperatingSystem() {
        if (Platform.isCurrentPlatform(Platform.WINDOWS)) {
            return "win32";
        }
        if (Platform.isCurrentPlatform(Platform.LINUX)) {
            return "linux";
        }
        if (Platform.isCurrentPlatform(Platform.MAC_OS_X)) {
            return "macosx";
        }
        if (Platform.isCurrentPlatform(Platform.SOLARIS)) {
            return "solaris";
        }
        if (Platform.isCurrentPlatform(Platform.HPUX)) {
            return "hpux";
        }
        if (Platform.isCurrentPlatform(Platform.AIX)) {
            return "aix";
        }
        if (Platform.isCurrentPlatform(Platform.Z_OS)) {
            return "zos";
        }
        if (Platform.isCurrentPlatform(Platform.FREEBSD)) {
            return "freebsd";
        }
        return null;
    }

    private static String getOSGIArchitecture() {
        String arch = System.getProperty("os.arch");
        if (StringUtil.containsStringInsensitive(X86_SYNONYMS, arch)) {
            return "x86";
        }
        if (StringUtil.containsStringInsensitive(AMD64_SYNONYMS, arch)) {
            return "x86_64";
        }
        if (StringUtil.containsStringInsensitive(POWERPC_32_SYNONYMS, arch) || StringUtil.containsStringInsensitive(POWERPC_64_SYNONYMS, arch)) {
            return "ppc";
        }
        if (StringUtil.containsStringInsensitive(SPARC_32_SYNONYMS, arch) || StringUtil.containsStringInsensitive(SPARC_64_SYNONYMS, arch)) {
            return "sparc";
        }
        if (StringUtil.containsStringInsensitive(PA_RISC_20_SYNONYMS, arch)) {
            return "PA_RISC";
        }
        if (StringUtil.containsStringInsensitive(ITANIUM_64_SYNONYMS, arch)) {
            return "ia64";
        }
        if (StringUtil.containsStringInsensitive(ITANIUM_32_SYNONYMS, arch)) {
            return "ia64_32";
        }
        if (StringUtil.containsStringInsensitive(Z_ARCH_SYNONYMS, arch)) {
            return "390";
        }
        if (StringUtil.containsStringInsensitive(ARM_32_SYNONYMS, arch)) {
            return "arm";
        }
        log.trace((Object)MessageFormat.format("Unknown value for property os.arch: {0}", arch));
        return null;
    }

    public static boolean loadLibraryAndLogError(String libraryName) {
        Check.notNull(libraryName, "libraryName");
        try {
            NativeLoader.loadLibrary(libraryName);
            log.debug((Object)MessageFormat.format("Successfully loaded native library {0}", libraryName));
            return true;
        }
        catch (IOException e) {
            log.error((Object)MessageFormat.format("IOException reading native library {0} in static initializer", libraryName), (Throwable)e);
        }
        catch (LinkageError e) {
            log.debug((Object)MessageFormat.format("Could not load native library {0} in static initializer", libraryName), (Throwable)e);
        }
        return false;
    }

    public static void loadLibrary(String libraryName) throws UnsatisfiedLinkError, IOException {
        String loadFromDirectory;
        Check.notNullOrEmpty(libraryName, "libraryName");
        log.debug((Object)MessageFormat.format("Loading library {0}", libraryName));
        String osgiOperatingSystem = NativeLoader.getOSGIOperatingSystem();
        if (osgiOperatingSystem == null) {
            throw new UnsatisfiedLinkError("Could not determine OSGI-style operating system name for resource path construction");
        }
        String osgiArchitecture = NativeLoader.getOSGIArchitecture();
        if (osgiArchitecture == null) {
            throw new UnsatisfiedLinkError("Could not determine OSGI-style architecture for resource path construction");
        }
        if (Platform.isCurrentPlatform(Platform.MAC_OS_X)) {
            osgiArchitecture = null;
        }
        if ((loadFromDirectory = System.getProperty(NATIVE_LIBRARY_BASE_DIRECTORY_PROPERTY)) != null) {
            log.debug((Object)MessageFormat.format("Property {0} set to {1}; only looking there for native libraries", NATIVE_LIBRARY_BASE_DIRECTORY_PROPERTY, loadFromDirectory));
            NativeLoader.loadLibraryFromDirectory(libraryName, loadFromDirectory, osgiOperatingSystem, osgiArchitecture);
            return;
        }
        System.loadLibrary(libraryName);
        log.info((Object)MessageFormat.format("Loaded {0} with System.loadLibrary()", libraryName));
    }

    private static void loadLibraryFromDirectory(String libraryName, String directory, String osgiOperatingSystem, String osgiArchitecture) {
        String mappedLibraryName;
        File fullLibraryFile;
        Check.notNullOrEmpty(libraryName, "libraryName");
        Check.notNull(directory, "directory");
        Check.notNull(osgiOperatingSystem, "osgiOperatingSystem");
        File libraryDirectory = new File(directory);
        if (!libraryDirectory.exists()) {
            throw new UnsatisfiedLinkError(MessageFormat.format("Native library base directory {0} does not exist", libraryDirectory.getAbsolutePath()));
        }
        if (!libraryDirectory.isDirectory()) {
            throw new UnsatisfiedLinkError(MessageFormat.format("Native library base directory {0} is not a directory", libraryDirectory.getAbsolutePath()));
        }
        File fullDirectory = new File(libraryDirectory, osgiOperatingSystem);
        if (osgiArchitecture != null && osgiArchitecture.length() > 0) {
            fullDirectory = new File(fullDirectory, osgiArchitecture);
        }
        if (!(fullLibraryFile = new File(fullDirectory, mappedLibraryName = Platform.isCurrentPlatform(Platform.MAC_OS_X) ? "lib" + libraryName + ".jnilib" : System.mapLibraryName(libraryName))).exists()) {
            throw new UnsatisfiedLinkError(MessageFormat.format("Native library file {0} does not exist", fullLibraryFile.getAbsolutePath()));
        }
        if (fullLibraryFile.isDirectory()) {
            throw new UnsatisfiedLinkError(MessageFormat.format("Native library file {0} is a directory", fullLibraryFile.getAbsolutePath()));
        }
        log.debug((Object)MessageFormat.format("Trying to load native library file {0}", fullLibraryFile.getAbsolutePath()));
        System.load(fullLibraryFile.getAbsolutePath());
        log.debug((Object)MessageFormat.format("Loaded {0} from user-specified directory", fullLibraryFile.getAbsolutePath()));
    }
}

