/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.util.datetime;

import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.Messages;
import com.microsoft.tfs.util.datetime.LenientDateTimeFormat;
import com.microsoft.tfs.util.datetime.LenientDateTimeParserExpander;
import com.microsoft.tfs.util.datetime.LenientDateTimePattern;
import com.microsoft.tfs.util.datetime.LenientDateTimeResult;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LenientDateTimeParser {
    private static final Log log = LogFactory.getLog(LenientDateTimeParser.class);
    private static final LenientDateTimePattern[] isoDateTimeFormats = new LenientDateTimePattern[]{new LenientDateTimePattern("yyyy/MM/dd'T'HH:mm:ss.SSSz", true, true), new LenientDateTimePattern("yyyy/MM/dd'T'HH:mm:ssz", true, true), new LenientDateTimePattern("yyyy/MM/dd'T'HH:mm:ss", true, true), new LenientDateTimePattern("yyyy/MM/dd'T'HH:mmz", true, true), new LenientDateTimePattern("yyyy/MM/dd'T'HH:mm", true, true)};
    private static final LenientDateTimePattern[] usDateFormats = new LenientDateTimePattern[]{new LenientDateTimePattern("MM/dd/yy h:mm:ss a z", true, true), new LenientDateTimePattern("MM/dd/yy h:mm:ss a", true, true), new LenientDateTimePattern("MM/dd/yy h:mm a z", true, true), new LenientDateTimePattern("MM/dd/yy h:mm a", true, true), new LenientDateTimePattern("MM/dd/yy HH:mm:ss z", true, true), new LenientDateTimePattern("MM/dd/yy HH:mm:ss", true, true), new LenientDateTimePattern("MM/dd/yy HH:mm z", true, true), new LenientDateTimePattern("MM/dd/yy HH:mm", true, true), new LenientDateTimePattern("MM/dd/yy", true, false)};
    private static final LenientDateTimePattern[] euDateFormats = new LenientDateTimePattern[]{new LenientDateTimePattern("d/MM/yy h:mm:ss a z", true, true), new LenientDateTimePattern("d/MM/yy h:mm:ss a", true, true), new LenientDateTimePattern("d/MM/yy h:mm a z", true, true), new LenientDateTimePattern("d/MM/yy h:mm a", true, true), new LenientDateTimePattern("d/MM/yy HH:mm:ss z", true, true), new LenientDateTimePattern("d/MM/yy HH:mm:ss", true, true), new LenientDateTimePattern("d/MM/yy HH:mm z", true, true), new LenientDateTimePattern("d/MM/yy HH:mm", true, true), new LenientDateTimePattern("d/MM/yy", true, false)};
    private static final LenientDateTimePattern[] genericTimeFormats = new LenientDateTimePattern[]{new LenientDateTimePattern("h:mm:ss a z", false, true), new LenientDateTimePattern("h:mm:ss a", false, true), new LenientDateTimePattern("h:mm a z", false, true), new LenientDateTimePattern("h:mm a", false, true), new LenientDateTimePattern("HH:mm:ss z", false, true), new LenientDateTimePattern("HH:mm:ssz", false, true), new LenientDateTimePattern("HH:mm:ss", false, true), new LenientDateTimePattern("HH:mm z", false, true), new LenientDateTimePattern("HH:mmz", false, true), new LenientDateTimePattern("HH:mm", false, true)};
    private LenientDateTimeFormat[] expandedFormats = new LenientDateTimeFormat[0];
    private final TimeZone timeZone;
    private final Locale locale;
    private final String[] additionalUTCTimeZoneStrings = new String[]{"Z", "z"};

    public LenientDateTimeParser() {
        this.timeZone = TimeZone.getDefault();
        this.locale = Locale.getDefault();
        this.computeFormats();
    }

    public LenientDateTimeParser(TimeZone timeZone, Locale locale) {
        Check.notNull(timeZone, "timeZone");
        Check.notNull(locale, "locale");
        this.timeZone = timeZone;
        this.locale = locale;
        this.computeFormats();
    }

    public LenientDateTimeResult parseExtended(String dateTimeString, boolean defaultDate, boolean defaultTime) throws ParseException {
        Check.notNull(dateTimeString, "dateTimeString");
        long start = System.currentTimeMillis();
        int i = 0;
        Calendar calendar = Calendar.getInstance(this.timeZone, this.locale);
        calendar.clear();
        dateTimeString = this.convertUnsupportedTimeZones(dateTimeString);
        for (i = 0; i < this.expandedFormats.length; ++i) {
            LenientDateTimeFormat format = this.expandedFormats[i];
            try {
                calendar.setTime(format.getDateFormat().parse(dateTimeString));
                if (defaultDate && !format.specifiesDate()) {
                    GregorianCalendar now = new GregorianCalendar(this.timeZone, this.locale);
                    calendar.set(0, now.get(0));
                    calendar.set(1, now.get(1));
                    calendar.set(2, now.get(2));
                    calendar.set(5, now.get(5));
                }
                if (defaultTime && !format.specifiesTime()) {
                    GregorianCalendar newRet = new GregorianCalendar(this.timeZone, this.locale);
                    newRet.set(0, calendar.get(0));
                    newRet.set(1, calendar.get(1));
                    newRet.set(2, calendar.get(2));
                    newRet.set(5, calendar.get(5));
                    calendar = newRet;
                }
                String messageFormat = "matched at index {0} in {1} ms: {2}";
                String message = MessageFormat.format("matched at index {0} in {1} ms: {2}", i, System.currentTimeMillis() - start, dateTimeString);
                log.trace((Object)message);
                return new LenientDateTimeResult(calendar, format.getDateFormat(), format.specifiesDate(), format.specifiesTime());
            }
            catch (ParseException e) {
                continue;
            }
        }
        String messageFormat = "no match in {0} ms: {1}";
        String message = MessageFormat.format(messageFormat, System.currentTimeMillis() - start, dateTimeString);
        log.trace((Object)message);
        messageFormat = Messages.getString("LenientDateTimeParser.UnknownDateFormat");
        message = MessageFormat.format(messageFormat, dateTimeString);
        throw new ParseException(message, 0);
    }

    public Calendar parse(String dateTimeString, boolean defaultDate, boolean defaultTime) throws ParseException {
        return this.parseExtended(dateTimeString, defaultDate, defaultTime).getCalendar();
    }

    public Calendar parse(String dateTimeString) throws ParseException {
        return this.parseExtended(dateTimeString, true, true).getCalendar();
    }

    protected String convertUnsupportedTimeZones(String dateTimeString) {
        if (dateTimeString == null) {
            return null;
        }
        for (int i = 0; i < this.additionalUTCTimeZoneStrings.length; ++i) {
            char previousChracter;
            int zoneIndex;
            String zoneString = this.additionalUTCTimeZoneStrings[i];
            if (!dateTimeString.endsWith(zoneString) || (zoneIndex = dateTimeString.lastIndexOf(zoneString)) < 1 || !Character.isDigit(previousChracter = dateTimeString.charAt(zoneIndex - 1)) && !Character.isWhitespace(previousChracter)) continue;
            return dateTimeString.replaceAll(zoneString + "$", "UTC");
        }
        return dateTimeString;
    }

    private void computeFormats() {
        DateFormat df;
        int i;
        LenientDateTimeParserExpander expander = new LenientDateTimeParserExpander(false, this.locale);
        for (int i2 = 0; i2 <= 2; ++i2) {
            for (int j = 0; j <= 3; ++j) {
                DateFormat df2 = SimpleDateFormat.getDateTimeInstance(i2, j, this.locale);
                df2.setLenient(false);
                expander.add(df2, true, true);
            }
        }
        GregorianCalendar c = new GregorianCalendar(this.timeZone, this.locale);
        c.clear();
        c.set(2, 0);
        c.set(5, 5);
        c.set(1, 9999);
        String defaultFormattedDate = SimpleDateFormat.getDateInstance(3, this.locale).format(c.getTime());
        int monthIndex = defaultFormattedDate.indexOf("1");
        int dateIndex = defaultFormattedDate.indexOf("5");
        expander.addExpanded(isoDateTimeFormats);
        if (dateIndex > monthIndex) {
            expander.addExpanded(usDateFormats);
            expander.addExpanded(euDateFormats);
        } else {
            expander.addExpanded(euDateFormats);
            expander.addExpanded(usDateFormats);
        }
        for (i = 0; i <= 2; ++i) {
            df = SimpleDateFormat.getDateInstance(i, this.locale);
            df.setLenient(false);
            expander.add(df, true, false);
        }
        for (i = 0; i <= 3; ++i) {
            df = SimpleDateFormat.getTimeInstance(i, this.locale);
            df.setLenient(false);
            expander.add(df, false, true);
        }
        expander.addExpanded(genericTimeFormats);
        this.expandedFormats = expander.getSortedResults();
    }

    public String toString() {
        return this.locale.toString() + "@" + this.timeZone.getID() + " [" + this.expandedFormats.length + " formats]";
    }
}

