/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.util.locking;

import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.Messages;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Set;

public final class AdvisoryFileLock {
    private static final Set heldLocks = new HashSet();
    private final File lockFile;
    private final FileLock lock;
    private final RandomAccessFile raf;
    private boolean released = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AdvisoryFileLock create(File lockFile, boolean block) throws IOException, InterruptedException {
        FileLock lock;
        Check.notNull(lockFile, "lockFile");
        RandomAccessFile raf = new RandomAccessFile(lockFile, "rw");
        Set set = heldLocks;
        synchronized (set) {
            if (block) {
                while (heldLocks.contains(lockFile)) {
                    heldLocks.wait();
                }
                lock = raf.getChannel().lock();
                if (lock == null) {
                    raf.close();
                    String messageFormat = Messages.getString("AdvisoryFileLock.InterruptedAcquiringLockFormat");
                    String message = MessageFormat.format(messageFormat, lockFile);
                    throw new InterruptedException(message);
                }
            } else {
                if (heldLocks.contains(lockFile)) {
                    raf.close();
                    return null;
                }
                lock = raf.getChannel().tryLock();
                if (lock == null) {
                    raf.close();
                    return null;
                }
            }
            heldLocks.add(lockFile);
        }
        return new AdvisoryFileLock(lockFile, lock, raf);
    }

    private AdvisoryFileLock(File lockFile, FileLock lock, RandomAccessFile raf) {
        Check.notNull(lockFile, "lockFile");
        Check.notNull(lock, "lock");
        Check.notNull(raf, "raf");
        this.lockFile = lockFile;
        this.lock = lock;
        this.raf = raf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void release() throws IOException {
        if (this.released) {
            return;
        }
        try {
            if (this.lock != null) {
                this.lock.release();
            }
            if (this.raf != null) {
                this.raf.close();
            }
        }
        finally {
            Set set = heldLocks;
            synchronized (set) {
                if (heldLocks.contains(this.lockFile)) {
                    heldLocks.remove(this.lockFile);
                    heldLocks.notifyAll();
                }
            }
            this.released = true;
        }
    }

    public synchronized boolean isReleased() {
        return this.released;
    }

    protected void finalize() throws Throwable {
        this.release();
    }

    public int hashCode() {
        return this.lockFile.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AdvisoryFileLock)) {
            return false;
        }
        AdvisoryFileLock other = (AdvisoryFileLock)obj;
        return other.lockFile == null ? this.lockFile == null : other.lockFile.equals(this.lockFile);
    }
}

