/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.util.temp;

import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.FileHelpers;
import com.microsoft.tfs.util.GUID;
import com.microsoft.tfs.util.Messages;
import com.microsoft.tfs.util.shutdown.ShutdownEventListener;
import com.microsoft.tfs.util.shutdown.ShutdownManager;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class TempStorageService {
    private static final Log log = LogFactory.getLog(TempStorageService.class);
    private static TempStorageService instance;
    public static final String DEFAULT_EXTENSION = ".tmp";
    private final AtomicLong currentSerialNumber = new AtomicLong(0L);
    private File systemTempDir;
    private final Map<File, CleanUpItem> cleanUpItems = new HashMap<File, CleanUpItem>();

    private TempStorageService() {
        ShutdownManager.getInstance().addShutdownEventListener(new ShutdownEventListener(){

            @Override
            public void onShutdown() {
                TempStorageService.this.cleanUpAllItems();
            }
        }, ShutdownManager.Priority.LATE);
    }

    public static synchronized TempStorageService getInstance() {
        if (instance == null) {
            instance = new TempStorageService();
        }
        return instance;
    }

    public File createTempFile() throws IOException {
        return this.createTempFile(null);
    }

    public File createTempFile(String extension) throws IOException {
        return this.createTempFile(null, extension);
    }

    public File createTempFile(File userDirectory, String extension) throws IOException {
        if (extension == null || extension.length() == 0) {
            extension = DEFAULT_EXTENSION;
        }
        boolean createDirectory = userDirectory == null || userDirectory.length() == 0L;
        File dir = createDirectory ? this.createTempDirectoryInternal() : userDirectory;
        File file = File.createTempFile("tfs", extension, dir);
        this.cleanUpItems.put(file, new CleanUpItem(createDirectory ? dir : file, this.currentSerialNumber.getAndIncrement()));
        if (createDirectory) {
            log.debug((Object)MessageFormat.format("remembered directory ''{0}'' for clean up (parent of ''{1}'')", dir, file));
        } else {
            log.debug((Object)MessageFormat.format("remembered file ''{0}'' for clean up", file));
        }
        return file;
    }

    public File createTempDirectory() throws IOException {
        File dir = this.createTempDirectoryInternal();
        this.cleanUpItems.put(dir, new CleanUpItem(dir, this.currentSerialNumber.getAndIncrement()));
        log.debug((Object)MessageFormat.format("remembered directory ''{0}'' for clean up", dir));
        return dir;
    }

    public synchronized void forgetItem(File item) {
        Check.notNull(item, "item");
        CleanUpItem removed = this.cleanUpItems.remove(item);
        if (removed != null) {
            log.debug((Object)MessageFormat.format("forgot clean up item ''{0}'' for temp item ''{1}''", removed.getCleanUpFile(), item));
        } else {
            log.debug((Object)MessageFormat.format("could not forget clean up item for ''{0}'': not found (this is harmless)", item));
        }
    }

    public synchronized void renameItem(File sourceItem, File targetItem) {
        Check.notNull(sourceItem, "sourceItem");
        Check.notNull(targetItem, "targetItem");
        if (!sourceItem.exists()) {
            throw new RuntimeException(MessageFormat.format(Messages.getString("TempStorageService.RenameErrorSourceDoesNotExistFormat"), sourceItem.getAbsolutePath(), targetItem.getAbsolutePath()));
        }
        if (targetItem.exists()) {
            throw new RuntimeException(MessageFormat.format(Messages.getString("TempStorageService.RenameErrorTargetExistsFormat"), sourceItem.getAbsolutePath(), targetItem.getAbsolutePath()));
        }
        if (!FileHelpers.renameWithoutException(sourceItem, targetItem)) {
            log.debug((Object)MessageFormat.format("attempt to rename ''{0}'' to ''{1}'' failed.", sourceItem.getAbsolutePath(), targetItem.getAbsolutePath()));
        }
    }

    public synchronized void deleteItem(File item) {
        log.debug((Object)MessageFormat.format("Trying to delete item ''{1}''.", item.getAbsolutePath()));
        if (!item.delete()) {
            log.debug((Object)MessageFormat.format("Remember a clean up item later for ''{1}''.", item.getAbsolutePath()));
            this.cleanUpItems.put(item, new CleanUpItem(item, this.currentSerialNumber.getAndIncrement()));
        }
    }

    private File createTempDirectoryInternal() {
        File dir = new File(this.getSystemTempFile(), GUID.newGUIDString());
        dir.mkdirs();
        return dir;
    }

    public synchronized void cleanUpItem(File item) {
        Check.notNull(item, "item");
        CleanUpItem tempItem = this.cleanUpItems.get(item);
        if (tempItem == null) {
            log.debug((Object)MessageFormat.format("could not clean up for item ''{0}'': not found (this is harmless)", item));
            return;
        }
        this.cleanUpItemInternal(tempItem);
        if (!item.exists()) {
            this.cleanUpItems.remove(item);
        }
    }

    public synchronized void cleanUpAllItems() {
        Collection<CleanUpItem> values = this.cleanUpItems.values();
        if (values.size() == 0) {
            return;
        }
        Object[] items = values.toArray(new CleanUpItem[values.size()]);
        Arrays.sort(items);
        for (int i = 0; i < items.length; ++i) {
            this.cleanUpItemInternal((CleanUpItem)items[i]);
        }
        this.cleanUpItems.clear();
    }

    private void cleanUpItemInternal(CleanUpItem tempItem) {
        Check.notNull(tempItem, "tempItem");
        File cleanUpFile = tempItem.getCleanUpFile();
        log.debug((Object)MessageFormat.format("deleting ''{0}'' (recursively)", cleanUpFile));
        this.deleteRecursive(cleanUpFile);
    }

    private void deleteRecursive(File fileOrDirectory) {
        if (fileOrDirectory == null) {
            return;
        }
        File[] subFiles = fileOrDirectory.listFiles();
        if (subFiles == null) {
            if (!fileOrDirectory.delete()) {
                log.warn((Object)MessageFormat.format("could not delete ''{0}'' (no futher information available)", fileOrDirectory));
            }
        } else {
            for (int i = 0; i < subFiles.length; ++i) {
                this.deleteRecursive(subFiles[i]);
            }
            if (!fileOrDirectory.delete()) {
                log.warn((Object)MessageFormat.format("could not delete directory ''{0}'' (no futher information available)", fileOrDirectory.getAbsolutePath()));
            }
        }
    }

    private synchronized File getSystemTempFile() {
        if (this.systemTempDir == null) {
            this.systemTempDir = new File(System.getProperty("java.io.tmpdir"));
        }
        return this.systemTempDir;
    }

    private static class CleanUpItem
    implements Comparable<CleanUpItem> {
        private final File cleanUpFile;
        private final long serialNumber;

        public CleanUpItem(File cleanUpFile, long serialNumber) {
            Check.notNull(cleanUpFile, "cleanUpFile");
            this.cleanUpFile = cleanUpFile;
            this.serialNumber = serialNumber;
        }

        public File getCleanUpFile() {
            return this.cleanUpFile;
        }

        @Override
        public int compareTo(CleanUpItem other) {
            if (this.serialNumber < other.serialNumber) {
                return -1;
            }
            if (this.serialNumber > other.serialNumber) {
                return 1;
            }
            return 0;
        }
    }
}

